/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.CombinedWriter;
import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.FSHLogProvider;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FSHLog
extends AbstractFSWAL<WALProvider.Writer> {
    private static final Logger LOG = LoggerFactory.getLogger(FSHLog.class);
    private static final String TOLERABLE_LOW_REPLICATION = "hbase.regionserver.hlog.tolerable.lowreplication";
    private static final String LOW_REPLICATION_ROLL_LIMIT = "hbase.regionserver.hlog.lowreplication.rolllimit";
    private static final int DEFAULT_LOW_REPLICATION_ROLL_LIMIT = 5;
    private static final String SYNCER_COUNT = "hbase.regionserver.hlog.syncer.count";
    private static final int DEFAULT_SYNCER_COUNT = 5;
    private static final String MAX_BATCH_COUNT = "hbase.regionserver.wal.sync.batch.count";
    private static final int DEFAULT_MAX_BATCH_COUNT = 200;
    private static final String FSHLOG_WAIT_ON_SHUTDOWN_IN_SECONDS = "hbase.wal.fshlog.wait.on.shutdown.seconds";
    private static final int DEFAULT_FSHLOG_WAIT_ON_SHUTDOWN_IN_SECONDS = 5;
    private static final IOException WITER_REPLACED_EXCEPTION = new IOException("Writer was replaced!");
    private static final IOException WITER_BROKEN_EXCEPTION = new IOException("Wirter was broken!");
    private static final IOException WAL_CLOSE_EXCEPTION = new IOException("WAL was closed!");
    private FSDataOutputStream hdfs_out;
    private final int minTolerableReplication;
    private final AtomicInteger consecutiveLogRolls = new AtomicInteger(0);
    private final int lowReplicationRollLimit;
    private volatile boolean lowReplicationRollEnabled = true;
    private final int syncerCount;
    private final int maxSyncRequestCount;
    private int syncRunnerIndex = 0;
    private SyncRunner[] syncRunners = null;
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 5 * ClassSize.REFERENCE + 2 * ClassSize.ATOMIC_INTEGER + 12 + 32);

    public FSHLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
        this(fs, root, logDir, "oldWALs", conf, null, true, null, null);
    }

    public FSHLog(FileSystem fs, Abortable abortable, Path root, String logDir, Configuration conf) throws IOException {
        this(fs, abortable, root, logDir, "oldWALs", conf, null, true, null, null, null, null);
    }

    public FSHLog(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix) throws IOException {
        this(fs, null, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, null, null);
    }

    public FSHLog(FileSystem fs, Abortable abortable, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, FileSystem remoteFs, Path remoteWALDir) throws IOException {
        super(fs, abortable, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, remoteFs, remoteWALDir);
        this.minTolerableReplication = conf.getInt(TOLERABLE_LOW_REPLICATION, (int)CommonFSUtils.getDefaultReplication(fs, this.walDir));
        this.lowReplicationRollLimit = conf.getInt(LOW_REPLICATION_ROLL_LIMIT, 5);
        this.syncerCount = conf.getInt(SYNCER_COUNT, 5);
        this.maxSyncRequestCount = conf.getInt(MAX_BATCH_COUNT, conf.getInt("hbase.regionserver.handler.count", 200));
        this.createSingleThreadPoolConsumeExecutor("FSHLog", rootDir, prefix);
        this.setWaitOnShutdownInSeconds(conf.getInt(FSHLOG_WAIT_ON_SHUTDOWN_IN_SECONDS, 5), FSHLOG_WAIT_ON_SHUTDOWN_IN_SECONDS);
    }

    @Override
    public void init() throws IOException {
        super.init();
        this.createSyncRunnersAndStart();
    }

    private void createSyncRunnersAndStart() {
        this.syncRunnerIndex = 0;
        this.syncRunners = new SyncRunner[this.syncerCount];
        for (int i = 0; i < this.syncerCount; ++i) {
            this.syncRunners[i] = new SyncRunner("sync." + i, this.maxSyncRequestCount);
            this.syncRunners[i].start();
        }
    }

    OutputStream getOutputStream() {
        FSDataOutputStream fsdos = this.hdfs_out;
        return fsdos != null ? fsdos.getWrappedStream() : null;
    }

    private void preemptiveSync(ProtobufLogWriter nextWriter) {
        long startTimeNanos = System.nanoTime();
        try {
            nextWriter.sync(this.useHsync);
            this.postSync(System.nanoTime() - startTimeNanos, 0);
        }
        catch (IOException e) {
            LOG.warn("pre-sync failed but an optimization so keep going", (Throwable)e);
        }
    }

    @Override
    protected WALProvider.Writer createWriterInstance(FileSystem fs, Path path) throws IOException {
        FSHLogProvider.Writer writer = FSHLogProvider.createWriter(this.conf, fs, path, false, this.blocksize);
        if (writer instanceof ProtobufLogWriter) {
            this.preemptiveSync((ProtobufLogWriter)writer);
        }
        return writer;
    }

    @Override
    protected void doAppend(WALProvider.Writer writer, FSWALEntry entry) throws IOException {
        writer.append(entry);
    }

    @Override
    protected void onWriterReplaced(WALProvider.Writer nextWriter) {
        this.hdfs_out = nextWriter != null && nextWriter instanceof ProtobufLogWriter ? ((ProtobufLogWriter)nextWriter).getStream() : null;
        this.createSyncRunnersAndStart();
    }

    @Override
    protected void doCleanUpResources() {
        this.shutDownSyncRunners();
    }

    private void shutDownSyncRunners() {
        SyncRunner[] syncRunnersToUse = this.syncRunners;
        if (syncRunnersToUse != null) {
            for (SyncRunner syncRunner : syncRunnersToUse) {
                syncRunner.shutDown();
            }
        }
        this.syncRunners = null;
    }

    @Override
    protected CompletableFuture<Long> doWriterSync(WALProvider.Writer writer, boolean shouldUseHSync, long txidWhenSync) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        SyncRequest syncRequest = new SyncRequest(writer, shouldUseHSync, txidWhenSync, future);
        this.offerSyncRequest(syncRequest);
        return future;
    }

    private void offerSyncRequest(SyncRequest syncRequest) {
        for (int i = 0; i < this.syncRunners.length; ++i) {
            this.syncRunnerIndex = (this.syncRunnerIndex + 1) % this.syncRunners.length;
            if (!this.syncRunners[this.syncRunnerIndex].offer(syncRequest)) continue;
            return;
        }
        syncRequest.completableFuture.completeExceptionally(new IOException("There is no available syncRunner."));
    }

    @Override
    protected void checkSlowSyncCount() {
        if (this.isLogRollRequested()) {
            return;
        }
        if (this.doCheckSlowSync()) {
            this.requestLogRoll(WALActionsListener.RollRequestReason.SLOW_SYNC);
        }
    }

    @Override
    protected boolean doCheckLogLowReplication() {
        boolean logRollNeeded = false;
        try {
            int numCurrentReplicas = this.getLogReplication();
            if (numCurrentReplicas != 0 && numCurrentReplicas < this.minTolerableReplication) {
                if (this.lowReplicationRollEnabled) {
                    if (this.consecutiveLogRolls.get() < this.lowReplicationRollLimit) {
                        LOG.warn("HDFS pipeline error detected. Found " + numCurrentReplicas + " replicas but expecting no less than " + this.minTolerableReplication + " replicas.  Requesting close of WAL. current pipeline: " + Arrays.toString(this.getPipeline()));
                        logRollNeeded = true;
                        this.consecutiveLogRolls.getAndIncrement();
                    } else {
                        LOG.warn("Too many consecutive RollWriter requests, it's a sign of the total number of live datanodes is lower than the tolerable replicas.");
                        this.consecutiveLogRolls.set(0);
                        this.lowReplicationRollEnabled = false;
                    }
                }
            } else if (numCurrentReplicas >= this.minTolerableReplication && !this.lowReplicationRollEnabled) {
                if (this.numEntries.get() <= 1) {
                    return logRollNeeded;
                }
                this.lowReplicationRollEnabled = true;
                LOG.info("LowReplication-Roller was enabled.");
            }
        }
        catch (Exception e) {
            LOG.warn("DFSOutputStream.getNumCurrentReplicas failed because of " + e + ", continuing...");
        }
        return logRollNeeded;
    }

    @Override
    int getLogReplication() {
        try {
            if (this.hdfs_out instanceof HdfsDataOutputStream) {
                return ((HdfsDataOutputStream)this.hdfs_out).getCurrentBlockReplication();
            }
        }
        catch (IOException e) {
            LOG.info("", (Throwable)e);
        }
        return 0;
    }

    boolean isLowReplicationRollEnabled() {
        return this.lowReplicationRollEnabled;
    }

    @Override
    DatanodeInfo[] getPipeline() {
        if (this.hdfs_out != null && this.hdfs_out.getWrappedStream() instanceof DFSOutputStream) {
            return ((DFSOutputStream)this.hdfs_out.getWrappedStream()).getPipeline();
        }
        return new DatanodeInfo[0];
    }

    @Override
    protected WALProvider.Writer createCombinedWriter(WALProvider.Writer localWriter, WALProvider.Writer remoteWriter) {
        return CombinedWriter.create(remoteWriter, localWriter);
    }

    private class SyncRunner
    extends Thread {
        private final BlockingQueue<SyncRequest> syncRequests;
        private volatile boolean shutDown;

        SyncRunner(String name, int maxHandlersCount) {
            super(name);
            this.shutDown = false;
            this.syncRequests = new LinkedBlockingQueue<SyncRequest>(maxHandlersCount * 3);
        }

        boolean offer(SyncRequest syncRequest) {
            if (this.shutDown) {
                return false;
            }
            if (!this.syncRequests.offer(syncRequest)) {
                return false;
            }
            return !this.shutDown || !this.syncRequests.remove(syncRequest);
        }

        private void completeSyncRequests(SyncRequest syncRequest, long syncedSequenceId) {
            SyncRequest head;
            if (syncRequest != null) {
                syncRequest.completableFuture.complete(syncedSequenceId);
            }
            while ((head = (SyncRequest)this.syncRequests.peek()) != null && head.sequenceWhenSync <= syncedSequenceId) {
                head.completableFuture.complete(syncedSequenceId);
                this.syncRequests.poll();
            }
        }

        private void completeExceptionallySyncRequests(SyncRequest syncRequest, Exception exception) {
            SyncRequest head;
            if (syncRequest != null) {
                syncRequest.completableFuture.completeExceptionally(exception);
            }
            while ((head = (SyncRequest)this.syncRequests.peek()) != null && head.writer == syncRequest.writer) {
                head.completableFuture.completeExceptionally(exception);
                this.syncRequests.poll();
            }
        }

        private SyncRequest takeSyncRequest() throws InterruptedException {
            SyncRequest syncRequest;
            while (true) {
                syncRequest = this.syncRequests.take();
                long currentHighestSyncedSequence = FSHLog.this.highestSyncedTxid.get();
                if (syncRequest.sequenceWhenSync >= currentHighestSyncedSequence) break;
                syncRequest.completableFuture.complete(currentHighestSyncedSequence);
            }
            return syncRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            while (!this.shutDown) {
                try {
                    SyncRequest syncRequest = this.takeSyncRequest();
                    long currentSequenceToUse = syncRequest.sequenceWhenSync;
                    boolean writerBroken = FSHLog.this.isWriterBroken();
                    long currentHighestProcessedAppendTxid = FSHLog.this.highestProcessedAppendTxid;
                    WALProvider.Writer currentWriter = (WALProvider.Writer)FSHLog.this.writer;
                    if (currentWriter != syncRequest.writer) {
                        syncRequest.completableFuture.completeExceptionally(WITER_REPLACED_EXCEPTION);
                        continue;
                    }
                    if (writerBroken) {
                        syncRequest.completableFuture.completeExceptionally(WITER_BROKEN_EXCEPTION);
                        continue;
                    }
                    if (currentHighestProcessedAppendTxid > currentSequenceToUse) {
                        currentSequenceToUse = currentHighestProcessedAppendTxid;
                    }
                    Exception lastException = null;
                    try {
                        ((WALProvider.Writer)FSHLog.this.writer).sync(syncRequest.shouldUseHSync);
                        if (lastException != null) {
                            this.completeExceptionallySyncRequests(syncRequest, lastException);
                            continue;
                        }
                        this.completeSyncRequests(syncRequest, currentSequenceToUse);
                    }
                    catch (IOException e) {
                        LOG.error("Error syncing", (Throwable)e);
                        lastException = e;
                        if (lastException != null) {
                            this.completeExceptionallySyncRequests(syncRequest, lastException);
                            continue;
                        }
                        this.completeSyncRequests(syncRequest, currentSequenceToUse);
                    }
                    catch (Exception e2) {
                        LOG.warn("UNEXPECTED", (Throwable)e2);
                        lastException = e2;
                        if (lastException != null) {
                            this.completeExceptionallySyncRequests(syncRequest, lastException);
                            continue;
                        }
                        this.completeSyncRequests(syncRequest, currentSequenceToUse);
                        continue;
                        {
                            catch (Throwable throwable) {
                                if (lastException != null) {
                                    this.completeExceptionallySyncRequests(syncRequest, lastException);
                                } else {
                                    this.completeSyncRequests(syncRequest, currentSequenceToUse);
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    LOG.info("interrupted");
                }
                catch (Throwable t) {
                    LOG.warn("UNEXPECTED, continuing", t);
                }
            }
            this.clearSyncRequestsWhenShutDown();
        }

        private void clearSyncRequestsWhenShutDown() {
            SyncRequest syncRequest;
            while ((syncRequest = (SyncRequest)this.syncRequests.poll()) != null) {
                syncRequest.completableFuture.completeExceptionally(WAL_CLOSE_EXCEPTION);
            }
        }

        void shutDown() {
            try {
                this.shutDown = true;
                this.interrupt();
                this.join();
            }
            catch (InterruptedException e) {
                LOG.warn("interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    static class SyncRequest {
        private final WALProvider.Writer writer;
        private final boolean shouldUseHSync;
        private final long sequenceWhenSync;
        private final CompletableFuture<Long> completableFuture;

        public SyncRequest(WALProvider.Writer writer, boolean shouldUseHSync, long txidWhenSync, CompletableFuture<Long> completableFuture) {
            this.writer = writer;
            this.shouldUseHSync = shouldUseHSync;
            this.sequenceWhenSync = txidWhenSync;
            this.completableFuture = completableFuture;
        }
    }
}

