/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.ClientMetaTableAccessor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ReplicationBarrierFamilyFormat {
    public static final byte[] REPLICATION_PARENT_QUALIFIER = Bytes.toBytes("parent");
    private static final byte ESCAPE_BYTE = -1;
    private static final byte SEPARATED_BYTE = 0;

    private ReplicationBarrierFamilyFormat() {
    }

    public static void addReplicationBarrier(Put put, long openSeqNum) throws IOException {
        put.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.REPLICATION_BARRIER_FAMILY).setQualifier(HConstants.SEQNUM_QUALIFIER).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(openSeqNum)).build());
    }

    private static void writeRegionName(ByteArrayOutputStream out, byte[] regionName) {
        for (byte b : regionName) {
            if (b == -1) {
                out.write(-1);
            }
            out.write(b);
        }
    }

    public static byte[] getParentsBytes(List<RegionInfo> parents) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Iterator<RegionInfo> iter = parents.iterator();
        ReplicationBarrierFamilyFormat.writeRegionName(bos, iter.next().getRegionName());
        while (iter.hasNext()) {
            bos.write(-1);
            bos.write(0);
            ReplicationBarrierFamilyFormat.writeRegionName(bos, iter.next().getRegionName());
        }
        return bos.toByteArray();
    }

    private static List<byte[]> parseParentsBytes(byte[] bytes) {
        ArrayList<byte[]> parents = new ArrayList<byte[]>();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == -1 && bytes[++i] == 0) {
                parents.add(bos.toByteArray());
                bos.reset();
                continue;
            }
            bos.write(bytes[i]);
        }
        if (bos.size() > 0) {
            parents.add(bos.toByteArray());
        }
        return parents;
    }

    public static void addReplicationParent(Put put, List<RegionInfo> parents) throws IOException {
        byte[] value = ReplicationBarrierFamilyFormat.getParentsBytes(parents);
        put.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.REPLICATION_BARRIER_FAMILY).setQualifier(REPLICATION_PARENT_QUALIFIER).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(value).build());
    }

    public static Put makePutForReplicationBarrier(RegionInfo regionInfo, long openSeqNum, long ts) throws IOException {
        Put put = new Put(regionInfo.getRegionName(), ts);
        ReplicationBarrierFamilyFormat.addReplicationBarrier(put, openSeqNum);
        return put;
    }

    private static long getReplicationBarrier(Cell c) {
        return Bytes.toLong(c.getValueArray(), c.getValueOffset(), c.getValueLength());
    }

    public static long[] getReplicationBarriers(Result result) {
        return result.getColumnCells(HConstants.REPLICATION_BARRIER_FAMILY, HConstants.SEQNUM_QUALIFIER).stream().mapToLong(ReplicationBarrierFamilyFormat::getReplicationBarrier).sorted().distinct().toArray();
    }

    private static ReplicationBarrierResult getReplicationBarrierResult(Result result) {
        long[] barriers = ReplicationBarrierFamilyFormat.getReplicationBarriers(result);
        byte[] stateBytes = result.getValue(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER);
        RegionState.State state = stateBytes != null ? RegionState.State.valueOf(Bytes.toString(stateBytes)) : null;
        byte[] parentRegionsBytes = result.getValue(HConstants.REPLICATION_BARRIER_FAMILY, REPLICATION_PARENT_QUALIFIER);
        List<byte[]> parentRegionNames = parentRegionsBytes != null ? ReplicationBarrierFamilyFormat.parseParentsBytes(parentRegionsBytes) : Collections.emptyList();
        return new ReplicationBarrierResult(barriers, state, parentRegionNames);
    }

    /*
     * Exception decompiling
     */
    public static ReplicationBarrierResult getReplicationBarrierResult(Connection conn, TableName tableName, byte[] row, byte[] encodedRegionName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long[] getReplicationBarriers(Connection conn, byte[] regionName) throws IOException {
        try (Table table = conn.getTable(TableName.META_TABLE_NAME);){
            Result result = table.get(new Get(regionName).addColumn(HConstants.REPLICATION_BARRIER_FAMILY, HConstants.SEQNUM_QUALIFIER).readAllVersions());
            long[] lArray = ReplicationBarrierFamilyFormat.getReplicationBarriers(result);
            return lArray;
        }
    }

    public static List<Pair<String, Long>> getTableEncodedRegionNameAndLastBarrier(Connection conn, TableName tableName) throws IOException {
        ArrayList<Pair<String, Long>> list = new ArrayList<Pair<String, Long>>();
        MetaTableAccessor.scanMeta(conn, ClientMetaTableAccessor.getTableStartRowForMeta(tableName, ClientMetaTableAccessor.QueryType.REPLICATION), ClientMetaTableAccessor.getTableStopRowForMeta(tableName, ClientMetaTableAccessor.QueryType.REPLICATION), ClientMetaTableAccessor.QueryType.REPLICATION, r -> {
            byte[] value = r.getValue(HConstants.REPLICATION_BARRIER_FAMILY, HConstants.SEQNUM_QUALIFIER);
            if (value == null) {
                return true;
            }
            long lastBarrier = Bytes.toLong(value);
            String encodedRegionName = RegionInfo.encodeRegionName(r.getRow());
            list.add(Pair.newPair(encodedRegionName, lastBarrier));
            return true;
        });
        return list;
    }

    public static List<String> getTableEncodedRegionNamesForSerialReplication(Connection conn, TableName tableName) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        MetaTableAccessor.scanMeta(conn, ClientMetaTableAccessor.getTableStartRowForMeta(tableName, ClientMetaTableAccessor.QueryType.REPLICATION), ClientMetaTableAccessor.getTableStopRowForMeta(tableName, ClientMetaTableAccessor.QueryType.REPLICATION), ClientMetaTableAccessor.QueryType.REPLICATION, new FirstKeyOnlyFilter(), Integer.MAX_VALUE, r -> {
            list.add(RegionInfo.encodeRegionName(r.getRow()));
            return true;
        });
        return list;
    }

    public static final class ReplicationBarrierResult {
        private final long[] barriers;
        private final RegionState.State state;
        private final List<byte[]> parentRegionNames;

        ReplicationBarrierResult(long[] barriers, RegionState.State state, List<byte[]> parentRegionNames) {
            this.barriers = barriers;
            this.state = state;
            this.parentRegionNames = parentRegionNames;
        }

        public long[] getBarriers() {
            return this.barriers;
        }

        public RegionState.State getState() {
            return this.state;
        }

        public List<byte[]> getParentRegionNames() {
            return this.parentRegionNames;
        }

        public String toString() {
            return "ReplicationBarrierResult [barriers=" + Arrays.toString(this.barriers) + ", state=" + (Object)((Object)this.state) + ", parentRegionNames=" + this.parentRegionNames.stream().map(Bytes::toStringBinary).collect(Collectors.joining(", ")) + "]";
        }
    }
}

