/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.ZKReplicationStorageBase;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZKReplicationPeerStorage
extends ZKReplicationStorageBase
implements ReplicationPeerStorage {
    public static final String PEERS_ZNODE = "zookeeper.znode.replication.peers";
    public static final String PEERS_ZNODE_DEFAULT = "peers";
    public static final String PEERS_STATE_ZNODE = "zookeeper.znode.replication.peers.state";
    public static final String PEERS_STATE_ZNODE_DEFAULT = "peer-state";
    public static final byte[] ENABLED_ZNODE_BYTES = ZKReplicationPeerStorage.toByteArray(ReplicationProtos.ReplicationState.State.ENABLED);
    public static final byte[] DISABLED_ZNODE_BYTES = ZKReplicationPeerStorage.toByteArray(ReplicationProtos.ReplicationState.State.DISABLED);
    public static final String SYNC_REPLICATION_STATE_ZNODE = "sync-rep-state";
    public static final String NEW_SYNC_REPLICATION_STATE_ZNODE = "new-sync-rep-state";
    public static final byte[] NONE_STATE_ZNODE_BYTES = SyncReplicationState.toByteArray(SyncReplicationState.NONE);
    private final String peerStateNodeName;
    private final String peersZNode;

    public ZKReplicationPeerStorage(ZKWatcher zookeeper, Configuration conf) {
        super(zookeeper, conf);
        this.peerStateNodeName = conf.get(PEERS_STATE_ZNODE, PEERS_STATE_ZNODE_DEFAULT);
        String peersZNodeName = conf.get(PEERS_ZNODE, PEERS_ZNODE_DEFAULT);
        this.peersZNode = ZNodePaths.joinZNode(this.replicationZNode, peersZNodeName);
    }

    public String getPeerStateNode(String peerId) {
        return ZNodePaths.joinZNode(this.getPeerNode(peerId), this.peerStateNodeName);
    }

    public String getPeerNode(String peerId) {
        return ZNodePaths.joinZNode(this.peersZNode, peerId);
    }

    public String getSyncReplicationStateNode(String peerId) {
        return ZNodePaths.joinZNode(this.getPeerNode(peerId), SYNC_REPLICATION_STATE_ZNODE);
    }

    public String getNewSyncReplicationStateNode(String peerId) {
        return ZNodePaths.joinZNode(this.getPeerNode(peerId), NEW_SYNC_REPLICATION_STATE_ZNODE);
    }

    @Override
    public void addPeer(String peerId, ReplicationPeerConfig peerConfig, boolean enabled, SyncReplicationState syncReplicationState) throws ReplicationException {
        List<ZKUtil.ZKUtilOp> multiOps = Arrays.asList(ZKUtil.ZKUtilOp.createAndFailSilent(this.getPeerNode(peerId), ReplicationPeerConfigUtil.toByteArray(peerConfig)), ZKUtil.ZKUtilOp.createAndFailSilent(this.getPeerStateNode(peerId), enabled ? ENABLED_ZNODE_BYTES : DISABLED_ZNODE_BYTES), ZKUtil.ZKUtilOp.createAndFailSilent(this.getSyncReplicationStateNode(peerId), SyncReplicationState.toByteArray(syncReplicationState)), ZKUtil.ZKUtilOp.createAndFailSilent(this.getNewSyncReplicationStateNode(peerId), NONE_STATE_ZNODE_BYTES));
        try {
            ZKUtil.createWithParents(this.zookeeper, this.peersZNode);
            ZKUtil.multiOrSequential(this.zookeeper, multiOps, false);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Could not add peer with id=" + peerId + ", peerConfig=>" + peerConfig + ", state=" + (enabled ? "ENABLED" : "DISABLED") + ", syncReplicationState=" + (Object)((Object)syncReplicationState), e);
        }
    }

    @Override
    public void removePeer(String peerId) throws ReplicationException {
        try {
            ZKUtil.deleteNodeRecursively(this.zookeeper, this.getPeerNode(peerId));
        }
        catch (KeeperException e) {
            throw new ReplicationException("Could not remove peer with id=" + peerId, e);
        }
    }

    @Override
    public void setPeerState(String peerId, boolean enabled) throws ReplicationException {
        byte[] stateBytes = enabled ? ENABLED_ZNODE_BYTES : DISABLED_ZNODE_BYTES;
        try {
            ZKUtil.setData(this.zookeeper, this.getPeerStateNode(peerId), stateBytes);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Unable to change state of the peer with id=" + peerId, e);
        }
    }

    @Override
    public void updatePeerConfig(String peerId, ReplicationPeerConfig peerConfig) throws ReplicationException {
        try {
            ZKUtil.setData(this.zookeeper, this.getPeerNode(peerId), ReplicationPeerConfigUtil.toByteArray(peerConfig));
        }
        catch (KeeperException e) {
            throw new ReplicationException("There was a problem trying to save changes to the replication peer " + peerId, e);
        }
    }

    @Override
    public List<String> listPeerIds() throws ReplicationException {
        try {
            List<String> children = ZKUtil.listChildrenNoWatch(this.zookeeper, this.peersZNode);
            return children != null ? children : Collections.emptyList();
        }
        catch (KeeperException e) {
            throw new ReplicationException("Cannot get the list of peers", e);
        }
    }

    @Override
    public boolean isPeerEnabled(String peerId) throws ReplicationException {
        try {
            return Arrays.equals(ENABLED_ZNODE_BYTES, ZKUtil.getData(this.zookeeper, this.getPeerStateNode(peerId)));
        }
        catch (InterruptedException | KeeperException e) {
            throw new ReplicationException("Unable to get status of the peer with id=" + peerId, e);
        }
    }

    @Override
    public ReplicationPeerConfig getPeerConfig(String peerId) throws ReplicationException {
        byte[] data;
        try {
            data = ZKUtil.getData(this.zookeeper, this.getPeerNode(peerId));
        }
        catch (InterruptedException | KeeperException e) {
            throw new ReplicationException("Error getting configuration for peer with id=" + peerId, e);
        }
        if (data == null || data.length == 0) {
            throw new ReplicationException("Replication peer config data shouldn't be empty, peerId=" + peerId);
        }
        try {
            return ReplicationPeerConfigUtil.parsePeerFrom(data);
        }
        catch (DeserializationException e) {
            throw new ReplicationException("Failed to parse replication peer config for peer with id=" + peerId, e);
        }
    }

    @Override
    public void setPeerNewSyncReplicationState(String peerId, SyncReplicationState state) throws ReplicationException {
        try {
            ZKUtil.createSetData(this.zookeeper, this.getNewSyncReplicationStateNode(peerId), SyncReplicationState.toByteArray(state));
        }
        catch (KeeperException e) {
            throw new ReplicationException("Unable to set the new sync replication state for peer with id=" + peerId, e);
        }
    }

    @Override
    public void transitPeerSyncReplicationState(String peerId) throws ReplicationException {
        String newStateNode = this.getNewSyncReplicationStateNode(peerId);
        try {
            byte[] data = ZKUtil.getData(this.zookeeper, newStateNode);
            ZKUtil.multiOrSequential(this.zookeeper, Arrays.asList(ZKUtil.ZKUtilOp.setData(newStateNode, NONE_STATE_ZNODE_BYTES), ZKUtil.ZKUtilOp.setData(this.getSyncReplicationStateNode(peerId), data)), false);
        }
        catch (InterruptedException | KeeperException e) {
            throw new ReplicationException("Error transiting sync replication state for peer with id=" + peerId, e);
        }
    }

    private SyncReplicationState getSyncReplicationState(String peerId, String path) throws ReplicationException {
        try {
            byte[] data = ZKUtil.getData(this.zookeeper, path);
            if (data == null || data.length == 0) {
                if (ZKUtil.checkExists(this.zookeeper, this.getPeerNode(peerId)) != -1) {
                    ZKUtil.createSetData(this.zookeeper, path, NONE_STATE_ZNODE_BYTES);
                    return SyncReplicationState.NONE;
                }
                throw new ReplicationException("Replication peer sync state shouldn't be empty, peerId=" + peerId);
            }
            return SyncReplicationState.parseFrom(data);
        }
        catch (IOException | InterruptedException | KeeperException e) {
            throw new ReplicationException("Error getting sync replication state of path " + path + " for peer with id=" + peerId, e);
        }
    }

    @Override
    public SyncReplicationState getPeerNewSyncReplicationState(String peerId) throws ReplicationException {
        return this.getSyncReplicationState(peerId, this.getNewSyncReplicationStateNode(peerId));
    }

    @Override
    public SyncReplicationState getPeerSyncReplicationState(String peerId) throws ReplicationException {
        return this.getSyncReplicationState(peerId, this.getSyncReplicationStateNode(peerId));
    }
}

