/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ZKReplicationStorageBase {
    public static final String REPLICATION_ZNODE = "zookeeper.znode.replication";
    public static final String REPLICATION_ZNODE_DEFAULT = "replication";
    protected final String replicationZNode;
    protected final ZKWatcher zookeeper;
    protected final Configuration conf;

    protected ZKReplicationStorageBase(ZKWatcher zookeeper, Configuration conf) {
        this.zookeeper = zookeeper;
        this.conf = conf;
        this.replicationZNode = ZNodePaths.joinZNode(this.zookeeper.getZNodePaths().baseZNode, conf.get(REPLICATION_ZNODE, REPLICATION_ZNODE_DEFAULT));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static byte[] toByteArray(ReplicationProtos.ReplicationState.State state) {
        ReplicationProtos.ReplicationState msg = ReplicationProtos.ReplicationState.newBuilder().setState(state).build();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            CodedOutputStream cos = CodedOutputStream.newInstance(baos, 16);
            msg.writeTo(cos);
            cos.flush();
            baos.flush();
            byte[] byArray = ProtobufUtil.prependPBMagic(baos.toByteArray());
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

