/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.replication.ReplicationPeerManager;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationOffsetUtil;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationQueueData;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleanerBarrier;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hbase.thirdparty.com.google.common.base.Predicate;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.MapUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ReplicationLogCleaner
extends BaseLogCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationLogCleaner.class);
    private Set<ServerName> notFullyDeadServers;
    private Set<String> peerIds;
    private Map<ServerName, Map<String, Map<String, ReplicationGroupOffset>>> replicationOffsets;
    private ReplicationLogCleanerBarrier barrier;
    private ReplicationPeerManager rpm;
    private Supplier<Set<ServerName>> getNotFullyDeadServers;
    private boolean canFilter;
    private boolean stopped = false;

    @Override
    public void preClean() {
        if (this.getConf() == null) {
            return;
        }
        try {
            if (!this.rpm.getQueueStorage().hasData()) {
                return;
            }
        }
        catch (ReplicationException e) {
            LOG.error("Error occurred while executing queueStorage.hasData()", (Throwable)e);
            return;
        }
        this.canFilter = this.barrier.start();
        if (this.canFilter) {
            List<ReplicationQueueData> allQueueData;
            this.notFullyDeadServers = this.getNotFullyDeadServers.get();
            this.peerIds = this.rpm.listPeers(null).stream().map(ReplicationPeerDescription::getPeerId).collect(Collectors.toSet());
            try {
                allQueueData = this.rpm.getQueueStorage().listAllQueues();
            }
            catch (ReplicationException e) {
                LOG.error("Can not list all replication queues, give up cleaning", (Throwable)e);
                this.barrier.stop();
                this.canFilter = false;
                this.notFullyDeadServers = null;
                this.peerIds = null;
                return;
            }
            this.replicationOffsets = new HashMap<ServerName, Map<String, Map<String, ReplicationGroupOffset>>>();
            for (ReplicationQueueData queueData : allQueueData) {
                ReplicationQueueId queueId = queueData.getId();
                ServerName serverName = queueId.getServerWALsBelongTo();
                Map peerId2Offsets = this.replicationOffsets.computeIfAbsent(serverName, k -> new HashMap());
                Map offsets = peerId2Offsets.computeIfAbsent(queueId.getPeerId(), k -> new HashMap());
                offsets.putAll(queueData.getOffsets());
            }
        } else {
            LOG.info("Skip replication log cleaner because an AddPeerProcedure is running");
        }
    }

    @Override
    public void postClean() {
        if (this.canFilter) {
            this.barrier.stop();
            this.canFilter = false;
            this.notFullyDeadServers = null;
            this.peerIds = null;
            this.replicationOffsets = null;
        }
    }

    private boolean shouldDelete(ReplicationGroupOffset offset, FileStatus file) {
        return !ReplicationOffsetUtil.shouldReplicate(offset, file.getPath().getName());
    }

    private boolean filterForLiveRegionServer(ServerName serverName, FileStatus file) {
        Map<String, Map<String, ReplicationGroupOffset>> peerId2Offsets = this.replicationOffsets.get(serverName);
        if (peerId2Offsets == null) {
            return false;
        }
        for (String peerId : this.peerIds) {
            Map<String, ReplicationGroupOffset> offsets = peerId2Offsets.get(peerId);
            if (offsets == null) {
                return false;
            }
            String walGroupId = AbstractFSWALProvider.getWALPrefixFromWALName(file.getPath().getName());
            ReplicationGroupOffset offset = offsets.get(walGroupId);
            if (this.shouldDelete(offset, file)) continue;
            return false;
        }
        return true;
    }

    private boolean filterForDeadRegionServer(ServerName serverName, FileStatus file) {
        Map<String, Map<String, ReplicationGroupOffset>> peerId2Offsets = this.replicationOffsets.get(serverName);
        if (peerId2Offsets == null) {
            return true;
        }
        for (String peerId : this.peerIds) {
            String walGroupId;
            ReplicationGroupOffset offset;
            Map<String, ReplicationGroupOffset> offsets = peerId2Offsets.get(peerId);
            if (offsets == null || this.shouldDelete(offset = offsets.get(walGroupId = AbstractFSWALProvider.getWALPrefixFromWALName(file.getPath().getName())), file)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        if (this.getConf() == null) {
            return files;
        }
        try {
            if (!this.rpm.getQueueStorage().hasData()) {
                return files;
            }
        }
        catch (ReplicationException e) {
            LOG.error("Error occurred while executing queueStorage.hasData()", (Throwable)e);
            return Collections.emptyList();
        }
        if (!this.canFilter) {
            return Collections.emptyList();
        }
        return Iterables.filter(files, new Predicate<FileStatus>(){

            @Override
            public boolean apply(FileStatus file) {
                if (file == null) {
                    return false;
                }
                if (ReplicationLogCleaner.this.peerIds.isEmpty()) {
                    return true;
                }
                if (!AbstractFSWALProvider.validateWALFilename(file.getPath().getName())) {
                    return true;
                }
                if (AbstractFSWALProvider.isMetaFile(file.getPath())) {
                    return true;
                }
                ServerName serverName = AbstractFSWALProvider.parseServerNameFromWALName(file.getPath().getName());
                if (ReplicationLogCleaner.this.notFullyDeadServers.contains(serverName)) {
                    return ReplicationLogCleaner.this.filterForLiveRegionServer(serverName, file);
                }
                return ReplicationLogCleaner.this.filterForDeadRegionServer(serverName, file);
            }
        });
    }

    private Set<ServerName> getNotFullyDeadServers(MasterServices services) {
        List<ServerName> onlineServers = services.getServerManager().getOnlineServersList();
        return Stream.concat(onlineServers.stream(), services.getMasterProcedureExecutor().getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure).filter(p -> !p.isFinished()).map(p -> ((ServerCrashProcedure)p).getServerName())).collect(Collectors.toSet());
    }

    @Override
    public void init(Map<String, Object> params) {
        Object master;
        super.init(params);
        if (MapUtils.isNotEmpty(params) && (master = params.get("master")) != null && master instanceof MasterServices) {
            MasterServices m3 = (MasterServices)master;
            this.barrier = m3.getReplicationLogCleanerBarrier();
            this.rpm = m3.getReplicationPeerManager();
            this.getNotFullyDeadServers = () -> this.getNotFullyDeadServers(m3);
            return;
        }
        throw new IllegalArgumentException("Missing master parameter");
    }

    @Override
    public void stop(String why) {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }
}

