/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.procedure2.BaseRSProcedureCallable;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.regionserver.PeerProcedureHandler;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ClaimReplicationQueueCallable
extends BaseRSProcedureCallable {
    private ReplicationQueueId queueId;

    @Override
    public EventType getEventType() {
        return EventType.RS_CLAIM_REPLICATION_QUEUE;
    }

    @Override
    protected void doCall() throws Exception {
        PeerProcedureHandler handler = this.rs.getReplicationSourceService().getPeerProcedureHandler();
        handler.claimReplicationQueue(this.queueId);
    }

    @Override
    protected void initParameter(byte[] parameter) throws InvalidProtocolBufferException {
        MasterProcedureProtos.ClaimReplicationQueueRemoteParameter param = MasterProcedureProtos.ClaimReplicationQueueRemoteParameter.parseFrom(parameter);
        ServerName crashedServer = ProtobufUtil.toServerName(param.getCrashedServer());
        String queue = param.getQueue();
        if (param.hasSourceServer()) {
            ServerName sourceServer = ProtobufUtil.toServerName(param.getSourceServer());
            this.queueId = new ReplicationQueueId(crashedServer, queue, sourceServer);
        } else {
            this.queueId = new ReplicationQueueId(crashedServer, queue);
        }
    }
}

