/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.io.WALLink;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationOffsetUtil;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationQueueData;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.AtomicLongMap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DumpReplicationQueues
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger((String)DumpReplicationQueues.class.getName());
    private List<String> deadRegionServers = new ArrayList<String>();
    private List<String> deletedQueues = new ArrayList<String>();
    private AtomicLongMap<String> peersQueueSize = AtomicLongMap.create();
    private long totalSizeOfWALs = 0L;
    private long numWalsNotFound = 0L;

    static DumpOptions parseOpts(Queue<String> args) {
        DumpOptions opts = new DumpOptions();
        String cmd = null;
        while ((cmd = args.poll()) != null) {
            if (cmd.equals("-h") || cmd.equals("--h") || cmd.equals("--help")) {
                args.add(cmd);
                break;
            }
            String hdfs = "--hdfs";
            if (cmd.equals("--hdfs")) {
                opts.setHdfs(true);
                continue;
            }
            String distributed = "--distributed";
            if (cmd.equals("--distributed")) {
                opts.setDistributed(true);
                continue;
            }
            DumpReplicationQueues.printUsageAndExit("ERROR: Unrecognized option/command: " + cmd, -1);
            if (opts.isDistributed() || !opts.isHdfs()) continue;
            DumpReplicationQueues.printUsageAndExit("ERROR: --hdfs option can only be used with --distributed: " + cmd, -1);
        }
        return opts;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new DumpReplicationQueues(), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        int errCode = -1;
        LinkedList<String> argv = new LinkedList<String>();
        argv.addAll(Arrays.asList(args));
        DumpOptions opts = DumpReplicationQueues.parseOpts(argv);
        if (!argv.isEmpty()) {
            errCode = 0;
            this.printUsage();
            return errCode;
        }
        return this.dumpReplicationQueues(opts);
    }

    protected void printUsage() {
        DumpReplicationQueues.printUsage(((Object)((Object)this)).getClass().getName(), null);
    }

    protected static void printUsage(String message) {
        DumpReplicationQueues.printUsage(DumpReplicationQueues.class.getName(), message);
    }

    protected static void printUsage(String className, String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.println("Usage: hbase " + className + " \\");
        System.err.println("  <OPTIONS> [-D<property=value>]*");
        System.err.println();
        System.err.println("General Options:");
        System.err.println(" -h|--h|--help  Show this help and exit.");
        System.err.println(" --distributed  Poll each RS and print its own replication queue. Default only polls replication table.");
        System.err.println(" --hdfs         Use HDFS to calculate usage of WALs by replication. It could be overestimated if replicating to multiple peers. --distributed flag is also needed.");
    }

    protected static void printUsageAndExit(String message, int exitCode) {
        DumpReplicationQueues.printUsage(message);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dumpReplicationQueues(DumpOptions opts) throws Exception {
        Configuration conf = this.getConf();
        Connection connection = ConnectionFactory.createConnection(conf);
        Admin admin = connection.getAdmin();
        try {
            List<TableCFs> replicatedTableCFs = admin.listReplicatedTableCFs();
            if (replicatedTableCFs.isEmpty()) {
                LOG.info("No tables with a configured replication peer were found.");
                int n = 0;
                return n;
            }
            LOG.info("Replicated Tables: " + replicatedTableCFs);
            List<ReplicationPeerDescription> peers = admin.listReplicationPeers();
            if (peers.isEmpty()) {
                LOG.info("Replication is enabled but no peer configuration was found.");
            }
            System.out.println("Dumping replication peers and configurations:");
            System.out.println(this.dumpPeersState(peers));
            if (opts.isDistributed()) {
                LOG.info("Found [--distributed], will poll each RegionServer.");
                Set<String> peerIds = peers.stream().map(peer -> peer.getPeerId()).collect(Collectors.toSet());
                System.out.println(this.dumpQueues(connection, peerIds, opts.isHdfs(), conf));
                System.out.println(this.dumpReplicationSummary());
            } else {
                System.out.println("Dumping replication info via replication table.");
                System.out.println(this.dumpReplicationViaTable(connection, conf));
            }
            int n = 0;
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            connection.close();
        }
    }

    public String dumpReplicationViaTable(Connection connection, Configuration conf) throws ReplicationException, IOException {
        StringBuilder sb = new StringBuilder();
        ReplicationQueueStorage queueStorage = ReplicationStorageFactory.getReplicationQueueStorage(connection, conf);
        String peersKey = "peers";
        sb.append(peersKey).append(": ").append("\n");
        List<ReplicationPeerDescription> repPeerDescs = connection.getAdmin().listReplicationPeers();
        for (ReplicationPeerDescription repPeerDesc : repPeerDescs) {
            sb.append(peersKey).append("/").append(repPeerDesc.getPeerId()).append(": ").append(repPeerDesc.getPeerConfig().getClusterKey()).append("\n");
            sb.append(peersKey).append("/").append(repPeerDesc.getPeerId()).append("/peer-state: ").append(repPeerDesc.isEnabled() ? "ENABLED" : "DISABLED").append("\n");
        }
        List<ReplicationQueueData> repQueueDataList = queueStorage.listAllQueues();
        String rsKey = "rs";
        sb.append(rsKey).append(": ").append("\n");
        for (ReplicationQueueData repQueueData : repQueueDataList) {
            String peerId = repQueueData.getId().getPeerId();
            for (Map.Entry entry : repQueueData.getOffsets().entrySet()) {
                sb.append(rsKey).append("/").append((String)entry.getKey()).append("/").append(peerId).append("/").append(((ReplicationGroupOffset)entry.getValue()).getWal()).append(": ").append(((ReplicationGroupOffset)entry.getValue()).getOffset()).append("\n");
            }
        }
        List<String> peerIds = queueStorage.getAllPeersFromHFileRefsQueue();
        String hfileKey = "hfile-refs";
        sb.append(hfileKey).append(": ").append("\n");
        for (String peerId : peerIds) {
            List<String> hfiles = queueStorage.getReplicableHFiles(peerId);
            sb.append(hfileKey).append("/").append(peerId).append("/").append(String.join((CharSequence)",", hfiles)).append("\n");
        }
        return sb.toString();
    }

    public String dumpReplicationSummary() {
        StringBuilder sb = new StringBuilder();
        if (!this.deletedQueues.isEmpty()) {
            sb.append("Found " + this.deletedQueues.size() + " deleted queues, run hbck -fixReplication in order to remove the deleted replication queues\n");
            for (String string : this.deletedQueues) {
                sb.append("    " + string + "\n");
            }
        }
        if (!this.deadRegionServers.isEmpty()) {
            sb.append("Found " + this.deadRegionServers.size() + " dead regionservers, restart one regionserver to transfer the queues of dead regionservers\n");
            for (String string : this.deadRegionServers) {
                sb.append("    " + string + "\n");
            }
        }
        if (!this.peersQueueSize.isEmpty()) {
            sb.append("Dumping all peers's number of WALs in replication queue\n");
            for (Map.Entry entry : this.peersQueueSize.asMap().entrySet()) {
                sb.append("    PeerId: " + (String)entry.getKey() + " , sizeOfLogQueue: " + entry.getValue() + "\n");
            }
        }
        sb.append("    Total size of WALs on HDFS: " + StringUtils.humanSize(this.totalSizeOfWALs) + "\n");
        if (this.numWalsNotFound > 0L) {
            sb.append("    ERROR: There are " + this.numWalsNotFound + " WALs not found!!!\n");
        }
        return sb.toString();
    }

    public String dumpPeersState(List<ReplicationPeerDescription> peers) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (ReplicationPeerDescription peer : peers) {
            ReplicationPeerConfig peerConfig = peer.getPeerConfig();
            sb.append("Peer: " + peer.getPeerId() + "\n");
            sb.append("    State: " + (peer.isEnabled() ? "ENABLED" : "DISABLED") + "\n");
            sb.append("    Cluster Name: " + peerConfig.getClusterKey() + "\n");
            sb.append("    Replication Endpoint: " + peerConfig.getReplicationEndpointImpl() + "\n");
            Map<String, String> currentConf = peerConfig.getConfiguration();
            if (currentConf.size() > 1) {
                sb.append("    Peer Configuration: " + currentConf + "\n");
            }
            sb.append("    Peer Table CFs: " + peerConfig.getTableCFsMap() + "\n");
            sb.append("    Peer Namespaces: " + peerConfig.getNamespaces() + "\n");
        }
        return sb.toString();
    }

    public String dumpQueues(Connection connection, Set<String> peerIds, boolean hdfs, Configuration conf) throws Exception {
        StringBuilder sb = new StringBuilder();
        ReplicationQueueStorage queueStorage = ReplicationStorageFactory.getReplicationQueueStorage(connection, conf);
        Set<ServerName> liveRegionServers = connection.getAdmin().getClusterMetrics().getLiveServerMetrics().keySet();
        List<ServerName> regionServers = queueStorage.listAllReplicators();
        if (regionServers == null || regionServers.isEmpty()) {
            return sb.toString();
        }
        for (ServerName regionServer : regionServers) {
            List<ReplicationQueueId> queueIds = queueStorage.listAllQueueIds(regionServer);
            if (!liveRegionServers.contains(regionServer)) {
                this.deadRegionServers.add(regionServer.getServerName());
            }
            for (ReplicationQueueId queueId : queueIds) {
                ArrayList tmpWals = new ArrayList();
                AbstractFSWALProvider.getWALFiles(connection.getConfiguration(), queueId.getServerWALsBelongTo()).stream().map(Path::toString).forEach(tmpWals::add);
                AbstractFSWALProvider.getArchivedWALFiles(connection.getConfiguration(), queueId.getServerWALsBelongTo(), URLEncoder.encode(queueId.getServerWALsBelongTo().toString(), StandardCharsets.UTF_8.name())).stream().map(Path::toString).forEach(tmpWals::add);
                Map<String, ReplicationGroupOffset> offsets = queueStorage.getOffsets(queueId);
                ArrayList<String> wals = new ArrayList<String>();
                for (Map.Entry<String, ReplicationGroupOffset> entry : offsets.entrySet()) {
                    ReplicationGroupOffset offset = entry.getValue();
                    for (String wal : tmpWals) {
                        if (!ReplicationOffsetUtil.shouldReplicate(offset, wal)) continue;
                        wals.add(wal);
                    }
                }
                Collections.sort(wals, Comparator.comparingLong(AbstractFSWALProvider::getTimestamp));
                if (!peerIds.contains(queueId.getPeerId())) {
                    this.deletedQueues.add(regionServer + "/" + queueId);
                    sb.append(this.formatQueue(regionServer, offsets, wals, queueId, true, hdfs));
                    continue;
                }
                sb.append(this.formatQueue(regionServer, offsets, wals, queueId, false, hdfs));
            }
        }
        return sb.toString();
    }

    private String formatQueue(ServerName regionServer, Map<String, ReplicationGroupOffset> offsets, List<String> wals, ReplicationQueueId queueId, boolean isDeleted, boolean hdfs) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("Dumping replication queue info for RegionServer: [" + regionServer + "]\n");
        sb.append("    Queue id: " + queueId + "\n");
        sb.append("    PeerID: " + queueId.getPeerId() + "\n");
        sb.append("    Recovered: " + queueId.isRecovered() + "\n");
        if (queueId.getSourceServerName().isPresent()) {
            sb.append("    Dead RegionServer: " + queueId.getSourceServerName().get() + "\n");
        } else {
            sb.append("    No dead RegionServer found in this queue.\n");
        }
        sb.append("    Was deleted: " + isDeleted + "\n");
        sb.append("    Number of WALs in replication queue: " + wals.size() + "\n");
        this.peersQueueSize.addAndGet(queueId.getPeerId(), wals.size());
        for (Map.Entry<String, ReplicationGroupOffset> entry : offsets.entrySet()) {
            String walGroup = entry.getKey();
            ReplicationGroupOffset offset = entry.getValue();
            for (String wal : wals) {
                long position = 0L;
                if (offset.getWal().equals(wal)) {
                    position = offset.getOffset();
                }
                sb.append(" Replication position for " + (walGroup != null ? walGroup + "/" + wal : wal) + ": ");
                if (position == 0L) {
                    sb.append("0 (not started or nothing to replicate)");
                } else if (position > 0L) {
                    sb.append(position);
                }
                sb.append("\n");
            }
        }
        if (hdfs) {
            FileSystem fs = FileSystem.get((Configuration)this.getConf());
            sb.append("    Total size of WALs on HDFS for this queue: " + StringUtils.humanSize(this.getTotalWALSize(fs, wals, regionServer)) + "\n");
        }
        return sb.toString();
    }

    private long getTotalWALSize(FileSystem fs, List<String> wals, ServerName server) {
        long size = 0L;
        for (String wal : wals) {
            FileStatus fileStatus;
            try {
                fileStatus = new WALLink(this.getConf(), server.getServerName(), wal).getFileStatus(fs);
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    ++this.numWalsNotFound;
                    LOG.warn("WAL " + wal + " couldn't be found, skipping", (Throwable)e);
                    continue;
                }
                LOG.warn("Can't get file status of WAL " + wal + ", skipping", (Throwable)e);
                continue;
            }
            size += fileStatus.getLen();
        }
        this.totalSizeOfWALs += size;
        return size;
    }

    static class DumpOptions {
        boolean hdfs = false;
        boolean distributed = false;

        public DumpOptions() {
        }

        public DumpOptions(DumpOptions that) {
            this.hdfs = that.hdfs;
            this.distributed = that.distributed;
        }

        boolean isHdfs() {
            return this.hdfs;
        }

        boolean isDistributed() {
            return this.distributed;
        }

        void setHdfs(boolean hdfs) {
            this.hdfs = hdfs;
        }

        void setDistributed(boolean distributed) {
            this.distributed = distributed;
        }
    }
}

