/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.replication.OfflineTableReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JsonMapper;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationSyncUp
extends Configured
implements Tool {
    public static final String INFO_DIR = "ReplicationSyncUp";
    public static final String INFO_FILE = "info";
    private static final long SLEEP_TIME = 10000L;

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new ReplicationSyncUp(), (String[])args);
        System.exit(ret);
    }

    private Set<ServerName> listRegionServers(FileSystem walFs, Path walDir) throws IOException {
        FileStatus[] statuses;
        try {
            statuses = walFs.listStatus(walDir);
        }
        catch (FileNotFoundException e) {
            System.out.println("WAL directory " + walDir + " does not exists, ignore");
            return Collections.emptySet();
        }
        HashSet<ServerName> regionServers = new HashSet<ServerName>();
        for (FileStatus status : statuses) {
            ServerName sn;
            if (!status.isDirectory() || (sn = AbstractFSWALProvider.getServerNameFromWALDirectoryName(status.getPath())) == null) continue;
            regionServers.add(sn);
        }
        return regionServers;
    }

    private void addMissingReplicationQueues(ReplicationQueueStorage storage, ServerName regionServer, Set<String> peerIds) throws ReplicationException {
        HashSet<String> existingQueuePeerIds = new HashSet<String>();
        List<ReplicationQueueId> queueIds = storage.listAllQueueIds(regionServer);
        for (ReplicationQueueId queueId : queueIds) {
            if (queueId.isRecovered()) continue;
            existingQueuePeerIds.add(queueId.getPeerId());
        }
        for (String peerId : peerIds) {
            if (existingQueuePeerIds.contains(peerId)) continue;
            ReplicationQueueId queueId = new ReplicationQueueId(regionServer, peerId);
            System.out.println("Add replication queue " + queueId + " for claiming");
            storage.setOffset(queueId, regionServer.toString(), ReplicationGroupOffset.BEGIN, Collections.emptyMap());
        }
    }

    private void addMissingReplicationQueues(ReplicationQueueStorage storage, Set<ServerName> regionServers, Set<String> peerIds) throws ReplicationException {
        for (ServerName regionServer : regionServers) {
            this.addMissingReplicationQueues(storage, regionServer, peerIds);
        }
    }

    private void claimReplicationQueues(ReplicationSourceManager mgr, Set<ServerName> regionServers) throws ReplicationException, KeeperException, IOException {
        HashSet<ServerName> replicators = new HashSet<ServerName>(regionServers);
        ReplicationQueueStorage queueStorage = mgr.getQueueStorage();
        replicators.addAll(queueStorage.listAllReplicators());
        FileSystem fs = CommonFSUtils.getCurrentFileSystem(this.getConf());
        Path infoDir = new Path(CommonFSUtils.getRootDir(this.getConf()), INFO_DIR);
        for (ServerName sn : replicators) {
            List<ReplicationQueueId> replicationQueues = queueStorage.listAllQueueIds(sn);
            System.out.println(sn + " is dead, claim its replication queues: " + replicationQueues);
            fs.createNewFile(new Path(infoDir, sn.getServerName()));
            for (ReplicationQueueId queueId : replicationQueues) {
                mgr.claimQueue(queueId, true);
            }
        }
    }

    private void writeInfoFile(FileSystem fs, boolean isForce) throws IOException {
        ReplicationSyncUpToolInfo info = new ReplicationSyncUpToolInfo(EnvironmentEdgeManager.currentTime());
        String json = JsonMapper.writeObjectAsString(info);
        Path infoDir = new Path(CommonFSUtils.getRootDir(this.getConf()), INFO_DIR);
        try (FSDataOutputStream out = fs.create(new Path(infoDir, INFO_FILE), isForce);){
            out.write(Bytes.toBytes(json));
        }
    }

    private static boolean parseOpts(String[] args) {
        LinkedList<String> argv = new LinkedList<String>();
        argv.addAll(Arrays.asList(args));
        String cmd = null;
        while ((cmd = (String)argv.poll()) != null) {
            if (cmd.equals("-h") || cmd.equals("--h") || cmd.equals("--help")) {
                ReplicationSyncUp.printUsageAndExit(null, 0);
            }
            if (cmd.equals("-f")) {
                return true;
            }
            if (argv.isEmpty()) continue;
            ReplicationSyncUp.printUsageAndExit("ERROR: Unrecognized option/command: " + cmd, -1);
        }
        return false;
    }

    private static void printUsageAndExit(String message, int exitCode) {
        ReplicationSyncUp.printUsage(message);
        System.exit(exitCode);
    }

    private static void printUsage(String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.println("Usage: hbase " + ReplicationSyncUp.class.getName() + " \\");
        System.err.println("  <OPTIONS> [-D<property=value>]*");
        System.err.println();
        System.err.println("General Options:");
        System.err.println(" -h|--h|--help  Show this help and exit.");
        System.err.println(" -f Start a new ReplicationSyncUp after the previous ReplicationSyncUp failed. See HBASE-27623 for details.");
    }

    public int run(String[] args) throws Exception {
        Abortable abortable = new Abortable(){
            private volatile boolean abort = false;

            @Override
            public void abort(String why, Throwable e) {
                if (this.isAborted()) {
                    return;
                }
                this.abort = true;
                System.err.println("Aborting because of " + why);
                e.printStackTrace();
                System.exit(1);
            }

            @Override
            public boolean isAborted() {
                return this.abort;
            }
        };
        boolean isForce = ReplicationSyncUp.parseOpts(args);
        Configuration conf = this.getConf();
        try (ZKWatcher zkw = new ZKWatcher(conf, "syncupReplication" + EnvironmentEdgeManager.currentTime(), abortable, true);){
            Path walRootDir = CommonFSUtils.getWALRootDir(conf);
            FileSystem fs = CommonFSUtils.getWALFileSystem(conf);
            Path oldLogDir = new Path(walRootDir, "oldWALs");
            Path logDir = new Path(walRootDir, "WALs");
            System.out.println("Start Replication Server");
            this.writeInfoFile(fs, isForce);
            Replication replication = new Replication();
            this.getConf().setClass("hbase.replication.queue.storage.impl", OfflineTableReplicationQueueStorage.class, ReplicationQueueStorage.class);
            DummyServer server = new DummyServer(this.getConf(), zkw);
            replication.initialize(server, fs, new Path(logDir, server.toString()), oldLogDir, new WALFactory(conf, ServerName.valueOf(((Object)((Object)this)).getClass().getSimpleName() + ",16010," + EnvironmentEdgeManager.currentTime()), null));
            ReplicationSourceManager manager = replication.getReplicationManager();
            manager.init();
            Set<ServerName> regionServers = this.listRegionServers(fs, logDir);
            this.addMissingReplicationQueues(manager.getQueueStorage(), regionServers, manager.getReplicationPeers().getAllPeerIds());
            this.claimReplicationQueues(manager, regionServers);
            while (manager.activeFailoverTaskCount() > 0) {
                Thread.sleep(10000L);
            }
            while (manager.getOldSources().size() > 0) {
                Thread.sleep(10000L);
            }
            manager.join();
        }
        catch (InterruptedException e) {
            System.err.println("didn't wait long enough:" + e);
            return -1;
        }
        return 0;
    }

    private static final class DummyServer
    implements Server {
        private final Configuration conf;
        private final String hostname = EnvironmentEdgeManager.currentTime() + ".SyncUpTool.replication.org";
        private final ZKWatcher zkw;
        private volatile boolean abort = false;

        DummyServer(Configuration conf, ZKWatcher zkw) {
            this.conf = conf;
            this.zkw = zkw;
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        @Override
        public ZKWatcher getZooKeeper() {
            return this.zkw;
        }

        @Override
        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        @Override
        public ServerName getServerName() {
            return ServerName.valueOf(this.hostname, 1234, 1L);
        }

        @Override
        public void abort(String why, Throwable e) {
            if (this.isAborted()) {
                return;
            }
            this.abort = true;
            System.err.println("Aborting because of " + why);
            e.printStackTrace();
            System.exit(1);
        }

        @Override
        public boolean isAborted() {
            return this.abort;
        }

        @Override
        public void stop(String why) {
        }

        @Override
        public boolean isStopped() {
            return false;
        }

        @Override
        public Connection getConnection() {
            return null;
        }

        @Override
        public ChoreService getChoreService() {
            return null;
        }

        @Override
        public FileSystem getFileSystem() {
            return null;
        }

        @Override
        public boolean isStopping() {
            return false;
        }

        @Override
        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }

        @Override
        public AsyncClusterConnection getAsyncClusterConnection() {
            return null;
        }
    }

    public static class ReplicationSyncUpToolInfo {
        private long startTimeMs;

        public ReplicationSyncUpToolInfo() {
        }

        public ReplicationSyncUpToolInfo(long startTimeMs) {
            this.startTimeMs = startTimeMs;
        }

        public long getStartTimeMs() {
            return this.startTimeMs;
        }

        public void setStartTimeMs(long startTimeMs) {
            this.startTimeMs = startTimeMs;
        }
    }
}

