/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class SyncReplicationPeerMappingManager {
    private final ConcurrentMap<TableName, String> table2PeerId = new ConcurrentHashMap<TableName, String>();

    SyncReplicationPeerMappingManager() {
    }

    void add(String peerId, ReplicationPeerConfig peerConfig) {
        peerConfig.getTableCFsMap().keySet().forEach(tn -> this.table2PeerId.put((TableName)tn, peerId));
    }

    void remove(String peerId, ReplicationPeerConfig peerConfig) {
        peerConfig.getTableCFsMap().keySet().forEach(this.table2PeerId::remove);
    }

    String getPeerId(TableName tableName) {
        return (String)this.table2PeerId.get(tableName);
    }
}

