/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.ClusterConnectionFactory;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.FsDelegationToken;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSVisitor;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimaps;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class BulkLoadHFilesTool
extends Configured
implements BulkLoadHFiles,
Tool {
    private static final Logger LOG = LoggerFactory.getLogger(BulkLoadHFilesTool.class);
    public static final String LOCALITY_SENSITIVE_CONF_KEY = "hbase.bulkload.locality.sensitive.enabled";
    private static final boolean DEFAULT_LOCALITY_SENSITIVE = true;
    public static final String NAME = "completebulkload";
    private static final String VALIDATE_HFILES = "hbase.loadincremental.validate.hfile";
    public static final String BULK_LOAD_HFILES_BY_FAMILY = "hbase.mapreduce.bulkload.by.family";
    public static final String FAIL_IF_NEED_SPLIT_HFILE = "hbase.loadincremental.fail.if.need.split.hfile";
    static final String TMP_DIR = ".tmp";
    private int maxFilesPerRegionPerFamily;
    private boolean assignSeqIds;
    private boolean bulkLoadByFamily;
    private FsDelegationToken fsDelegationToken;
    private UserProvider userProvider;
    private int nrThreads;
    private final AtomicInteger numRetries = new AtomicInteger(0);
    private String bulkToken;
    private List<String> clusterIds = new ArrayList<String>();
    private boolean replicate = true;
    private boolean failIfNeedSplitHFile = false;

    public BulkLoadHFilesTool(Configuration conf) {
        super(new Configuration(conf));
        this.initialize();
    }

    public void initialize() {
        Configuration conf = this.getConf();
        conf.setFloat("hfile.block.cache.size", 0.0f);
        this.userProvider = UserProvider.instantiate(conf);
        this.fsDelegationToken = new FsDelegationToken(this.userProvider, "renewer");
        this.assignSeqIds = conf.getBoolean("hbase.mapreduce.bulkload.assign.sequenceNumbers", true);
        this.maxFilesPerRegionPerFamily = conf.getInt("hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily", 32);
        this.nrThreads = conf.getInt("hbase.loadincremental.threads.max", Runtime.getRuntime().availableProcessors());
        this.bulkLoadByFamily = conf.getBoolean(BULK_LOAD_HFILES_BY_FAMILY, false);
        this.failIfNeedSplitHFile = conf.getBoolean(FAIL_IF_NEED_SPLIT_HFILE, false);
    }

    private ExecutorService createExecutorService() {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(this.nrThreads, this.nrThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("BulkLoadHFilesTool-%1$d").setDaemon(true).build());
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private boolean isCreateTable() {
        return "yes".equalsIgnoreCase(this.getConf().get("create.table", "yes"));
    }

    private boolean isSilence() {
        return "yes".equalsIgnoreCase(this.getConf().get("ignore.unmatched.families", ""));
    }

    private boolean isAlwaysCopyFiles() {
        return this.getConf().getBoolean("always.copy.files", false);
    }

    private static boolean shouldCopyHFileMetaKey(byte[] key) {
        if (Bytes.equals(key, HFileDataBlockEncoder.DATA_BLOCK_ENCODING)) {
            return false;
        }
        return !HFileInfo.isReservedFileInfoKey(key);
    }

    private static void validateFamiliesInHFiles(TableDescriptor tableDesc, Deque<BulkLoadHFiles.LoadQueueItem> queue, boolean silence) throws IOException {
        Set familyNames = Arrays.stream(tableDesc.getColumnFamilies()).map(ColumnFamilyDescriptor::getNameAsString).collect(Collectors.toSet());
        List unmatchedFamilies = queue.stream().map(item -> Bytes.toString(item.getFamily())).filter(fn -> !familyNames.contains(fn)).distinct().collect(Collectors.toList());
        if (unmatchedFamilies.size() > 0) {
            String msg = "Unmatched family names found: unmatched family names in HFiles to be bulkloaded: " + unmatchedFamilies + "; valid family names of table " + tableDesc.getTableName() + " are: " + familyNames;
            LOG.error(msg);
            if (!silence) {
                throw new IOException(msg);
            }
        }
    }

    private static void populateLoadQueue(Deque<BulkLoadHFiles.LoadQueueItem> ret, Map<byte[], List<Path>> map) {
        map.forEach((k, v) -> v.stream().map(p -> new BulkLoadHFiles.LoadQueueItem((byte[])k, (Path)p)).forEachOrdered(ret::add));
    }

    private static <TFamily> void visitBulkHFiles(FileSystem fs, Path bulkDir, BulkHFileVisitor<TFamily> visitor, boolean validateHFile) throws IOException {
        FileStatus[] familyDirStatuses;
        for (FileStatus familyStat : familyDirStatuses = fs.listStatus(bulkDir)) {
            FileStatus[] hfileStatuses;
            if (!familyStat.isDirectory()) {
                LOG.warn("Skipping non-directory " + familyStat.getPath());
                continue;
            }
            Path familyDir = familyStat.getPath();
            byte[] familyName = Bytes.toBytes(familyDir.getName());
            try {
                ColumnFamilyDescriptorBuilder.isLegalColumnFamilyName(familyName);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Skipping invalid " + familyStat.getPath());
                continue;
            }
            TFamily family = visitor.bulkFamily(familyName);
            for (FileStatus hfileStatus : hfileStatuses = fs.listStatus(familyDir)) {
                block12: {
                    if (!fs.isFile(hfileStatus.getPath())) {
                        LOG.warn("Skipping non-file " + hfileStatus);
                        continue;
                    }
                    Path hfile = hfileStatus.getPath();
                    String fileName = hfile.getName();
                    if (fileName.startsWith("_")) continue;
                    if (StoreFileInfo.isReference(fileName)) {
                        LOG.warn("Skipping reference " + fileName);
                        continue;
                    }
                    if (HFileLink.isHFileLink(fileName)) {
                        LOG.warn("Skipping HFileLink " + fileName);
                        continue;
                    }
                    if (validateHFile) {
                        try {
                            if (!HFile.isHFileFormat(fs, hfile)) {
                                LOG.warn("the file " + hfile + " doesn't seems to be an hfile. skipping");
                            }
                            break block12;
                        }
                        catch (FileNotFoundException e) {
                            LOG.warn("the file " + hfile + " was removed");
                        }
                        continue;
                    }
                }
                visitor.bulkHFile(family, hfileStatus);
            }
        }
    }

    private static void discoverLoadQueue(final Configuration conf, final Deque<BulkLoadHFiles.LoadQueueItem> ret, Path hfofDir, boolean validateHFile) throws IOException {
        BulkLoadHFilesTool.visitBulkHFiles(hfofDir.getFileSystem(conf), hfofDir, new BulkHFileVisitor<byte[]>(){

            @Override
            public byte[] bulkFamily(byte[] familyName) {
                return familyName;
            }

            @Override
            public void bulkHFile(byte[] family, FileStatus hfile) {
                long length = hfile.getLen();
                if (length > conf.getLong("hbase.hregion.max.filesize", 0x280000000L)) {
                    LOG.warn("Trying to bulk load hfile " + hfile.getPath() + " with size: " + length + " bytes can be problematic as it may lead to oversplitting.");
                }
                ret.add(new BulkLoadHFiles.LoadQueueItem(family, hfile.getPath()));
            }
        }, validateHFile);
    }

    public static void prepareHFileQueue(AsyncClusterConnection conn, TableName tableName, Map<byte[], List<Path>> map, Deque<BulkLoadHFiles.LoadQueueItem> queue, boolean silence) throws IOException {
        BulkLoadHFilesTool.populateLoadQueue(queue, map);
        BulkLoadHFilesTool.validateFamiliesInHFiles(FutureUtils.get(conn.getAdmin().getDescriptor(tableName)), queue, silence);
    }

    public static void prepareHFileQueue(Configuration conf, AsyncClusterConnection conn, TableName tableName, Path hfilesDir, Deque<BulkLoadHFiles.LoadQueueItem> queue, boolean validateHFile, boolean silence) throws IOException {
        BulkLoadHFilesTool.discoverLoadQueue(conf, queue, hfilesDir, validateHFile);
        BulkLoadHFilesTool.validateFamiliesInHFiles(FutureUtils.get(conn.getAdmin().getDescriptor(tableName)), queue, silence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHFileQueue(AsyncClusterConnection conn, TableName tableName, Deque<BulkLoadHFiles.LoadQueueItem> queue, boolean copyFiles) throws IOException {
        ExecutorService pool = this.createExecutorService();
        try {
            Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups = this.groupOrSplitPhase(conn, tableName, pool, queue, FutureUtils.get(conn.getRegionLocator(tableName).getStartEndKeys())).getFirst();
            this.bulkLoadPhase(conn, tableName, queue, regionGroups, copyFiles, null);
        }
        finally {
            pool.shutdown();
        }
    }

    @InterfaceAudience.Private
    protected CompletableFuture<Collection<BulkLoadHFiles.LoadQueueItem>> tryAtomicRegionLoad(AsyncClusterConnection conn, TableName tableName, boolean copyFiles, byte[] first, Collection<BulkLoadHFiles.LoadQueueItem> lqis) {
        List<Pair<byte[], String>> familyPaths = lqis.stream().map(lqi -> Pair.newPair(lqi.getFamily(), lqi.getFilePath().toString())).collect(Collectors.toList());
        CompletableFuture<Collection<BulkLoadHFiles.LoadQueueItem>> future = new CompletableFuture<Collection<BulkLoadHFiles.LoadQueueItem>>();
        FutureUtils.addListener(conn.bulkLoad(tableName, familyPaths, first, this.assignSeqIds, this.fsDelegationToken.getUserToken(), this.bulkToken, copyFiles, this.clusterIds, this.replicate), (loaded, error) -> {
            if (error != null) {
                LOG.error("Encountered unrecoverable error from region server", error);
                if (this.getConf().getBoolean("hbase.bulkload.retries.retryOnIOException", false) && this.numRetries.get() < this.getConf().getInt("hbase.client.retries.number", 15)) {
                    LOG.warn("Will attempt to retry loading failed HFiles. Retry #" + this.numRetries.incrementAndGet());
                    future.complete(lqis);
                } else {
                    LOG.error("hbase.bulkload.retries.retryOnIOException is disabled or we have reached retry limit. Unable to recover");
                    future.completeExceptionally((Throwable)error);
                }
            } else if (loaded.booleanValue()) {
                future.complete(Collections.emptyList());
            } else {
                LOG.warn("Attempt to bulk load region containing " + Bytes.toStringBinary(first) + " into table " + tableName + " with files " + lqis + " failed.  This is recoverable and they will be retried.");
                future.complete(lqis);
            }
        });
        return future;
    }

    @InterfaceAudience.Private
    protected void bulkLoadPhase(AsyncClusterConnection conn, TableName tableName, Deque<BulkLoadHFiles.LoadQueueItem> queue, Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups, boolean copyFiles, Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> item2RegionMap) throws IOException {
        ArrayList<CompletableFuture<Collection<BulkLoadHFiles.LoadQueueItem>>> loadingFutures = new ArrayList<CompletableFuture<Collection<BulkLoadHFiles.LoadQueueItem>>>();
        for (Map.Entry<ByteBuffer, Collection<BulkLoadHFiles.LoadQueueItem>> entry : regionGroups.asMap().entrySet()) {
            byte[] first = entry.getKey().array();
            Collection<BulkLoadHFiles.LoadQueueItem> lqis = entry.getValue();
            if (this.bulkLoadByFamily) {
                this.groupByFamilies(lqis).values().forEach(familyQueue -> loadingFutures.add(this.tryAtomicRegionLoad(conn, tableName, copyFiles, first, (Collection<BulkLoadHFiles.LoadQueueItem>)familyQueue)));
            } else {
                loadingFutures.add(this.tryAtomicRegionLoad(conn, tableName, copyFiles, first, lqis));
            }
            if (item2RegionMap == null) continue;
            Iterator iterator = lqis.iterator();
            while (iterator.hasNext()) {
                BulkLoadHFiles.LoadQueueItem lqi = (BulkLoadHFiles.LoadQueueItem)iterator.next();
                item2RegionMap.put(lqi, entry.getKey());
            }
        }
        for (Future future : loadingFutures) {
            try {
                Collection toRetry = (Collection)future.get();
                if (item2RegionMap != null) {
                    for (BulkLoadHFiles.LoadQueueItem lqi : toRetry) {
                        item2RegionMap.remove(lqi);
                    }
                }
                queue.addAll(toRetry);
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    throw new IOException("BulkLoad encountered an unrecoverable problem", t);
                }
                LOG.error("Unexpected execution exception during bulk load", (Throwable)e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error("Unexpected interrupted exception during bulk load", (Throwable)e1);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
            }
        }
    }

    private Map<byte[], Collection<BulkLoadHFiles.LoadQueueItem>> groupByFamilies(Collection<BulkLoadHFiles.LoadQueueItem> itemsInRegion) {
        TreeMap<byte[], Collection<BulkLoadHFiles.LoadQueueItem>> families2Queue = new TreeMap<byte[], Collection<BulkLoadHFiles.LoadQueueItem>>(Bytes.BYTES_COMPARATOR);
        itemsInRegion.forEach(item -> families2Queue.computeIfAbsent(item.getFamily(), queue -> new ArrayList()).add(item));
        return families2Queue;
    }

    private boolean checkHFilesCountPerRegionPerFamily(Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups) {
        for (Map.Entry<ByteBuffer, Collection<BulkLoadHFiles.LoadQueueItem>> e : regionGroups.asMap().entrySet()) {
            TreeMap<byte[], MutableInt> filesMap = new TreeMap<byte[], MutableInt>(Bytes.BYTES_COMPARATOR);
            for (BulkLoadHFiles.LoadQueueItem lqi : e.getValue()) {
                MutableInt count = filesMap.computeIfAbsent(lqi.getFamily(), k -> new MutableInt());
                count.increment();
                if (count.intValue() <= this.maxFilesPerRegionPerFamily) continue;
                LOG.error("Trying to load more than " + this.maxFilesPerRegionPerFamily + " hfiles to family " + Bytes.toStringBinary(lqi.getFamily()) + " of region with start key " + Bytes.toStringBinary(e.getKey()));
                return false;
            }
        }
        return true;
    }

    private Pair<Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem>, Set<String>> groupOrSplitPhase(AsyncClusterConnection conn, TableName tableName, ExecutorService pool, Deque<BulkLoadHFiles.LoadQueueItem> queue, List<Pair<byte[], byte[]>> startEndKeys) throws IOException {
        HashMultimap rgs = HashMultimap.create();
        Multimap regionGroups = Multimaps.synchronizedMultimap(rgs);
        HashSet missingHFiles = new HashSet();
        Pair<Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem>, Set<String>> pair = new Pair<Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem>, Set<String>>(regionGroups, missingHFiles);
        HashSet<Future<Pair>> splittingFutures = new HashSet<Future<Pair>>();
        while (!queue.isEmpty()) {
            BulkLoadHFiles.LoadQueueItem item = queue.remove();
            Callable<Pair> callable = () -> this.groupOrSplit(conn, tableName, regionGroups, item, startEndKeys);
            splittingFutures.add(pool.submit(callable));
        }
        for (Future future : splittingFutures) {
            try {
                Pair splits = (Pair)future.get();
                if (splits == null) continue;
                if (splits.getFirst() != null) {
                    queue.addAll((Collection)splits.getFirst());
                    continue;
                }
                missingHFiles.add(splits.getSecond());
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    LOG.error("IOException during splitting", (Throwable)e1);
                    throw (IOException)t;
                }
                LOG.error("Unexpected execution exception during splitting", (Throwable)e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error("Unexpected interrupted exception during splitting", (Throwable)e1);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
            }
        }
        return pair;
    }

    private String getUniqueName() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private List<BulkLoadHFiles.LoadQueueItem> splitStoreFile(AsyncTableRegionLocator loc, BulkLoadHFiles.LoadQueueItem item, TableDescriptor tableDesc, byte[] splitKey) throws IOException {
        Path hfilePath = item.getFilePath();
        byte[] family = item.getFamily();
        Path tmpDir = hfilePath.getParent();
        if (!tmpDir.getName().equals(TMP_DIR)) {
            tmpDir = new Path(tmpDir, TMP_DIR);
        }
        LOG.info("HFile at " + hfilePath + " no longer fits inside a single region. Splitting...");
        String uniqueName = this.getUniqueName();
        ColumnFamilyDescriptor familyDesc = tableDesc.getColumnFamily(family);
        Path botOut = new Path(tmpDir, uniqueName + ".bottom");
        Path topOut = new Path(tmpDir, uniqueName + ".top");
        BulkLoadHFilesTool.splitStoreFile(loc, this.getConf(), hfilePath, familyDesc, splitKey, botOut, topOut);
        FileSystem fs = tmpDir.getFileSystem(this.getConf());
        fs.setPermission(tmpDir, FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(botOut, FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(topOut, FsPermission.valueOf((String)"-rwxrwxrwx"));
        ArrayList<BulkLoadHFiles.LoadQueueItem> lqis = new ArrayList<BulkLoadHFiles.LoadQueueItem>(2);
        lqis.add(new BulkLoadHFiles.LoadQueueItem(family, botOut));
        lqis.add(new BulkLoadHFiles.LoadQueueItem(family, topOut));
        try {
            if (tmpDir.getName().equals(TMP_DIR)) {
                fs.delete(hfilePath, false);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to delete temporary split file " + hfilePath);
        }
        LOG.info("Successfully split into new HFiles " + botOut + " and " + topOut);
        return lqis;
    }

    private int getRegionIndex(List<Pair<byte[], byte[]>> startEndKeys, byte[] key) {
        int idx = Collections.binarySearch(startEndKeys, Pair.newPair(key, HConstants.EMPTY_END_ROW), (p1, p2) -> Bytes.compareTo((byte[])p1.getFirst(), (byte[])p2.getFirst()));
        if (idx < 0) {
            idx = -(idx + 1) - 1;
        }
        return idx;
    }

    private void checkRegionIndexValid(int idx, List<Pair<byte[], byte[]>> startEndKeys, TableName tableName) throws IOException {
        if (idx < 0) {
            throw new IOException("The first region info for table " + tableName + " can't be found in hbase:meta.Please use hbck tool to fix it first.");
        }
        if (idx == startEndKeys.size() - 1 && !Bytes.equals(startEndKeys.get(idx).getSecond(), HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IOException("The last region info for table " + tableName + " can't be found in hbase:meta.Please use hbck tool to fix it first.");
        }
        if (idx + 1 < startEndKeys.size() && Bytes.compareTo(startEndKeys.get(idx).getSecond(), startEndKeys.get(idx + 1).getFirst()) != 0) {
            throw new IOException("The endkey of one region for table " + tableName + " is not equal to the startkey of the next region in hbase:meta.Please use hbck tool to fix it first.");
        }
    }

    @InterfaceAudience.Private
    protected Pair<List<BulkLoadHFiles.LoadQueueItem>, String> groupOrSplit(AsyncClusterConnection conn, TableName tableName, Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups, BulkLoadHFiles.LoadQueueItem item, List<Pair<byte[], byte[]>> startEndKeys) throws IOException {
        boolean lastKeyInRange;
        Optional<byte[]> last;
        Optional<byte[]> first;
        Path hfilePath = item.getFilePath();
        try (HFile.Reader hfr = HFile.createReader(hfilePath.getFileSystem(this.getConf()), hfilePath, CacheConfig.DISABLED, true, this.getConf());){
            first = hfr.getFirstRowKey();
            last = hfr.getLastRowKey();
        }
        catch (FileNotFoundException fnfe) {
            LOG.debug("encountered", (Throwable)fnfe);
            return new Pair<Object, String>(null, hfilePath.getName());
        }
        LOG.info("Trying to load hfile=" + hfilePath + " first=" + first.map(Bytes::toStringBinary) + " last=" + last.map(Bytes::toStringBinary));
        if (!first.isPresent() || !last.isPresent()) {
            assert (!first.isPresent() && !last.isPresent());
            LOG.info("hfile " + hfilePath + " has no entries, skipping");
            return null;
        }
        if (Bytes.compareTo(first.get(), last.get()) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(first.get()) + " > " + Bytes.toStringBinary(last.get()));
        }
        int firstKeyRegionIdx = this.getRegionIndex(startEndKeys, first.get());
        this.checkRegionIndexValid(firstKeyRegionIdx, startEndKeys, tableName);
        boolean bl = lastKeyInRange = Bytes.compareTo(last.get(), startEndKeys.get(firstKeyRegionIdx).getSecond()) < 0 || Bytes.equals(startEndKeys.get(firstKeyRegionIdx).getSecond(), HConstants.EMPTY_BYTE_ARRAY);
        if (!lastKeyInRange) {
            if (this.failIfNeedSplitHFile) {
                throw new IOException("The key range of hfile=" + hfilePath + " fits into no region. And because " + FAIL_IF_NEED_SPLIT_HFILE + " was set to true, we just skip the next steps.");
            }
            int lastKeyRegionIdx = this.getRegionIndex(startEndKeys, last.get());
            int splitIdx = (firstKeyRegionIdx + lastKeyRegionIdx) / 2;
            if (splitIdx != firstKeyRegionIdx) {
                this.checkRegionIndexValid(splitIdx, startEndKeys, tableName);
            }
            byte[] splitPoint = startEndKeys.get(splitIdx).getSecond();
            List<BulkLoadHFiles.LoadQueueItem> lqis = this.splitStoreFile(conn.getRegionLocator(tableName), item, FutureUtils.get(conn.getAdmin().getDescriptor(tableName)), splitPoint);
            return new Pair<List<BulkLoadHFiles.LoadQueueItem>, Object>(lqis, null);
        }
        regionGroups.put(ByteBuffer.wrap(startEndKeys.get(firstKeyRegionIdx).getFirst()), item);
        return null;
    }

    @InterfaceAudience.Private
    static void splitStoreFile(AsyncTableRegionLocator loc, Configuration conf, Path inFile, ColumnFamilyDescriptor familyDesc, byte[] splitKey, Path bottomOut, Path topOut) throws IOException {
        Reference topReference = Reference.createTopReference(splitKey);
        Reference bottomReference = Reference.createBottomReference(splitKey);
        BulkLoadHFilesTool.copyHFileHalf(conf, inFile, topOut, topReference, familyDesc, loc);
        BulkLoadHFilesTool.copyHFileHalf(conf, inFile, bottomOut, bottomReference, familyDesc, loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyHFileHalf(Configuration conf, Path inFile, Path outFile, Reference reference, ColumnFamilyDescriptor familyDescriptor, AsyncTableRegionLocator loc) throws IOException {
        FileSystem fs = inFile.getFileSystem(conf);
        CacheConfig cacheConf = CacheConfig.DISABLED;
        StoreFileReader halfReader = null;
        StoreFileWriter halfWriter = null;
        try {
            ReaderContext context = new ReaderContextBuilder().withFileSystemAndPath(fs, inFile).build();
            StoreFileInfo storeFileInfo = new StoreFileInfo(conf, fs, fs.getFileStatus(inFile), reference);
            storeFileInfo.initHFileInfo(context);
            halfReader = (HalfStoreFileReader)storeFileInfo.createReader(context, cacheConf);
            storeFileInfo.getHFileInfo().initMetaAndIndex(halfReader.getHFileReader());
            Map<byte[], byte[]> fileInfo = halfReader.loadFileInfo();
            int blocksize = familyDescriptor.getBlocksize();
            Compression.Algorithm compression = familyDescriptor.getCompressionType();
            BloomType bloomFilterType = familyDescriptor.getBloomFilterType();
            HFileContext hFileContext = new HFileContextBuilder().withCompression(compression).withChecksumType(StoreUtils.getChecksumType(conf)).withBytesPerCheckSum(StoreUtils.getBytesPerChecksum(conf)).withBlockSize(blocksize).withDataBlockEncoding(familyDescriptor.getDataBlockEncoding()).withIncludesTags(true).withCreateTime(EnvironmentEdgeManager.currentTime()).build();
            HFileScanner scanner = ((HalfStoreFileReader)halfReader).getScanner(false, false, false);
            scanner.seekTo();
            do {
                Cell cell = scanner.getCell();
                if (null != halfWriter) {
                    halfWriter.append(cell);
                    continue;
                }
                if (conf.getBoolean(LOCALITY_SENSITIVE_CONF_KEY, true)) {
                    byte[] rowKey = CellUtil.cloneRow(cell);
                    HRegionLocation hRegionLocation = FutureUtils.get(loc.getRegionLocation(rowKey));
                    InetSocketAddress[] favoredNodes = null;
                    if (null == hRegionLocation) {
                        LOG.warn("Failed get region location for  rowkey {} , Using writer without favoured nodes.", (Object)Bytes.toString(rowKey));
                        halfWriter = new StoreFileWriter.Builder(conf, cacheConf, fs).withFilePath(outFile).withBloomType(bloomFilterType).withFileContext(hFileContext).build();
                    } else {
                        LOG.debug("First rowkey: [{}]", (Object)Bytes.toString(rowKey));
                        InetSocketAddress initialIsa = new InetSocketAddress(hRegionLocation.getHostname(), hRegionLocation.getPort());
                        if (initialIsa.isUnresolved()) {
                            LOG.warn("Failed get location for region {} , Using writer without favoured nodes.", (Object)hRegionLocation);
                            halfWriter = new StoreFileWriter.Builder(conf, cacheConf, fs).withFilePath(outFile).withBloomType(bloomFilterType).withFileContext(hFileContext).build();
                        } else {
                            LOG.debug("Use favored nodes writer: {}", (Object)initialIsa.getHostString());
                            favoredNodes = new InetSocketAddress[]{initialIsa};
                            halfWriter = new StoreFileWriter.Builder(conf, cacheConf, fs).withFilePath(outFile).withBloomType(bloomFilterType).withFileContext(hFileContext).withFavoredNodes(favoredNodes).build();
                        }
                    }
                } else {
                    halfWriter = new StoreFileWriter.Builder(conf, cacheConf, fs).withFilePath(outFile).withBloomType(bloomFilterType).withFileContext(hFileContext).build();
                }
                halfWriter.append(cell);
            } while (scanner.next());
            for (Map.Entry<byte[], byte[]> entry : fileInfo.entrySet()) {
                if (!BulkLoadHFilesTool.shouldCopyHFileMetaKey(entry.getKey())) continue;
                halfWriter.appendFileInfo(entry.getKey(), entry.getValue());
            }
        }
        finally {
            if (halfReader != null) {
                try {
                    halfReader.close(cacheConf.shouldEvictOnClose());
                }
                catch (IOException e) {
                    LOG.warn("failed to close hfile reader for " + inFile, (Throwable)e);
                }
            }
            if (halfWriter != null) {
                halfWriter.close();
            }
        }
    }

    public static byte[][] inferBoundaries(SortedMap<byte[], Integer> bdryMap) {
        ArrayList<byte[]> keysArray = new ArrayList<byte[]>();
        int runningValue = 0;
        byte[] currStartKey = null;
        boolean firstBoundary = true;
        for (Map.Entry<byte[], Integer> item : bdryMap.entrySet()) {
            if (runningValue == 0) {
                currStartKey = item.getKey();
            }
            if ((runningValue += item.getValue().intValue()) != 0) continue;
            if (!firstBoundary) {
                keysArray.add(currStartKey);
            }
            firstBoundary = false;
        }
        return (byte[][])keysArray.toArray((T[])new byte[0][]);
    }

    private void createTable(TableName tableName, Path hfofDir, AsyncAdmin admin) throws IOException {
        final FileSystem fs = hfofDir.getFileSystem(this.getConf());
        final ArrayList familyBuilders = new ArrayList();
        final TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        BulkLoadHFilesTool.visitBulkHFiles(fs, hfofDir, new BulkHFileVisitor<ColumnFamilyDescriptorBuilder>(){

            @Override
            public ColumnFamilyDescriptorBuilder bulkFamily(byte[] familyName) {
                ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder(familyName);
                familyBuilders.add(builder);
                return builder;
            }

            @Override
            public void bulkHFile(ColumnFamilyDescriptorBuilder builder, FileStatus hfileStatus) throws IOException {
                Path hfile = hfileStatus.getPath();
                try (HFile.Reader reader = HFile.createReader(fs, hfile, CacheConfig.DISABLED, true, BulkLoadHFilesTool.this.getConf());){
                    if (builder.getCompressionType() != reader.getFileContext().getCompression()) {
                        builder.setCompressionType(reader.getFileContext().getCompression());
                        LOG.info("Setting compression " + reader.getFileContext().getCompression().name() + " for family " + builder.getNameAsString());
                    }
                    byte[] first = reader.getFirstRowKey().get();
                    byte[] last = reader.getLastRowKey().get();
                    LOG.info("Trying to figure out region boundaries hfile=" + hfile + " first=" + Bytes.toStringBinary(first) + " last=" + Bytes.toStringBinary(last));
                    Integer value = map.getOrDefault(first, 0);
                    map.put(first, value + 1);
                    value = map.containsKey(last) ? (Integer)map.get(last) : Integer.valueOf(0);
                    map.put(last, value - 1);
                }
            }
        }, true);
        byte[][] keys = BulkLoadHFilesTool.inferBoundaries(map);
        TableDescriptorBuilder tdBuilder = TableDescriptorBuilder.newBuilder(tableName);
        familyBuilders.stream().map(ColumnFamilyDescriptorBuilder::build).forEachOrdered(tdBuilder::setColumnFamily);
        FutureUtils.get(admin.createTable(tdBuilder.build(), keys));
        LOG.info("Table " + tableName + " is available!!");
    }

    private Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> performBulkLoad(AsyncClusterConnection conn, TableName tableName, Deque<BulkLoadHFiles.LoadQueueItem> queue, ExecutorService pool, boolean copyFile) throws IOException {
        int count = 0;
        this.fsDelegationToken.acquireDelegationToken(queue.peek().getFilePath().getFileSystem(this.getConf()));
        this.bulkToken = FutureUtils.get(conn.prepareBulkLoad(tableName));
        Pair<Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem>, Set<String>> pair = null;
        HashMap<BulkLoadHFiles.LoadQueueItem, ByteBuffer> item2RegionMap = new HashMap<BulkLoadHFiles.LoadQueueItem, ByteBuffer>();
        while (!queue.isEmpty()) {
            List<Pair<byte[], byte[]>> startEndKeys = FutureUtils.get(conn.getRegionLocator(tableName).getStartEndKeys());
            if (count != 0) {
                LOG.info("Split occurred while grouping HFiles, retry attempt " + count + " with " + queue.size() + " files remaining to group or split");
            }
            int maxRetries = this.getConf().getInt("hbase.bulkload.retries.number", 10);
            if ((maxRetries = Math.max(maxRetries, startEndKeys.size() + 1)) != 0 && count >= maxRetries) {
                throw new IOException("Retry attempted " + count + " times without completing, bailing out");
            }
            ++count;
            pair = this.groupOrSplitPhase(conn, tableName, pool, queue, startEndKeys);
            Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups = pair.getFirst();
            if (!this.checkHFilesCountPerRegionPerFamily(regionGroups)) {
                throw new IOException("Trying to load more than " + this.maxFilesPerRegionPerFamily + " hfiles to one family of one region");
            }
            this.bulkLoadPhase(conn, tableName, queue, regionGroups, copyFile, item2RegionMap);
        }
        return item2RegionMap;
    }

    private void cleanup(AsyncClusterConnection conn, TableName tableName, Deque<BulkLoadHFiles.LoadQueueItem> queue, ExecutorService pool) throws IOException {
        this.fsDelegationToken.releaseDelegationToken();
        if (this.bulkToken != null) {
            conn.cleanupBulkLoad(tableName, this.bulkToken);
        }
        if (pool != null) {
            pool.shutdown();
        }
        if (!queue.isEmpty()) {
            StringBuilder err = new StringBuilder();
            err.append("-------------------------------------------------\n");
            err.append("Bulk load aborted with some files not yet loaded:\n");
            err.append("-------------------------------------------------\n");
            for (BulkLoadHFiles.LoadQueueItem q : queue) {
                err.append("  ").append(q.getFilePath()).append('\n');
            }
            LOG.error(err.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> doBulkLoad(AsyncClusterConnection conn, TableName tableName, Map<byte[], List<Path>> map, boolean silence, boolean copyFile) throws IOException {
        ExecutorService pool;
        ArrayDeque<BulkLoadHFiles.LoadQueueItem> queue;
        block3: {
            Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> map2;
            this.tableExists(conn, tableName);
            queue = new ArrayDeque<BulkLoadHFiles.LoadQueueItem>();
            pool = null;
            try {
                BulkLoadHFilesTool.prepareHFileQueue(conn, tableName, map, queue, silence);
                if (!queue.isEmpty()) break block3;
                LOG.warn("Bulk load operation did not get any files to load");
                map2 = Collections.emptyMap();
            }
            catch (Throwable throwable) {
                this.cleanup(conn, tableName, queue, pool);
                throw throwable;
            }
            this.cleanup(conn, tableName, queue, pool);
            return map2;
        }
        pool = this.createExecutorService();
        Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> map3 = this.performBulkLoad(conn, tableName, queue, pool, copyFile);
        this.cleanup(conn, tableName, queue, pool);
        return map3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> doBulkLoad(AsyncClusterConnection conn, TableName tableName, Path hfofDir, boolean silence, boolean copyFile) throws IOException {
        ExecutorService pool;
        ArrayDeque<BulkLoadHFiles.LoadQueueItem> queue;
        block4: {
            Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> map;
            this.tableExists(conn, tableName);
            boolean validateHFile = this.getConf().getBoolean(VALIDATE_HFILES, true);
            if (!validateHFile) {
                LOG.warn("You are skipping HFiles validation, it might cause some data loss if files are not correct. If you fail to read data from your table after using this option, consider removing the files and bulkload again without this option. See HBASE-13985");
            }
            queue = new ArrayDeque<BulkLoadHFiles.LoadQueueItem>();
            pool = null;
            try {
                BulkLoadHFilesTool.prepareHFileQueue(this.getConf(), conn, tableName, hfofDir, queue, validateHFile, silence);
                if (!queue.isEmpty()) break block4;
                LOG.warn("Bulk load operation did not find any files to load in directory {}. Does it contain files in subdirectories that correspond to column family names?", (Object)(hfofDir != null ? hfofDir.toUri().toString() : ""));
                map = Collections.emptyMap();
            }
            catch (Throwable throwable) {
                this.cleanup(conn, tableName, queue, pool);
                throw throwable;
            }
            this.cleanup(conn, tableName, queue, pool);
            return map;
        }
        pool = this.createExecutorService();
        Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> map = this.performBulkLoad(conn, tableName, queue, pool, copyFile);
        this.cleanup(conn, tableName, queue, pool);
        return map;
    }

    @Override
    public Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> bulkLoad(TableName tableName, Map<byte[], List<Path>> family2Files) throws IOException {
        try (AsyncClusterConnection conn = ClusterConnectionFactory.createAsyncClusterConnection(this.getConf(), null, this.userProvider.getCurrent());){
            Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> map = this.doBulkLoad(conn, tableName, family2Files, this.isSilence(), this.isAlwaysCopyFiles());
            return map;
        }
    }

    @Override
    public Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> bulkLoad(TableName tableName, Path dir) throws IOException {
        try (AsyncClusterConnection conn = ClusterConnectionFactory.createAsyncClusterConnection(this.getConf(), null, this.userProvider.getCurrent());){
            AsyncAdmin admin = conn.getAdmin();
            if (!FutureUtils.get(admin.tableExists(tableName)).booleanValue()) {
                if (this.isCreateTable()) {
                    this.createTable(tableName, dir, admin);
                } else {
                    this.throwAndLogTableNotFoundException(tableName);
                }
            }
            Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> map = this.doBulkLoad(conn, tableName, dir, this.isSilence(), this.isAlwaysCopyFiles());
            return map;
        }
    }

    private void tableExists(AsyncClusterConnection conn, TableName tableName) throws IOException {
        if (!FutureUtils.get(conn.getAdmin().tableExists(tableName)).booleanValue()) {
            this.throwAndLogTableNotFoundException(tableName);
        }
    }

    private void throwAndLogTableNotFoundException(TableName tn) throws TableNotFoundException {
        String errorMsg = String.format("Table '%s' does not exist.", tn);
        LOG.error(errorMsg);
        throw new TableNotFoundException(errorMsg);
    }

    public void setBulkToken(String bulkToken) {
        this.bulkToken = bulkToken;
    }

    public void setClusterIds(List<String> clusterIds) {
        this.clusterIds = clusterIds;
    }

    private void usage() {
        System.err.println("Usage: bin/hbase completebulkload [OPTIONS] </PATH/TO/HFILEOUTPUTFORMAT-OUTPUT> <TABLENAME>\nLoads directory of hfiles -- a region dir or product of HFileOutputFormat -- into an hbase table.\nOPTIONS (for other -D options, see source code):\n -Dcreate.table=no whether to create table; when 'no', target table must exist.\n -Dignore.unmatched.families=yes to ignore unmatched column families.\n -loadTable for when directory of files to load has a depth of 3; target table must exist;\n must be last of the options on command line.\nSee http://hbase.apache.org/book.html#arch.bulk.load.complete.strays for documentation.\n");
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2 && args.length != 3) {
            this.usage();
            return -1;
        }
        this.initialize();
        Path dirPath = new Path(args[0]);
        TableName tableName = TableName.valueOf(args[1]);
        if (args.length == 2) {
            return !this.bulkLoad(tableName, dirPath).isEmpty() ? 0 : -1;
        }
        HashMap<byte[], List<Path>> family2Files = Maps.newHashMap();
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        for (FileStatus regionDir : fs.listStatus(dirPath)) {
            FSVisitor.visitRegionStoreFiles(fs, regionDir.getPath(), (region, family, hfileName) -> {
                Path path = new Path(regionDir.getPath(), new Path(family, hfileName));
                byte[] familyName = Bytes.toBytes(family);
                if (family2Files.containsKey(familyName)) {
                    ((List)family2Files.get(familyName)).add(path);
                } else {
                    family2Files.put(familyName, Lists.newArrayList(path));
                }
            });
        }
        return !this.bulkLoad(tableName, family2Files).isEmpty() ? 0 : -1;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new BulkLoadHFilesTool(conf), (String[])args);
        System.exit(ret);
    }

    @Override
    public void disableReplication() {
        this.replicate = false;
    }

    @Override
    public boolean isReplicationDisabled() {
        return !this.replicate;
    }

    private static interface BulkHFileVisitor<TFamily> {
        public TFamily bulkFamily(byte[] var1) throws IOException;

        public void bulkHFile(TFamily var1, FileStatus var2) throws IOException;
    }
}

