/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class BoundedPriorityBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();
    private final PriorityQueue<E> queue;

    public BoundedPriorityBlockingQueue(int capacity, Comparator<? super E> comparator) {
        this.queue = new PriorityQueue<E>(capacity, comparator);
    }

    @Override
    public boolean offer(E e) {
        Objects.requireNonNull(e);
        this.lock.lock();
        try {
            if (this.queue.remainingCapacity() > 0) {
                this.queue.add(e);
                this.notEmpty.signal();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    @Override
    public void put(E e) throws InterruptedException {
        Objects.requireNonNull(e);
        this.lock.lock();
        try {
            while (this.queue.remainingCapacity() == 0) {
                this.notFull.await();
            }
            this.queue.add(e);
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Objects.requireNonNull(e);
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            while (this.queue.remainingCapacity() == 0) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            this.queue.add(e);
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    @Override
    public E take() throws InterruptedException {
        E result = null;
        this.lock.lockInterruptibly();
        try {
            while (this.queue.size() == 0) {
                this.notEmpty.await();
            }
            result = this.queue.poll();
            this.notFull.signal();
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public E poll() {
        E result = null;
        this.lock.lock();
        try {
            if (this.queue.size() > 0) {
                result = this.queue.poll();
                this.notFull.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        E result = null;
        try {
            while (this.queue.size() == 0 && nanos > 0L) {
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            if (this.queue.size() > 0) {
                result = this.queue.poll();
            }
            this.notFull.signal();
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public E peek() {
        this.lock.lock();
        try {
            E e = this.queue.peek();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    public Comparator<? super E> comparator() {
        return this.queue.comparator();
    }

    @Override
    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n = this.queue.remainingCapacity();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        this.lock.lock();
        try {
            boolean bl = this.queue.contains(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        Objects.requireNonNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        this.lock.lock();
        try {
            int n = Math.min(this.queue.size(), maxElements);
            for (int i = 0; i < n; ++i) {
                c.add(this.queue.poll());
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class PriorityQueue<E> {
        private final Comparator<? super E> comparator;
        private final E[] objects;
        private int head = 0;
        private int tail = 0;

        public PriorityQueue(int capacity, Comparator<? super E> comparator) {
            this.objects = new Object[capacity];
            this.comparator = comparator;
        }

        public void add(E elem) {
            if (this.tail == this.objects.length) {
                this.tail -= this.head;
                System.arraycopy(this.objects, this.head, this.objects, 0, this.tail);
                this.head = 0;
            }
            if (this.tail == this.head || this.comparator.compare(this.objects[this.tail - 1], elem) <= 0) {
                this.objects[this.tail++] = elem;
            } else if (this.head > 0 && this.comparator.compare(this.objects[this.head], elem) > 0) {
                this.objects[--this.head] = elem;
            } else {
                int index = this.upperBound(this.head, this.tail - 1, elem);
                System.arraycopy(this.objects, index, this.objects, index + 1, this.tail - index);
                this.objects[index] = elem;
                ++this.tail;
            }
        }

        public E peek() {
            return this.head != this.tail ? (E)this.objects[this.head] : null;
        }

        public E poll() {
            E elem = this.objects[this.head];
            this.objects[this.head] = null;
            this.head = (this.head + 1) % this.objects.length;
            if (this.head == 0) {
                this.tail = 0;
            }
            return elem;
        }

        public int size() {
            return this.tail - this.head;
        }

        public Comparator<? super E> comparator() {
            return this.comparator;
        }

        public boolean contains(Object o) {
            for (int i = this.head; i < this.tail; ++i) {
                if (this.objects[i] != o) continue;
                return true;
            }
            return false;
        }

        public int remainingCapacity() {
            return this.objects.length - (this.tail - this.head);
        }

        private int upperBound(int start, int end, E key) {
            while (start < end) {
                int mid = start + (end - start >> 1);
                E mitem = this.objects[mid];
                int cmp = this.comparator.compare(mitem, key);
                if (cmp > 0) {
                    end = mid;
                    continue;
                }
                start = mid + 1;
            }
            return start;
        }
    }
}

