/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.KeyRange;
import org.apache.hadoop.hbase.util.RegionSplitCalculator;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HbckRegionInfo
implements KeyRange {
    private static final Logger LOG = LoggerFactory.getLogger((String)HbckRegionInfo.class.getName());
    private MetaEntry metaEntry = null;
    private HdfsEntry hdfsEntry = null;
    private List<OnlineEntry> deployedEntries = Lists.newArrayList();
    private List<ServerName> deployedOn = Lists.newArrayList();
    private boolean skipChecks = false;
    private boolean isMerged = false;
    private int deployedReplicaId = 0;
    private RegionInfo primaryHRIForDeployedReplica = null;
    static final Comparator<HbckRegionInfo> COMPARATOR = new Comparator<HbckRegionInfo>(){

        @Override
        public int compare(HbckRegionInfo l, HbckRegionInfo r) {
            if (l == r) {
                return 0;
            }
            int tableCompare = l.getTableName().compareTo(r.getTableName());
            if (tableCompare != 0) {
                return tableCompare;
            }
            int startComparison = RegionSplitCalculator.BYTES_COMPARATOR.compare(l.getStartKey(), r.getStartKey());
            if (startComparison != 0) {
                return startComparison;
            }
            byte[] endKey = r.getEndKey();
            endKey = endKey.length == 0 ? null : endKey;
            byte[] endKey2 = l.getEndKey();
            int endComparison = RegionSplitCalculator.BYTES_COMPARATOR.compare(endKey2 = endKey2.length == 0 ? null : endKey2, endKey);
            if (endComparison != 0) {
                return endComparison;
            }
            if (l.getHdfsEntry() == null && r.getHdfsEntry() == null) {
                return 0;
            }
            if (l.getHdfsEntry() == null && r.getHdfsEntry() != null) {
                return 1;
            }
            if (r.getHdfsEntry() == null) {
                return -1;
            }
            return Long.compare(l.getHdfsEntry().hri.getRegionId(), r.getHdfsEntry().hri.getRegionId());
        }
    };

    public HbckRegionInfo(MetaEntry metaEntry) {
        this.metaEntry = metaEntry;
    }

    public synchronized int getReplicaId() {
        return this.metaEntry != null ? this.metaEntry.hri.getReplicaId() : this.deployedReplicaId;
    }

    public synchronized void addServer(RegionInfo regionInfo, ServerName serverName) {
        OnlineEntry rse = new OnlineEntry(regionInfo, serverName);
        this.deployedEntries.add(rse);
        this.deployedOn.add(serverName);
        this.deployedReplicaId = regionInfo.getReplicaId();
        this.primaryHRIForDeployedReplica = RegionReplicaUtil.getRegionInfoForDefaultReplica(regionInfo);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ meta => ");
        sb.append(this.metaEntry != null ? this.metaEntry.hri.getRegionNameAsString() : "null");
        sb.append(", hdfs => " + this.getHdfsRegionDir());
        sb.append(", deployed => " + Joiner.on(", ").join(this.deployedEntries));
        sb.append(", replicaId => " + this.getReplicaId());
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public byte[] getStartKey() {
        if (this.metaEntry != null) {
            return this.metaEntry.hri.getStartKey();
        }
        if (this.hdfsEntry != null) {
            return this.hdfsEntry.hri.getStartKey();
        }
        LOG.error("Entry " + this + " has no meta or hdfs region start key.");
        return null;
    }

    @Override
    public byte[] getEndKey() {
        if (this.metaEntry != null) {
            return this.metaEntry.hri.getEndKey();
        }
        if (this.hdfsEntry != null) {
            return this.hdfsEntry.hri.getEndKey();
        }
        LOG.error("Entry " + this + " has no meta or hdfs region start key.");
        return null;
    }

    public MetaEntry getMetaEntry() {
        return this.metaEntry;
    }

    public void setMetaEntry(MetaEntry metaEntry) {
        this.metaEntry = metaEntry;
    }

    public HdfsEntry getHdfsEntry() {
        return this.hdfsEntry;
    }

    public void setHdfsEntry(HdfsEntry hdfsEntry) {
        this.hdfsEntry = hdfsEntry;
    }

    public List<OnlineEntry> getOnlineEntries() {
        return this.deployedEntries;
    }

    public List<ServerName> getDeployedOn() {
        return this.deployedOn;
    }

    public void loadHdfsRegioninfo(Configuration conf) throws IOException {
        Path regionDir = this.getHdfsRegionDir();
        if (regionDir == null) {
            if (this.getReplicaId() == 0) {
                LOG.warn("No HDFS region dir found: " + this + " meta=" + this.metaEntry);
            }
            return;
        }
        if (this.hdfsEntry.hri != null) {
            return;
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        RegionInfo hri = HRegionFileSystem.loadRegionInfoFileContent(fs, regionDir);
        LOG.debug("RegionInfo read: " + hri.toString());
        this.hdfsEntry.hri = hri;
    }

    public TableName getTableName() {
        if (this.metaEntry != null) {
            return this.metaEntry.hri.getTable();
        }
        if (this.hdfsEntry != null) {
            Path tableDir = this.hdfsEntry.regionDir.getParent();
            return CommonFSUtils.getTableName(tableDir);
        }
        Iterator<OnlineEntry> iterator = this.deployedEntries.iterator();
        if (iterator.hasNext()) {
            OnlineEntry e = iterator.next();
            return e.getRegionInfo().getTable();
        }
        return null;
    }

    public String getRegionNameAsString() {
        if (this.metaEntry != null) {
            return this.metaEntry.hri.getRegionNameAsString();
        }
        if (this.hdfsEntry != null) {
            if (this.hdfsEntry.hri != null) {
                return this.hdfsEntry.hri.getRegionNameAsString();
            }
        } else {
            Iterator<OnlineEntry> iterator = this.deployedEntries.iterator();
            if (iterator.hasNext()) {
                OnlineEntry e = iterator.next();
                return e.getRegionInfo().getRegionNameAsString();
            }
        }
        return null;
    }

    public byte[] getRegionName() {
        if (this.metaEntry != null) {
            return this.metaEntry.hri.getRegionName();
        }
        if (this.hdfsEntry != null) {
            return this.hdfsEntry.hri.getRegionName();
        }
        Iterator<OnlineEntry> iterator = this.deployedEntries.iterator();
        if (iterator.hasNext()) {
            OnlineEntry e = iterator.next();
            return e.getRegionInfo().getRegionName();
        }
        return null;
    }

    public RegionInfo getPrimaryHRIForDeployedReplica() {
        return this.primaryHRIForDeployedReplica;
    }

    public Path getHdfsRegionDir() {
        if (this.hdfsEntry == null) {
            return null;
        }
        return this.hdfsEntry.regionDir;
    }

    public boolean containsOnlyHdfsEdits() {
        if (this.hdfsEntry == null) {
            return false;
        }
        return this.hdfsEntry.hdfsOnlyEdits;
    }

    public boolean isHdfsRegioninfoPresent() {
        if (this.hdfsEntry == null) {
            return false;
        }
        return this.hdfsEntry.hdfsRegioninfoFilePresent;
    }

    public long getModTime() {
        if (this.hdfsEntry == null) {
            return 0L;
        }
        return this.hdfsEntry.regionDirModTime;
    }

    public RegionInfo getHdfsHRI() {
        if (this.hdfsEntry == null) {
            return null;
        }
        return this.hdfsEntry.hri;
    }

    public void setSkipChecks(boolean skipChecks) {
        this.skipChecks = skipChecks;
    }

    public boolean isSkipChecks() {
        return this.skipChecks;
    }

    public void setMerged(boolean isMerged) {
        this.isMerged = isMerged;
    }

    public boolean isMerged() {
        return this.isMerged;
    }

    static class OnlineEntry {
        private RegionInfo regionInfo;
        private ServerName serverName;

        OnlineEntry(RegionInfo regionInfo, ServerName serverName) {
            this.regionInfo = regionInfo;
            this.serverName = serverName;
        }

        public RegionInfo getRegionInfo() {
            return this.regionInfo;
        }

        public ServerName getServerName() {
            return this.serverName;
        }

        public String toString() {
            return this.serverName.toString() + ";" + this.regionInfo.getRegionNameAsString();
        }
    }

    public static class HdfsEntry {
        RegionInfo hri;
        Path regionDir = null;
        long regionDirModTime = 0L;
        boolean hdfsRegioninfoFilePresent = false;
        boolean hdfsOnlyEdits = false;

        HdfsEntry() {
        }

        public HdfsEntry(Path regionDir) {
            this.regionDir = regionDir;
        }
    }

    public static class MetaEntry {
        RegionInfo hri;
        ServerName regionServer;
        long modTime;
        RegionInfo splitA;
        RegionInfo splitB;

        public MetaEntry(RegionInfo rinfo, ServerName regionServer, long modTime) {
            this(rinfo, regionServer, modTime, null, null);
        }

        public MetaEntry(RegionInfo rinfo, ServerName regionServer, long modTime, RegionInfo splitA, RegionInfo splitB) {
            this.hri = rinfo;
            this.regionServer = regionServer;
            this.modTime = modTime;
            this.splitA = splitA;
            this.splitB = splitB;
        }

        public RegionInfo getRegionInfo() {
            return this.hri;
        }

        public ServerName getRegionServer() {
            return this.regionServer;
        }

        public boolean equals(Object o) {
            boolean superEq = super.equals(o);
            if (!superEq) {
                return superEq;
            }
            MetaEntry me = (MetaEntry)o;
            if (!this.regionServer.equals(me.regionServer)) {
                return false;
            }
            return this.modTime == me.modTime;
        }

        public int hashCode() {
            int hash = this.hri.hashCode();
            if (this.regionServer != null) {
                hash ^= this.regionServer.hashCode();
            }
            hash = (int)((long)hash ^ this.modTime);
            return hash;
        }
    }
}

