/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncAdminBuilder;
import org.apache.hadoop.hbase.client.AsyncBufferedMutatorBuilder;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTableBuilder;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.hadoop.hbase.client.SharedConnection;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SharedAsyncConnection
implements AsyncConnection {
    private final AsyncConnection conn;

    public SharedAsyncConnection(AsyncConnection conn) {
        this.conn = conn;
    }

    public boolean isClosed() {
        return this.conn.isClosed();
    }

    public void close() throws IOException {
        throw new UnsupportedOperationException("Shared connection");
    }

    public Configuration getConfiguration() {
        return this.conn.getConfiguration();
    }

    public AsyncTableRegionLocator getRegionLocator(TableName tableName) {
        return this.conn.getRegionLocator(tableName);
    }

    public void clearRegionLocationCache() {
        this.conn.clearRegionLocationCache();
    }

    public AsyncTableBuilder<AdvancedScanResultConsumer> getTableBuilder(TableName tableName) {
        return this.conn.getTableBuilder(tableName);
    }

    public AsyncTableBuilder<ScanResultConsumer> getTableBuilder(TableName tableName, ExecutorService pool) {
        return this.conn.getTableBuilder(tableName, pool);
    }

    public AsyncAdminBuilder getAdminBuilder() {
        return this.conn.getAdminBuilder();
    }

    public AsyncAdminBuilder getAdminBuilder(ExecutorService pool) {
        return this.conn.getAdminBuilder(pool);
    }

    public AsyncBufferedMutatorBuilder getBufferedMutatorBuilder(TableName tableName) {
        return this.conn.getBufferedMutatorBuilder(tableName);
    }

    public AsyncBufferedMutatorBuilder getBufferedMutatorBuilder(TableName tableName, ExecutorService pool) {
        return this.conn.getBufferedMutatorBuilder(tableName, pool);
    }

    public CompletableFuture<Hbck> getHbck() {
        return this.conn.getHbck();
    }

    public Hbck getHbck(ServerName masterServer) throws IOException {
        return this.conn.getHbck(masterServer);
    }

    public Connection toConnection() {
        return new SharedConnection(this.conn.toConnection());
    }
}

