/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.locking;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class EntityLock {
    private static final Logger LOG = LoggerFactory.getLogger(EntityLock.class);
    public static final String HEARTBEAT_TIME_BUFFER = "hbase.client.locks.heartbeat.time.buffer.ms";
    private final AtomicBoolean locked = new AtomicBoolean(false);
    private final CountDownLatch latch = new CountDownLatch(1);
    private final LockServiceProtos.LockService.BlockingInterface stub;
    private final LockHeartbeatWorker worker;
    private final LockServiceProtos.LockRequest lockRequest;
    private final Abortable abort;
    private final int heartbeatTimeBuffer;
    private long testingSleepTime = 0L;
    private Long procId = null;

    EntityLock(Configuration conf, LockServiceProtos.LockService.BlockingInterface stub, LockServiceProtos.LockRequest request, Abortable abort) {
        this.stub = stub;
        this.lockRequest = request;
        this.abort = abort;
        this.heartbeatTimeBuffer = conf.getInt(HEARTBEAT_TIME_BUFFER, 10000);
        this.worker = new LockHeartbeatWorker(this.lockRequest.getDescription());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityLock locked=");
        sb.append(this.locked.get());
        sb.append(", procId=");
        sb.append(this.procId);
        sb.append(", type=");
        sb.append(this.lockRequest.getLockType());
        if (this.lockRequest.getRegionInfoCount() > 0) {
            sb.append(", regions=");
            for (int i = 0; i < this.lockRequest.getRegionInfoCount(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.lockRequest.getRegionInfo(i));
            }
        } else if (this.lockRequest.hasTableName()) {
            sb.append(", table=");
            sb.append(this.lockRequest.getTableName());
        } else if (this.lockRequest.hasNamespace()) {
            sb.append(", namespace=");
            sb.append(this.lockRequest.getNamespace());
        }
        sb.append(", description=");
        sb.append(this.lockRequest.getDescription());
        return sb.toString();
    }

    @InterfaceAudience.Private
    void setTestingSleepTime(long timeInMillis) {
        this.testingSleepTime = timeInMillis;
    }

    @InterfaceAudience.Private
    LockHeartbeatWorker getWorker() {
        return this.worker;
    }

    public boolean isLocked() {
        return this.locked.get();
    }

    public void requestLock() throws IOException {
        if (this.procId == null) {
            try {
                this.procId = this.stub.requestLock(null, this.lockRequest).getProcId();
            }
            catch (Exception e) {
                throw ProtobufUtil.handleRemoteException((Throwable)e);
            }
            this.worker.start();
        } else {
            LOG.info("Lock already queued : " + this.toString());
        }
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        boolean result = this.latch.await(timeout, timeUnit);
        String lockRequestStr = this.lockRequest.toString().replace("\n", ", ");
        if (result) {
            LOG.info("Acquired " + lockRequestStr);
        } else {
            LOG.info(String.format("Failed acquire in %s %s of %s", timeout, timeUnit.toString(), lockRequestStr));
        }
        return result;
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public void unlock() throws IOException {
        Threads.shutdown((Thread)this.worker.shutdown());
        try {
            this.stub.lockHeartbeat(null, LockServiceProtos.LockHeartbeatRequest.newBuilder().setProcId(this.procId.longValue()).setKeepAlive(false).build());
        }
        catch (Exception e) {
            throw ProtobufUtil.handleRemoteException((Throwable)e);
        }
    }

    protected class LockHeartbeatWorker
    extends Thread {
        private volatile boolean shutdown;

        public LockHeartbeatWorker(String desc) {
            super("LockHeartbeatWorker(" + desc + ")");
            this.shutdown = false;
            this.setDaemon(true);
        }

        Thread shutdown() {
            this.shutdown = true;
            this.interrupt();
            return this;
        }

        @Override
        public void run() {
            LockServiceProtos.LockHeartbeatRequest lockHeartbeatRequest = LockServiceProtos.LockHeartbeatRequest.newBuilder().setProcId(EntityLock.this.procId.longValue()).build();
            while (true) {
                LockServiceProtos.LockHeartbeatResponse response;
                try {
                    response = EntityLock.this.stub.lockHeartbeat(null, lockHeartbeatRequest);
                }
                catch (Exception e2) {
                    IOException e2 = ProtobufUtil.handleRemoteException((Throwable)e2);
                    EntityLock.this.locked.set(false);
                    LOG.error("Heartbeat failed, releasing " + EntityLock.this, (Throwable)e2);
                    EntityLock.this.abort.abort("Heartbeat failed", (Throwable)e2);
                    return;
                }
                if (!EntityLock.this.isLocked() && response.getLockStatus() == LockServiceProtos.LockHeartbeatResponse.LockStatus.LOCKED) {
                    EntityLock.this.locked.set(true);
                    EntityLock.this.latch.countDown();
                } else if (EntityLock.this.isLocked() && response.getLockStatus() == LockServiceProtos.LockHeartbeatResponse.LockStatus.UNLOCKED) {
                    EntityLock.this.locked.set(false);
                    EntityLock.this.abort.abort("Lock timed out.", null);
                    return;
                }
                try {
                    long sleepTime = 1000L;
                    if (EntityLock.this.isLocked()) {
                        sleepTime = Math.max(response.getTimeoutMs() - EntityLock.this.heartbeatTimeBuffer, 1);
                    }
                    if (EntityLock.this.testingSleepTime != 0L) {
                        sleepTime = EntityLock.this.testingSleepTime;
                    }
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    EntityLock.this.locked.set(false);
                    if (!this.shutdown) {
                        LOG.error("Interrupted, releasing " + this, (Throwable)e);
                        EntityLock.this.abort.abort("Worker thread interrupted", (Throwable)e);
                    }
                    return;
                }
            }
        }
    }
}

