/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.BooleanStateStore;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class SplitOrMergeStateStore {
    private static final String SPLIT_STATE_NAME = "split_enabled";
    private static final String MERGE_STATE_NAME = "merge_enabled";
    private SwitchStateStore splitStateStore;
    private SwitchStateStore mergeStateStore;

    public SplitOrMergeStateStore(MasterRegion masterRegion, ZKWatcher watcher, Configuration conf) throws IOException, KeeperException, DeserializationException {
        String splitZnode = ZNodePaths.joinZNode((String)watcher.getZNodePaths().switchZNode, (String[])new String[]{conf.get("zookeeper.znode.switch.split", "split")});
        String mergeZnode = ZNodePaths.joinZNode((String)watcher.getZNodePaths().switchZNode, (String[])new String[]{conf.get("zookeeper.znode.switch.merge", "merge")});
        this.splitStateStore = new SwitchStateStore(masterRegion, SPLIT_STATE_NAME, watcher, splitZnode);
        this.mergeStateStore = new SwitchStateStore(masterRegion, MERGE_STATE_NAME, watcher, mergeZnode);
    }

    public boolean isSplitOrMergeEnabled(MasterSwitchType switchType) {
        switch (switchType) {
            case SPLIT: {
                return this.splitStateStore.get();
            }
            case MERGE: {
                return this.mergeStateStore.get();
            }
        }
        return false;
    }

    public void setSplitOrMergeEnabled(boolean enabled, MasterSwitchType switchType) throws IOException {
        switch (switchType) {
            case SPLIT: {
                this.splitStateStore.set(enabled);
                break;
            }
            case MERGE: {
                this.mergeStateStore.set(enabled);
                break;
            }
        }
    }

    private static final class SwitchStateStore
    extends BooleanStateStore {
        public SwitchStateStore(MasterRegion masterRegion, String stateName, ZKWatcher watcher, String zkPath) throws IOException, KeeperException, DeserializationException {
            super(masterRegion, stateName, watcher, zkPath);
        }

        @Override
        protected byte[] toByteArray(boolean enabled) {
            ZooKeeperProtos.SwitchState.Builder builder = ZooKeeperProtos.SwitchState.newBuilder();
            builder.setEnabled(enabled);
            return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
        }

        @Override
        protected boolean parseFrom(byte[] bytes) throws DeserializationException {
            ProtobufUtil.expectPBMagicPrefix((byte[])bytes);
            ZooKeeperProtos.SwitchState.Builder builder = ZooKeeperProtos.SwitchState.newBuilder();
            try {
                int magicLen = ProtobufUtil.lengthOfPBMagic();
                ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])bytes, (int)magicLen, (int)(bytes.length - magicLen));
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
            return builder.build().getEnabled();
        }
    }
}

