/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureFutureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RegionStateNodeLock {
    private final RegionInfo regionInfo;
    private final Lock lock = new ReentrantLock();
    private final Queue<QueueEntry> waitingQueue = new ArrayDeque<QueueEntry>();
    private Object owner;
    private int count;

    RegionStateNodeLock(RegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    private void lock0(QueueEntry entry) throws ProcedureSuspendedException {
        this.lock.lock();
        try {
            while (true) {
                if (this.owner == null) {
                    this.owner = entry.getOwner();
                    this.count = 1;
                    return;
                }
                if (this.owner == entry.getOwner()) {
                    ++this.count;
                    return;
                }
                this.waitingQueue.add(entry);
                entry.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean tryLock0(Object lockBy) {
        if (!this.lock.tryLock()) {
            return false;
        }
        try {
            if (this.owner == null) {
                this.owner = lockBy;
                this.count = 1;
                boolean bl = true;
                return bl;
            }
            if (this.owner == lockBy) {
                ++this.count;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void unlock0(Object unlockBy) {
        this.lock.lock();
        try {
            if (this.owner == null) {
                throw new IllegalMonitorStateException("RegionStateNode " + this.regionInfo + " is not locked");
            }
            if (this.owner != unlockBy) {
                throw new IllegalMonitorStateException("RegionStateNode " + this.regionInfo + " is locked by " + this.owner + ", can not be unlocked by " + unlockBy);
            }
            --this.count;
            if (this.count == 0) {
                this.owner = null;
                QueueEntry entry = this.waitingQueue.poll();
                if (entry != null) {
                    entry.signal();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void lock() {
        final Thread currentThread = Thread.currentThread();
        try {
            this.lock0(new QueueEntry(){
                private Condition cond;

                @Override
                public void signal() {
                    this.cond.signal();
                }

                @Override
                public Object getOwner() {
                    return currentThread;
                }

                @Override
                @SuppressWarnings(value={"WA_AWAIT_NOT_IN_LOOP"}, justification="Loop is in the caller method")
                public void await() {
                    if (this.cond == null) {
                        this.cond = RegionStateNodeLock.this.lock.newCondition();
                    }
                    this.cond.awaitUninterruptibly();
                }
            });
        }
        catch (ProcedureSuspendedException e) {
            throw new AssertionError((Object)e);
        }
    }

    boolean tryLock() {
        return this.tryLock0(Thread.currentThread());
    }

    void unlock() {
        this.unlock0(Thread.currentThread());
    }

    void lock(final Procedure<?> proc, final Runnable wakeUp) throws ProcedureSuspendedException {
        this.lock0(new QueueEntry(){

            @Override
            public Object getOwner() {
                return proc;
            }

            @Override
            public void await() throws ProcedureSuspendedException {
                ProcedureFutureUtil.suspend(proc);
            }

            @Override
            public void signal() {
                assert (RegionStateNodeLock.this.owner == null);
                assert (RegionStateNodeLock.this.count == 0);
                RegionStateNodeLock.this.owner = proc;
                RegionStateNodeLock.this.count = 1;
                wakeUp.run();
            }
        });
    }

    boolean tryLock(Procedure<?> proc) {
        return this.tryLock0(proc);
    }

    void unlock(Procedure<?> proc) {
        this.unlock0(proc);
    }

    boolean isLocked() {
        this.lock.lock();
        try {
            boolean bl = this.owner != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean isLockedBy(Object lockBy) {
        this.lock.lock();
        try {
            boolean bl = this.owner == lockBy;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static interface QueueEntry {
        public Object getOwner();

        public void await() throws ProcedureSuspendedException;

        public void signal();
    }
}

