/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ModifyNamespaceProcedure
extends AbstractStateMachineNamespaceProcedure<MasterProcedureProtos.ModifyNamespaceState> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyNamespaceProcedure.class);
    private NamespaceDescriptor oldNsDescriptor = null;
    private NamespaceDescriptor newNsDescriptor;

    public ModifyNamespaceProcedure() {
    }

    public ModifyNamespaceProcedure(MasterProcedureEnv env, NamespaceDescriptor newNsDescriptor) {
        this(env, newNsDescriptor, null);
    }

    public ModifyNamespaceProcedure(MasterProcedureEnv env, NamespaceDescriptor newNsDescriptor, ProcedurePrepareLatch latch) {
        super(env, latch);
        this.newNsDescriptor = newNsDescriptor;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ModifyNamespaceState state) throws InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case MODIFY_NAMESPACE_PREPARE: {
                    boolean success = this.prepareModify(env);
                    this.releaseSyncLatch();
                    if (!success) {
                        assert (this.isFailed()) : "Modify namespace should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(MasterProcedureProtos.ModifyNamespaceState.MODIFY_NAMESPACE_UPDATE_NS_TABLE);
                    break;
                }
                case MODIFY_NAMESPACE_UPDATE_NS_TABLE: {
                    ModifyNamespaceProcedure.addOrUpdateNamespace(env, this.newNsDescriptor);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case MODIFY_NAMESPACE_UPDATE_ZK: {
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-modify-namespace", e);
            }
            LOG.warn("Retriable error trying to modify namespace=" + this.newNsDescriptor.getName() + " (in state=" + state + ")", (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ModifyNamespaceState state) throws IOException {
        if (state == MasterProcedureProtos.ModifyNamespaceState.MODIFY_NAMESPACE_PREPARE) {
            this.releaseSyncLatch();
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.ModifyNamespaceState state) {
        switch (state) {
            case MODIFY_NAMESPACE_PREPARE: {
                return true;
            }
        }
        return false;
    }

    protected MasterProcedureProtos.ModifyNamespaceState getState(int stateId) {
        return MasterProcedureProtos.ModifyNamespaceState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.ModifyNamespaceState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.ModifyNamespaceState getInitialState() {
        return MasterProcedureProtos.ModifyNamespaceState.MODIFY_NAMESPACE_PREPARE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.ModifyNamespaceStateData.Builder modifyNamespaceMsg = MasterProcedureProtos.ModifyNamespaceStateData.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)this.newNsDescriptor));
        if (this.oldNsDescriptor != null) {
            modifyNamespaceMsg.setUnmodifiedNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)this.oldNsDescriptor));
        }
        serializer.serialize((Message)modifyNamespaceMsg.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ModifyNamespaceStateData modifyNamespaceMsg = (MasterProcedureProtos.ModifyNamespaceStateData)serializer.deserialize(MasterProcedureProtos.ModifyNamespaceStateData.class);
        this.newNsDescriptor = ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)modifyNamespaceMsg.getNamespaceDescriptor());
        if (modifyNamespaceMsg.hasUnmodifiedNamespaceDescriptor()) {
            this.oldNsDescriptor = ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)modifyNamespaceMsg.getUnmodifiedNamespaceDescriptor());
        }
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    @Override
    protected String getNamespaceName() {
        return this.newNsDescriptor.getName();
    }

    private boolean prepareModify(MasterProcedureEnv env) throws IOException {
        if (!ModifyNamespaceProcedure.getTableNamespaceManager(env).doesNamespaceExist(this.newNsDescriptor.getName())) {
            this.setFailure("master-modify-namespace", (Throwable)new NamespaceNotFoundException(this.newNsDescriptor.getName()));
            return false;
        }
        ModifyNamespaceProcedure.getTableNamespaceManager(env).validateTableAndRegionCount(this.newNsDescriptor);
        this.oldNsDescriptor = ModifyNamespaceProcedure.getTableNamespaceManager(env).get(this.newNsDescriptor.getName());
        if (!Objects.equals(this.oldNsDescriptor.getConfigurationValue("hbase.rsgroup.name"), this.newNsDescriptor.getConfigurationValue("hbase.rsgroup.name"))) {
            this.checkNamespaceRSGroup(env, this.newNsDescriptor);
        }
        return true;
    }
}

