/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ServerRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.regionserver.ClaimReplicationQueueCallable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ClaimReplicationQueueRemoteProcedure
extends ServerRemoteProcedure
implements ServerProcedureInterface,
RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ServerName> {
    private static final Logger LOG = LoggerFactory.getLogger(ClaimReplicationQueueRemoteProcedure.class);
    private ReplicationQueueId queueId;

    public ClaimReplicationQueueRemoteProcedure() {
    }

    public ClaimReplicationQueueRemoteProcedure(ReplicationQueueId queueId, ServerName targetServer) {
        this.queueId = queueId;
        this.targetServer = targetServer;
    }

    private boolean shouldSkip(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterFileSystem();
        Path syncUpDir = new Path(mfs.getRootDir(), "ReplicationSyncUp");
        return mfs.getFileSystem().exists(new Path(syncUpDir, this.getServerName().getServerName()));
    }

    @Override
    protected synchronized Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        try {
            if (this.shouldSkip(env)) {
                LOG.info("Skip claiming {} because replication sync up has already done it for us", (Object)this.getServerName());
                return null;
            }
        }
        catch (IOException e) {
            LOG.warn("failed to check whether we should skip claiming {} due to replication sync up", (Object)this.getServerName(), (Object)e);
            return null;
        }
        return super.execute(env);
    }

    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv env, ServerName remote) {
        assert (this.targetServer.equals((Object)remote));
        MasterProcedureProtos.ClaimReplicationQueueRemoteParameter.Builder builder = MasterProcedureProtos.ClaimReplicationQueueRemoteParameter.newBuilder().setCrashedServer(ProtobufUtil.toServerName((ServerName)this.queueId.getServerName())).setQueue(this.queueId.getPeerId());
        this.queueId.getSourceServerName().ifPresent(sourceServer -> builder.setSourceServer(ProtobufUtil.toServerName((ServerName)sourceServer)));
        return Optional.of(new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), ClaimReplicationQueueCallable.class, builder.build().toByteArray()));
    }

    @Override
    public ServerName getServerName() {
        return this.queueId.getServerName();
    }

    @Override
    public boolean hasMetaTableRegion() {
        return false;
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.CLAIM_REPLICATION_QUEUE_REMOTE;
    }

    @Override
    protected void complete(MasterProcedureEnv env, Throwable error) {
        if (error != null) {
            LOG.warn("Failed to claim replication queue {} on server {} ", new Object[]{this.queueId, this.targetServer, error});
            this.succ = false;
        } else {
            this.succ = true;
        }
    }

    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    protected boolean waitInitialized(MasterProcedureEnv env) {
        return env.waitInitialized(this);
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.ClaimReplicationQueueRemoteStateData.Builder builder = MasterProcedureProtos.ClaimReplicationQueueRemoteStateData.newBuilder().setCrashedServer(ProtobufUtil.toServerName((ServerName)this.queueId.getServerName())).setQueue(this.queueId.getPeerId()).setTargetServer(ProtobufUtil.toServerName((ServerName)this.targetServer));
        this.queueId.getSourceServerName().ifPresent(sourceServer -> builder.setSourceServer(ProtobufUtil.toServerName((ServerName)sourceServer)));
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.ClaimReplicationQueueRemoteStateData data = (MasterProcedureProtos.ClaimReplicationQueueRemoteStateData)serializer.deserialize(MasterProcedureProtos.ClaimReplicationQueueRemoteStateData.class);
        this.targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getTargetServer());
        ServerName crashedServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getCrashedServer());
        String queue = data.getQueue();
        this.queueId = data.hasSourceServer() ? new ReplicationQueueId(crashedServer, queue, ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getSourceServer())) : new ReplicationQueueId(crashedServer, queue);
    }
}

