/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SyncReplicationReplayWALManager {
    private static final Logger LOG = LoggerFactory.getLogger(SyncReplicationReplayWALManager.class);
    private final ServerManager serverManager;
    private final FileSystem fs;
    private final Path walRootDir;
    private final Path remoteWALDir;
    private final ConcurrentMap<String, UsedReplayWorkersForPeer> usedWorkersByPeer = new ConcurrentHashMap<String, UsedReplayWorkersForPeer>();

    public SyncReplicationReplayWALManager(final MasterServices services) throws IOException, ReplicationException {
        this.serverManager = services.getServerManager();
        this.fs = services.getMasterFileSystem().getWALFileSystem();
        this.walRootDir = services.getMasterFileSystem().getWALRootDir();
        this.remoteWALDir = new Path(this.walRootDir, "remoteWALs");
        this.serverManager.registerListener(new ServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serverAdded(ServerName serverName) {
                MasterProcedureScheduler scheduler = ((MasterProcedureEnv)services.getMasterProcedureExecutor().getEnvironment()).getProcedureScheduler();
                Iterator iterator = SyncReplicationReplayWALManager.this.usedWorkersByPeer.values().iterator();
                while (iterator.hasNext()) {
                    UsedReplayWorkersForPeer usedWorkers;
                    UsedReplayWorkersForPeer usedReplayWorkersForPeer = usedWorkers = (UsedReplayWorkersForPeer)iterator.next();
                    synchronized (usedReplayWorkersForPeer) {
                        usedWorkers.wake(scheduler);
                    }
                }
            }
        });
    }

    public void registerPeer(String peerId) {
        this.usedWorkersByPeer.put(peerId, new UsedReplayWorkersForPeer(peerId));
    }

    public void unregisterPeer(String peerId) {
        this.usedWorkersByPeer.remove(peerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerName acquirePeerWorker(String peerId, Procedure<?> proc) throws ProcedureSuspendedException {
        UsedReplayWorkersForPeer usedWorkers;
        UsedReplayWorkersForPeer usedReplayWorkersForPeer = usedWorkers = (UsedReplayWorkersForPeer)this.usedWorkersByPeer.get(peerId);
        synchronized (usedReplayWorkersForPeer) {
            Optional<ServerName> worker = usedWorkers.acquire(this.serverManager);
            if (worker.isPresent()) {
                return worker.get();
            }
            usedWorkers.suspend(proc);
        }
        throw new ProcedureSuspendedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePeerWorker(String peerId, ServerName worker, MasterProcedureScheduler scheduler) {
        UsedReplayWorkersForPeer usedWorkers;
        UsedReplayWorkersForPeer usedReplayWorkersForPeer = usedWorkers = (UsedReplayWorkersForPeer)this.usedWorkersByPeer.get(peerId);
        synchronized (usedReplayWorkersForPeer) {
            usedWorkers.release(worker);
            usedWorkers.wake(scheduler);
        }
    }

    public void addUsedPeerWorker(String peerId, ServerName worker) {
        ((UsedReplayWorkersForPeer)this.usedWorkersByPeer.get(peerId)).used(worker);
    }

    public void createPeerRemoteWALDir(String peerId) throws IOException {
        Path peerRemoteWALDir = ReplicationUtils.getPeerRemoteWALDir((Path)this.remoteWALDir, (String)peerId);
        if (!this.fs.exists(peerRemoteWALDir) && !this.fs.mkdirs(peerRemoteWALDir)) {
            throw new IOException("Unable to mkdir " + peerRemoteWALDir);
        }
    }

    private void rename(Path src, Path dst, String peerId) throws IOException {
        if (this.fs.exists(src)) {
            this.deleteDir(dst, peerId);
            if (!this.fs.rename(src, dst)) {
                throw new IOException("Failed to rename dir from " + src + " to " + dst + " for peer id=" + peerId);
            }
            LOG.info("Renamed dir from {} to {} for peer id={}", new Object[]{src, dst, peerId});
        } else if (!this.fs.exists(dst)) {
            throw new IOException("Want to rename from " + src + " to " + dst + ", but they both do not exist");
        }
    }

    public void renameToPeerReplayWALDir(String peerId) throws IOException {
        this.rename(ReplicationUtils.getPeerRemoteWALDir((Path)this.remoteWALDir, (String)peerId), ReplicationUtils.getPeerReplayWALDir((Path)this.remoteWALDir, (String)peerId), peerId);
    }

    public void renameToPeerSnapshotWALDir(String peerId) throws IOException {
        this.rename(ReplicationUtils.getPeerReplayWALDir((Path)this.remoteWALDir, (String)peerId), ReplicationUtils.getPeerSnapshotWALDir((Path)this.remoteWALDir, (String)peerId), peerId);
    }

    public List<Path> getReplayWALsAndCleanUpUnusedFiles(String peerId) throws IOException {
        Path peerReplayWALDir = ReplicationUtils.getPeerReplayWALDir((Path)this.remoteWALDir, (String)peerId);
        for (FileStatus status : this.fs.listStatus(peerReplayWALDir, p -> p.getName().endsWith(".ren"))) {
            Path src = status.getPath();
            String srcName = src.getName();
            String dstName = srcName.substring(0, srcName.length() - ".ren".length());
            FSUtils.renameFile(this.fs, src, new Path(src.getParent(), dstName));
        }
        ArrayList<Path> wals = new ArrayList<Path>();
        for (FileStatus status : this.fs.listStatus(peerReplayWALDir)) {
            Path path = status.getPath();
            if (path.getName().endsWith(".syncrep")) {
                wals.add(path);
                continue;
            }
            if (this.fs.delete(path, true)) continue;
            LOG.warn("Can not delete unused file: " + path);
        }
        return wals;
    }

    private void deleteDir(Path dir, String peerId) throws IOException {
        if (!this.fs.delete(dir, true) && this.fs.exists(dir)) {
            throw new IOException("Failed to remove dir " + dir + " for peer id=" + peerId);
        }
    }

    public void removePeerRemoteWALs(String peerId) throws IOException {
        this.deleteDir(ReplicationUtils.getPeerRemoteWALDir((Path)this.remoteWALDir, (String)peerId), peerId);
        this.deleteDir(ReplicationUtils.getPeerReplayWALDir((Path)this.remoteWALDir, (String)peerId), peerId);
        this.deleteDir(ReplicationUtils.getPeerSnapshotWALDir((Path)this.remoteWALDir, (String)peerId), peerId);
    }

    public String removeWALRootPath(Path path) {
        String pathStr = path.toString();
        return pathStr.substring(this.walRootDir.toString().length() + 1);
    }

    public void finishReplayWAL(String wal) throws IOException {
        Path walPath = new Path(this.walRootDir, wal);
        this.fs.truncate(walPath, 0L);
    }

    public boolean isReplayWALFinished(String wal) throws IOException {
        Path walPath = new Path(this.walRootDir, wal);
        return this.fs.getFileStatus(walPath).getLen() == 0L;
    }

    public Path getRemoteWALDir() {
        return this.remoteWALDir;
    }

    private static final class UsedReplayWorkersForPeer {
        private final Set<ServerName> usedWorkers = new HashSet<ServerName>();
        private final ProcedureEvent<?> event;

        public UsedReplayWorkersForPeer(String peerId) {
            this.event = new ProcedureEvent((Object)peerId);
        }

        public void used(ServerName worker) {
            this.usedWorkers.add(worker);
        }

        public Optional<ServerName> acquire(ServerManager serverManager) {
            Optional<ServerName> worker = serverManager.getOnlineServers().keySet().stream().filter(server -> !this.usedWorkers.contains(server)).findAny();
            worker.ifPresent(this.usedWorkers::add);
            return worker;
        }

        public void release(ServerName worker) {
            this.usedWorkers.remove(worker);
        }

        public void suspend(Procedure<?> proc) {
            this.event.suspend();
            this.event.suspendIfNotReady(proc);
        }

        public void wake(MasterProcedureScheduler scheduler) {
            if (!this.event.isReady()) {
                this.event.wake((AbstractProcedureScheduler)scheduler);
            }
        }
    }
}

