/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerQuotaSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsTable;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregate;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregateFactory;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class MetricsRegionServer {
    public static final String RS_ENABLE_SERVER_QUERY_METER_METRICS_KEY = "hbase.regionserver.enable.server.query.meter";
    public static final boolean RS_ENABLE_SERVER_QUERY_METER_METRICS_KEY_DEFAULT = false;
    public static final String SLOW_METRIC_TIME = "hbase.ipc.slow.metric.time";
    private final MetricsRegionServerSource serverSource;
    private final MetricsRegionServerWrapper regionServerWrapper;
    private final MetricsTable metricsTable;
    private MetricsRegionServerQuotaSource quotaSource;
    private final MetricsUserAggregate userAggregate;
    private MetricRegistry metricRegistry;
    private Timer bulkLoadTimer;
    private Meter serverReadQueryMeter;
    private Meter serverWriteQueryMeter;
    protected long slowMetricTime;
    protected static final int DEFAULT_SLOW_METRIC_TIME = 1000;

    public MetricsRegionServer(MetricsRegionServerWrapper regionServerWrapper, Configuration conf, MetricsTable metricsTable) {
        this(regionServerWrapper, ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).createServer(regionServerWrapper), metricsTable, MetricsUserAggregateFactory.getMetricsUserAggregate(conf));
        this.metricRegistry = (MetricRegistry)MetricRegistries.global().get(this.serverSource.getMetricRegistryInfo()).get();
        this.bulkLoadTimer = this.metricRegistry.timer("Bulkload");
        this.slowMetricTime = conf.getLong(SLOW_METRIC_TIME, 1000L);
        this.quotaSource = (MetricsRegionServerQuotaSource)CompatibilitySingletonFactory.getInstance(MetricsRegionServerQuotaSource.class);
        if (conf.getBoolean(RS_ENABLE_SERVER_QUERY_METER_METRICS_KEY, false)) {
            this.serverReadQueryMeter = this.metricRegistry.meter("ServerReadQueryPerSecond");
            this.serverWriteQueryMeter = this.metricRegistry.meter("ServerWriteQueryPerSecond");
        }
    }

    MetricsRegionServer(MetricsRegionServerWrapper regionServerWrapper, MetricsRegionServerSource serverSource, MetricsTable metricsTable, MetricsUserAggregate userAggregate) {
        this.regionServerWrapper = regionServerWrapper;
        this.serverSource = serverSource;
        this.metricsTable = metricsTable;
        this.userAggregate = userAggregate;
    }

    public MetricsRegionServerSource getMetricsSource() {
        return this.serverSource;
    }

    public MetricsUserAggregate getMetricsUserAggregate() {
        return this.userAggregate;
    }

    public MetricsRegionServerWrapper getRegionServerWrapper() {
        return this.regionServerWrapper;
    }

    public void updatePutBatch(HRegion region, long t) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updatePutBatch(t);
        }
        this.serverSource.updatePutBatch(t);
    }

    public void updatePut(HRegion region, long t) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updatePut(t);
        }
        if (t > this.slowMetricTime) {
            this.serverSource.incrSlowPut();
        }
        this.serverSource.updatePut(t);
        this.userAggregate.updatePut(t);
    }

    public void updateDelete(HRegion region, long t) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updateDelete(t);
        }
        if (t > this.slowMetricTime) {
            this.serverSource.incrSlowDelete();
        }
        this.serverSource.updateDelete(t);
        this.userAggregate.updateDelete(t);
    }

    public void updateDeleteBatch(HRegion region, long t) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updateDeleteBatch(t);
        }
        this.serverSource.updateDeleteBatch(t);
    }

    public void updateCheckAndDelete(HRegion region, long t) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updateCheckAndDelete(t);
        }
        this.serverSource.updateCheckAndDelete(t);
    }

    public void updateCheckAndPut(HRegion region, long t) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updateCheckAndPut(t);
        }
        this.serverSource.updateCheckAndPut(t);
    }

    public void updateCheckAndMutate(HRegion region, long time, long blockBytesScanned) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updateCheckAndMutate(time, blockBytesScanned);
        }
        this.serverSource.updateCheckAndMutate(time, blockBytesScanned);
        this.userAggregate.updateCheckAndMutate(blockBytesScanned);
    }

    public void updateGet(HRegion region, long time, long blockBytesScanned) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updateGet(time, blockBytesScanned);
        }
        if (time > this.slowMetricTime) {
            this.serverSource.incrSlowGet();
        }
        this.serverSource.updateGet(time, blockBytesScanned);
        this.userAggregate.updateGet(time, blockBytesScanned);
    }

    public void updateIncrement(HRegion region, long time, long blockBytesScanned) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updateIncrement(time, blockBytesScanned);
        }
        if (time > this.slowMetricTime) {
            this.serverSource.incrSlowIncrement();
        }
        this.serverSource.updateIncrement(time, blockBytesScanned);
        this.userAggregate.updateIncrement(time, blockBytesScanned);
    }

    public void updateAppend(HRegion region, long time, long blockBytesScanned) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updateAppend(time, blockBytesScanned);
        }
        if (time > this.slowMetricTime) {
            this.serverSource.incrSlowAppend();
        }
        this.serverSource.updateAppend(time, blockBytesScanned);
        this.userAggregate.updateAppend(time, blockBytesScanned);
    }

    public void updateReplay(long t) {
        this.serverSource.updateReplay(t);
        this.userAggregate.updateReplay(t);
    }

    public void updateScan(HRegion region, long time, long responseCellSize, long blockBytesScanned) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updateScan(time, responseCellSize, blockBytesScanned);
        }
        this.serverSource.updateScan(time, responseCellSize, blockBytesScanned);
        this.userAggregate.updateScan(time, blockBytesScanned);
    }

    public void updateSplitTime(long t) {
        this.serverSource.updateSplitTime(t);
    }

    public void incrSplitRequest() {
        this.serverSource.incrSplitRequest();
    }

    public void incrSplitSuccess() {
        this.serverSource.incrSplitSuccess();
    }

    public void updateFlush(String table, long t, long memstoreSize, long fileSize) {
        this.serverSource.updateFlushTime(t);
        this.serverSource.updateFlushMemStoreSize(memstoreSize);
        this.serverSource.updateFlushOutputSize(fileSize);
        if (table != null) {
            this.metricsTable.updateFlushTime(table, t);
            this.metricsTable.updateFlushMemstoreSize(table, memstoreSize);
            this.metricsTable.updateFlushOutputSize(table, fileSize);
        }
    }

    public void updateCompaction(String table, boolean isMajor, long t, int inputFileCount, int outputFileCount, long inputBytes, long outputBytes) {
        this.serverSource.updateCompactionTime(isMajor, t);
        this.serverSource.updateCompactionInputFileCount(isMajor, (long)inputFileCount);
        this.serverSource.updateCompactionOutputFileCount(isMajor, (long)outputFileCount);
        this.serverSource.updateCompactionInputSize(isMajor, inputBytes);
        this.serverSource.updateCompactionOutputSize(isMajor, outputBytes);
        if (table != null) {
            this.metricsTable.updateCompactionTime(table, isMajor, t);
            this.metricsTable.updateCompactionInputFileCount(table, isMajor, inputFileCount);
            this.metricsTable.updateCompactionOutputFileCount(table, isMajor, outputFileCount);
            this.metricsTable.updateCompactionInputSize(table, isMajor, inputBytes);
            this.metricsTable.updateCompactionOutputSize(table, isMajor, outputBytes);
        }
    }

    public void updateBulkLoad(long millis) {
        this.bulkLoadTimer.updateMillis(millis);
    }

    public void incrementNumRegionSizeReportsSent(long numReportsSent) {
        this.quotaSource.incrementNumRegionSizeReportsSent(numReportsSent);
    }

    public void incrementRegionSizeReportingChoreTime(long time) {
        this.quotaSource.incrementRegionSizeReportingChoreTime(time);
    }

    public void updateReadQueryMeter(HRegion region, long count) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updateTableReadQueryMeter(count);
        }
        if (this.serverReadQueryMeter != null) {
            this.serverReadQueryMeter.mark(count);
        }
    }

    public void updateWriteQueryMeter(HRegion region, long count) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updateTableWriteQueryMeter(count);
        }
        if (this.serverWriteQueryMeter != null) {
            this.serverWriteQueryMeter.mark(count);
        }
    }

    public void updateWriteQueryMeter(HRegion region) {
        if (region.getMetricsTableRequests() != null) {
            region.getMetricsTableRequests().updateTableWriteQueryMeter();
        }
        if (this.serverWriteQueryMeter != null) {
            this.serverWriteQueryMeter.mark();
        }
    }

    public void incrScannerLeaseExpired() {
        this.serverSource.incrScannerLeaseExpired();
    }
}

