/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetricsRegionWrapperImpl
implements MetricsRegionWrapper,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsRegionWrapperImpl.class);
    public static final int PERIOD = 45;
    public static final String UNKNOWN = "unknown";
    private final HRegion region;
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long numStoreFiles;
    private long storeRefCount;
    private long maxCompactedStoreFileRefCount;
    private long memstoreSize;
    private long storeFileSize;
    private long maxStoreFileAge;
    private long minStoreFileAge;
    private long avgStoreFileAge;
    private long numReferenceFiles;
    private long maxFlushQueueSize;
    private long maxCompactionQueueSize;
    private Map<String, Long> readsOnlyFromMemstore;
    private Map<String, Long> mixedReadsOnStore;
    private ScheduledFuture<?> regionMetricsUpdateTask;
    private float currentRegionCacheRatio;

    public MetricsRegionWrapperImpl(HRegion region) {
        this.region = region;
        this.executor = ((MetricsExecutor)CompatibilitySingletonFactory.getInstance(MetricsExecutor.class)).getExecutor();
        this.runnable = new HRegionMetricsWrapperRunnable();
        this.regionMetricsUpdateTask = this.executor.scheduleWithFixedDelay(this.runnable, 45L, 45L, TimeUnit.SECONDS);
    }

    public String getTableName() {
        TableDescriptor tableDesc = this.region.getTableDescriptor();
        if (tableDesc == null) {
            return UNKNOWN;
        }
        return tableDesc.getTableName().getQualifierAsString();
    }

    public String getNamespace() {
        TableDescriptor tableDesc = this.region.getTableDescriptor();
        if (tableDesc == null) {
            return UNKNOWN;
        }
        return tableDesc.getTableName().getNamespaceAsString();
    }

    public String getRegionName() {
        RegionInfo regionInfo = this.region.getRegionInfo();
        if (regionInfo == null) {
            return UNKNOWN;
        }
        return regionInfo.getEncodedName();
    }

    public long getNumStores() {
        Map<byte[], HStore> stores = this.region.stores;
        if (stores == null) {
            return 0L;
        }
        return stores.size();
    }

    public long getNumStoreFiles() {
        return this.numStoreFiles;
    }

    public long getMemStoreSize() {
        return this.memstoreSize;
    }

    public long getStoreFileSize() {
        return this.storeFileSize;
    }

    public float getCurrentRegionCacheRatio() {
        return this.currentRegionCacheRatio;
    }

    public long getStoreRefCount() {
        return this.storeRefCount;
    }

    public long getMaxCompactedStoreFileRefCount() {
        return this.maxCompactedStoreFileRefCount;
    }

    public long getReadRequestCount() {
        return this.region.getReadRequestsCount();
    }

    public long getCpRequestCount() {
        return this.region.getCpRequestsCount();
    }

    public long getFilteredReadRequestCount() {
        return this.region.getFilteredReadRequestsCount();
    }

    public long getWriteRequestCount() {
        return this.region.getWriteRequestsCount();
    }

    public long getNumFilesCompacted() {
        return this.region.compactionNumFilesCompacted.sum();
    }

    public long getNumBytesCompacted() {
        return this.region.compactionNumBytesCompacted.sum();
    }

    public long getNumCompactionsCompleted() {
        return this.region.compactionsFinished.sum();
    }

    public long getLastMajorCompactionAge() {
        long lastMajorCompactionTs = 0L;
        try {
            lastMajorCompactionTs = this.region.getOldestHfileTs(true);
        }
        catch (IOException ioe) {
            LOG.error("Could not load HFile info ", (Throwable)ioe);
        }
        long now = EnvironmentEdgeManager.currentTime();
        return now - lastMajorCompactionTs;
    }

    public long getTotalRequestCount() {
        return this.getReadRequestCount() + this.getWriteRequestCount();
    }

    public long getNumCompactionsFailed() {
        return this.region.compactionsFailed.sum();
    }

    public long getNumCompactionsQueued() {
        return this.region.compactionsQueued.sum();
    }

    public long getNumFlushesQueued() {
        return this.region.flushesQueued.sum();
    }

    public long getMaxCompactionQueueSize() {
        return this.maxCompactionQueueSize;
    }

    public long getMaxFlushQueueSize() {
        return this.maxFlushQueueSize;
    }

    public long getMaxStoreFileAge() {
        return this.maxStoreFileAge;
    }

    public long getMinStoreFileAge() {
        return this.minStoreFileAge;
    }

    public long getAvgStoreFileAge() {
        return this.avgStoreFileAge;
    }

    public long getNumReferenceFiles() {
        return this.numReferenceFiles;
    }

    public int getRegionHashCode() {
        return this.region.hashCode();
    }

    public Map<String, Long> getMemstoreOnlyRowReadsCount() {
        return this.readsOnlyFromMemstore;
    }

    public Map<String, Long> getMixedRowReadsCount() {
        return this.mixedReadsOnStore;
    }

    @Override
    public void close() throws IOException {
        this.regionMetricsUpdateTask.cancel(true);
    }

    public int getReplicaId() {
        return this.region.getRegionInfo().getReplicaId();
    }

    public class HRegionMetricsWrapperRunnable
    implements Runnable {
        @Override
        public void run() {
            long tempNumStoreFiles = 0L;
            int tempStoreRefCount = 0;
            int tempMaxCompactedStoreFileRefCount = 0;
            long tempMemstoreSize = 0L;
            long tempStoreFileSize = 0L;
            long tempMaxStoreFileAge = 0L;
            long tempMinStoreFileAge = Long.MAX_VALUE;
            long tempNumReferenceFiles = 0L;
            long tempMaxCompactionQueueSize = 0L;
            long tempMaxFlushQueueSize = 0L;
            long avgAgeNumerator = 0L;
            long numHFiles = 0L;
            if (((MetricsRegionWrapperImpl)MetricsRegionWrapperImpl.this).region.stores != null) {
                for (HStore store : ((MetricsRegionWrapperImpl)MetricsRegionWrapperImpl.this).region.stores.values()) {
                    Long tempVal;
                    OptionalLong storeMinStoreFileAge;
                    tempNumStoreFiles += (long)store.getStorefilesCount();
                    int currentStoreRefCount = store.getStoreRefCount();
                    tempStoreRefCount += currentStoreRefCount;
                    int currentMaxCompactedStoreFileRefCount = store.getMaxCompactedStoreFileRefCount();
                    tempMaxCompactedStoreFileRefCount = Math.max(tempMaxCompactedStoreFileRefCount, currentMaxCompactedStoreFileRefCount);
                    tempMemstoreSize += store.getMemStoreSize().getDataSize();
                    tempStoreFileSize += store.getStorefilesSize();
                    OptionalLong storeMaxStoreFileAge = store.getMaxStoreFileAge();
                    if (storeMaxStoreFileAge.isPresent() && storeMaxStoreFileAge.getAsLong() > tempMaxStoreFileAge) {
                        tempMaxStoreFileAge = storeMaxStoreFileAge.getAsLong();
                    }
                    if ((storeMinStoreFileAge = store.getMinStoreFileAge()).isPresent() && storeMinStoreFileAge.getAsLong() < tempMinStoreFileAge) {
                        tempMinStoreFileAge = storeMinStoreFileAge.getAsLong();
                    }
                    long storeHFiles = store.getNumHFiles();
                    numHFiles += storeHFiles;
                    tempNumReferenceFiles += store.getNumReferenceFiles();
                    OptionalDouble storeAvgStoreFileAge = store.getAvgStoreFileAge();
                    if (storeAvgStoreFileAge.isPresent()) {
                        avgAgeNumerator += (long)storeAvgStoreFileAge.getAsDouble() * storeHFiles;
                    }
                    if (MetricsRegionWrapperImpl.this.mixedReadsOnStore == null) {
                        MetricsRegionWrapperImpl.this.mixedReadsOnStore = new HashMap();
                    }
                    tempVal = (tempVal = (Long)MetricsRegionWrapperImpl.this.mixedReadsOnStore.get(store.getColumnFamilyName())) == null ? Long.valueOf(0L) : Long.valueOf(tempVal + store.getMixedRowReadsCount());
                    MetricsRegionWrapperImpl.this.mixedReadsOnStore.put(store.getColumnFamilyName(), tempVal);
                    if (MetricsRegionWrapperImpl.this.readsOnlyFromMemstore == null) {
                        MetricsRegionWrapperImpl.this.readsOnlyFromMemstore = new HashMap();
                    }
                    tempVal = (tempVal = (Long)MetricsRegionWrapperImpl.this.readsOnlyFromMemstore.get(store.getColumnFamilyName())) == null ? Long.valueOf(0L) : Long.valueOf(tempVal + store.getMemstoreOnlyRowReadsCount());
                    MetricsRegionWrapperImpl.this.readsOnlyFromMemstore.put(store.getColumnFamilyName(), tempVal);
                }
            }
            MutableLong regionCachedAmount = new MutableLong(0L);
            MetricsRegionWrapperImpl.this.region.getBlockCache().getRegionCachedInfo().ifPresent(regionCacheRatio -> regionCachedAmount.addAndGet((Number)regionCacheRatio.getOrDefault(MetricsRegionWrapperImpl.this.region.getRegionInfo().getEncodedName(), 0L)));
            if (tempStoreFileSize > 0L) {
                LOG.debug("Region {}, had cached {} bytes from a total of {}", new Object[]{MetricsRegionWrapperImpl.this.region.getRegionInfo().getEncodedName(), regionCachedAmount.getValue(), tempStoreFileSize});
                MetricsRegionWrapperImpl.this.currentRegionCacheRatio = regionCachedAmount.floatValue() / (float)tempStoreFileSize;
            }
            MetricsRegionWrapperImpl.this.numStoreFiles = tempNumStoreFiles;
            MetricsRegionWrapperImpl.this.storeRefCount = tempStoreRefCount;
            MetricsRegionWrapperImpl.this.maxCompactedStoreFileRefCount = tempMaxCompactedStoreFileRefCount;
            MetricsRegionWrapperImpl.this.memstoreSize = tempMemstoreSize;
            MetricsRegionWrapperImpl.this.storeFileSize = tempStoreFileSize;
            MetricsRegionWrapperImpl.this.maxStoreFileAge = tempMaxStoreFileAge;
            if (tempMinStoreFileAge != Long.MAX_VALUE) {
                MetricsRegionWrapperImpl.this.minStoreFileAge = tempMinStoreFileAge;
            }
            if (numHFiles != 0L) {
                MetricsRegionWrapperImpl.this.avgStoreFileAge = avgAgeNumerator / numHFiles;
            }
            MetricsRegionWrapperImpl.this.numReferenceFiles = tempNumReferenceFiles;
            tempMaxCompactionQueueSize = MetricsRegionWrapperImpl.this.getNumCompactionsQueued();
            tempMaxFlushQueueSize = MetricsRegionWrapperImpl.this.getNumFlushesQueued();
            if (tempMaxCompactionQueueSize > MetricsRegionWrapperImpl.this.maxCompactionQueueSize) {
                MetricsRegionWrapperImpl.this.maxCompactionQueueSize = tempMaxCompactionQueueSize;
            }
            if (tempMaxFlushQueueSize > MetricsRegionWrapperImpl.this.maxFlushQueueSize) {
                MetricsRegionWrapperImpl.this.maxFlushQueueSize = tempMaxFlushQueueSize;
            }
        }
    }
}

