/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.ClientTokenUtil;
import org.apache.hadoop.hbase.security.token.FsDelegationToken;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Methods;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SecureBulkLoadManager {
    public static final long VERSION = 0L;
    private static final int RANDOM_WIDTH = 320;
    private static final int RANDOM_RADIX = 32;
    private static final Logger LOG = LoggerFactory.getLogger(SecureBulkLoadManager.class);
    private static final FsPermission PERM_ALL_ACCESS = FsPermission.valueOf((String)"-rwxrwxrwx");
    private static final FsPermission PERM_HIDDEN = FsPermission.valueOf((String)"-rwx--x--x");
    private SecureRandom random;
    private FileSystem fs;
    private Configuration conf;
    private Path baseStagingDir;
    private UserProvider userProvider;
    private ConcurrentHashMap<UserGroupInformation, MutableInt> ugiReferenceCounter;
    private AsyncConnection conn;
    private Consumer<HRegion> fsCreatedListener;

    SecureBulkLoadManager(Configuration conf, AsyncConnection conn) {
        this.conf = conf;
        this.conn = conn;
    }

    public void start() throws IOException {
        this.random = new SecureRandom();
        this.userProvider = UserProvider.instantiate((Configuration)this.conf);
        this.ugiReferenceCounter = new ConcurrentHashMap();
        this.fs = FileSystem.get((Configuration)this.conf);
        this.baseStagingDir = new Path(CommonFSUtils.getRootDir((Configuration)this.conf), "staging");
        if (this.conf.get("hbase.bulkload.staging.dir") != null) {
            LOG.warn("hbase.bulkload.staging.dir  is deprecated. Bulkload staging directory is " + this.baseStagingDir);
        }
        if (!this.fs.exists(this.baseStagingDir)) {
            this.fs.mkdirs(this.baseStagingDir, PERM_HIDDEN);
            if (!PERM_HIDDEN.equals((Object)PERM_HIDDEN.applyUMask(FsPermission.getUMask((Configuration)this.conf)))) {
                LOG.info("Modifying permissions to " + PERM_HIDDEN);
                this.fs.setPermission(this.baseStagingDir, PERM_HIDDEN);
            }
        }
    }

    public void stop() throws IOException {
    }

    public String prepareBulkLoad(HRegion region, ClientProtos.PrepareBulkLoadRequest request) throws IOException {
        User user = this.getActiveUser();
        region.getCoprocessorHost().prePrepareBulkLoad(user);
        String bulkToken = this.createStagingDir(this.baseStagingDir, user, region.getTableDescriptor().getTableName()).toString();
        return bulkToken;
    }

    public void cleanupBulkLoad(HRegion region, ClientProtos.CleanupBulkLoadRequest request) throws IOException {
        region.getCoprocessorHost().preCleanupBulkLoad(this.getActiveUser());
        Path path = new Path(request.getBulkToken());
        if (!this.fs.delete(path, true) && this.fs.exists(path)) {
            throw new IOException("Failed to clean up " + path);
        }
        LOG.trace("Cleaned up {} successfully.", (Object)path);
    }

    void setFsCreatedListener(Consumer<HRegion> fsCreatedListener) {
        this.fsCreatedListener = fsCreatedListener;
    }

    private void incrementUgiReference(UserGroupInformation ugi) {
        this.ugiReferenceCounter.compute(ugi, (key, value) -> {
            if (value == null) {
                value = new MutableInt(1);
            } else {
                value.increment();
            }
            return value;
        });
    }

    private void decrementUgiReference(UserGroupInformation ugi) {
        this.ugiReferenceCounter.computeIfPresent(ugi, (key, value) -> {
            if (value.intValue() > 1) {
                value.decrement();
            } else {
                value = null;
            }
            return value;
        });
    }

    private boolean isUserReferenced(UserGroupInformation ugi) {
        return this.ugiReferenceCounter.containsKey(ugi);
    }

    public Map<byte[], List<Path>> secureBulkLoadHFiles(HRegion region, ClientProtos.BulkLoadHFileRequest request) throws IOException {
        return this.secureBulkLoadHFiles(region, request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], List<Path>> secureBulkLoadHFiles(final HRegion region, final ClientProtos.BulkLoadHFileRequest request, final List<String> clusterIds) throws IOException {
        final ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>(request.getFamilyPathCount());
        for (ClientProtos.BulkLoadHFileRequest.FamilyPath el : request.getFamilyPathList()) {
            familyPaths.add(new Pair((Object)el.getFamily().toByteArray(), (Object)el.getPath()));
        }
        Token userToken = null;
        if (this.userProvider.isHadoopSecurityEnabled()) {
            userToken = new Token(request.getFsToken().getIdentifier().toByteArray(), request.getFsToken().getPassword().toByteArray(), new Text(request.getFsToken().getKind()), new Text(request.getFsToken().getService()));
        }
        final String bulkToken = request.getBulkToken();
        User user = this.getActiveUser();
        UserGroupInformation ugi = user.getUGI();
        if (this.userProvider.isHadoopSecurityEnabled()) {
            try {
                Token tok = (Token)ClientTokenUtil.obtainToken((AsyncConnection)this.conn).get();
                if (tok != null) {
                    boolean b = ugi.addToken(tok);
                    LOG.debug("token added " + tok + " for user " + ugi + " return=" + b);
                }
            }
            catch (Exception ioe) {
                LOG.warn("unable to add token", (Throwable)ioe);
            }
        }
        if (userToken != null) {
            ugi.addToken(userToken);
        } else if (this.userProvider.isHadoopSecurityEnabled()) {
            throw new DoNotRetryIOException("User token cannot be null");
        }
        if (region.getCoprocessorHost() != null) {
            region.getCoprocessorHost().preBulkLoadHFile(familyPaths);
        }
        Map map = null;
        try {
            this.incrementUgiReference(ugi);
            if (this.userProvider.isHadoopSecurityEnabled()) {
                FsDelegationToken targetfsDelegationToken = new FsDelegationToken(this.userProvider, "renewer");
                targetfsDelegationToken.acquireDelegationToken(this.fs);
                Token<?> targetFsToken = targetfsDelegationToken.getUserToken();
                if (!(targetFsToken == null || userToken != null && targetFsToken.getService().equals((Object)userToken.getService()))) {
                    ugi.addToken(targetFsToken);
                }
            }
            map = (Map)ugi.doAs((PrivilegedAction)new PrivilegedAction<Map<byte[], List<Path>>>(){

                @Override
                public Map<byte[], List<Path>> run() {
                    FileSystem fs = null;
                    try {
                        fs = FileSystem.get((Configuration)SecureBulkLoadManager.this.conf);
                        for (Pair el : familyPaths) {
                            Path stageFamily = new Path(bulkToken, Bytes.toString((byte[])((byte[])el.getFirst())));
                            if (fs.exists(stageFamily)) continue;
                            fs.mkdirs(stageFamily);
                            fs.setPermission(stageFamily, PERM_ALL_ACCESS);
                        }
                        if (SecureBulkLoadManager.this.fsCreatedListener != null) {
                            SecureBulkLoadManager.this.fsCreatedListener.accept(region);
                        }
                        return region.bulkLoadHFiles(familyPaths, true, new SecureBulkLoadListener(fs, bulkToken, SecureBulkLoadManager.this.conf), request.getCopyFile(), clusterIds, request.getReplicate());
                    }
                    catch (Exception e) {
                        LOG.error("Failed to complete bulk load", (Throwable)e);
                        return null;
                    }
                }
            });
            this.decrementUgiReference(ugi);
        }
        catch (Throwable throwable) {
            this.decrementUgiReference(ugi);
            try {
                if (!UserGroupInformation.getLoginUser().equals((Object)ugi) && !this.isUserReferenced(ugi)) {
                    FileSystem.closeAllForUGI((UserGroupInformation)ugi);
                }
            }
            catch (IOException e) {
                LOG.error("Failed to close FileSystem for: {}", (Object)ugi, (Object)e);
            }
            if (region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().postBulkLoadHFile(familyPaths, map);
            }
            throw throwable;
        }
        try {
            if (!UserGroupInformation.getLoginUser().equals((Object)ugi) && !this.isUserReferenced(ugi)) {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to close FileSystem for: {}", (Object)ugi, (Object)e);
        }
        if (region.getCoprocessorHost() != null) {
            region.getCoprocessorHost().postBulkLoadHFile(familyPaths, map);
        }
        return map;
    }

    private Path createStagingDir(Path baseDir, User user, TableName tableName) throws IOException {
        String tblName = tableName.getNameAsString().replace(":", "_");
        String randomDir = user.getShortName() + "__" + tblName + "__" + new BigInteger(320, this.random).toString(32);
        return this.createStagingDir(baseDir, user, randomDir);
    }

    private Path createStagingDir(Path baseDir, User user, String randomDir) throws IOException {
        Path p = new Path(baseDir, randomDir);
        this.fs.mkdirs(p, PERM_ALL_ACCESS);
        this.fs.setPermission(p, PERM_ALL_ACCESS);
        return p;
    }

    private User getActiveUser() throws IOException {
        User user = RpcServer.getRequestUser().orElse(this.userProvider.getCurrent());
        if (this.userProvider.isHadoopSecurityEnabled() && "simple".equalsIgnoreCase(this.conf.get("hbase.security.authentication"))) {
            return User.createUserForTesting((Configuration)this.conf, (String)user.getShortName(), (String[])new String[0]);
        }
        return user;
    }

    static class SecureBulkLoadListener
    implements HRegion.BulkLoadListener {
        private final FileSystem fs;
        private final String stagingDir;
        private final Configuration conf;
        private FileSystem srcFs = null;
        private Map<String, FsPermission> origPermissions = null;
        private Map<String, String> origSources = null;

        public SecureBulkLoadListener(FileSystem fs, String stagingDir, Configuration conf) {
            this.fs = fs;
            this.stagingDir = stagingDir;
            this.conf = conf;
            this.origPermissions = new HashMap<String, FsPermission>();
            this.origSources = new HashMap<String, String>();
        }

        @Override
        public String prepareBulkLoad(byte[] family, String srcPath, boolean copyFile, String customStaging) throws IOException {
            Path stageP;
            Path p = new Path(srcPath);
            String currentStaging = this.stagingDir;
            if (StringUtils.isNotEmpty((CharSequence)customStaging)) {
                currentStaging = customStaging;
            }
            if (p.equals((Object)(stageP = new Path(currentStaging, new Path(Bytes.toString((byte[])family), p.getName()))))) {
                LOG.debug(p.getName() + " is already available in staging directory. Skipping copy or rename.");
                return stageP.toString();
            }
            if (this.srcFs == null) {
                this.srcFs = FileSystem.newInstance((URI)p.toUri(), (Configuration)this.conf);
            }
            if (!this.isFile(p)) {
                throw new IOException("Path does not reference a file: " + p);
            }
            if (!FSUtils.isSameHdfs(this.conf, this.srcFs, this.fs)) {
                LOG.debug("Bulk-load file " + srcPath + " is on different filesystem than the destination filesystem. Copying file over to destination staging dir.");
                FileUtil.copy((FileSystem)this.srcFs, (Path)p, (FileSystem)this.fs, (Path)stageP, (boolean)false, (Configuration)this.conf);
            } else if (copyFile) {
                LOG.debug("Bulk-load file " + srcPath + " is copied to destination staging dir.");
                FileUtil.copy((FileSystem)this.srcFs, (Path)p, (FileSystem)this.fs, (Path)stageP, (boolean)false, (Configuration)this.conf);
            } else {
                LOG.debug("Moving " + p + " to " + stageP);
                FileStatus origFileStatus = this.fs.getFileStatus(p);
                this.origPermissions.put(srcPath, origFileStatus.getPermission());
                this.origSources.put(stageP.toString(), srcPath);
                if (!this.fs.rename(p, stageP)) {
                    throw new IOException("Failed to move HFile: " + p + " to " + stageP);
                }
            }
            this.fs.setPermission(stageP, PERM_ALL_ACCESS);
            return stageP.toString();
        }

        @Override
        public void doneBulkLoad(byte[] family, String srcPath) throws IOException {
            LOG.debug("Bulk Load done for: " + srcPath);
            this.closeSrcFs();
        }

        private void closeSrcFs() throws IOException {
            if (this.srcFs != null) {
                this.srcFs.close();
                this.srcFs = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failedBulkLoad(byte[] family, String stagedPath) throws IOException {
            try {
                String src = this.origSources.get(stagedPath);
                if (StringUtils.isEmpty((CharSequence)src)) {
                    LOG.debug(stagedPath + " was not moved to staging. No need to move back");
                    return;
                }
                Path stageP = new Path(stagedPath);
                if (!this.fs.exists(stageP)) {
                    throw new IOException("Missing HFile: " + stageP + ", can't be moved back to it's original place");
                }
                Path srcPath = new Path(src);
                if (this.srcFs.exists(srcPath)) {
                    LOG.debug(src + " is already at it's original place. No need to move.");
                    return;
                }
                LOG.debug("Moving " + stageP + " back to " + srcPath);
                if (!this.fs.rename(stageP, srcPath)) {
                    throw new IOException("Failed to move HFile: " + stageP + " to " + srcPath);
                }
                if (this.origPermissions.containsKey(stagedPath)) {
                    this.fs.setPermission(srcPath, this.origPermissions.get(src));
                } else {
                    LOG.warn("Can't find previous permission for path=" + stagedPath);
                }
            }
            finally {
                this.closeSrcFs();
            }
        }

        private boolean isFile(Path p) throws IOException {
            FileStatus status = this.srcFs.getFileStatus(p);
            boolean isFile = !status.isDirectory();
            try {
                isFile = isFile && (Boolean)Methods.call(FileStatus.class, (Object)status, (String)"isSymlink", null, null) == false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return isFile;
        }
    }
}

