/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import io.opentelemetry.api.trace.Span;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.management.MemoryType;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.RingBufferTruck;
import org.apache.hadoop.hbase.regionserver.wal.SequenceIdAccounting;
import org.apache.hadoop.hbase.regionserver.wal.SyncFuture;
import org.apache.hadoop.hbase.regionserver.wal.SyncFutureCache;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALClosedException;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALSyncTimeoutIOException;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALPrettyPrinter;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractFSWAL<W extends WALProvider.WriterBase>
implements WAL {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFSWAL.class);
    private static final Comparator<SyncFuture> SEQ_COMPARATOR = Comparator.comparingLong(SyncFuture::getTxid).thenComparingInt(System::identityHashCode);
    private static final String SURVIVED_TOO_LONG_SEC_KEY = "hbase.regionserver.wal.too.old.sec";
    private static final int SURVIVED_TOO_LONG_SEC_DEFAULT = 900;
    private static final long SURVIVED_TOO_LONG_LOG_INTERVAL_NS = TimeUnit.MINUTES.toNanos(5L);
    protected static final String SLOW_SYNC_TIME_MS = "hbase.regionserver.wal.slowsync.ms";
    protected static final int DEFAULT_SLOW_SYNC_TIME_MS = 100;
    protected static final String ROLL_ON_SYNC_TIME_MS = "hbase.regionserver.wal.roll.on.sync.ms";
    protected static final int DEFAULT_ROLL_ON_SYNC_TIME_MS = 10000;
    protected static final String SLOW_SYNC_ROLL_THRESHOLD = "hbase.regionserver.wal.slowsync.roll.threshold";
    protected static final int DEFAULT_SLOW_SYNC_ROLL_THRESHOLD = 100;
    protected static final String SLOW_SYNC_ROLL_INTERVAL_MS = "hbase.regionserver.wal.slowsync.roll.interval.ms";
    protected static final int DEFAULT_SLOW_SYNC_ROLL_INTERVAL_MS = 60000;
    public static final String WAL_SYNC_TIMEOUT_MS = "hbase.regionserver.wal.sync.timeout";
    protected static final int DEFAULT_WAL_SYNC_TIMEOUT_MS = 300000;
    public static final String WAL_ROLL_MULTIPLIER = "hbase.regionserver.logroll.multiplier";
    public static final String MAX_LOGS = "hbase.regionserver.maxlogs";
    public static final String RING_BUFFER_SLOT_COUNT = "hbase.regionserver.wal.disruptor.event.count";
    public static final String WAL_SHUTDOWN_WAIT_TIMEOUT_MS = "hbase.wal.shutdown.wait.timeout.ms";
    public static final int DEFAULT_WAL_SHUTDOWN_WAIT_TIMEOUT_MS = 15000;
    public static final String WAL_BATCH_SIZE = "hbase.wal.batch.size";
    public static final long DEFAULT_WAL_BATCH_SIZE = 65536L;
    protected final FileSystem fs;
    protected final Path walDir;
    private final FileSystem remoteFs;
    private final Path remoteWALDir;
    protected final Path walArchiveDir;
    protected final PathFilter ourFiles;
    protected final String walFilePrefix;
    protected final String walFileSuffix;
    protected final String prefixPathStr;
    protected final WALCoprocessorHost coprocessorHost;
    protected final Configuration conf;
    protected final Abortable abortable;
    protected final List<WALActionsListener> listeners = new CopyOnWriteArrayList<WALActionsListener>();
    protected final Map<String, W> inflightWALClosures = new ConcurrentHashMap<String, W>();
    protected final SequenceIdAccounting sequenceIdAccounting = new SequenceIdAccounting();
    protected final long slowSyncNs;
    protected final long rollOnSyncNs;
    protected final int slowSyncRollThreshold;
    protected final int slowSyncCheckInterval;
    protected final AtomicInteger slowSyncCount = new AtomicInteger();
    private final long walSyncTimeoutNs;
    private final long walTooOldNs;
    protected final long logrollsize;
    protected final long blocksize;
    protected final int maxLogs;
    protected final boolean useHsync;
    protected final ReentrantLock rollWriterLock = new ReentrantLock(true);
    protected final AtomicLong filenum = new AtomicLong(-1L);
    protected final AtomicInteger numEntries = new AtomicInteger(0);
    protected volatile long highestUnsyncedTxid = -1L;
    protected final AtomicLong highestSyncedTxid = new AtomicLong(0L);
    protected final AtomicLong totalLogSize = new AtomicLong(0L);
    volatile W writer;
    private volatile long lastTimeCheckLowReplication = EnvironmentEdgeManager.currentTime();
    private volatile long lastTimeCheckSlowSync = EnvironmentEdgeManager.currentTime();
    protected volatile boolean closed = false;
    protected final AtomicBoolean shutdown = new AtomicBoolean(false);
    protected final long walShutdownTimeout;
    private long nextLogTooOldNs = System.nanoTime();
    final Comparator<Path> LOG_NAME_COMPARATOR = (o1, o2) -> Long.compare(this.getFileNumFromFileName((Path)o1), this.getFileNumFromFileName((Path)o2));
    protected final ConcurrentNavigableMap<Path, WALProps> walFile2Props = new ConcurrentSkipListMap<Path, WALProps>(this.LOG_NAME_COMPARATOR);
    protected final SyncFutureCache syncFutureCache;
    protected final String implClassName;
    protected final AtomicBoolean rollRequested = new AtomicBoolean(false);
    protected final ExecutorService closeExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Close-WAL-Writer-%d").build());
    private final ExecutorService logArchiveExecutor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("WAL-Archive-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    private final int archiveRetries;
    protected ExecutorService consumeExecutor;
    private final Lock consumeLock = new ReentrantLock();
    protected final Runnable consumer = this::consume;
    protected Supplier<Boolean> hasConsumerTask;
    private static final int MAX_EPOCH = 0x3FFFFFFF;
    private volatile int epochAndState;
    private boolean readyForRolling;
    private final Condition readyForRollingCond = this.consumeLock.newCondition();
    private final RingBuffer<RingBufferTruck> waitingConsumePayloads;
    private final Sequence waitingConsumePayloadsGatingSequence;
    private final AtomicBoolean consumerScheduled = new AtomicBoolean(false);
    private final long batchSize;
    protected final Deque<FSWALEntry> toWriteAppends = new ArrayDeque<FSWALEntry>();
    protected final Deque<FSWALEntry> unackedAppends = new ArrayDeque<FSWALEntry>();
    protected final SortedSet<SyncFuture> syncFutures = new TreeSet<SyncFuture>(SEQ_COMPARATOR);
    protected long highestProcessedAppendTxid;
    private long fileLengthAtLastSync;
    private long highestProcessedAppendTxidAtLastSync;
    private int waitOnShutdownInSeconds;
    private String waitOnShutdownInSecondsConfigKey;
    protected boolean shouldShutDownConsumeExecutorWhenClose = true;
    private volatile boolean skipRemoteWAL = false;
    private volatile boolean markerEditOnly = false;

    public long getFilenum() {
        return this.filenum.get();
    }

    protected long getFileNumFromFileName(Path fileName) {
        Preconditions.checkNotNull((Object)fileName, (Object)"file name can't be null");
        if (!this.ourFiles.accept(fileName)) {
            throw new IllegalArgumentException("The log file " + fileName + " doesn't belong to this WAL. (" + this.toString() + ")");
        }
        String fileNameString = fileName.toString();
        String chompedPath = fileNameString.substring(this.prefixPathStr.length(), fileNameString.length() - this.walFileSuffix.length());
        return Long.parseLong(chompedPath);
    }

    private int calculateMaxLogFiles(Configuration conf, long logRollSize) {
        Pair<Long, MemoryType> globalMemstoreSize = MemorySizeUtil.getGlobalMemStoreSize(conf);
        return (int)((Long)globalMemstoreSize.getFirst() * 2L / logRollSize);
    }

    protected final int getPreallocatedEventCount() {
        int preallocatedEventCount = this.conf.getInt(RING_BUFFER_SLOT_COUNT, 16384);
        Preconditions.checkArgument((preallocatedEventCount >= 0 ? 1 : 0) != 0, (Object)"hbase.regionserver.wal.disruptor.event.count must > 0");
        int floor = Integer.highestOneBit(preallocatedEventCount);
        if (floor == preallocatedEventCount) {
            return floor;
        }
        if (floor >= 0x20000000) {
            return 0x40000000;
        }
        return floor << 1;
    }

    protected final void setWaitOnShutdownInSeconds(int waitOnShutdownInSeconds, String waitOnShutdownInSecondsConfigKey) {
        this.waitOnShutdownInSeconds = waitOnShutdownInSeconds;
        this.waitOnShutdownInSecondsConfigKey = waitOnShutdownInSecondsConfigKey;
    }

    protected final void createSingleThreadPoolConsumeExecutor(String walType, Path rootDir, String prefix) {
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(walType + "-%d-" + rootDir.toString() + "-prefix:" + (prefix == null ? "default" : prefix).replace("%", "%%")).setDaemon(true).build());
        this.hasConsumerTask = () -> threadPool.getQueue().peek() == this.consumer;
        this.consumeExecutor = threadPool;
        this.shouldShutDownConsumeExecutorWhenClose = true;
    }

    protected AbstractFSWAL(FileSystem fs, Abortable abortable, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, FileSystem remoteFs, Path remoteWALDir) throws FailedLogCloseException, IOException {
        FileStatus[] walFiles;
        this.fs = fs;
        this.walDir = new Path(rootDir, logDir);
        this.walArchiveDir = new Path(rootDir, archiveDir);
        this.conf = conf;
        this.abortable = abortable;
        this.remoteFs = remoteFs;
        this.remoteWALDir = remoteWALDir;
        if (!fs.exists(this.walDir) && !fs.mkdirs(this.walDir)) {
            throw new IOException("Unable to mkdir " + this.walDir);
        }
        if (!fs.exists(this.walArchiveDir) && !fs.mkdirs(this.walArchiveDir)) {
            throw new IOException("Unable to mkdir " + this.walArchiveDir);
        }
        String string = this.walFilePrefix = prefix == null || prefix.isEmpty() ? "wal" : URLEncoder.encode(prefix, StandardCharsets.UTF_8.name());
        if (suffix != null && !suffix.isEmpty() && !suffix.startsWith(".")) {
            throw new IllegalArgumentException("WAL suffix must start with '.' but instead was '" + suffix + "'");
        }
        String storagePolicy = conf.get("hbase.wal.storage.policy", "NONE");
        CommonFSUtils.setStoragePolicy((FileSystem)fs, (Path)this.walDir, (String)storagePolicy);
        this.walFileSuffix = suffix == null ? "" : URLEncoder.encode(suffix, "UTF8");
        this.prefixPathStr = new Path(this.walDir, this.walFilePrefix + ".").toString();
        this.ourFiles = new PathFilter(){

            public boolean accept(Path fileName) {
                String fileNameString = fileName.toString();
                if (!fileNameString.startsWith(AbstractFSWAL.this.prefixPathStr)) {
                    return false;
                }
                if (AbstractFSWAL.this.walFileSuffix.isEmpty()) {
                    return org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)fileNameString.substring(AbstractFSWAL.this.prefixPathStr.length()));
                }
                return fileNameString.endsWith(AbstractFSWAL.this.walFileSuffix);
            }
        };
        if (failIfWALExists && null != (walFiles = CommonFSUtils.listStatus((FileSystem)fs, (Path)this.walDir, (PathFilter)this.ourFiles)) && 0 != walFiles.length) {
            throw new IOException("Target WAL already exists within directory " + this.walDir);
        }
        if (listeners != null) {
            for (WALActionsListener i : listeners) {
                this.registerWALActionsListener(i);
            }
        }
        this.coprocessorHost = new WALCoprocessorHost(this, conf);
        this.blocksize = WALUtil.getWALBlockSize(this.conf, this.fs, this.walDir);
        float multiplier = conf.getFloat(WAL_ROLL_MULTIPLIER, 0.5f);
        this.logrollsize = (long)((float)this.blocksize * multiplier);
        this.maxLogs = conf.getInt(MAX_LOGS, Math.max(32, this.calculateMaxLogFiles(conf, this.logrollsize)));
        LOG.info("WAL configuration: blocksize=" + StringUtils.byteDesc((long)this.blocksize) + ", rollsize=" + StringUtils.byteDesc((long)this.logrollsize) + ", prefix=" + this.walFilePrefix + ", suffix=" + this.walFileSuffix + ", logDir=" + this.walDir + ", archiveDir=" + this.walArchiveDir + ", maxLogs=" + this.maxLogs);
        this.slowSyncNs = TimeUnit.MILLISECONDS.toNanos(conf.getInt(SLOW_SYNC_TIME_MS, 100));
        this.rollOnSyncNs = TimeUnit.MILLISECONDS.toNanos(conf.getInt(ROLL_ON_SYNC_TIME_MS, 10000));
        this.slowSyncRollThreshold = conf.getInt(SLOW_SYNC_ROLL_THRESHOLD, 100);
        this.slowSyncCheckInterval = conf.getInt(SLOW_SYNC_ROLL_INTERVAL_MS, 60000);
        this.walSyncTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong(WAL_SYNC_TIMEOUT_MS, 300000L));
        this.syncFutureCache = new SyncFutureCache(conf);
        this.implClassName = this.getClass().getSimpleName();
        this.walTooOldNs = TimeUnit.SECONDS.toNanos(conf.getInt(SURVIVED_TOO_LONG_SEC_KEY, 900));
        this.useHsync = conf.getBoolean("hbase.wal.hsync", false);
        this.archiveRetries = this.conf.getInt("hbase.regionserver.walroll.archive.retries", 0);
        this.walShutdownTimeout = conf.getLong(WAL_SHUTDOWN_WAIT_TIMEOUT_MS, 15000L);
        int preallocatedEventCount = conf.getInt(RING_BUFFER_SLOT_COUNT, 16384);
        this.waitingConsumePayloads = RingBuffer.createMultiProducer(RingBufferTruck::new, (int)preallocatedEventCount);
        this.waitingConsumePayloadsGatingSequence = new Sequence(-1L);
        this.waitingConsumePayloads.addGatingSequences(new Sequence[]{this.waitingConsumePayloadsGatingSequence});
        this.waitingConsumePayloads.publish(this.waitingConsumePayloads.next());
        this.waitingConsumePayloadsGatingSequence.set(this.waitingConsumePayloads.getCursor());
        this.batchSize = conf.getLong(WAL_BATCH_SIZE, 65536L);
    }

    @Override
    public void init() throws IOException {
        this.rollWriter();
    }

    @Override
    public void registerWALActionsListener(WALActionsListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean unregisterWALActionsListener(WALActionsListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public WALCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    @Override
    public Long startCacheFlush(byte[] encodedRegionName, Set<byte[]> families) {
        return this.sequenceIdAccounting.startCacheFlush(encodedRegionName, families);
    }

    @Override
    public Long startCacheFlush(byte[] encodedRegionName, Map<byte[], Long> familyToSeq) {
        return this.sequenceIdAccounting.startCacheFlush(encodedRegionName, familyToSeq);
    }

    @Override
    public void completeCacheFlush(byte[] encodedRegionName, long maxFlushedSeqId) {
        this.sequenceIdAccounting.completeCacheFlush(encodedRegionName, maxFlushedSeqId);
    }

    @Override
    public void abortCacheFlush(byte[] encodedRegionName) {
        this.sequenceIdAccounting.abortCacheFlush(encodedRegionName);
    }

    @Override
    public long getEarliestMemStoreSeqNum(byte[] encodedRegionName) {
        return this.sequenceIdAccounting.getLowestSequenceId(encodedRegionName);
    }

    @Override
    public long getEarliestMemStoreSeqNum(byte[] encodedRegionName, byte[] familyName) {
        return this.sequenceIdAccounting.getLowestSequenceId(encodedRegionName, familyName);
    }

    @Override
    public Map<byte[], List<byte[]>> rollWriter() throws FailedLogCloseException, IOException {
        return this.rollWriter(false);
    }

    @Override
    public final void sync() throws IOException {
        this.sync(this.useHsync);
    }

    @Override
    public final void sync(long txid) throws IOException {
        this.sync(txid, this.useHsync);
    }

    @Override
    public final void sync(boolean forceSync) throws IOException {
        TraceUtil.trace(() -> this.doSync(forceSync), () -> this.createSpan("WAL.sync"));
    }

    @Override
    public final void sync(long txid, boolean forceSync) throws IOException {
        TraceUtil.trace(() -> this.doSync(txid, forceSync), () -> this.createSpan("WAL.sync"));
    }

    protected Path computeFilename(long filenum) {
        if (filenum < 0L) {
            throw new RuntimeException("WAL file number can't be < 0");
        }
        String child = this.walFilePrefix + "." + filenum + this.walFileSuffix;
        return new Path(this.walDir, child);
    }

    public Path getCurrentFileName() {
        return this.computeFilename(this.filenum.get());
    }

    private Path getNewPath() throws IOException {
        this.filenum.set(Math.max(this.getFilenum() + 1L, EnvironmentEdgeManager.currentTime()));
        Path newPath = this.getCurrentFileName();
        return newPath;
    }

    public Path getOldPath() {
        long currentFilenum = this.filenum.get();
        Path oldPath = null;
        if (currentFilenum > 0L) {
            oldPath = this.computeFilename(currentFilenum);
        }
        return oldPath;
    }

    private void tellListenersAboutPreLogRoll(Path oldPath, Path newPath) throws IOException {
        this.coprocessorHost.preWALRoll(oldPath, newPath);
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.preLogRoll(oldPath, newPath);
            }
        }
    }

    private void tellListenersAboutPostLogRoll(Path oldPath, Path newPath) throws IOException {
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.postLogRoll(oldPath, newPath);
            }
        }
        this.coprocessorHost.postWALRoll(oldPath, newPath);
    }

    public int getNumRolledLogFiles() {
        return this.walFile2Props.size();
    }

    public int getNumLogFiles() {
        return this.getNumRolledLogFiles() + 1;
    }

    Map<byte[], List<byte[]>> findRegionsToForceFlush() throws IOException {
        Map<byte[], List<byte[]>> regions = null;
        int logCount = this.getNumRolledLogFiles();
        if (logCount > this.maxLogs && logCount > 0) {
            Map.Entry firstWALEntry = this.walFile2Props.firstEntry();
            regions = this.sequenceIdAccounting.findLower(((WALProps)firstWALEntry.getValue()).encodedName2HighestSequenceId);
        }
        if (regions != null) {
            ArrayList<String> listForPrint = new ArrayList<String>();
            for (Map.Entry r : regions.entrySet()) {
                StringBuilder families = new StringBuilder();
                for (int i = 0; i < ((List)r.getValue()).size(); ++i) {
                    if (i > 0) {
                        families.append(",");
                    }
                    families.append(Bytes.toString((byte[])((byte[])((List)r.getValue()).get(i))));
                }
                listForPrint.add(Bytes.toStringBinary((byte[])((byte[])r.getKey())) + "[" + families.toString() + "]");
            }
            LOG.info("Too many WALs; count=" + logCount + ", max=" + this.maxLogs + "; forcing (partial) flush of " + regions.size() + " region(s): " + StringUtils.join((CharSequence)",", listForPrint));
        }
        return regions;
    }

    private void markClosedAndClean(Path path) {
        WALProps props = (WALProps)this.walFile2Props.get(path);
        if (props != null) {
            props.closed = true;
            this.cleanOldLogs();
        }
    }

    private synchronized void cleanOldLogs() {
        ArrayList<Pair> logsToArchive = null;
        long now = System.nanoTime();
        boolean mayLogTooOld = this.nextLogTooOldNs <= now;
        ArrayList<byte[]> regionsBlockingWal = null;
        for (Map.Entry e : this.walFile2Props.entrySet()) {
            Map sequenceNums;
            if (!((WALProps)e.getValue()).closed) {
                LOG.debug("{} is not closed yet, will try archiving it next time", e.getKey());
                continue;
            }
            Path path = (Path)e.getKey();
            ArrayList<byte[]> regionsBlockingThisWal = null;
            long ageNs = now - ((WALProps)e.getValue()).rollTimeNs;
            if (ageNs > this.walTooOldNs) {
                if (mayLogTooOld && regionsBlockingWal == null) {
                    regionsBlockingWal = new ArrayList<byte[]>();
                }
                regionsBlockingThisWal = regionsBlockingWal;
            }
            if (this.sequenceIdAccounting.areAllLower(sequenceNums = ((WALProps)e.getValue()).encodedName2HighestSequenceId, regionsBlockingThisWal)) {
                if (logsToArchive == null) {
                    logsToArchive = new ArrayList<Pair>();
                }
                logsToArchive.add(Pair.newPair((Object)path, (Object)((WALProps)e.getValue()).logSize));
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("WAL file ready for archiving " + path);
                continue;
            }
            if (regionsBlockingThisWal == null) continue;
            StringBuilder sb = new StringBuilder(path.toString()).append(" has not been archived for ").append(TimeUnit.NANOSECONDS.toSeconds(ageNs)).append(" seconds; blocked by: ");
            boolean isFirst = true;
            for (byte[] region : regionsBlockingThisWal) {
                if (!isFirst) {
                    sb.append("; ");
                }
                isFirst = false;
                sb.append(Bytes.toString((byte[])region));
            }
            LOG.warn(sb.toString());
            this.nextLogTooOldNs = now + SURVIVED_TOO_LONG_LOG_INTERVAL_NS;
            regionsBlockingThisWal.clear();
        }
        if (logsToArchive != null) {
            ArrayList<Pair> localLogsToArchive = logsToArchive;
            for (Pair pair : localLogsToArchive) {
                this.logArchiveExecutor.execute(() -> this.archive((Pair<Path, Long>)pair));
                this.walFile2Props.remove(pair.getFirst());
            }
        }
    }

    protected void archive(Pair<Path, Long> log) {
        this.totalLogSize.addAndGet(-((Long)log.getSecond()).longValue());
        int retry = 1;
        while (true) {
            try {
                this.archiveLogFile((Path)log.getFirst());
            }
            catch (Throwable e) {
                if (retry > this.archiveRetries) {
                    LOG.error("Failed log archiving for the log {},", log.getFirst(), (Object)e);
                    if (this.abortable != null) {
                        this.abortable.abort("Failed log archiving", e);
                        break;
                    }
                } else {
                    LOG.error("Log archiving failed for the log {} - attempt {}", new Object[]{log.getFirst(), retry, e});
                }
                ++retry;
                continue;
            }
            break;
        }
    }

    public static Path getWALArchivePath(Path archiveDir, Path p) {
        return new Path(archiveDir, p.getName());
    }

    protected void archiveLogFile(Path p) throws IOException {
        Path newPath = AbstractFSWAL.getWALArchivePath(this.walArchiveDir, p);
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.preLogArchive(p, newPath);
            }
        }
        LOG.info("Archiving " + p + " to " + newPath);
        if (!CommonFSUtils.renameAndSetModifyTime((FileSystem)this.fs, (Path)p, (Path)newPath)) {
            throw new IOException("Unable to rename " + p + " to " + newPath);
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.postLogArchive(p, newPath);
            }
        }
    }

    protected final void logRollAndSetupWalProps(Path oldPath, Path newPath, long oldFileLen) {
        String newPathString;
        int oldNumEntries = this.numEntries.getAndSet(0);
        String string = newPathString = newPath != null ? CommonFSUtils.getPath((Path)newPath) : null;
        if (oldPath != null) {
            this.walFile2Props.put(oldPath, new WALProps(this.sequenceIdAccounting.resetHighest(), oldFileLen));
            this.totalLogSize.addAndGet(oldFileLen);
            LOG.info("Rolled WAL {} with entries={}, filesize={}; new WAL {}", new Object[]{CommonFSUtils.getPath((Path)oldPath), oldNumEntries, StringUtils.byteDesc((long)oldFileLen), newPathString});
        } else {
            LOG.info("New WAL {}", (Object)newPathString);
        }
    }

    private Span createSpan(String name) {
        return TraceUtil.createSpan((String)name).setAttribute(HBaseSemanticAttributes.WAL_IMPL, (Object)this.implClassName);
    }

    Path replaceWriter(Path oldPath, Path newPath, W nextWriter) throws IOException {
        return (Path)TraceUtil.trace(() -> {
            this.doReplaceWriter(oldPath, newPath, nextWriter);
            return newPath;
        }, () -> this.createSpan("WAL.replaceWriter"));
    }

    protected final void blockOnSync(SyncFuture syncFuture) throws IOException {
        try {
            if (syncFuture != null) {
                if (this.closed) {
                    throw new IOException("WAL has been closed");
                }
                syncFuture.get(this.walSyncTimeoutNs);
            }
        }
        catch (TimeoutIOException tioe) {
            throw new WALSyncTimeoutIOException(tioe);
        }
        catch (InterruptedException ie) {
            LOG.warn("Interrupted", (Throwable)ie);
            throw this.convertInterruptedExceptionToIOException(ie);
        }
        catch (ExecutionException e) {
            throw AbstractFSWAL.ensureIOException(e.getCause());
        }
    }

    private static IOException ensureIOException(Throwable t) {
        return t instanceof IOException ? (IOException)t : new IOException(t);
    }

    private IOException convertInterruptedExceptionToIOException(InterruptedException ie) {
        Thread.currentThread().interrupt();
        InterruptedIOException ioe = new InterruptedIOException();
        ioe.initCause(ie);
        return ioe;
    }

    private W createCombinedWriter(W localWriter, Path localPath) throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        Path remoteWAL = new Path(this.remoteWALDir, localPath.getName());
        int retry = 0;
        while (true) {
            block6: {
                W remoteWriter;
                if (this.skipRemoteWAL) {
                    return localWriter;
                }
                try {
                    remoteWriter = this.createWriterInstance(this.remoteFs, remoteWAL);
                }
                catch (IOException e) {
                    LOG.warn("create remote writer {} failed, retry = {}", new Object[]{remoteWAL, retry, e});
                    try {
                        Thread.sleep(ConnectionUtils.getPauseTime((long)100L, (int)retry));
                        break block6;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        Closeables.close(localWriter, (boolean)true);
                        throw (IOException)new InterruptedIOException().initCause(ie);
                    }
                }
                return this.createCombinedWriter(localWriter, remoteWriter);
            }
            ++retry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<byte[], List<byte[]>> rollWriterInternal(boolean force) throws IOException {
        this.rollWriterLock.lock();
        try {
            if (this.closed) {
                throw new WALClosedException("WAL has been closed");
            }
            if (!force && this.writer != null && this.numEntries.get() <= 0) {
                Map<byte[], List<byte[]>> map = null;
                return map;
            }
            Map<byte[], List<byte[]>> regionsToFlush = null;
            try {
                Path oldPath = this.getOldPath();
                Path newPath = this.getNewPath();
                Object nextWriter = this.createWriterInstance(this.fs, newPath);
                if (this.remoteFs != null) {
                    nextWriter = this.createCombinedWriter(nextWriter, (W)newPath);
                }
                this.tellListenersAboutPreLogRoll(oldPath, newPath);
                newPath = this.replaceWriter(oldPath, newPath, nextWriter);
                this.tellListenersAboutPostLogRoll(oldPath, newPath);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Create new " + this.implClassName + " writer with pipeline: " + Arrays.toString(this.getPipeline()));
                }
                this.lastTimeCheckSlowSync = EnvironmentEdgeManager.currentTime();
                this.slowSyncCount.set(0);
                if (this.getNumRolledLogFiles() > 0) {
                    this.cleanOldLogs();
                    regionsToFlush = this.findRegionsToForceFlush();
                }
            }
            catch (CommonFSUtils.StreamLacksCapabilityException exception) {
                throw new IOException("Underlying FileSystem can't meet stream requirements. See RS log for details.", exception);
            }
            Map<byte[], List<byte[]>> map = regionsToFlush;
            return map;
        }
        finally {
            this.rollWriterLock.unlock();
        }
    }

    @Override
    public Map<byte[], List<byte[]>> rollWriter(boolean force) throws IOException {
        return (Map)TraceUtil.trace(() -> this.rollWriterInternal(force), () -> this.createSpan("WAL.rollWriter"));
    }

    public long getLogFileSize() {
        return this.totalLogSize.get();
    }

    public void requestLogRoll() {
        this.requestLogRoll(WALActionsListener.RollRequestReason.ERROR);
    }

    FileStatus[] getFiles() throws IOException {
        return CommonFSUtils.listStatus((FileSystem)this.fs, (Path)this.walDir, (PathFilter)this.ourFiles);
    }

    @Override
    public void shutdown() throws IOException {
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        this.closed = true;
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.logCloseRequested();
            }
        }
        ExecutorService shutdownExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("WAL-Shutdown-%d").build());
        Future<Void> future = shutdownExecutor.submit(new Callable<Void>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Void call() throws Exception {
                if (!AbstractFSWAL.this.rollWriterLock.tryLock(AbstractFSWAL.this.walShutdownTimeout, TimeUnit.SECONDS)) throw new IOException("Waiting for rollWriterLock timeout");
                try {
                    AbstractFSWAL.this.doShutdown();
                    if (AbstractFSWAL.this.syncFutureCache == null) return null;
                    AbstractFSWAL.this.syncFutureCache.clear();
                    return null;
                }
                finally {
                    AbstractFSWAL.this.rollWriterLock.unlock();
                }
            }
        });
        shutdownExecutor.shutdown();
        try {
            future.get(this.walShutdownTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for shutdown WAL");
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException("We have waited " + this.walShutdownTimeout + "ms, but the shutdown of WAL doesn't complete! Please check the status of underlying filesystem or increase the wait time by the config \"" + WAL_SHUTDOWN_WAIT_TIMEOUT_MS + "\"", (Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
        finally {
            this.logArchiveExecutor.shutdown();
        }
        try {
            if (!this.logArchiveExecutor.awaitTermination(this.walShutdownTimeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutIOException("We have waited " + this.walShutdownTimeout + "ms, but the shutdown of WAL doesn't complete! Please check the status of underlying filesystem or increase the wait time by the config \"" + WAL_SHUTDOWN_WAIT_TIMEOUT_MS + "\"");
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for shutdown WAL");
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
        FileStatus[] files = this.getFiles();
        if (null != files && 0 != files.length) {
            for (FileStatus file : files) {
                Path p = AbstractFSWAL.getWALArchivePath(this.walArchiveDir, file.getPath());
                if (!this.listeners.isEmpty()) {
                    for (WALActionsListener i : this.listeners) {
                        i.preLogArchive(file.getPath(), p);
                    }
                }
                if (!CommonFSUtils.renameAndSetModifyTime((FileSystem)this.fs, (Path)file.getPath(), (Path)p)) {
                    throw new IOException("Unable to rename " + file.getPath() + " to " + p);
                }
                if (this.listeners.isEmpty()) continue;
                for (WALActionsListener i : this.listeners) {
                    i.postLogArchive(file.getPath(), p);
                }
            }
            LOG.debug("Moved " + files.length + " WAL file(s) to " + CommonFSUtils.getPath((Path)this.walArchiveDir));
        }
        LOG.info("Closed WAL: " + this.toString());
    }

    public int getInflightWALCloseCount() {
        return this.inflightWALClosures.size();
    }

    @Override
    public void updateStore(byte[] encodedRegionName, byte[] familyName, Long sequenceid, boolean onlyIfGreater) {
        this.sequenceIdAccounting.updateStore(encodedRegionName, familyName, sequenceid, onlyIfGreater);
    }

    protected final SyncFuture getSyncFuture(long sequence, boolean forceSync) {
        return this.syncFutureCache.getIfPresentOrNew().reset(sequence, forceSync);
    }

    protected boolean isLogRollRequested() {
        return this.rollRequested.get();
    }

    protected final void requestLogRoll(WALActionsListener.RollRequestReason reason) {
        if (!this.listeners.isEmpty() && this.rollRequested.compareAndSet(false, true)) {
            for (WALActionsListener i : this.listeners) {
                i.logRollRequested(reason);
            }
        }
    }

    long getUnflushedEntriesCount() {
        long highestUnsynced;
        long highestSynced = this.highestSyncedTxid.get();
        return highestSynced >= (highestUnsynced = this.highestUnsyncedTxid) ? 0L : highestUnsynced - highestSynced;
    }

    boolean isUnflushedEntries() {
        return this.getUnflushedEntriesCount() > 0L;
    }

    protected void atHeadOfRingBufferEventHandlerAppend() {
    }

    protected final boolean appendEntry(W writer, FSWALEntry entry) throws IOException {
        this.atHeadOfRingBufferEventHandlerAppend();
        long start = EnvironmentEdgeManager.currentTime();
        byte[] encodedRegionName = entry.getKey().getEncodedRegionName();
        long regionSequenceId = entry.getKey().getSequenceId();
        if (entry.getEdit().isEmpty()) {
            return false;
        }
        this.coprocessorHost.preWALWrite(entry.getRegionInfo(), entry.getKey(), entry.getEdit());
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.visitLogEntryBeforeWrite(entry.getRegionInfo(), entry.getKey(), entry.getEdit());
            }
        }
        this.doAppend(writer, entry);
        assert (this.highestUnsyncedTxid < entry.getTxid());
        this.highestUnsyncedTxid = entry.getTxid();
        if (entry.isCloseRegion()) {
            this.sequenceIdAccounting.onRegionClose(encodedRegionName);
        } else {
            this.sequenceIdAccounting.update(encodedRegionName, entry.getFamilyNames(), regionSequenceId, entry.isInMemStore());
        }
        this.coprocessorHost.postWALWrite(entry.getRegionInfo(), entry.getKey(), entry.getEdit());
        this.postAppend(entry, EnvironmentEdgeManager.currentTime() - start);
        this.numEntries.incrementAndGet();
        return true;
    }

    private long postAppend(WAL.Entry e, long elapsedTime) throws IOException {
        long len = 0L;
        if (!this.listeners.isEmpty()) {
            for (Cell cell : e.getEdit().getCells()) {
                len += (long)PrivateCellUtil.estimatedSerializedSizeOf((Cell)cell);
            }
            for (WALActionsListener listener : this.listeners) {
                listener.postAppend(len, elapsedTime, e.getKey(), e.getEdit());
            }
        }
        return len;
    }

    protected final void postSync(long timeInNanos, int handlerSyncs) {
        if (timeInNanos > this.slowSyncNs) {
            String msg = "Slow sync cost: " + TimeUnit.NANOSECONDS.toMillis(timeInNanos) + " ms, current pipeline: " + Arrays.toString(this.getPipeline());
            LOG.info(msg);
            if (timeInNanos > this.rollOnSyncNs) {
                LOG.warn("Requesting log roll because we exceeded slow sync threshold; time=" + TimeUnit.NANOSECONDS.toMillis(timeInNanos) + " ms, threshold=" + TimeUnit.NANOSECONDS.toMillis(this.rollOnSyncNs) + " ms, current pipeline: " + Arrays.toString(this.getPipeline()));
                this.requestLogRoll(WALActionsListener.RollRequestReason.SLOW_SYNC);
            }
            this.slowSyncCount.incrementAndGet();
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener listener : this.listeners) {
                listener.postSync(timeInNanos, handlerSyncs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long stampSequenceIdAndPublishToRingBuffer(RegionInfo hri, WALKeyImpl key, WALEdit edits, boolean inMemstore, RingBuffer<RingBufferTruck> ringBuffer) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot append; log is closed, regionName = " + hri.getRegionNameAsString());
        }
        MutableLong txidHolder = new MutableLong();
        MultiVersionConcurrencyControl.WriteEntry we = key.getMvcc().begin(() -> txidHolder.setValue(ringBuffer.next()));
        long txid = txidHolder.longValue();
        ServerCall rpcCall = RpcServer.getCurrentServerCallWithCellScanner().orElse(null);
        try {
            FSWALEntry entry = new FSWALEntry(txid, key, edits, hri, inMemstore, rpcCall);
            entry.stampRegionSequenceId(we);
            ((RingBufferTruck)ringBuffer.get(txid)).load(entry);
        }
        finally {
            ringBuffer.publish(txid);
        }
        return txid;
    }

    @Override
    public String toString() {
        return this.implClassName + " " + this.walFilePrefix + ":" + this.walFileSuffix + "(num " + this.filenum + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptionalLong getLogFileSizeIfBeingWritten(Path path) {
        this.rollWriterLock.lock();
        try {
            Path currentPath = this.getOldPath();
            if (path.equals((Object)currentPath)) {
                W writer = this.writer;
                OptionalLong optionalLong = writer != null ? OptionalLong.of(writer.getSyncedLength()) : OptionalLong.empty();
                return optionalLong;
            }
            WALProvider.WriterBase temp = (WALProvider.WriterBase)this.inflightWALClosures.get(path.getName());
            if (temp != null) {
                OptionalLong optionalLong = OptionalLong.of(temp.getSyncedLength());
                return optionalLong;
            }
            OptionalLong optionalLong = OptionalLong.empty();
            return optionalLong;
        }
        finally {
            this.rollWriterLock.unlock();
        }
    }

    @Override
    public long appendData(RegionInfo info, WALKeyImpl key, WALEdit edits) throws IOException {
        return (Long)TraceUtil.trace(() -> this.append(info, key, edits, true), () -> this.createSpan("WAL.appendData"));
    }

    @Override
    public long appendMarker(RegionInfo info, WALKeyImpl key, WALEdit edits) throws IOException {
        return (Long)TraceUtil.trace(() -> this.append(info, key, edits, false), () -> this.createSpan("WAL.appendMarker"));
    }

    protected void markFutureDoneAndOffer(SyncFuture future, long txid, Throwable t) {
        future.done(txid, t);
        this.syncFutureCache.offer(future);
    }

    private static boolean waitingRoll(int epochAndState) {
        return (epochAndState & 1) != 0;
    }

    private static boolean writerBroken(int epochAndState) {
        return (epochAndState >>> 1 & 1) != 0;
    }

    private static int epoch(int epochAndState) {
        return epochAndState >>> 2;
    }

    private boolean trySetReadyForRolling() {
        if (!AbstractFSWAL.waitingRoll(this.epochAndState) || !this.unackedAppends.isEmpty()) {
            return false;
        }
        this.consumeLock.lock();
        try {
            if (AbstractFSWAL.waitingRoll(this.epochAndState)) {
                this.readyForRolling = true;
                this.readyForRollingCond.signalAll();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.consumeLock.unlock();
        }
    }

    private void syncFailed(long epochWhenSync, Throwable error) {
        LOG.warn("sync failed", error);
        this.onException(epochWhenSync, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onException(long epochWhenSync, Throwable error) {
        boolean shouldRequestLogRoll = true;
        this.consumeLock.lock();
        try {
            int currentEpochAndState = this.epochAndState;
            if ((long)AbstractFSWAL.epoch(currentEpochAndState) != epochWhenSync || AbstractFSWAL.writerBroken(currentEpochAndState)) {
                return;
            }
            this.epochAndState = currentEpochAndState | 2;
            if (AbstractFSWAL.waitingRoll(currentEpochAndState)) {
                this.readyForRolling = true;
                this.readyForRollingCond.signalAll();
                shouldRequestLogRoll = false;
            }
        }
        finally {
            this.consumeLock.unlock();
        }
        Iterator<FSWALEntry> iter = this.unackedAppends.descendingIterator();
        while (iter.hasNext()) {
            this.toWriteAppends.addFirst(iter.next());
        }
        this.highestUnsyncedTxid = this.highestSyncedTxid.get();
        if (shouldRequestLogRoll) {
            this.requestLogRoll(WALActionsListener.RollRequestReason.ERROR);
        }
    }

    private void syncCompleted(long epochWhenSync, W writer, long processedTxid, long startTimeNs) {
        FSWALEntry entry;
        int epochAndState = this.epochAndState;
        if ((long)AbstractFSWAL.epoch(epochAndState) != epochWhenSync || AbstractFSWAL.writerBroken(epochAndState)) {
            LOG.warn("Got a sync complete call after the writer is broken, skip");
            return;
        }
        if (processedTxid < this.highestSyncedTxid.get()) {
            return;
        }
        this.highestSyncedTxid.set(processedTxid);
        Iterator<FSWALEntry> iter = this.unackedAppends.iterator();
        while (iter.hasNext() && (entry = iter.next()).getTxid() <= processedTxid) {
            entry.release();
            iter.remove();
        }
        this.postSync(System.nanoTime() - startTimeNs, this.finishSync());
        this.checkSlowSyncCount();
        if (this.trySetReadyForRolling()) {
            return;
        }
        if (!this.isLogRollRequested() && writer.getLength() > this.logrollsize) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Requesting log roll because of file size threshold; length=" + writer.getLength() + ", logrollsize=" + this.logrollsize);
            }
            this.requestLogRoll(WALActionsListener.RollRequestReason.SIZE);
        }
    }

    private boolean isHsync(long beginTxid, long endTxid) {
        SortedSet<SyncFuture> futures = this.syncFutures.subSet(new SyncFuture().reset(beginTxid, false), new SyncFuture().reset(endTxid + 1L, false));
        if (futures.isEmpty()) {
            return this.useHsync;
        }
        for (SyncFuture future : futures) {
            if (!future.isForceSync()) continue;
            return true;
        }
        return false;
    }

    private void sync(W writer) {
        this.fileLengthAtLastSync = writer.getLength();
        long currentHighestProcessedAppendTxid = this.highestProcessedAppendTxid;
        boolean shouldUseHsync = this.isHsync(this.highestProcessedAppendTxidAtLastSync, currentHighestProcessedAppendTxid);
        this.highestProcessedAppendTxidAtLastSync = currentHighestProcessedAppendTxid;
        long startTimeNs = System.nanoTime();
        long epoch = (long)this.epochAndState >>> 2;
        FutureUtils.addListener(this.doWriterSync(writer, shouldUseHsync, currentHighestProcessedAppendTxid), (result, error) -> {
            if (error != null) {
                this.syncFailed(epoch, (Throwable)error);
            } else {
                long syncedTxid = this.getSyncedTxid(currentHighestProcessedAppendTxid, (long)result);
                this.syncCompleted(epoch, writer, syncedTxid, startTimeNs);
            }
        }, (Executor)this.consumeExecutor);
    }

    protected long getSyncedTxid(long processedTxid, long completableFutureResult) {
        return processedTxid;
    }

    protected abstract CompletableFuture<Long> doWriterSync(W var1, boolean var2, long var3);

    private int finishSyncLowerThanTxid(long txid) {
        SyncFuture sync;
        int finished = 0;
        Iterator iter = this.syncFutures.iterator();
        while (iter.hasNext() && (sync = (SyncFuture)iter.next()).getTxid() <= txid) {
            this.markFutureDoneAndOffer(sync, txid, null);
            iter.remove();
            ++finished;
        }
        return finished;
    }

    private int finishSync() {
        if (this.unackedAppends.isEmpty()) {
            if (this.toWriteAppends.isEmpty()) {
                long maxSyncTxid = this.highestSyncedTxid.get();
                for (SyncFuture sync : this.syncFutures) {
                    maxSyncTxid = Math.max(maxSyncTxid, sync.getTxid());
                    this.markFutureDoneAndOffer(sync, maxSyncTxid, null);
                }
                this.highestSyncedTxid.set(maxSyncTxid);
                int finished = this.syncFutures.size();
                this.syncFutures.clear();
                return finished;
            }
            long lowestUnprocessedAppendTxid = this.toWriteAppends.peek().getTxid();
            assert (lowestUnprocessedAppendTxid > this.highestProcessedAppendTxid);
            long doneTxid = lowestUnprocessedAppendTxid - 1L;
            this.highestSyncedTxid.set(doneTxid);
            return this.finishSyncLowerThanTxid(doneTxid);
        }
        long lowestUnackedAppendTxid = this.unackedAppends.peek().getTxid();
        long doneTxid = Math.max(lowestUnackedAppendTxid - 1L, this.highestSyncedTxid.get());
        this.highestSyncedTxid.set(doneTxid);
        return this.finishSyncLowerThanTxid(doneTxid);
    }

    private static long getLastTxid(Deque<FSWALEntry> queue) {
        return queue.peekLast().getTxid();
    }

    private void appendAndSync() throws IOException {
        W writer = this.writer;
        this.finishSync();
        long newHighestProcessedAppendTxid = -1L;
        boolean addedToUnackedAppends = false;
        Iterator<FSWALEntry> iter = this.toWriteAppends.iterator();
        while (iter.hasNext()) {
            FSWALEntry entry = iter.next();
            boolean appended = this.appendEntry(writer, entry);
            newHighestProcessedAppendTxid = entry.getTxid();
            iter.remove();
            if (!appended) continue;
            if (addedToUnackedAppends || this.unackedAppends.isEmpty() || AbstractFSWAL.getLastTxid(this.unackedAppends) < entry.getTxid()) {
                this.unackedAppends.addLast(entry);
                addedToUnackedAppends = true;
            }
            if (writer.getLength() - this.fileLengthAtLastSync < this.batchSize || !addedToUnackedAppends && entry.getTxid() < AbstractFSWAL.getLastTxid(this.unackedAppends)) continue;
            break;
        }
        if (newHighestProcessedAppendTxid > 0L) {
            this.highestProcessedAppendTxid = newHighestProcessedAppendTxid;
        } else {
            newHighestProcessedAppendTxid = this.highestProcessedAppendTxid;
        }
        if (writer.getLength() - this.fileLengthAtLastSync >= this.batchSize) {
            this.sync(writer);
            return;
        }
        if (writer.getLength() == this.fileLengthAtLastSync) {
            if (this.unackedAppends.isEmpty()) {
                this.highestSyncedTxid.set(this.highestProcessedAppendTxid);
                this.finishSync();
                this.trySetReadyForRolling();
            }
            return;
        }
    }

    private void consume() {
        this.consumeLock.lock();
        try {
            int currentEpochAndState = this.epochAndState;
            if (AbstractFSWAL.writerBroken(currentEpochAndState)) {
                return;
            }
            if (AbstractFSWAL.waitingRoll(currentEpochAndState)) {
                if (this.writer.getLength() > this.fileLengthAtLastSync) {
                    this.sync(this.writer);
                } else if (this.unackedAppends.isEmpty()) {
                    this.readyForRolling = true;
                    this.readyForRollingCond.signalAll();
                }
                return;
            }
        }
        finally {
            this.consumeLock.unlock();
        }
        long cursorBound = this.waitingConsumePayloads.getCursor();
        for (long nextCursor = this.waitingConsumePayloadsGatingSequence.get() + 1L; nextCursor <= cursorBound && this.waitingConsumePayloads.isPublished(nextCursor); ++nextCursor) {
            RingBufferTruck truck = (RingBufferTruck)this.waitingConsumePayloads.get(nextCursor);
            switch (truck.type()) {
                case APPEND: {
                    this.toWriteAppends.addLast(truck.unloadAppend());
                    break;
                }
                case SYNC: {
                    this.syncFutures.add(truck.unloadSync());
                    break;
                }
                default: {
                    LOG.warn("RingBufferTruck with unexpected type: " + (Object)((Object)truck.type()));
                }
            }
            this.waitingConsumePayloadsGatingSequence.set(nextCursor);
        }
        if (this.markerEditOnly) {
            this.drainNonMarkerEditsAndFailSyncs();
        }
        try {
            this.appendAndSync();
        }
        catch (IOException exception) {
            LOG.error("appendAndSync throws IOException.", (Throwable)exception);
            this.onAppendEntryFailed(exception);
            return;
        }
        if (this.hasConsumerTask.get().booleanValue()) {
            return;
        }
        if (this.toWriteAppends.isEmpty() && this.waitingConsumePayloadsGatingSequence.get() == this.waitingConsumePayloads.getCursor()) {
            this.consumerScheduled.set(false);
            if (this.waitingConsumePayloadsGatingSequence.get() == this.waitingConsumePayloads.getCursor()) {
                if (this.writer.getLength() > this.fileLengthAtLastSync && !this.syncFutures.isEmpty() && this.syncFutures.last().getTxid() > this.highestProcessedAppendTxidAtLastSync) {
                    this.sync(this.writer);
                }
                return;
            }
            if (!this.consumerScheduled.compareAndSet(false, true)) {
                return;
            }
        }
        this.consumeExecutor.execute(this.consumer);
    }

    private boolean shouldScheduleConsumer() {
        int currentEpochAndState = this.epochAndState;
        if (AbstractFSWAL.writerBroken(currentEpochAndState) || AbstractFSWAL.waitingRoll(currentEpochAndState)) {
            return false;
        }
        return this.consumerScheduled.compareAndSet(false, true);
    }

    protected long append(RegionInfo hri, WALKeyImpl key, WALEdit edits, boolean inMemstore) throws IOException {
        if (this.markerEditOnly && !edits.isMetaEdit()) {
            throw new IOException("WAL is closing, only marker edit is allowed");
        }
        long txid = this.stampSequenceIdAndPublishToRingBuffer(hri, key, edits, inMemstore, this.waitingConsumePayloads);
        if (this.shouldScheduleConsumer()) {
            this.consumeExecutor.execute(this.consumer);
        }
        return txid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSync(boolean forceSync) throws IOException {
        SyncFuture future;
        long txid = this.waitingConsumePayloads.next();
        try {
            future = this.getSyncFuture(txid, forceSync);
            RingBufferTruck truck = (RingBufferTruck)this.waitingConsumePayloads.get(txid);
            truck.load(future);
        }
        finally {
            this.waitingConsumePayloads.publish(txid);
        }
        if (this.shouldScheduleConsumer()) {
            this.consumeExecutor.execute(this.consumer);
        }
        this.blockOnSync(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSync(long txid, boolean forceSync) throws IOException {
        SyncFuture future;
        if (this.highestSyncedTxid.get() >= txid) {
            return;
        }
        long sequence = this.waitingConsumePayloads.next();
        try {
            future = this.getSyncFuture(txid, forceSync);
            RingBufferTruck truck = (RingBufferTruck)this.waitingConsumePayloads.get(sequence);
            truck.load(future);
        }
        finally {
            this.waitingConsumePayloads.publish(sequence);
        }
        if (this.shouldScheduleConsumer()) {
            this.consumeExecutor.execute(this.consumer);
        }
        this.blockOnSync(future);
    }

    private void drainNonMarkerEditsAndFailSyncs() {
        if (this.toWriteAppends.isEmpty()) {
            return;
        }
        boolean hasNonMarkerEdits = false;
        Iterator<FSWALEntry> iter = this.toWriteAppends.descendingIterator();
        while (iter.hasNext()) {
            FSWALEntry entry = iter.next();
            if (entry.getEdit().isMetaEdit()) continue;
            entry.release();
            hasNonMarkerEdits = true;
            break;
        }
        if (hasNonMarkerEdits) {
            SyncFuture future;
            while (true) {
                iter.remove();
                if (!iter.hasNext()) break;
                iter.next().release();
            }
            for (FSWALEntry entry : this.unackedAppends) {
                entry.release();
            }
            this.unackedAppends.clear();
            long txid = this.toWriteAppends.isEmpty() ? Long.MAX_VALUE : this.toWriteAppends.peek().getTxid();
            IOException error = new IOException("WAL is closing, only marker edit is allowed");
            Iterator syncIter = this.syncFutures.iterator();
            while (syncIter.hasNext() && (future = (SyncFuture)syncIter.next()).getTxid() < txid) {
                this.markFutureDoneAndOffer(future, future.getTxid(), error);
                syncIter.remove();
            }
        }
    }

    protected abstract W createWriterInstance(FileSystem var1, Path var2) throws IOException, CommonFSUtils.StreamLacksCapabilityException;

    protected abstract W createCombinedWriter(W var1, W var2);

    protected final void waitForSafePoint() {
        this.consumeLock.lock();
        try {
            int currentEpochAndState = this.epochAndState;
            if (AbstractFSWAL.writerBroken(currentEpochAndState) || this.writer == null) {
                return;
            }
            this.consumerScheduled.set(true);
            this.epochAndState = currentEpochAndState | 1;
            this.readyForRolling = false;
            this.consumeExecutor.execute(this.consumer);
            while (!this.readyForRolling) {
                this.readyForRollingCond.awaitUninterruptibly();
            }
        }
        finally {
            this.consumeLock.unlock();
        }
    }

    protected final void closeWriter(W writer, Path path) {
        this.inflightWALClosures.put(path.getName(), writer);
        this.closeExecutor.execute(() -> {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.warn("close old writer failed", (Throwable)e);
            }
            finally {
                this.markClosedAndClean(path);
                this.inflightWALClosures.remove(path.getName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReplaceWriter(Path oldPath, Path newPath, W nextWriter) throws IOException {
        Preconditions.checkNotNull(nextWriter);
        this.waitForSafePoint();
        this.doCleanUpResources();
        if (this.writer != null) {
            long oldFileLen = this.writer.getLength();
            this.logRollAndSetupWalProps(oldPath, newPath, oldFileLen);
            this.closeWriter(this.writer, oldPath);
        } else {
            this.logRollAndSetupWalProps(oldPath, newPath, 0L);
        }
        this.writer = nextWriter;
        this.onWriterReplaced(nextWriter);
        this.fileLengthAtLastSync = nextWriter.getLength();
        this.highestProcessedAppendTxidAtLastSync = 0L;
        this.consumeLock.lock();
        try {
            this.consumerScheduled.set(true);
            int currentEpoch = this.epochAndState >>> 2;
            int nextEpoch = currentEpoch == 0x3FFFFFFF ? 0 : currentEpoch + 1;
            this.epochAndState = nextEpoch << 2;
            this.rollRequested.set(false);
            this.consumeExecutor.execute(this.consumer);
        }
        finally {
            this.consumeLock.unlock();
        }
    }

    protected abstract void onWriterReplaced(W var1);

    protected void doShutdown() throws IOException {
        this.waitForSafePoint();
        this.doCleanUpResources();
        if (this.writer != null) {
            this.closeWriter(this.writer, this.getOldPath());
            this.writer = null;
        }
        this.closeExecutor.shutdown();
        try {
            if (!this.closeExecutor.awaitTermination(this.waitOnShutdownInSeconds, TimeUnit.SECONDS)) {
                LOG.error("We have waited " + this.waitOnShutdownInSeconds + " seconds but the close of async writer doesn't complete.Please check the status of underlying filesystem or increase the wait time by the config \"" + this.waitOnShutdownInSecondsConfigKey + "\"");
            }
        }
        catch (InterruptedException e) {
            LOG.error("The wait for close of async writer is interrupted");
            Thread.currentThread().interrupt();
        }
        IOException error = new IOException("WAL has been closed");
        long cursorBound = this.waitingConsumePayloads.getCursor();
        block5: for (long nextCursor = this.waitingConsumePayloadsGatingSequence.get() + 1L; nextCursor <= cursorBound && this.waitingConsumePayloads.isPublished(nextCursor); ++nextCursor) {
            RingBufferTruck truck = (RingBufferTruck)this.waitingConsumePayloads.get(nextCursor);
            switch (truck.type()) {
                case SYNC: {
                    this.syncFutures.add(truck.unloadSync());
                    continue block5;
                }
            }
        }
        this.syncFutures.forEach(f -> this.markFutureDoneAndOffer((SyncFuture)f, f.getTxid(), error));
        if (this.shouldShutDownConsumeExecutorWhenClose) {
            this.consumeExecutor.shutdown();
        }
    }

    protected void doCleanUpResources() {
    }

    protected abstract void doAppend(W var1, FSWALEntry var2) throws IOException;

    abstract DatanodeInfo[] getPipeline();

    abstract int getLogReplication();

    protected abstract boolean doCheckLogLowReplication();

    protected boolean isWriterBroken() {
        return AbstractFSWAL.writerBroken(this.epochAndState);
    }

    private void onAppendEntryFailed(IOException exception) {
        LOG.warn("append entry failed", (Throwable)exception);
        long currentEpoch = (long)this.epochAndState >>> 2;
        this.onException(currentEpoch, exception);
    }

    protected void checkSlowSyncCount() {
    }

    protected boolean doCheckSlowSync() {
        boolean result = false;
        long now = EnvironmentEdgeManager.currentTime();
        long elapsedTime = now - this.lastTimeCheckSlowSync;
        if (elapsedTime >= (long)this.slowSyncCheckInterval) {
            if (this.slowSyncCount.get() >= this.slowSyncRollThreshold) {
                if (elapsedTime >= (long)(2 * this.slowSyncCheckInterval)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("checkSlowSync triggered but we decided to ignore it; count=" + this.slowSyncCount.get() + ", threshold=" + this.slowSyncRollThreshold + ", elapsedTime=" + elapsedTime + " ms, slowSyncCheckInterval=" + this.slowSyncCheckInterval + " ms");
                    }
                } else {
                    LOG.warn("Requesting log roll because we exceeded slow sync threshold; count=" + this.slowSyncCount.get() + ", threshold=" + this.slowSyncRollThreshold + ", current pipeline: " + Arrays.toString(this.getPipeline()));
                    result = true;
                }
            }
            this.lastTimeCheckSlowSync = now;
            this.slowSyncCount.set(0);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLogLowReplication(long checkInterval) {
        long now = EnvironmentEdgeManager.currentTime();
        if (now - this.lastTimeCheckLowReplication < checkInterval) {
            return;
        }
        if (!this.rollWriterLock.tryLock()) {
            return;
        }
        try {
            this.lastTimeCheckLowReplication = now;
            if (this.doCheckLogLowReplication()) {
                this.requestLogRoll(WALActionsListener.RollRequestReason.LOW_REPLICATION);
            }
        }
        finally {
            this.rollWriterLock.unlock();
        }
    }

    @Override
    public void skipRemoteWAL(boolean markerEditOnly) {
        if (markerEditOnly) {
            this.markerEditOnly = true;
        }
        this.skipRemoteWAL = true;
    }

    private static void split(Configuration conf, Path p) throws IOException {
        FileSystem fs = CommonFSUtils.getWALFileSystem((Configuration)conf);
        if (!fs.exists(p)) {
            throw new FileNotFoundException(p.toString());
        }
        if (!fs.getFileStatus(p).isDirectory()) {
            throw new IOException(p + " is not a directory");
        }
        Path baseDir = CommonFSUtils.getWALRootDir((Configuration)conf);
        Path archiveDir = new Path(baseDir, "oldWALs");
        if (conf.getBoolean("hbase.separate.oldlogdir.by.regionserver", false)) {
            archiveDir = new Path(archiveDir, p.getName());
        }
        WALSplitter.split(baseDir, p, archiveDir, fs, conf, WALFactory.getInstance(conf));
    }

    W getWriter() {
        return this.writer;
    }

    private static void usage() {
        System.err.println("Usage: AbstractFSWAL <ARGS>");
        System.err.println("Arguments:");
        System.err.println(" --dump  Dump textual representation of passed one or more files");
        System.err.println("         For example: AbstractFSWAL --dump hdfs://example.com:9000/hbase/WALs/MACHINE/LOGFILE");
        System.err.println(" --split Split the passed directory of WAL logs");
        System.err.println("         For example: AbstractFSWAL --split hdfs://example.com:9000/hbase/WALs/DIR");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            AbstractFSWAL.usage();
            System.exit(-1);
        }
        if (args[0].compareTo("--dump") == 0) {
            WALPrettyPrinter.run(Arrays.copyOfRange(args, 1, args.length));
        } else if (args[0].compareTo("--perf") == 0) {
            LOG.error(HBaseMarkers.FATAL, "Please use the WALPerformanceEvaluation tool instead. i.e.:");
            LOG.error(HBaseMarkers.FATAL, "\thbase org.apache.hadoop.hbase.wal.WALPerformanceEvaluation --iterations " + args[1]);
            System.exit(-1);
        } else if (args[0].compareTo("--split") == 0) {
            Configuration conf = HBaseConfiguration.create();
            for (int i = 1; i < args.length; ++i) {
                try {
                    Path logPath = new Path(args[i]);
                    CommonFSUtils.setFsDefault((Configuration)conf, (Path)logPath);
                    AbstractFSWAL.split(conf, logPath);
                    continue;
                }
                catch (IOException t) {
                    t.printStackTrace(System.err);
                    System.exit(-1);
                }
            }
        } else {
            AbstractFSWAL.usage();
            System.exit(-1);
        }
    }

    private static final class WALProps {
        private final Map<byte[], Long> encodedName2HighestSequenceId;
        private final long logSize;
        private final long rollTimeNs;
        private volatile boolean closed = false;

        WALProps(Map<byte[], Long> encodedName2HighestSequenceId, long logSize) {
            this.encodedName2HighestSequenceId = encodedName2HighestSequenceId;
            this.logSize = logSize;
            this.rollTimeNs = System.nanoTime();
        }
    }
}

