/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.ByteBufferWriter;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutputHelper;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.regionserver.wal.AbstractProtobufLogWriter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AsyncProtobufLogWriter
extends AbstractProtobufLogWriter
implements AsyncFSWALProvider.AsyncWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncProtobufLogWriter.class);
    private final EventLoopGroup eventLoopGroup;
    private final Class<? extends Channel> channelClass;
    private volatile AsyncFSOutput output;
    private volatile long finalSyncedLength = -1L;
    private OutputStream asyncOutputWrapper;
    private long waitTimeout;

    public AsyncProtobufLogWriter(EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) {
        this.eventLoopGroup = eventLoopGroup;
        this.channelClass = channelClass;
        if (this.conf == null) {
            this.conf = HBaseConfiguration.create();
        }
        this.waitTimeout = this.conf.getLong("hbase.regionserver.logroll.wait.timeout.ms", 30000L);
    }

    @Override
    public void append(WAL.Entry entry) {
        int buffered = this.output.buffered();
        try {
            entry.getKey().getBuilder(this.compressor).setFollowingKvCount(entry.getEdit().size()).build().writeDelimitedTo(this.asyncOutputWrapper);
        }
        catch (IOException e) {
            throw new AssertionError("should not happen", e);
        }
        try {
            for (Cell cell : entry.getEdit().getCells()) {
                this.cellEncoder.write(cell);
            }
        }
        catch (IOException e) {
            throw new AssertionError("should not happen", e);
        }
        this.length.addAndGet(this.output.buffered() - buffered);
    }

    @Override
    public CompletableFuture<Long> sync(boolean forceSync) {
        return this.output.flush(forceSync);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.output == null) {
            return;
        }
        try {
            this.writeWALTrailer();
            this.output.close();
        }
        catch (Exception e) {
            LOG.warn("normal close failed, try recover", (Throwable)e);
            this.output.recoverAndClose(null);
        }
        this.finalSyncedLength = this.output.getSyncedLength();
        this.output = null;
    }

    public AsyncFSOutput getOutput() {
        return this.output;
    }

    @Override
    protected void initOutput(FileSystem fs, Path path, boolean overwritable, int bufferSize, short replication, long blockSize, StreamSlowMonitor monitor) throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        this.output = AsyncFSOutputHelper.createOutput((FileSystem)fs, (Path)path, (boolean)overwritable, (boolean)false, (short)replication, (long)blockSize, (EventLoopGroup)this.eventLoopGroup, this.channelClass, (StreamSlowMonitor)monitor);
        this.asyncOutputWrapper = new OutputStreamWrapper(this.output);
    }

    @Override
    protected void closeOutputIfNecessary() {
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException e) {
                LOG.warn("Close output failed", (Throwable)e);
            }
        }
    }

    private long writeWALMetadata(Consumer<CompletableFuture<Long>> action) throws IOException {
        CompletableFuture future = new CompletableFuture();
        action.accept(future);
        try {
            return (Long)future.get(this.waitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            InterruptedIOException ioe = new InterruptedIOException();
            ioe.initCause(e);
            throw ioe;
        }
        catch (ExecutionException | TimeoutException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    protected long writeMagicAndWALHeader(byte[] magic, WALProtos.WALHeader header) throws IOException {
        return this.writeWALMetadata(future -> {
            this.output.write(magic);
            try {
                header.writeDelimitedTo(this.asyncOutputWrapper);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            FutureUtils.addListener((CompletableFuture)this.output.flush(false), (len, error) -> {
                if (error != null) {
                    future.completeExceptionally((Throwable)error);
                } else {
                    future.complete(len);
                }
            });
        });
    }

    @Override
    protected long writeWALTrailerAndMagic(WALProtos.WALTrailer trailer, byte[] magic) throws IOException {
        return this.writeWALMetadata(future -> {
            try {
                trailer.writeTo(this.asyncOutputWrapper);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.output.writeInt(trailer.getSerializedSize());
            this.output.write(magic);
            FutureUtils.addListener((CompletableFuture)this.output.flush(false), (len, error) -> {
                if (error != null) {
                    future.completeExceptionally((Throwable)error);
                } else {
                    future.complete(len);
                }
            });
        });
    }

    @Override
    protected OutputStream getOutputStreamForCellEncoder() {
        return this.asyncOutputWrapper;
    }

    @Override
    public long getSyncedLength() {
        AsyncFSOutput outputToUse = this.output;
        if (outputToUse == null) {
            long finalSyncedLengthToUse = this.finalSyncedLength;
            assert (finalSyncedLengthToUse >= 0L);
            return finalSyncedLengthToUse;
        }
        return outputToUse.getSyncedLength();
    }

    private static final class OutputStreamWrapper
    extends OutputStream
    implements ByteBufferWriter {
        private final AsyncFSOutput out;
        private final byte[] oneByteBuf = new byte[1];

        @Override
        public void write(int b) throws IOException {
            this.oneByteBuf[0] = (byte)b;
            this.write(this.oneByteBuf);
        }

        public OutputStreamWrapper(AsyncFSOutput out) {
            this.out = out;
        }

        public void write(ByteBuffer b, int off, int len) throws IOException {
            ByteBuffer bb = b.duplicate();
            bb.position(off);
            bb.limit(off + len);
            this.out.write(bb);
        }

        public void writeInt(int i) throws IOException {
            this.out.writeInt(i);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

