/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.regionserver.wal.CombinedWriterBase;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class CombinedWriter
extends CombinedWriterBase<WALProvider.Writer>
implements WALProvider.Writer {
    private final ImmutableList<ExecutorService> executors;

    private CombinedWriter(ImmutableList<WALProvider.Writer> writers) {
        super(writers);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(writers.size() - 1));
        for (int i = 0; i < writers.size() - 1; ++i) {
            WALProvider.Writer writer = (WALProvider.Writer)writers.get(i);
            builder.add((Object)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("WAL-Writer-" + writer + "-%d").setDaemon(true).build()));
        }
        this.executors = builder.build();
    }

    private void apply(final Action action) throws IOException {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(this.writers.size() - 1);
        for (int i = 0; i < this.writers.size() - 1; ++i) {
            final WALProvider.Writer writer = (WALProvider.Writer)this.writers.get(i);
            futures.add(((ExecutorService)this.executors.get(i)).submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    action.action(writer);
                    return null;
                }
            }));
        }
        action.action((WALProvider.Writer)this.writers.get(this.writers.size() - 1));
        for (Future future : futures) {
            FutureUtils.get((Future)future);
        }
    }

    @Override
    public void sync(boolean forceSync) throws IOException {
        this.apply(writer -> writer.sync(forceSync));
    }

    @Override
    public void append(WAL.Entry entry) throws IOException {
        this.apply(writer -> writer.append(entry));
    }

    @Override
    public void close() throws IOException {
        this.executors.forEach(ExecutorService::shutdown);
        super.close();
    }

    public static CombinedWriter create(WALProvider.Writer writer, WALProvider.Writer ... writers) {
        return new CombinedWriter((ImmutableList<WALProvider.Writer>)ImmutableList.builder().add((Object)writer).add((Object[])writers).build());
    }

    private static interface Action {
        public void action(WALProvider.Writer var1) throws IOException;
    }
}

