/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerImpl;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.regionserver.PeerActionListener;
import org.apache.hadoop.hbase.replication.regionserver.PeerProcedureHandler;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class PeerProcedureHandlerImpl
implements PeerProcedureHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PeerProcedureHandlerImpl.class);
    private final ReplicationSourceManager replicationSourceManager;
    private final PeerActionListener peerActionListener;
    private final KeyLocker<String> peersLock = new KeyLocker();

    public PeerProcedureHandlerImpl(ReplicationSourceManager replicationSourceManager, PeerActionListener peerActionListener) {
        this.replicationSourceManager = replicationSourceManager;
        this.peerActionListener = peerActionListener;
    }

    @Override
    public void addPeer(String peerId) throws IOException {
        ReentrantLock peerLock = this.peersLock.acquireLock((Object)peerId);
        try {
            this.replicationSourceManager.addPeer(peerId);
        }
        finally {
            peerLock.unlock();
        }
    }

    @Override
    public void removePeer(String peerId) throws IOException {
        ReentrantLock peerLock = this.peersLock.acquireLock((Object)peerId);
        try {
            if (this.replicationSourceManager.getReplicationPeers().getPeer(peerId) != null) {
                this.replicationSourceManager.removePeer(peerId);
            }
        }
        finally {
            peerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPeerState(String peerId) throws ReplicationException, IOException {
        ReentrantLock peerLock = this.peersLock.acquireLock((Object)peerId);
        ReplicationPeerImpl peer = null;
        ReplicationPeer.PeerState oldState = null;
        boolean success = false;
        try {
            peer = this.replicationSourceManager.getReplicationPeers().getPeer(peerId);
            if (peer == null) {
                throw new ReplicationException("Peer with id=" + peerId + " is not cached.");
            }
            oldState = peer.getPeerState();
            ReplicationPeer.PeerState newState = this.replicationSourceManager.getReplicationPeers().refreshPeerState(peerId);
            if (oldState.equals((Object)ReplicationPeer.PeerState.ENABLED) && newState.equals((Object)ReplicationPeer.PeerState.DISABLED)) {
                this.replicationSourceManager.refreshSources(peerId);
            }
            success = true;
        }
        finally {
            if (!success && peer != null) {
                peer.setPeerState(oldState.equals((Object)ReplicationPeer.PeerState.ENABLED));
            }
            peerLock.unlock();
        }
    }

    @Override
    public void enablePeer(String peerId) throws ReplicationException, IOException {
        this.refreshPeerState(peerId);
    }

    @Override
    public void disablePeer(String peerId) throws ReplicationException, IOException {
        this.refreshPeerState(peerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePeerConfig(String peerId) throws ReplicationException, IOException {
        ReentrantLock peerLock = this.peersLock.acquireLock((Object)peerId);
        ReplicationPeers peers = this.replicationSourceManager.getReplicationPeers();
        ReplicationPeerImpl peer = null;
        ReplicationPeerConfig oldConfig = null;
        ReplicationPeer.PeerState oldState = null;
        boolean success = false;
        try {
            peer = peers.getPeer(peerId);
            if (peer == null) {
                throw new ReplicationException("Peer with id=" + peerId + " is not cached.");
            }
            oldConfig = peer.getPeerConfig();
            oldState = peer.getPeerState();
            ReplicationPeerConfig newConfig = peers.refreshPeerConfig(peerId);
            ReplicationPeer.PeerState newState = peers.refreshPeerState(peerId);
            if (!ReplicationUtils.isNamespacesAndTableCFsEqual((ReplicationPeerConfig)oldConfig, (ReplicationPeerConfig)newConfig) || oldConfig.isSerial() != newConfig.isSerial() || oldState.equals((Object)ReplicationPeer.PeerState.ENABLED) && newState.equals((Object)ReplicationPeer.PeerState.DISABLED)) {
                this.replicationSourceManager.refreshSources(peerId);
            }
            success = true;
        }
        finally {
            if (!success && peer != null) {
                peer.setPeerConfig(oldConfig);
                peer.setPeerState(oldState.equals((Object)ReplicationPeer.PeerState.ENABLED));
            }
            peerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transitSyncReplicationPeerState(String peerId, int stage, HRegionServer rs) throws ReplicationException, IOException {
        block19: {
            ReplicationPeers replicationPeers = this.replicationSourceManager.getReplicationPeers();
            ReentrantLock peerLock = this.peersLock.acquireLock((Object)peerId);
            try {
                ReplicationPeerImpl peer = replicationPeers.getPeer(peerId);
                if (peer == null) {
                    throw new ReplicationException("Peer with id=" + peerId + " is not cached.");
                }
                if (!peer.getPeerConfig().isSyncReplication()) {
                    throw new ReplicationException("Peer with id=" + peerId + " is not synchronous.");
                }
                SyncReplicationState newSyncReplicationState = peer.getNewSyncReplicationState();
                if (stage == 0) {
                    if (newSyncReplicationState != SyncReplicationState.NONE) {
                        LOG.warn("The new sync replication state for peer {} has already been set to {}, this should be a retry, give up", (Object)peerId, (Object)newSyncReplicationState);
                        return;
                    }
                    ReplicationPeer.PeerState oldState = peer.getPeerState();
                    boolean success = false;
                    try {
                        ReplicationPeer.PeerState newState = replicationPeers.refreshPeerState(peerId);
                        if (oldState.equals((Object)ReplicationPeer.PeerState.ENABLED) && newState.equals((Object)ReplicationPeer.PeerState.DISABLED)) {
                            this.replicationSourceManager.refreshSources(peerId);
                        }
                        success = true;
                    }
                    finally {
                        if (!success) {
                            peer.setPeerState(oldState.equals((Object)ReplicationPeer.PeerState.ENABLED));
                        }
                    }
                    newSyncReplicationState = replicationPeers.refreshPeerNewSyncReplicationState(peerId);
                    SyncReplicationState oldSyncReplicationState = peer.getSyncReplicationState();
                    this.peerActionListener.peerSyncReplicationStateChange(peerId, oldSyncReplicationState, newSyncReplicationState, stage);
                    break block19;
                }
                if (newSyncReplicationState == SyncReplicationState.NONE) {
                    LOG.warn("The new sync replication state for peer {} has already been clear, and the current state is {}, this should be a retry, give up", (Object)peerId, (Object)newSyncReplicationState);
                    return;
                }
                if (newSyncReplicationState == SyncReplicationState.STANDBY) {
                    this.replicationSourceManager.drainSources(peerId);
                    LogRoller roller = rs.getWalRoller();
                    roller.requestRollAll();
                    try {
                        roller.waitUntilWalRollFinished();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw (IOException)new InterruptedIOException("Interrupted while waiting for wal roll finish").initCause(e);
                    }
                }
                SyncReplicationState oldState = peer.getSyncReplicationState();
                this.peerActionListener.peerSyncReplicationStateChange(peerId, oldState, newSyncReplicationState, stage);
                peer.transitSyncReplicationState();
            }
            finally {
                peerLock.unlock();
            }
        }
    }

    @Override
    public void claimReplicationQueue(ReplicationQueueId queueId) throws ReplicationException, IOException {
        this.replicationSourceManager.claimQueue(queueId);
    }
}

