/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.Optional;
import java.util.function.BiPredicate;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationPeerImpl;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.regionserver.SyncReplicationPeerInfoProvider;
import org.apache.hadoop.hbase.replication.regionserver.SyncReplicationPeerMappingManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class SyncReplicationPeerInfoProviderImpl
implements SyncReplicationPeerInfoProvider {
    private final ReplicationPeers replicationPeers;
    private final SyncReplicationPeerMappingManager mapping;

    SyncReplicationPeerInfoProviderImpl(ReplicationPeers replicationPeers, SyncReplicationPeerMappingManager mapping) {
        this.replicationPeers = replicationPeers;
        this.mapping = mapping;
    }

    @Override
    public Optional<Pair<String, String>> getPeerIdAndRemoteWALDir(TableName table) {
        if (table == null) {
            return Optional.empty();
        }
        String peerId = this.mapping.getPeerId(table);
        if (peerId == null) {
            return Optional.empty();
        }
        ReplicationPeerImpl peer = this.replicationPeers.getPeer(peerId);
        if (peer == null) {
            return Optional.empty();
        }
        Pair states = peer.getSyncReplicationStateAndNewState();
        if (states.getFirst() == SyncReplicationState.ACTIVE && states.getSecond() == SyncReplicationState.NONE || states.getFirst() == SyncReplicationState.DOWNGRADE_ACTIVE && states.getSecond() == SyncReplicationState.ACTIVE) {
            return Optional.of(Pair.newPair((Object)peerId, (Object)peer.getPeerConfig().getRemoteWALDir()));
        }
        return Optional.empty();
    }

    @Override
    public boolean checkState(TableName table, BiPredicate<SyncReplicationState, SyncReplicationState> checker) {
        String peerId = this.mapping.getPeerId(table);
        if (peerId == null) {
            return false;
        }
        ReplicationPeerImpl peer = this.replicationPeers.getPeer(peerId);
        if (peer == null) {
            return false;
        }
        Pair states = peer.getSyncReplicationStateAndNewState();
        return checker.test((SyncReplicationState)states.getFirst(), (SyncReplicationState)states.getSecond());
    }
}

