/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RSGroupAdminProtos;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class RSGroupAdminServiceImpl
extends RSGroupAdminProtos.RSGroupAdminService {
    private static final Logger LOG = LoggerFactory.getLogger(RSGroupAdminServiceImpl.class);
    private MasterServices master;
    private RSGroupInfoManager rsGroupInfoManager;

    RSGroupAdminServiceImpl() {
    }

    void initialize(MasterServices masterServices) {
        this.master = masterServices;
        this.rsGroupInfoManager = masterServices.getRSGroupInfoManager();
    }

    private RSGroupInfo fillTables(RSGroupInfo rsGroupInfo) throws IOException {
        return RSGroupUtil.fillTables(rsGroupInfo, this.master.getTableDescriptors().getAll().values());
    }

    public void getRSGroupInfo(RpcController controller, RSGroupAdminProtos.GetRSGroupInfoRequest request, RpcCallback<RSGroupAdminProtos.GetRSGroupInfoResponse> done) {
        RSGroupAdminProtos.GetRSGroupInfoResponse.Builder builder = RSGroupAdminProtos.GetRSGroupInfoResponse.newBuilder();
        String groupName = request.getRSGroupName();
        LOG.info(this.master.getClientIdAuditPrefix() + " initiates rsgroup info retrieval, group=" + groupName);
        try {
            RSGroupInfo rsGroupInfo;
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preGetRSGroupInfo(groupName);
            }
            if ((rsGroupInfo = this.rsGroupInfoManager.getRSGroup(groupName)) != null) {
                builder.setRSGroupInfo(ProtobufUtil.toProtoGroupInfo((RSGroupInfo)this.fillTables(rsGroupInfo)));
            }
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postGetRSGroupInfo(groupName);
            }
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void getRSGroupInfoOfTable(RpcController controller, RSGroupAdminProtos.GetRSGroupInfoOfTableRequest request, RpcCallback<RSGroupAdminProtos.GetRSGroupInfoOfTableResponse> done) {
        RSGroupAdminProtos.GetRSGroupInfoOfTableResponse.Builder builder = RSGroupAdminProtos.GetRSGroupInfoOfTableResponse.newBuilder();
        TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName());
        LOG.info(this.master.getClientIdAuditPrefix() + " initiates rsgroup info retrieval, table=" + tableName);
        try {
            Optional<RSGroupInfo> optGroup;
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preGetRSGroupInfoOfTable(tableName);
            }
            if ((optGroup = RSGroupUtil.getRSGroupInfo(this.master, this.rsGroupInfoManager, tableName)).isPresent()) {
                builder.setRSGroupInfo(ProtobufUtil.toProtoGroupInfo((RSGroupInfo)this.fillTables(optGroup.get())));
            } else if (this.master.getTableStateManager().isTablePresent(tableName)) {
                RSGroupInfo rsGroupInfo = this.rsGroupInfoManager.getRSGroup("default");
                builder.setRSGroupInfo(ProtobufUtil.toProtoGroupInfo((RSGroupInfo)this.fillTables(rsGroupInfo)));
            }
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postGetRSGroupInfoOfTable(tableName);
            }
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void moveServers(RpcController controller, RSGroupAdminProtos.MoveServersRequest request, RpcCallback<RSGroupAdminProtos.MoveServersResponse> done) {
        RSGroupAdminProtos.MoveServersResponse.Builder builder = RSGroupAdminProtos.MoveServersResponse.newBuilder();
        HashSet hostPorts = Sets.newHashSet();
        for (HBaseProtos.ServerName el : request.getServersList()) {
            hostPorts.add(Address.fromParts((String)el.getHostName(), (int)el.getPort()));
        }
        LOG.info(this.master.getClientIdAuditPrefix() + " move servers " + hostPorts + " to rsgroup " + request.getTargetGroup());
        try {
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preMoveServers(hostPorts, request.getTargetGroup());
            }
            this.rsGroupInfoManager.moveServers(hostPorts, request.getTargetGroup());
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postMoveServers(hostPorts, request.getTargetGroup());
            }
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    private void moveTablesAndWait(Set<TableName> tables, String targetGroup) throws IOException {
        ArrayList<Long> procIds = new ArrayList<Long>();
        for (TableName tableName : tables) {
            TableDescriptor oldTd = this.master.getTableDescriptors().get(tableName);
            if (oldTd == null) continue;
            TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)oldTd).setRegionServerGroup(targetGroup).build();
            procIds.add(this.master.modifyTable(tableName, newTd, 0L, 0L));
        }
        Iterator<Object> iterator = procIds.iterator();
        while (iterator.hasNext()) {
            long procId = (Long)iterator.next();
            Procedure proc = this.master.getMasterProcedureExecutor().getProcedure(procId);
            if (proc == null) continue;
            ProcedureSyncWait.waitForProcedureToCompleteIOE(this.master.getMasterProcedureExecutor(), proc, Long.MAX_VALUE);
        }
    }

    public void moveTables(RpcController controller, RSGroupAdminProtos.MoveTablesRequest request, RpcCallback<RSGroupAdminProtos.MoveTablesResponse> done) {
        RSGroupAdminProtos.MoveTablesResponse.Builder builder = RSGroupAdminProtos.MoveTablesResponse.newBuilder();
        HashSet<TableName> tables = new HashSet<TableName>(request.getTableNameList().size());
        for (HBaseProtos.TableName tableName : request.getTableNameList()) {
            tables.add(ProtobufUtil.toTableName((HBaseProtos.TableName)tableName));
        }
        LOG.info(this.master.getClientIdAuditPrefix() + " move tables " + tables + " to rsgroup " + request.getTargetGroup());
        try {
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preMoveTables(tables, request.getTargetGroup());
            }
            this.moveTablesAndWait(tables, request.getTargetGroup());
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postMoveTables(tables, request.getTargetGroup());
            }
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void addRSGroup(RpcController controller, RSGroupAdminProtos.AddRSGroupRequest request, RpcCallback<RSGroupAdminProtos.AddRSGroupResponse> done) {
        RSGroupAdminProtos.AddRSGroupResponse.Builder builder = RSGroupAdminProtos.AddRSGroupResponse.newBuilder();
        LOG.info(this.master.getClientIdAuditPrefix() + " add rsgroup " + request.getRSGroupName());
        try {
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preAddRSGroup(request.getRSGroupName());
            }
            this.rsGroupInfoManager.addRSGroup(new RSGroupInfo(request.getRSGroupName()));
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postAddRSGroup(request.getRSGroupName());
            }
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void removeRSGroup(RpcController controller, RSGroupAdminProtos.RemoveRSGroupRequest request, RpcCallback<RSGroupAdminProtos.RemoveRSGroupResponse> done) {
        RSGroupAdminProtos.RemoveRSGroupResponse.Builder builder = RSGroupAdminProtos.RemoveRSGroupResponse.newBuilder();
        LOG.info(this.master.getClientIdAuditPrefix() + " remove rsgroup " + request.getRSGroupName());
        try {
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preRemoveRSGroup(request.getRSGroupName());
            }
            this.rsGroupInfoManager.removeRSGroup(request.getRSGroupName());
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postRemoveRSGroup(request.getRSGroupName());
            }
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void balanceRSGroup(RpcController controller, RSGroupAdminProtos.BalanceRSGroupRequest request, RpcCallback<RSGroupAdminProtos.BalanceRSGroupResponse> done) {
        BalanceRequest balanceRequest = ProtobufUtil.toBalanceRequest((RSGroupAdminProtos.BalanceRSGroupRequest)request);
        RSGroupAdminProtos.BalanceRSGroupResponse.Builder builder = RSGroupAdminProtos.BalanceRSGroupResponse.newBuilder().setBalanceRan(false);
        LOG.info(this.master.getClientIdAuditPrefix() + " balance rsgroup, group=" + request.getRSGroupName());
        try {
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preBalanceRSGroup(request.getRSGroupName(), balanceRequest);
            }
            BalanceResponse response = this.rsGroupInfoManager.balanceRSGroup(request.getRSGroupName(), balanceRequest);
            ProtobufUtil.populateBalanceRSGroupResponse((RSGroupAdminProtos.BalanceRSGroupResponse.Builder)builder, (BalanceResponse)response);
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postBalanceRSGroup(request.getRSGroupName(), balanceRequest, response);
            }
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void listRSGroupInfos(RpcController controller, RSGroupAdminProtos.ListRSGroupInfosRequest request, RpcCallback<RSGroupAdminProtos.ListRSGroupInfosResponse> done) {
        RSGroupAdminProtos.ListRSGroupInfosResponse.Builder builder = RSGroupAdminProtos.ListRSGroupInfosResponse.newBuilder();
        LOG.info(this.master.getClientIdAuditPrefix() + " list rsgroup");
        try {
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preListRSGroups();
            }
            List rsGroupInfos = this.rsGroupInfoManager.listRSGroups().stream().map(RSGroupInfo::new).collect(Collectors.toList());
            HashMap<String, RSGroupInfo> name2Info = new HashMap<String, RSGroupInfo>();
            for (RSGroupInfo rsGroupInfo : rsGroupInfos) {
                name2Info.put(rsGroupInfo.getName(), rsGroupInfo);
            }
            for (TableDescriptor td : this.master.getTableDescriptors().getAll().values()) {
                String groupName = td.getRegionServerGroup().orElse("default");
                RSGroupInfo rsGroupInfo = (RSGroupInfo)name2Info.get(groupName);
                if (rsGroupInfo == null) continue;
                rsGroupInfo.addTable(td.getTableName());
            }
            for (RSGroupInfo rsGroupInfo : rsGroupInfos) {
                builder.addRSGroupInfo(ProtobufUtil.toProtoGroupInfo((RSGroupInfo)rsGroupInfo));
            }
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postListRSGroups();
            }
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void getRSGroupInfoOfServer(RpcController controller, RSGroupAdminProtos.GetRSGroupInfoOfServerRequest request, RpcCallback<RSGroupAdminProtos.GetRSGroupInfoOfServerResponse> done) {
        RSGroupAdminProtos.GetRSGroupInfoOfServerResponse.Builder builder = RSGroupAdminProtos.GetRSGroupInfoOfServerResponse.newBuilder();
        Address hp = Address.fromParts((String)request.getServer().getHostName(), (int)request.getServer().getPort());
        LOG.info(this.master.getClientIdAuditPrefix() + " initiates rsgroup info retrieval, server=" + hp);
        try {
            RSGroupInfo info;
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preGetRSGroupInfoOfServer(hp);
            }
            if ((info = this.rsGroupInfoManager.getRSGroupOfServer(hp)) != null) {
                builder.setRSGroupInfo(ProtobufUtil.toProtoGroupInfo((RSGroupInfo)this.fillTables(info)));
            }
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postGetRSGroupInfoOfServer(hp);
            }
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void moveServersAndTables(RpcController controller, RSGroupAdminProtos.MoveServersAndTablesRequest request, RpcCallback<RSGroupAdminProtos.MoveServersAndTablesResponse> done) {
        RSGroupAdminProtos.MoveServersAndTablesResponse.Builder builder = RSGroupAdminProtos.MoveServersAndTablesResponse.newBuilder();
        HashSet hostPorts = Sets.newHashSet();
        for (Object el : request.getServersList()) {
            hostPorts.add(Address.fromParts((String)el.getHostName(), (int)el.getPort()));
        }
        HashSet<TableName> tables = new HashSet<TableName>(request.getTableNameList().size());
        for (HBaseProtos.TableName tableName : request.getTableNameList()) {
            tables.add(ProtobufUtil.toTableName((HBaseProtos.TableName)tableName));
        }
        LOG.info(this.master.getClientIdAuditPrefix() + " move servers " + hostPorts + " and tables " + tables + " to rsgroup" + request.getTargetGroup());
        try {
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preMoveServersAndTables(hostPorts, tables, request.getTargetGroup());
            }
            this.rsGroupInfoManager.moveServers(hostPorts, request.getTargetGroup());
            this.moveTablesAndWait(tables, request.getTargetGroup());
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postMoveServersAndTables(hostPorts, tables, request.getTargetGroup());
            }
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void removeServers(RpcController controller, RSGroupAdminProtos.RemoveServersRequest request, RpcCallback<RSGroupAdminProtos.RemoveServersResponse> done) {
        RSGroupAdminProtos.RemoveServersResponse.Builder builder = RSGroupAdminProtos.RemoveServersResponse.newBuilder();
        HashSet servers = Sets.newHashSet();
        for (HBaseProtos.ServerName el : request.getServersList()) {
            servers.add(Address.fromParts((String)el.getHostName(), (int)el.getPort()));
        }
        LOG.info(this.master.getClientIdAuditPrefix() + " remove decommissioned servers from rsgroup: " + servers);
        try {
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preRemoveServers(servers);
            }
            this.rsGroupInfoManager.removeServers(servers);
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postRemoveServers(servers);
            }
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void renameRSGroup(RpcController controller, RSGroupAdminProtos.RenameRSGroupRequest request, RpcCallback<RSGroupAdminProtos.RenameRSGroupResponse> done) {
        String oldRSGroup = request.getOldRsgroupName();
        String newRSGroup = request.getNewRsgroupName();
        LOG.info("{} rename rsgroup from {} to {}", new Object[]{this.master.getClientIdAuditPrefix(), oldRSGroup, newRSGroup});
        RSGroupAdminProtos.RenameRSGroupResponse.Builder builder = RSGroupAdminProtos.RenameRSGroupResponse.newBuilder();
        try {
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preRenameRSGroup(oldRSGroup, newRSGroup);
            }
            this.rsGroupInfoManager.renameRSGroup(oldRSGroup, newRSGroup);
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postRenameRSGroup(oldRSGroup, newRSGroup);
            }
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }
}

