/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.protobuf.ProtobufMagic;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.rsgroup.MigrateRSGroupProcedure;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RSGroupProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hadoop.util.Shell;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableCollection;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class RSGroupInfoManagerImpl
implements RSGroupInfoManager {
    private static final Logger LOG = LoggerFactory.getLogger(RSGroupInfoManagerImpl.class);
    static final TableName RSGROUP_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"rsgroup");
    static final String KEEP_ONE_SERVER_IN_DEFAULT_ERROR_MESSAGE = "should keep at least one server in 'default' RSGroup.";
    static final String FAILED_MOVE_MAX_RETRY = "hbase.rsgroup.move.max.retry";
    static final int DEFAULT_MAX_RETRY_VALUE = 50;
    private static final String RS_GROUP_ZNODE = "rsgroup";
    static final byte[] META_FAMILY_BYTES = Bytes.toBytes((String)"m");
    static final byte[] META_QUALIFIER_BYTES = Bytes.toBytes((String)"i");
    static final String MIGRATE_THREAD_NAME = "Migrate-RSGroup-Tables";
    private static final byte[] ROW_KEY = new byte[]{0};
    private static final TableDescriptor RSGROUP_TABLE_DESC;
    private volatile RSGroupInfoHolder holder = new RSGroupInfoHolder();
    private final MasterServices masterServices;
    private final AsyncClusterConnection conn;
    private final ZKWatcher watcher;
    private final RSGroupStartupWorker rsGroupStartupWorker;
    private Set<String> prevRSGroups = new HashSet<String>();
    private RSGroupMappingScript script;

    private RSGroupInfoManagerImpl(MasterServices masterServices) {
        this.masterServices = masterServices;
        this.watcher = masterServices.getZooKeeper();
        this.conn = masterServices.getAsyncClusterConnection();
        this.rsGroupStartupWorker = new RSGroupStartupWorker();
        this.script = new RSGroupMappingScript(masterServices.getConfiguration());
    }

    private synchronized void updateDefaultServers() {
        LOG.info("Updating default servers.");
        HashMap newGroupMap = Maps.newHashMap(this.holder.groupName2Group);
        RSGroupInfo oldDefaultGroupInfo = this.getRSGroup("default");
        assert (oldDefaultGroupInfo != null);
        RSGroupInfo newDefaultGroupInfo = new RSGroupInfo("default", this.getDefaultServers());
        newDefaultGroupInfo.addAllTables((Collection)oldDefaultGroupInfo.getTables());
        newGroupMap.put("default", newDefaultGroupInfo);
        this.resetRSGroupMap(newGroupMap);
        LOG.info("Updated default servers, {} servers", (Object)newDefaultGroupInfo.getServers().size());
        if (LOG.isDebugEnabled()) {
            LOG.debug("New default servers list: {}", (Object)newDefaultGroupInfo.getServers());
        }
    }

    private synchronized void init() throws IOException {
        this.refresh(false);
        this.masterServices.getServerManager().registerListener(new ServerListener(){

            @Override
            public void serverAdded(ServerName serverName) {
                RSGroupInfoManagerImpl.this.updateDefaultServers();
            }

            @Override
            public void serverRemoved(ServerName serverName) {
                RSGroupInfoManagerImpl.this.updateDefaultServers();
            }
        });
    }

    static RSGroupInfoManager getInstance(MasterServices masterServices) throws IOException {
        RSGroupInfoManagerImpl instance = new RSGroupInfoManagerImpl(masterServices);
        instance.init();
        return instance;
    }

    @Override
    public void start() {
        this.rsGroupStartupWorker.start();
    }

    @Override
    public synchronized void addRSGroup(RSGroupInfo rsGroupInfo) throws IOException {
        this.checkGroupName(rsGroupInfo.getName());
        ImmutableMap<String, RSGroupInfo> rsGroupMap = this.holder.groupName2Group;
        if (rsGroupMap.get(rsGroupInfo.getName()) != null || rsGroupInfo.getName().equals("default")) {
            throw new ConstraintException("Group already exists: " + rsGroupInfo.getName());
        }
        HashMap newGroupMap = Maps.newHashMap(rsGroupMap);
        newGroupMap.put(rsGroupInfo.getName(), rsGroupInfo);
        this.flushConfig(newGroupMap);
        LOG.info("Add group {} done.", (Object)rsGroupInfo.getName());
    }

    private RSGroupInfo getRSGroupInfo(String groupName) throws ConstraintException {
        RSGroupInfo rsGroupInfo = (RSGroupInfo)this.holder.groupName2Group.get((Object)groupName);
        if (rsGroupInfo == null) {
            throw new ConstraintException("RSGroup " + groupName + " does not exist");
        }
        return rsGroupInfo;
    }

    private Set<Address> getOnlineServers() {
        return this.masterServices.getServerManager().getOnlineServers().keySet().stream().map(ServerName::getAddress).collect(Collectors.toSet());
    }

    public synchronized Set<Address> moveServers(Set<Address> servers, String srcGroup, String dstGroup) throws IOException {
        RSGroupInfo src = this.getRSGroupInfo(srcGroup);
        RSGroupInfo dst = this.getRSGroupInfo(dstGroup);
        HashSet<Address> movedServers = new HashSet<Address>();
        Set<Address> onlineServers = dst.getName().equals("default") ? this.getOnlineServers() : null;
        for (Address el : servers) {
            src.removeServer(el);
            if (onlineServers != null && !onlineServers.contains(el)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Dropping " + el + " during move-to-default RSGroup because not online");
                continue;
            }
            dst.addServer(el);
            movedServers.add(el);
        }
        HashMap newGroupMap = Maps.newHashMap(this.holder.groupName2Group);
        newGroupMap.put(src.getName(), src);
        newGroupMap.put(dst.getName(), dst);
        this.flushConfig(newGroupMap);
        return movedServers;
    }

    @Override
    public RSGroupInfo getRSGroupOfServer(Address serverHostPort) {
        for (RSGroupInfo info : this.holder.groupName2Group.values()) {
            if (!info.containsServer(serverHostPort)) continue;
            return info;
        }
        return null;
    }

    @Override
    public RSGroupInfo getRSGroup(String groupName) {
        return (RSGroupInfo)this.holder.groupName2Group.get((Object)groupName);
    }

    @Override
    public synchronized void removeRSGroup(String groupName) throws IOException {
        RSGroupInfo rsGroupInfo = this.getRSGroupInfo(groupName);
        int serverCount = rsGroupInfo.getServers().size();
        if (serverCount > 0) {
            throw new ConstraintException("RSGroup " + groupName + " has " + serverCount + " servers; you must remove these servers from the RSGroup before the RSGroup can be removed.");
        }
        for (TableDescriptor td : this.masterServices.getTableDescriptors().getAll().values()) {
            if (!td.getRegionServerGroup().map(groupName::equals).orElse(false).booleanValue()) continue;
            throw new ConstraintException("RSGroup " + groupName + " is already referenced by " + td.getTableName() + "; you must remove all the tables from the RSGroup before the RSGroup can be removed.");
        }
        for (NamespaceDescriptor ns : this.masterServices.getClusterSchema().getNamespaces()) {
            String nsGroup = ns.getConfigurationValue("hbase.rsgroup.name");
            if (nsGroup == null || !nsGroup.equals(groupName)) continue;
            throw new ConstraintException("RSGroup " + groupName + " is referenced by namespace: " + ns.getName());
        }
        ImmutableMap<String, RSGroupInfo> rsGroupMap = this.holder.groupName2Group;
        if (!rsGroupMap.containsKey(groupName) || groupName.equals("default")) {
            throw new ConstraintException("Group " + groupName + " does not exist or is a reserved group");
        }
        HashMap newGroupMap = Maps.newHashMap(rsGroupMap);
        newGroupMap.remove(groupName);
        this.flushConfig(newGroupMap);
        LOG.info("Remove group {} done", (Object)groupName);
    }

    @Override
    public List<RSGroupInfo> listRSGroups() {
        return Lists.newArrayList((Iterable)this.holder.groupName2Group.values());
    }

    @Override
    public boolean isOnline() {
        return this.rsGroupStartupWorker.isOnline();
    }

    @Override
    public synchronized void removeServers(Set<Address> servers) throws IOException {
        if (servers == null || servers.isEmpty()) {
            throw new ConstraintException("The set of servers to remove cannot be null or empty.");
        }
        this.checkForDeadOrOnlineServers(servers);
        HashMap<String, RSGroupInfo> rsGroupInfos = new HashMap<String, RSGroupInfo>();
        for (Address el : servers) {
            RSGroupInfo rsGroupInfo = this.getRSGroupOfServer(el);
            if (rsGroupInfo != null) {
                RSGroupInfo newRsGroupInfo = (RSGroupInfo)rsGroupInfos.get(rsGroupInfo.getName());
                if (newRsGroupInfo == null) {
                    rsGroupInfo.removeServer(el);
                    rsGroupInfos.put(rsGroupInfo.getName(), rsGroupInfo);
                    continue;
                }
                newRsGroupInfo.removeServer(el);
                rsGroupInfos.put(newRsGroupInfo.getName(), newRsGroupInfo);
                continue;
            }
            LOG.warn("Server " + el + " does not belong to any rsgroup.");
        }
        if (rsGroupInfos.size() > 0) {
            HashMap newGroupMap = Maps.newHashMap(this.holder.groupName2Group);
            newGroupMap.putAll(rsGroupInfos);
            this.flushConfig(newGroupMap);
        }
        LOG.info("Remove decommissioned servers {} from RSGroup done", servers);
    }

    private List<RSGroupInfo> retrieveGroupListFromGroupTable() throws IOException {
        ArrayList rsGroupInfoList = Lists.newArrayList();
        AsyncTable table = this.conn.getTable(RSGROUP_TABLE_NAME);
        try (ResultScanner scanner = table.getScanner(META_FAMILY_BYTES, META_QUALIFIER_BYTES);){
            Result result;
            while ((result = scanner.next()) != null) {
                RSGroupProtos.RSGroupInfo proto = RSGroupProtos.RSGroupInfo.parseFrom((byte[])result.getValue(META_FAMILY_BYTES, META_QUALIFIER_BYTES));
                rsGroupInfoList.add(ProtobufUtil.toGroupInfo((RSGroupProtos.RSGroupInfo)proto));
            }
        }
        return rsGroupInfoList;
    }

    private List<RSGroupInfo> retrieveGroupListFromZookeeper() throws IOException {
        String groupBasePath = ZNodePaths.joinZNode((String)this.watcher.getZNodePaths().baseZNode, (String[])new String[]{RS_GROUP_ZNODE});
        ArrayList RSGroupInfoList = Lists.newArrayList();
        try {
            if (ZKUtil.checkExists((ZKWatcher)this.watcher, (String)groupBasePath) != -1) {
                List children = ZKUtil.listChildrenAndWatchForNewChildren((ZKWatcher)this.watcher, (String)groupBasePath);
                if (children == null) {
                    return RSGroupInfoList;
                }
                for (String znode : children) {
                    byte[] data = ZKUtil.getData((ZKWatcher)this.watcher, (String)ZNodePaths.joinZNode((String)groupBasePath, (String[])new String[]{znode}));
                    if (data == null || data.length <= 0) continue;
                    ProtobufUtil.expectPBMagicPrefix((byte[])data);
                    ByteArrayInputStream bis = new ByteArrayInputStream(data, ProtobufUtil.lengthOfPBMagic(), data.length);
                    RSGroupInfoList.add(ProtobufUtil.toGroupInfo((RSGroupProtos.RSGroupInfo)RSGroupProtos.RSGroupInfo.parseFrom((InputStream)bis)));
                }
                LOG.debug("Read ZK GroupInfo count:" + RSGroupInfoList.size());
            }
        }
        catch (InterruptedException | DeserializationException | KeeperException e) {
            throw new IOException("Failed to read rsGroupZNode", e);
        }
        return RSGroupInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrate(Collection<RSGroupInfo> groupList) {
        TableDescriptors tds = this.masterServices.getTableDescriptors();
        ProcedureExecutor<MasterProcedureEnv> procExec = this.masterServices.getMasterProcedureExecutor();
        for (RSGroupInfo groupInfo : groupList) {
            if (groupInfo.getName().equals("default")) continue;
            TreeSet<TableName> failedTables = new TreeSet<TableName>();
            ArrayList<MigrateRSGroupProcedure> procs = new ArrayList<MigrateRSGroupProcedure>();
            for (TableName tableName : groupInfo.getTables()) {
                TableDescriptor oldTd;
                LOG.debug("Migrating {} in group {}", (Object)tableName, (Object)groupInfo.getName());
                try {
                    oldTd = tds.get(tableName);
                }
                catch (IOException e) {
                    LOG.warn("Failed to migrate {} in group {}", new Object[]{tableName, groupInfo.getName(), e});
                    failedTables.add(tableName);
                    continue;
                }
                if (oldTd == null) continue;
                if (oldTd.getRegionServerGroup().isPresent()) {
                    LOG.debug("Skip migrating {} since it is already in group {}", (Object)tableName, oldTd.getRegionServerGroup().get());
                    continue;
                }
                MigrateRSGroupProcedure proc = new MigrateRSGroupProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName);
                procExec.submitProcedure((Procedure)proc);
                procs.add(proc);
            }
            for (MigrateRSGroupProcedure proc : procs) {
                try {
                    ProcedureSyncWait.waitForProcedureToComplete(procExec, proc, 60000L);
                }
                catch (IOException e) {
                    LOG.warn("Failed to migrate rs group {} for table {}", (Object)groupInfo.getName(), (Object)proc.getTableName());
                    failedTables.add(proc.getTableName());
                }
            }
            LOG.debug("Done migrating {}, failed tables {}", (Object)groupInfo.getName(), failedTables);
            RSGroupInfoManagerImpl rSGroupInfoManagerImpl = this;
            synchronized (rSGroupInfoManagerImpl) {
                ImmutableMap<String, RSGroupInfo> rsGroupMap = this.holder.groupName2Group;
                RSGroupInfo currentInfo = (RSGroupInfo)rsGroupMap.get(groupInfo.getName());
                if (currentInfo != null) {
                    RSGroupInfo newInfo = new RSGroupInfo(currentInfo.getName(), currentInfo.getServers(), failedTables);
                    HashMap<String, RSGroupInfo> newGroupMap = new HashMap<String, RSGroupInfo>((Map<String, RSGroupInfo>)rsGroupMap);
                    newGroupMap.put(groupInfo.getName(), newInfo);
                    try {
                        this.flushConfig(newGroupMap);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to persist rs group {}", (Object)newInfo.getName(), (Object)e);
                    }
                }
            }
        }
    }

    private void migrate() {
        Thread migrateThread = new Thread(MIGRATE_THREAD_NAME){

            @Override
            public void run() {
                ImmutableCollection groups;
                boolean hasTables;
                LOG.info("Start migrating table rs group config");
                while (!RSGroupInfoManagerImpl.this.masterServices.isStopped() && (hasTables = (groups = ((RSGroupInfoManagerImpl)RSGroupInfoManagerImpl.this).holder.groupName2Group.values()).stream().anyMatch(r -> !r.getTables().isEmpty()))) {
                    RSGroupInfoManagerImpl.this.migrate((Collection)groups);
                }
                LOG.info("Done migrating table rs group info");
            }
        };
        migrateThread.setDaemon(true);
        migrateThread.start();
    }

    private synchronized void refresh(boolean forceOnline) throws IOException {
        ArrayList<RSGroupInfo> groupList = new ArrayList<RSGroupInfo>();
        if (forceOnline || this.isOnline()) {
            LOG.debug("Refreshing in Online mode.");
            groupList.addAll(this.retrieveGroupListFromGroupTable());
        } else {
            LOG.debug("Refreshing in Offline mode.");
            groupList.addAll(this.retrieveGroupListFromZookeeper());
        }
        groupList.add(new RSGroupInfo("default", this.getDefaultServers(groupList)));
        HashMap newGroupMap = Maps.newHashMap();
        for (RSGroupInfo group : groupList) {
            newGroupMap.put(group.getName(), group);
        }
        this.resetRSGroupMap(newGroupMap);
        this.updateCacheOfRSGroups(newGroupMap.keySet());
    }

    private void flushConfigTable(Map<String, RSGroupInfo> groupMap) throws IOException {
        ArrayList mutations = Lists.newArrayList();
        for (String groupName : this.prevRSGroups) {
            if (groupMap.containsKey(groupName)) continue;
            Delete d = new Delete(Bytes.toBytes((String)groupName));
            mutations.add(d);
        }
        for (RSGroupInfo gi : groupMap.values()) {
            if (gi.getName().equals("default")) continue;
            RSGroupProtos.RSGroupInfo proto = ProtobufUtil.toProtoGroupInfo((RSGroupInfo)gi);
            Put p = new Put(Bytes.toBytes((String)gi.getName()));
            p.addColumn(META_FAMILY_BYTES, META_QUALIFIER_BYTES, proto.toByteArray());
            mutations.add(p);
        }
        if (mutations.size() > 0) {
            this.multiMutate(mutations);
        }
    }

    private synchronized void flushConfig() throws IOException {
        this.flushConfig((Map<String, RSGroupInfo>)this.holder.groupName2Group);
    }

    private synchronized void flushConfig(Map<String, RSGroupInfo> newGroupMap) throws IOException {
        if (!this.isOnline()) {
            if (newGroupMap == this.holder.groupName2Group) {
                return;
            }
            LOG.debug("Offline mode, cannot persist to {}", (Object)RSGROUP_TABLE_NAME);
            HashMap oldGroupMap = Maps.newHashMap(this.holder.groupName2Group);
            RSGroupInfo oldDefaultGroup = (RSGroupInfo)oldGroupMap.remove("default");
            RSGroupInfo newDefaultGroup = newGroupMap.remove("default");
            if (!oldGroupMap.equals(newGroupMap) || !oldDefaultGroup.getTables().equals(newDefaultGroup.getTables())) {
                throw new IOException("Only servers in default group can be updated during offline mode");
            }
            newGroupMap.put("default", newDefaultGroup);
            this.holder = new RSGroupInfoHolder(newGroupMap);
            LOG.debug("New RSGroup map: {}", newGroupMap);
            return;
        }
        LOG.debug("Online mode, persisting to {} and ZK", (Object)RSGROUP_TABLE_NAME);
        this.flushConfigTable(newGroupMap);
        this.resetRSGroupMap(newGroupMap);
        this.saveRSGroupMapToZK(newGroupMap);
        this.updateCacheOfRSGroups(newGroupMap.keySet());
        LOG.info("Flush config done, new RSGroup map: {}", newGroupMap);
    }

    private void saveRSGroupMapToZK(Map<String, RSGroupInfo> newGroupMap) throws IOException {
        LOG.debug("Saving RSGroup info to ZK");
        try {
            String znode;
            String groupBasePath = ZNodePaths.joinZNode((String)this.watcher.getZNodePaths().baseZNode, (String[])new String[]{RS_GROUP_ZNODE});
            ZKUtil.createAndFailSilent((ZKWatcher)this.watcher, (String)groupBasePath, (byte[])ProtobufMagic.PB_MAGIC);
            ArrayList<ZKUtil.ZKUtilOp> zkOps = new ArrayList<ZKUtil.ZKUtilOp>(newGroupMap.size());
            for (String groupName : this.prevRSGroups) {
                if (newGroupMap.containsKey(groupName)) continue;
                znode = ZNodePaths.joinZNode((String)groupBasePath, (String[])new String[]{groupName});
                zkOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)znode));
            }
            for (RSGroupInfo gi : newGroupMap.values()) {
                if (gi.getName().equals("default")) continue;
                znode = ZNodePaths.joinZNode((String)groupBasePath, (String[])new String[]{gi.getName()});
                RSGroupProtos.RSGroupInfo proto = ProtobufUtil.toProtoGroupInfo((RSGroupInfo)gi);
                LOG.debug("Updating znode: " + znode);
                ZKUtil.createAndFailSilent((ZKWatcher)this.watcher, (String)znode);
                zkOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)znode));
                zkOps.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)znode, (byte[])ProtobufUtil.prependPBMagic((byte[])proto.toByteArray())));
            }
            LOG.debug("Writing ZK GroupInfo count: " + zkOps.size());
            ZKUtil.multiOrSequential((ZKWatcher)this.watcher, zkOps, (boolean)false);
        }
        catch (KeeperException e) {
            LOG.error("Failed to write to rsGroupZNode", (Throwable)e);
            this.masterServices.abort("Failed to write to rsGroupZNode", e);
            throw new IOException("Failed to write to rsGroupZNode", e);
        }
    }

    private void resetRSGroupMap(Map<String, RSGroupInfo> newRSGroupMap) {
        this.holder = new RSGroupInfoHolder(newRSGroupMap);
    }

    private void updateCacheOfRSGroups(Set<String> currentGroups) {
        this.prevRSGroups.clear();
        this.prevRSGroups.addAll(currentGroups);
    }

    private SortedSet<Address> getDefaultServers() {
        return this.getDefaultServers(this.listRSGroups());
    }

    private SortedSet<Address> getDefaultServers(List<RSGroupInfo> rsGroupInfoList) {
        HashSet serversInOtherGroup = new HashSet();
        for (RSGroupInfo group : rsGroupInfoList) {
            if ("default".equals(group.getName())) continue;
            serversInOtherGroup.addAll(group.getServers());
        }
        TreeSet defaultServers = Sets.newTreeSet();
        for (ServerName serverName : this.masterServices.getServerManager().getOnlineServers().keySet()) {
            Address server = Address.fromParts((String)serverName.getHostname(), (int)serverName.getPort());
            if (serversInOtherGroup.contains(server)) continue;
            defaultServers.add(server);
        }
        return defaultServers;
    }

    private static boolean isMasterRunning(MasterServices masterServices) {
        return !masterServices.isAborted() && !masterServices.isStopped();
    }

    private void multiMutate(List<Mutation> mutations) throws IOException {
        MultiRowMutationProtos.MutateRowsRequest.Builder builder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
        for (Mutation mutation : mutations) {
            if (mutation instanceof Put) {
                builder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)mutation));
                continue;
            }
            if (mutation instanceof Delete) {
                builder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.DELETE, (Mutation)mutation));
                continue;
            }
            throw new DoNotRetryIOException("multiMutate doesn't support " + mutation.getClass().getName());
        }
        MultiRowMutationProtos.MutateRowsRequest request = builder.build();
        AsyncTable table = this.conn.getTable(RSGROUP_TABLE_NAME);
        LOG.debug("Multimutating {} with {} mutations", (Object)RSGROUP_TABLE_NAME, (Object)mutations.size());
        FutureUtils.get((Future)table.coprocessorService(MultiRowMutationProtos.MultiRowMutationService::newStub, (stub, controller, done) -> stub.mutateRows(controller, request, done), ROW_KEY));
        LOG.info("Multimutating {} with {} mutations done", (Object)RSGROUP_TABLE_NAME, (Object)mutations.size());
    }

    private void checkGroupName(String groupName) throws ConstraintException {
        if (!groupName.matches("[a-zA-Z0-9_]+")) {
            throw new ConstraintException("RSGroup name should only contain alphanumeric characters");
        }
    }

    @Override
    public RSGroupInfo getRSGroupForTable(TableName tableName) throws IOException {
        return (RSGroupInfo)this.holder.tableName2Group.get((Object)tableName);
    }

    private void checkForDeadOrOnlineServers(Set<Address> servers) throws IOException {
        HashSet<Address> onlineServers = new HashSet<Address>();
        List<ServerName> drainingServers = this.masterServices.getServerManager().getDrainingServersList();
        for (ServerName server : this.masterServices.getServerManager().getOnlineServers().keySet()) {
            if (drainingServers.contains(server)) continue;
            onlineServers.add(server.getAddress());
        }
        HashSet<Address> deadServers = new HashSet<Address>();
        for (ServerName server : this.masterServices.getServerManager().getDeadServers().copyServerNames()) {
            deadServers.add(server.getAddress());
        }
        for (Address address : servers) {
            if (onlineServers.contains(address)) {
                throw new DoNotRetryIOException("Server " + address + " is an online server, not allowed to remove.");
            }
            if (!deadServers.contains(address)) continue;
            throw new DoNotRetryIOException("Server " + address + " is on the dead servers list, Maybe it will come back again, not allowed to remove.");
        }
    }

    private void checkOnlineServersOnly(Set<Address> servers) throws IOException {
        HashSet<Address> onlineServers = new HashSet<Address>();
        for (ServerName server : this.masterServices.getServerManager().getOnlineServers().keySet()) {
            onlineServers.add(server.getAddress());
        }
        for (Address address : servers) {
            if (onlineServers.contains(address)) continue;
            throw new DoNotRetryIOException("Server " + address + " is not an online server in 'default' RSGroup.");
        }
    }

    private List<RegionInfo> getRegions(Address server) {
        LinkedList<RegionInfo> regions = new LinkedList<RegionInfo>();
        for (Map.Entry<RegionInfo, ServerName> el : this.masterServices.getAssignmentManager().getRegionStates().getRegionAssignments().entrySet()) {
            if (el.getValue() == null || !el.getValue().getAddress().equals((Object)server)) continue;
            this.addRegion(regions, el.getKey());
        }
        for (RegionStateNode state : this.masterServices.getAssignmentManager().getRegionsInTransition()) {
            if (state.getRegionLocation() == null || !state.getRegionLocation().getAddress().equals((Object)server)) continue;
            this.addRegion(regions, state.getRegionInfo());
        }
        return regions;
    }

    private void addRegion(LinkedList<RegionInfo> regions, RegionInfo hri) {
        if (hri.isMetaRegion()) {
            regions.addLast(hri);
        } else {
            regions.addFirst(hri);
        }
    }

    private void moveServerRegionsFromGroup(Set<Address> movedServers, Set<Address> srcGrpServers, String targetGroupName, String sourceGroupName) throws IOException {
        this.moveRegionsBetweenGroups(movedServers, srcGrpServers, targetGroupName, sourceGroupName, rs -> this.getRegions((Address)rs), info -> {
            try {
                String groupName = RSGroupUtil.getRSGroupInfo(this.masterServices, this, info.getTable()).map(RSGroupInfo::getName).orElse("default");
                return groupName.equals(targetGroupName);
            }
            catch (IOException e) {
                LOG.warn("Failed to test group for region {} and target group {}", info, (Object)targetGroupName);
                return false;
            }
        });
    }

    private <T> void moveRegionsBetweenGroups(Set<T> regionsOwners, Set<Address> newRegionsOwners, String targetGroupName, String sourceGroupName, Function<T, List<RegionInfo>> getRegionsInfo, Function<RegionInfo, Boolean> validation) throws IOException {
        ArrayList<ServerName> movedServerNames = new ArrayList<ServerName>(regionsOwners.size());
        ArrayList<ServerName> srcGrpServerNames = new ArrayList<ServerName>(newRegionsOwners.size());
        for (ServerName serverName : this.masterServices.getServerManager().getOnlineServers().keySet()) {
            if (newRegionsOwners.contains(serverName.getAddress())) {
                srcGrpServerNames.add(serverName);
            }
            if (!regionsOwners.contains(serverName.getAddress())) continue;
            movedServerNames.add(serverName);
        }
        ArrayList<Pair<RegionInfo, Future<byte[]>>> assignmentFutures = new ArrayList<Pair<RegionInfo, Future<byte[]>>>();
        int retry = 0;
        HashSet<String> failedRegions = new HashSet<String>();
        IOException toThrow = null;
        do {
            assignmentFutures.clear();
            failedRegions.clear();
            for (ServerName owner : movedServerNames) {
                for (RegionInfo region : getRegionsInfo.apply(owner.getAddress())) {
                    if (validation.apply(region).booleanValue()) continue;
                    LOG.info("Moving region {}, which does not belong to RSGroup {}", (Object)region.getShortNameToLog(), (Object)targetGroupName);
                    ServerName dest = this.masterServices.getLoadBalancer().randomAssignment(region, srcGrpServerNames);
                    if (dest == null) {
                        failedRegions.add(region.getRegionNameAsString());
                        continue;
                    }
                    RegionPlan rp = new RegionPlan(region, owner, dest);
                    try {
                        Future<byte[]> future = this.masterServices.getAssignmentManager().moveAsync(rp);
                        assignmentFutures.add((Pair<RegionInfo, Future<byte[]>>)Pair.newPair((Object)region, future));
                    }
                    catch (IOException ioe) {
                        failedRegions.add(region.getRegionNameAsString());
                        LOG.debug("Move region {} failed, will retry, current retry time is {}", new Object[]{region.getShortNameToLog(), retry, ioe});
                        toThrow = ioe;
                    }
                }
            }
            this.waitForRegionMovement(assignmentFutures, failedRegions, sourceGroupName, retry);
            if (failedRegions.isEmpty()) {
                LOG.info("All regions from {} are moved back to {}", movedServerNames, (Object)sourceGroupName);
                return;
            }
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                LOG.warn("Sleep interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        } while (!failedRegions.isEmpty() && ++retry <= this.masterServices.getConfiguration().getInt(FAILED_MOVE_MAX_RETRY, 50));
        if (!failedRegions.isEmpty()) {
            String msg = String.format("move regions for group %s failed, failed regions: %s", sourceGroupName, failedRegions);
            LOG.error(msg);
            throw new DoNotRetryIOException(msg + ", just record the last failed region's cause, more details in server log", toThrow);
        }
    }

    private void waitForRegionMovement(List<Pair<RegionInfo, Future<byte[]>>> regionMoveFutures, Set<String> failedRegions, String sourceGroupName, int retryCount) {
        LOG.info("Moving {} region(s) to group {}, current retry={}", new Object[]{regionMoveFutures.size(), sourceGroupName, retryCount});
        for (Pair<RegionInfo, Future<byte[]>> pair : regionMoveFutures) {
            try {
                ((Future)pair.getSecond()).get();
                if (!this.masterServices.getAssignmentManager().getRegionStates().getRegionState((RegionInfo)pair.getFirst()).isFailedOpen()) continue;
                failedRegions.add(((RegionInfo)pair.getFirst()).getRegionNameAsString());
            }
            catch (InterruptedException e) {
                failedRegions.add(((RegionInfo)pair.getFirst()).getRegionNameAsString());
                LOG.warn("Sleep interrupted", (Throwable)e);
            }
            catch (Exception e) {
                failedRegions.add(((RegionInfo)pair.getFirst()).getRegionNameAsString());
                LOG.error("Move region {} to group {} failed, will retry on next attempt", new Object[]{((RegionInfo)pair.getFirst()).getShortNameToLog(), sourceGroupName, e});
            }
        }
    }

    private boolean isTableInGroup(TableName tableName, String groupName, Set<TableName> tablesInGroupCache) throws IOException {
        if (tablesInGroupCache.contains(tableName)) {
            return true;
        }
        if (RSGroupUtil.getRSGroupInfo(this.masterServices, this, tableName).map(RSGroupInfo::getName).orElse("default").equals(groupName)) {
            tablesInGroupCache.add(tableName);
            return true;
        }
        return false;
    }

    private Map<String, RegionState> rsGroupGetRegionsInTransition(String groupName) throws IOException {
        TreeMap rit = Maps.newTreeMap();
        HashSet<TableName> tablesInGroupCache = new HashSet<TableName>();
        for (RegionStateNode regionNode : this.masterServices.getAssignmentManager().getRegionsInTransition()) {
            TableName tn = regionNode.getTable();
            if (!this.isTableInGroup(tn, groupName, tablesInGroupCache)) continue;
            rit.put(regionNode.getRegionInfo().getEncodedName(), regionNode.toRegionState());
        }
        return rit;
    }

    Map<TableName, Map<ServerName, List<RegionInfo>>> getRSGroupAssignmentsByTable(TableStateManager tableStateManager, String groupName) throws IOException {
        HashMap result = Maps.newHashMap();
        HashSet<TableName> tablesInGroupCache = new HashSet<TableName>();
        for (Map.Entry<RegionInfo, ServerName> entry : this.masterServices.getAssignmentManager().getRegionStates().getRegionAssignments().entrySet()) {
            RegionInfo region = entry.getKey();
            TableName tn = region.getTable();
            ServerName server = entry.getValue();
            if (!this.isTableInGroup(tn, groupName, tablesInGroupCache) || tableStateManager.isTableState(tn, TableState.State.DISABLED, TableState.State.DISABLING) || region.isSplitParent()) continue;
            result.computeIfAbsent(tn, k -> new HashMap()).computeIfAbsent(server, k -> new ArrayList()).add(region);
        }
        RSGroupInfo rsGroupInfo = this.getRSGroupInfo(groupName);
        for (ServerName serverName : this.masterServices.getServerManager().getOnlineServers().keySet()) {
            if (!rsGroupInfo.containsServer(serverName.getAddress())) continue;
            for (Map map : result.values()) {
                map.computeIfAbsent(serverName, k -> Collections.emptyList());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BalanceResponse balanceRSGroup(String groupName, BalanceRequest request) throws IOException {
        ServerManager serverManager = this.masterServices.getServerManager();
        LoadBalancer balancer = this.masterServices.getLoadBalancer();
        this.getRSGroupInfo(groupName);
        BalanceResponse.Builder responseBuilder = BalanceResponse.newBuilder();
        LoadBalancer loadBalancer = balancer;
        synchronized (loadBalancer) {
            if (!this.masterServices.isBalancerOn() && !request.isDryRun()) {
                return responseBuilder.build();
            }
            Map<String, RegionState> groupRIT = this.rsGroupGetRegionsInTransition(groupName);
            if (groupRIT.size() > 0 && !request.isIgnoreRegionsInTransition()) {
                LOG.debug("Not running balancer because {} region(s) in transition: {}", (Object)groupRIT.size(), (Object)StringUtils.abbreviate((String)this.masterServices.getAssignmentManager().getRegionStates().getRegionsInTransition().toString(), (int)256));
                return responseBuilder.build();
            }
            if (serverManager.areDeadServersInProgress()) {
                LOG.debug("Not running balancer because processing dead regionserver(s): {}", (Object)serverManager.getDeadServers());
                return responseBuilder.build();
            }
            Map<TableName, Map<ServerName, List<RegionInfo>>> assignmentsByTable = this.getRSGroupAssignmentsByTable(this.masterServices.getTableStateManager(), groupName);
            List plans = balancer.balanceCluster(assignmentsByTable);
            boolean balancerRan = !plans.isEmpty();
            responseBuilder.setBalancerRan(balancerRan).setMovesCalculated(plans.size());
            if (balancerRan && !request.isDryRun()) {
                LOG.info("RSGroup balance {} starting with plan count: {}", (Object)groupName, (Object)plans.size());
                List<RegionPlan> executed = this.masterServices.executeRegionPlansWithThrottling(plans);
                responseBuilder.setMovesExecuted(executed.size());
                LOG.info("RSGroup balance " + groupName + " completed");
            }
            return responseBuilder.build();
        }
    }

    private void moveTablesAndWait(Set<TableName> tables, String targetGroup) throws IOException {
        LOG.debug("Moving {} tables to target group {}", (Object)tables.size(), (Object)targetGroup);
        ArrayList<Long> procIds = new ArrayList<Long>();
        for (TableName tableName : tables) {
            TableDescriptor oldTd = this.masterServices.getTableDescriptors().get(tableName);
            if (oldTd == null) continue;
            TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)oldTd).setRegionServerGroup(targetGroup).build();
            procIds.add(this.masterServices.modifyTable(tableName, newTd, 0L, 0L));
        }
        Iterator<Object> iterator = procIds.iterator();
        while (iterator.hasNext()) {
            long procId = (Long)iterator.next();
            Procedure proc = this.masterServices.getMasterProcedureExecutor().getProcedure(procId);
            if (proc == null) continue;
            ProcedureSyncWait.waitForProcedureToCompleteIOE(this.masterServices.getMasterProcedureExecutor(), proc, Long.MAX_VALUE);
        }
        LOG.info("Move tables done: moved {} tables to {}", (Object)tables.size(), (Object)targetGroup);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Tables moved to {}: {}", (Object)targetGroup, tables);
        }
    }

    @Override
    public void setRSGroup(Set<TableName> tables, String groupName) throws IOException {
        this.getRSGroupInfo(groupName);
        this.moveTablesAndWait(tables, groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveServers(Set<Address> servers, String targetGroupName) throws IOException {
        if (servers == null) {
            throw new ConstraintException("The list of servers to move cannot be null.");
        }
        if (servers.isEmpty()) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)targetGroupName)) {
            throw new ConstraintException("RSGroup cannot be null.");
        }
        RSGroupInfoManagerImpl rSGroupInfoManagerImpl = this;
        synchronized (rSGroupInfoManagerImpl) {
            Address firstServer = servers.iterator().next();
            RSGroupInfo srcGrp = this.getRSGroupOfServer(firstServer);
            if (srcGrp == null) {
                throw new ConstraintException("Server " + firstServer + " is either offline or it does not exist.");
            }
            if ("default".equals(srcGrp.getName())) {
                if (srcGrp.getServers().size() <= servers.size()) {
                    throw new ConstraintException(KEEP_ONE_SERVER_IN_DEFAULT_ERROR_MESSAGE);
                }
                this.checkOnlineServersOnly(servers);
            }
            for (Address server : servers) {
                String tmpGroup = this.getRSGroupOfServer(server).getName();
                if (tmpGroup.equals(srcGrp.getName())) continue;
                throw new ConstraintException("Move server request should only come from one source RSGroup. Expecting only " + srcGrp.getName() + " but contains " + tmpGroup);
            }
            if (srcGrp.getServers().size() <= servers.size()) {
                for (TableDescriptor td : this.masterServices.getTableDescriptors().getAll().values()) {
                    Optional optGroupName = td.getRegionServerGroup();
                    if (!optGroupName.isPresent() || !((String)optGroupName.get()).equals(srcGrp.getName())) continue;
                    throw new ConstraintException("Cannot leave a RSGroup " + srcGrp.getName() + " that contains tables('" + td.getTableName() + "' at least) without servers to host them.");
                }
            }
            Set<Address> movedServers = this.moveServers(servers, srcGrp.getName(), targetGroupName);
            this.moveServerRegionsFromGroup(movedServers, srcGrp.getServers(), targetGroupName, srcGrp.getName());
            LOG.info("Move servers done: moved {} servers from {} to {}", new Object[]{movedServers.size(), srcGrp.getName(), targetGroupName});
            if (LOG.isDebugEnabled()) {
                LOG.debug("Servers moved from {} to {}: {}", new Object[]{srcGrp.getName(), targetGroupName, movedServers});
            }
        }
    }

    @Override
    public String determineRSGroupInfoForTable(TableName tableName) {
        return this.script.getRSGroup(tableName.getNamespaceAsString(), tableName.getQualifierAsString());
    }

    @Override
    public synchronized void renameRSGroup(String oldName, String newName) throws IOException {
        if (oldName.equals("default")) {
            throw new ConstraintException("default can't be rename");
        }
        this.checkGroupName(newName);
        RSGroupInfo oldRSG = this.getRSGroupInfo(oldName);
        ImmutableMap<String, RSGroupInfo> rsGroupMap = this.holder.groupName2Group;
        if (rsGroupMap.containsKey(newName)) {
            throw new ConstraintException("Group already exists: " + newName);
        }
        HashMap newGroupMap = Maps.newHashMap(rsGroupMap);
        newGroupMap.remove(oldRSG.getName());
        RSGroupInfo newRSG = new RSGroupInfo(newName, oldRSG.getServers());
        newGroupMap.put(newName, newRSG);
        this.flushConfig(newGroupMap);
        Set<TableName> updateTables = this.masterServices.getTableDescriptors().getAll().values().stream().filter(t -> oldName.equals(t.getRegionServerGroup().orElse(null))).map(TableDescriptor::getTableName).collect(Collectors.toSet());
        this.setRSGroup(updateTables, newName);
        LOG.info("Rename RSGroup done: {} => {}", (Object)oldName, (Object)newName);
    }

    @Override
    public synchronized void updateRSGroupConfig(String groupName, Map<String, String> configuration) throws IOException {
        if ("default".equals(groupName)) {
            throw new ConstraintException("configuration of default can't be stored persistently");
        }
        RSGroupInfo rsGroupInfo = this.getRSGroupInfo(groupName);
        rsGroupInfo.getConfiguration().forEach((k, v) -> rsGroupInfo.removeConfiguration(k));
        configuration.forEach((k, v) -> rsGroupInfo.setConfiguration(k, v));
        this.flushConfig();
    }

    static {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)RSGROUP_TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])META_FAMILY_BYTES)).setRegionSplitPolicyClassName(DisabledRegionSplitPolicy.class.getName());
        try {
            builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)MultiRowMutationEndpoint.class.getName()).setPriority(0x1FFFFFFF).build());
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        RSGROUP_TABLE_DESC = builder.build();
    }

    private class RSGroupStartupWorker
    extends Thread {
        private final Logger LOG;
        private volatile boolean online;

        RSGroupStartupWorker() {
            super(RSGroupStartupWorker.class.getName() + "-" + RSGroupInfoManagerImpl.this.masterServices.getServerName());
            this.LOG = LoggerFactory.getLogger(RSGroupStartupWorker.class);
            this.online = false;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (this.waitForGroupTableOnline()) {
                this.LOG.info("GroupBasedLoadBalancer is now online");
            } else {
                this.LOG.warn("Quit without making region group table online");
            }
        }

        private boolean waitForGroupTableOnline() {
            while (RSGroupInfoManagerImpl.isMasterRunning(RSGroupInfoManagerImpl.this.masterServices)) {
                try {
                    TableStateManager tsm = RSGroupInfoManagerImpl.this.masterServices.getTableStateManager();
                    if (!tsm.isTablePresent(RSGROUP_TABLE_NAME)) {
                        this.createRSGroupTable();
                    }
                    FutureUtils.get((Future)RSGroupInfoManagerImpl.this.conn.getTable(RSGROUP_TABLE_NAME).get(new Get(ROW_KEY)));
                    this.LOG.info("RSGroup table={} is online, refreshing cached information", (Object)RSGROUP_TABLE_NAME);
                    RSGroupInfoManagerImpl.this.refresh(true);
                    this.online = true;
                    RSGroupInfoManagerImpl.this.flushConfig();
                    RSGroupInfoManagerImpl.this.migrate();
                    return true;
                }
                catch (Exception e) {
                    this.LOG.warn("Failed to perform check", (Throwable)e);
                    Threads.sleepWithoutInterrupt((long)100L);
                }
            }
            return false;
        }

        private void createRSGroupTable() throws IOException {
            int tries;
            long procId;
            OptionalLong optProcId = RSGroupInfoManagerImpl.this.masterServices.getProcedures().stream().filter(p -> p instanceof CreateTableProcedure).map(p -> (CreateTableProcedure)p).filter(p -> p.getTableName().equals((Object)RSGROUP_TABLE_NAME)).mapToLong(Procedure::getProcId).findFirst();
            if (optProcId.isPresent()) {
                procId = optProcId.getAsLong();
            } else {
                this.LOG.debug("Creating group table {}", (Object)RSGROUP_TABLE_NAME);
                procId = RSGroupInfoManagerImpl.this.masterServices.createSystemTable(RSGROUP_TABLE_DESC);
            }
            for (tries = 600; !RSGroupInfoManagerImpl.this.masterServices.getMasterProcedureExecutor().isFinished(procId) && RSGroupInfoManagerImpl.this.masterServices.getMasterProcedureExecutor().isRunning() && tries > 0; --tries) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException("Wait interrupted ", e);
                }
            }
            if (tries <= 0) {
                throw new IOException("Failed to create group table in a given time.");
            }
            Procedure result = RSGroupInfoManagerImpl.this.masterServices.getMasterProcedureExecutor().getResult(procId);
            if (result != null && result.isFailed()) {
                throw new IOException("Failed to create group table. " + MasterProcedureUtil.unwrapRemoteIOException(result));
            }
        }

        public boolean isOnline() {
            return this.online;
        }
    }

    static class RSGroupMappingScript {
        static final String RS_GROUP_MAPPING_SCRIPT = "hbase.rsgroup.table.mapping.script";
        static final String RS_GROUP_MAPPING_SCRIPT_TIMEOUT = "hbase.rsgroup.table.mapping.script.timeout";
        private final String script;
        private final long scriptTimeout;

        RSGroupMappingScript(Configuration conf) {
            this.script = conf.get(RS_GROUP_MAPPING_SCRIPT);
            this.scriptTimeout = conf.getLong(RS_GROUP_MAPPING_SCRIPT_TIMEOUT, 5000L);
        }

        String getRSGroup(String namespace, String tablename) {
            if (this.script == null || this.script.isEmpty()) {
                return null;
            }
            Shell.ShellCommandExecutor rsgroupMappingScript = new Shell.ShellCommandExecutor(new String[]{this.script, "", ""}, null, null, this.scriptTimeout);
            String[] exec = rsgroupMappingScript.getExecString();
            exec[1] = namespace;
            exec[2] = tablename;
            try {
                rsgroupMappingScript.execute();
            }
            catch (IOException e) {
                LOG.error("{}, placing {} back to default rsgroup", (Object)e.getMessage(), (Object)TableName.valueOf((String)namespace, (String)tablename));
                return "default";
            }
            return rsgroupMappingScript.getOutput().trim();
        }
    }

    private static final class RSGroupInfoHolder {
        final ImmutableMap<String, RSGroupInfo> groupName2Group;
        final ImmutableMap<TableName, RSGroupInfo> tableName2Group;

        RSGroupInfoHolder() {
            this(Collections.emptyMap());
        }

        RSGroupInfoHolder(Map<String, RSGroupInfo> rsGroupMap) {
            ImmutableMap.Builder group2Name2GroupBuilder = ImmutableMap.builder();
            ImmutableMap.Builder tableName2GroupBuilder = ImmutableMap.builder();
            rsGroupMap.forEach((groupName, rsGroupInfo) -> {
                group2Name2GroupBuilder.put(groupName, rsGroupInfo);
                if (!groupName.equals("default")) {
                    rsGroupInfo.getTables().forEach(tableName -> tableName2GroupBuilder.put(tableName, rsGroupInfo));
                }
            });
            this.groupName2Group = group2Name2GroupBuilder.build();
            this.tableName2Group = tableName2GroupBuilder.build();
        }
    }
}

