/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MoveWithAck
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(MoveWithAck.class);
    private final RegionInfo region;
    private final ServerName targetServer;
    private final List<RegionInfo> movedRegions;
    private final ServerName sourceServer;
    private final Connection conn;
    private final Admin admin;

    MoveWithAck(Connection conn, RegionInfo regionInfo, ServerName sourceServer, ServerName targetServer, List<RegionInfo> movedRegions) throws IOException {
        this.conn = conn;
        this.region = regionInfo;
        this.targetServer = targetServer;
        this.movedRegions = movedRegions;
        this.sourceServer = sourceServer;
        this.admin = conn.getAdmin();
    }

    @Override
    public Boolean call() throws IOException, InterruptedException {
        boolean moved = false;
        int count = 0;
        int retries = this.admin.getConfiguration().getInt("hbase.move.retries.max", 5);
        int maxWaitInSeconds = this.admin.getConfiguration().getInt("hbase.move.wait.max", 60);
        long startTime = EnvironmentEdgeManager.currentTime();
        boolean sameServer = true;
        this.isSuccessfulScan(this.region);
        LOG.info("Moving region: {} from {} to {}", new Object[]{this.region.getRegionNameAsString(), this.sourceServer, this.targetServer});
        while (count < retries && sameServer) {
            if (count > 0) {
                LOG.debug("Retry {} of maximum {} for region: {}", new Object[]{count, retries, this.region.getRegionNameAsString()});
            }
            ++count;
            this.admin.move(this.region.getEncodedNameAsBytes(), this.targetServer);
            long maxWait = startTime + (long)(maxWaitInSeconds * 1000);
            while (EnvironmentEdgeManager.currentTime() < maxWait && (sameServer = this.isSameServer(this.region, this.sourceServer))) {
                Thread.sleep(1000L);
            }
        }
        if (sameServer) {
            LOG.error("Region: {} stuck on {} for {} sec , newServer={}", new Object[]{this.region.getRegionNameAsString(), this.sourceServer, MoveWithAck.getTimeDiffInSec(startTime), this.targetServer});
        } else {
            this.isSuccessfulScan(this.region);
            LOG.info("Moved Region {} , cost (sec): {}", (Object)this.region.getRegionNameAsString(), (Object)MoveWithAck.getTimeDiffInSec(startTime));
            moved = true;
            this.movedRegions.add(this.region);
        }
        return moved;
    }

    private static String getTimeDiffInSec(long startTime) {
        return String.format("%.3f", Float.valueOf((float)(EnvironmentEdgeManager.currentTime() - startTime) / 1000.0f));
    }

    private void isSuccessfulScan(RegionInfo region) throws IOException {
        Scan scan = new Scan().withStartRow(region.getStartKey()).setRaw(true).setOneRowLimit().setMaxResultSize(1L).setCaching(1).setFilter((Filter)new FirstKeyOnlyFilter()).setCacheBlocks(false);
        try (Table table = this.conn.getTable(region.getTable());
             ResultScanner scanner = table.getScanner(scan);){
            scanner.next();
        }
        catch (IOException e) {
            LOG.error("Could not scan region: {}", (Object)region.getEncodedName(), (Object)e);
            throw e;
        }
    }

    private boolean isSameServer(RegionInfo region, ServerName serverName) throws IOException {
        ServerName serverForRegion = MoveWithAck.getServerNameForRegion(region, this.admin, this.conn);
        return serverForRegion != null && serverForRegion.equals((Object)serverName);
    }

    static ServerName getServerNameForRegion(RegionInfo region, Admin admin, Connection conn) throws IOException {
        if (!admin.isTableEnabled(region.getTable())) {
            return null;
        }
        HRegionLocation loc = conn.getRegionLocator(region.getTable()).getRegionLocation(region.getStartKey(), region.getReplicaId(), true);
        if (loc != null) {
            return loc.getServerName();
        }
        return null;
    }
}

