/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationQueueData;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.util.HbckErrorReporter;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationChecker.class);
    private final HbckErrorReporter errorReporter;
    private Map<ServerName, List<ReplicationQueueId>> undeletedQueueIds = new HashMap<ServerName, List<ReplicationQueueId>>();
    private Set<String> undeletedHFileRefsPeerIds = new HashSet<String>();
    private final ReplicationPeerStorage peerStorage;
    private final ReplicationQueueStorage queueStorage;

    public ReplicationChecker(Configuration conf, ZKWatcher zkw, Connection conn, HbckErrorReporter errorReporter) throws IOException {
        this.peerStorage = ReplicationStorageFactory.getReplicationPeerStorage((FileSystem)FileSystem.get((Configuration)conf), (ZKWatcher)zkw, (Configuration)conf);
        this.queueStorage = ReplicationStorageFactory.getReplicationQueueStorage((Connection)conn, (Configuration)conf);
        this.errorReporter = errorReporter;
    }

    public boolean hasUnDeletedQueues() {
        return this.errorReporter.getErrorList().contains((Object)HbckErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE);
    }

    private Map<ServerName, List<ReplicationQueueId>> getUnDeletedQueues() throws ReplicationException {
        HashMap<ServerName, List<ReplicationQueueId>> undeletedQueues = new HashMap<ServerName, List<ReplicationQueueId>>();
        HashSet peerIds = new HashSet(this.peerStorage.listPeerIds());
        for (ReplicationQueueData queueData : this.queueStorage.listAllQueues()) {
            ReplicationQueueId queueId = queueData.getId();
            if (peerIds.contains(queueId.getPeerId())) continue;
            undeletedQueues.computeIfAbsent(queueId.getServerName(), key -> new ArrayList()).add(queueId);
            LOG.debug("Undeleted replication queue for removed peer found: [removedPeerId={}, replicator={}, queueId={}]", new Object[]{queueId.getPeerId(), queueId.getServerName(), queueId});
        }
        return undeletedQueues;
    }

    private Set<String> getUndeletedHFileRefsPeers() throws ReplicationException {
        HashSet<String> undeletedHFileRefsPeerIds = new HashSet<String>(this.queueStorage.getAllPeersFromHFileRefsQueue());
        HashSet peerIds = new HashSet(this.peerStorage.listPeerIds());
        undeletedHFileRefsPeerIds.removeAll(peerIds);
        if (LOG.isDebugEnabled()) {
            for (String peerId : undeletedHFileRefsPeerIds) {
                LOG.debug("Undeleted replication hfile-refs queue for removed peer {} found", (Object)peerId);
            }
        }
        return undeletedHFileRefsPeerIds;
    }

    public void checkUnDeletedQueues() throws ReplicationException {
        this.undeletedQueueIds = this.getUnDeletedQueues();
        this.undeletedQueueIds.forEach((replicator, queueIds) -> queueIds.forEach(queueId -> {
            String msg = "Undeleted replication queue for removed peer found: " + String.format("[removedPeerId=%s, replicator=%s, queueId=%s]", queueId.getPeerId(), replicator, queueId);
            this.errorReporter.reportError(HbckErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE, msg);
        }));
        this.undeletedHFileRefsPeerIds = this.getUndeletedHFileRefsPeers();
        this.undeletedHFileRefsPeerIds.stream().map(peerId -> "Undeleted replication hfile-refs queue for removed peer " + peerId + " found").forEach(msg -> this.errorReporter.reportError(HbckErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE, (String)msg));
    }

    public void fixUnDeletedQueues() throws ReplicationException {
        for (Map.Entry<ServerName, List<ReplicationQueueId>> replicatorAndQueueIds : this.undeletedQueueIds.entrySet()) {
            ServerName replicator = replicatorAndQueueIds.getKey();
            for (ReplicationQueueId queueId : replicatorAndQueueIds.getValue()) {
                this.queueStorage.removeQueue(queueId);
            }
        }
        for (String peerId : this.undeletedHFileRefsPeerIds) {
            this.queueStorage.removePeerFromHFileRefs(peerId);
        }
    }
}

