/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.locking.EntityLock;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.quotas.RegionServerRpcQuotaManager;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.quotas.RegionSizeStore;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.LeaseManager;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ReplicationSourceService;
import org.apache.hadoop.hbase.regionserver.SecureBulkLoadManager;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequester;
import org.apache.hadoop.hbase.regionserver.regionreplication.RegionReplicationBufferManager;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.protobuf.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockRegionServerServices
implements RegionServerServices {
    protected static final Logger LOG = LoggerFactory.getLogger(MockRegionServerServices.class);
    private final Map<String, HRegion> regions = new HashMap<String, HRegion>();
    private final ConcurrentSkipListMap<byte[], Boolean> rit = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private HFileSystem hfs = null;
    private final Configuration conf;
    private ZKWatcher zkw = null;
    private ServerName serverName = null;
    private RpcServerInterface rpcServer = null;
    private volatile boolean abortRequested;
    private volatile boolean stopping = false;
    private final AtomicBoolean running = new AtomicBoolean(true);

    public MockRegionServerServices(ZKWatcher zkw) {
        this(zkw, null);
    }

    public MockRegionServerServices(ZKWatcher zkw, ServerName serverName) {
        this.zkw = zkw;
        this.serverName = serverName;
        this.conf = zkw == null ? new Configuration() : zkw.getConfiguration();
    }

    public MockRegionServerServices() {
        this(null, null);
    }

    public MockRegionServerServices(Configuration conf) {
        this.conf = conf;
    }

    public boolean removeRegion(HRegion r, ServerName destination) {
        return this.regions.remove(r.getRegionInfo().getEncodedName()) != null;
    }

    public HRegion getRegion(String encodedRegionName) {
        return this.regions.get(encodedRegionName);
    }

    public List<HRegion> getRegions(TableName tableName) throws IOException {
        return null;
    }

    public List<HRegion> getRegions() {
        return null;
    }

    public void addRegion(HRegion r) {
        this.regions.put(r.getRegionInfo().getEncodedName(), r);
    }

    public void postOpenDeployTasks(RegionServerServices.PostOpenDeployContext context) throws IOException {
        this.addRegion(context.getRegion());
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public RpcServerInterface getRpcServer() {
        return this.rpcServer;
    }

    public void setRpcServer(RpcServerInterface rpc) {
        this.rpcServer = rpc;
    }

    public ConcurrentSkipListMap<byte[], Boolean> getRegionsInTransitionInRS() {
        return this.rit;
    }

    public FlushRequester getFlushRequester() {
        return null;
    }

    public CompactionRequester getCompactionRequestor() {
        return null;
    }

    public Connection getConnection() {
        return null;
    }

    public ZKWatcher getZooKeeper() {
        return this.zkw;
    }

    public CoordinatedStateManager getCoordinatedStateManager() {
        return null;
    }

    public RegionServerAccounting getRegionServerAccounting() {
        return null;
    }

    public RegionServerRpcQuotaManager getRegionServerRpcQuotaManager() {
        return null;
    }

    public ServerName getServerName() {
        return this.serverName;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public void abort(String why, Throwable e) {
        this.abortRequested = true;
        this.stop(why);
    }

    public void stop(String why) {
        this.stopping = true;
        if (this.running.compareAndSet(true, false)) {
            LOG.info("Shutting down due to request '" + why + "'");
        }
    }

    public boolean isStopped() {
        return !this.running.get();
    }

    public boolean isAborted() {
        return this.abortRequested;
    }

    public HFileSystem getFileSystem() {
        return this.hfs;
    }

    public void setFileSystem(FileSystem hfs) {
        this.hfs = (HFileSystem)hfs;
    }

    public LeaseManager getLeaseManager() {
        return null;
    }

    public List<WAL> getWALs() throws IOException {
        return Collections.emptyList();
    }

    public WAL getWAL(RegionInfo regionInfo) throws IOException {
        return null;
    }

    public ExecutorService getExecutorService() {
        return null;
    }

    public ChoreService getChoreService() {
        return null;
    }

    public void updateRegionFavoredNodesMapping(String encodedRegionName, List<HBaseProtos.ServerName> favoredNodes) {
    }

    public InetSocketAddress[] getFavoredNodesForRegion(String encodedRegionName) {
        return null;
    }

    public ServerNonceManager getNonceManager() {
        return null;
    }

    public boolean reportRegionStateTransition(RegionServerServices.RegionStateTransitionContext context) {
        return false;
    }

    public boolean registerService(Service service) {
        return false;
    }

    public HeapMemoryManager getHeapMemoryManager() {
        return null;
    }

    public double getCompactionPressure() {
        return 0.0;
    }

    public ThroughputController getFlushThroughputController() {
        return null;
    }

    public double getFlushPressure() {
        return 0.0;
    }

    public MetricsRegionServer getMetrics() {
        return null;
    }

    public EntityLock regionLock(List<RegionInfo> regionInfos, String description, Abortable abort) throws IOException {
        return null;
    }

    public SecureBulkLoadManager getSecureBulkLoadManager() {
        return null;
    }

    public void unassign(byte[] regionName) throws IOException {
    }

    public RegionServerSpaceQuotaManager getRegionServerSpaceQuotaManager() {
        return null;
    }

    public Connection createConnection(Configuration conf) throws IOException {
        return null;
    }

    public boolean reportRegionSizesForQuotas(RegionSizeStore sizeStore) {
        return true;
    }

    public boolean reportFileArchivalForQuotas(TableName tableName, Collection<Map.Entry<String, Long>> archivedFiles) {
        return true;
    }

    public boolean isClusterUp() {
        return true;
    }

    public ReplicationSourceService getReplicationSourceService() {
        return null;
    }

    public TableDescriptors getTableDescriptors() {
        return null;
    }

    public Optional<BlockCache> getBlockCache() {
        return Optional.empty();
    }

    public Optional<MobFileCache> getMobFileCache() {
        return Optional.empty();
    }

    public AccessChecker getAccessChecker() {
        return null;
    }

    public ZKPermissionWatcher getZKPermissionWatcher() {
        return null;
    }

    public AsyncClusterConnection getAsyncClusterConnection() {
        return null;
    }

    public RegionReplicationBufferManager getRegionReplicationBufferManager() {
        return null;
    }
}

