/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseClusterInterface;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Phoenix"})
@InterfaceStability.Evolving
public class SingleProcessHBaseCluster
extends HBaseClusterInterface {
    private static final Logger LOG = LoggerFactory.getLogger((String)SingleProcessHBaseCluster.class.getName());
    public LocalHBaseCluster hbaseCluster;
    private static int index;

    public SingleProcessHBaseCluster(Configuration conf, int numRegionServers) throws IOException, InterruptedException {
        this(conf, 1, numRegionServers);
    }

    public SingleProcessHBaseCluster(Configuration conf, int numMasters, int numRegionServers) throws IOException, InterruptedException {
        this(conf, numMasters, numRegionServers, null, null);
    }

    public SingleProcessHBaseCluster(Configuration conf, int numMasters, int numRegionServers, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseClusterRegionServer> regionserverClass) throws IOException, InterruptedException {
        this(conf, numMasters, 0, numRegionServers, null, masterClass, regionserverClass);
    }

    public SingleProcessHBaseCluster(Configuration conf, int numMasters, int numAlwaysStandByMasters, int numRegionServers, List<Integer> rsPorts, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseClusterRegionServer> regionserverClass) throws IOException, InterruptedException {
        super(conf);
        ((MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class)).init();
        this.init(numMasters, numAlwaysStandByMasters, numRegionServers, rsPorts, masterClass, regionserverClass);
        this.initialClusterStatus = this.getClusterMetrics();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    private void init(int nMasterNodes, int numAlwaysStandByMasters, int nRegionNodes, List<Integer> rsPorts, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseClusterRegionServer> regionserverClass) throws IOException, InterruptedException {
        try {
            if (masterClass == null) {
                masterClass = HMaster.class;
            }
            if (regionserverClass == null) {
                regionserverClass = MiniHBaseClusterRegionServer.class;
            }
            this.hbaseCluster = new LocalHBaseCluster(this.conf, nMasterNodes, numAlwaysStandByMasters, 0, masterClass, regionserverClass);
            for (int i = 0; i < nRegionNodes; ++i) {
                Configuration rsConf = HBaseConfiguration.create((Configuration)this.conf);
                if (rsPorts != null) {
                    rsConf.setInt("hbase.regionserver.port", rsPorts.get(i).intValue());
                }
                User user = HBaseTestingUtil.getDifferentUser(rsConf, ".hfs." + index++);
                this.hbaseCluster.addRegionServer(rsConf, i, user);
            }
            this.hbaseCluster.startup();
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
        catch (Throwable t) {
            LOG.error("Error starting cluster", t);
            this.shutdown();
            throw new IOException("Shutting down", t);
        }
    }

    @Override
    public void startRegionServer(String hostname, int port) throws IOException {
        Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        newConf.setInt("hbase.regionserver.port", port);
        this.startRegionServer(newConf);
    }

    @Override
    public void killRegionServer(ServerName serverName) throws IOException {
        HRegionServer server = this.getRegionServer(this.getRegionServerIndex(serverName));
        if (server instanceof MiniHBaseClusterRegionServer) {
            LOG.info("Killing " + server.toString());
            ((MiniHBaseClusterRegionServer)server).kill();
        } else {
            this.abortRegionServer(this.getRegionServerIndex(serverName));
        }
    }

    @Override
    public boolean isKilledRS(ServerName serverName) {
        return MiniHBaseClusterRegionServer.killedServers.contains(serverName);
    }

    @Override
    public void stopRegionServer(ServerName serverName) throws IOException {
        this.stopRegionServer(this.getRegionServerIndex(serverName));
    }

    @Override
    public void suspendRegionServer(ServerName serverName) throws IOException {
        this.suspendRegionServer(this.getRegionServerIndex(serverName));
    }

    @Override
    public void resumeRegionServer(ServerName serverName) throws IOException {
        this.resumeRegionServer(this.getRegionServerIndex(serverName));
    }

    @Override
    public void waitForRegionServerToStop(ServerName serverName, long timeout) throws IOException {
        this.waitOnRegionServer(this.getRegionServerIndex(serverName));
    }

    @Override
    public void startZkNode(String hostname, int port) throws IOException {
        LOG.warn("Starting zookeeper nodes on mini cluster is not supported");
    }

    @Override
    public void killZkNode(ServerName serverName) throws IOException {
        LOG.warn("Aborting zookeeper nodes on mini cluster is not supported");
    }

    @Override
    public void stopZkNode(ServerName serverName) throws IOException {
        LOG.warn("Stopping zookeeper nodes on mini cluster is not supported");
    }

    @Override
    public void waitForZkNodeToStart(ServerName serverName, long timeout) throws IOException {
        LOG.warn("Waiting for zookeeper nodes to start on mini cluster is not supported");
    }

    @Override
    public void waitForZkNodeToStop(ServerName serverName, long timeout) throws IOException {
        LOG.warn("Waiting for zookeeper nodes to stop on mini cluster is not supported");
    }

    @Override
    public void startDataNode(ServerName serverName) throws IOException {
        LOG.warn("Starting datanodes on mini cluster is not supported");
    }

    @Override
    public void killDataNode(ServerName serverName) throws IOException {
        LOG.warn("Aborting datanodes on mini cluster is not supported");
    }

    @Override
    public void stopDataNode(ServerName serverName) throws IOException {
        LOG.warn("Stopping datanodes on mini cluster is not supported");
    }

    @Override
    public void waitForDataNodeToStart(ServerName serverName, long timeout) throws IOException {
        LOG.warn("Waiting for datanodes to start on mini cluster is not supported");
    }

    @Override
    public void waitForDataNodeToStop(ServerName serverName, long timeout) throws IOException {
        LOG.warn("Waiting for datanodes to stop on mini cluster is not supported");
    }

    @Override
    public void startNameNode(ServerName serverName) throws IOException {
        LOG.warn("Starting namenodes on mini cluster is not supported");
    }

    @Override
    public void killNameNode(ServerName serverName) throws IOException {
        LOG.warn("Aborting namenodes on mini cluster is not supported");
    }

    @Override
    public void stopNameNode(ServerName serverName) throws IOException {
        LOG.warn("Stopping namenodes on mini cluster is not supported");
    }

    @Override
    public void waitForNameNodeToStart(ServerName serverName, long timeout) throws IOException {
        LOG.warn("Waiting for namenodes to start on mini cluster is not supported");
    }

    @Override
    public void waitForNameNodeToStop(ServerName serverName, long timeout) throws IOException {
        LOG.warn("Waiting for namenodes to stop on mini cluster is not supported");
    }

    @Override
    public void startJournalNode(ServerName serverName) {
        LOG.warn("Starting journalnodes on mini cluster is not supported");
    }

    @Override
    public void killJournalNode(ServerName serverName) {
        LOG.warn("Aborting journalnodes on mini cluster is not supported");
    }

    @Override
    public void stopJournalNode(ServerName serverName) {
        LOG.warn("Stopping journalnodes on mini cluster is not supported");
    }

    @Override
    public void waitForJournalNodeToStart(ServerName serverName, long timeout) {
        LOG.warn("Waiting for journalnodes to start on mini cluster is not supported");
    }

    @Override
    public void waitForJournalNodeToStop(ServerName serverName, long timeout) {
        LOG.warn("Waiting for journalnodes to stop on mini cluster is not supported");
    }

    @Override
    public void startMaster(String hostname, int port) throws IOException {
        this.startMaster();
    }

    @Override
    public void killMaster(ServerName serverName) throws IOException {
        this.abortMaster(this.getMasterIndex(serverName));
    }

    @Override
    public void stopMaster(ServerName serverName) throws IOException {
        this.stopMaster(this.getMasterIndex(serverName));
    }

    @Override
    public void waitForMasterToStop(ServerName serverName, long timeout) throws IOException {
        this.waitOnMaster(this.getMasterIndex(serverName));
    }

    public JVMClusterUtil.RegionServerThread startRegionServer() throws IOException {
        Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        return this.startRegionServer(newConf);
    }

    private JVMClusterUtil.RegionServerThread startRegionServer(Configuration configuration) throws IOException {
        User rsUser = HBaseTestingUtil.getDifferentUser(configuration, ".hfs." + index++);
        JVMClusterUtil.RegionServerThread t = null;
        try {
            t = this.hbaseCluster.addRegionServer(configuration, this.hbaseCluster.getRegionServers().size(), rsUser);
            t.start();
            t.waitForServerOnline();
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted adding regionserver to cluster", ie);
        }
        return t;
    }

    public JVMClusterUtil.RegionServerThread startRegionServerAndWait(long timeout) throws IOException {
        JVMClusterUtil.RegionServerThread t = this.startRegionServer();
        ServerName rsServerName = t.getRegionServer().getServerName();
        long start = EnvironmentEdgeManager.currentTime();
        ClusterMetrics clusterStatus = this.getClusterMetrics();
        while (EnvironmentEdgeManager.currentTime() - start < timeout) {
            if (clusterStatus != null && clusterStatus.getLiveServerMetrics().containsKey(rsServerName)) {
                return t;
            }
            Threads.sleep((long)100L);
        }
        if (t.getRegionServer().isOnline()) {
            throw new IOException("RS: " + rsServerName + " online, but not processed by master");
        }
        throw new IOException("RS: " + rsServerName + " is offline");
    }

    public String abortRegionServer(int serverNumber) {
        HRegionServer server = this.getRegionServer(serverNumber);
        LOG.info("Aborting " + server.toString());
        server.abort("Aborting for tests", (Throwable)new Exception("Trace info"));
        return server.toString();
    }

    public JVMClusterUtil.RegionServerThread stopRegionServer(int serverNumber) {
        return this.stopRegionServer(serverNumber, true);
    }

    public JVMClusterUtil.RegionServerThread stopRegionServer(int serverNumber, boolean shutdownFS) {
        JVMClusterUtil.RegionServerThread server = (JVMClusterUtil.RegionServerThread)this.hbaseCluster.getRegionServers().get(serverNumber);
        LOG.info("Stopping " + server.toString());
        server.getRegionServer().stop("Stopping rs " + serverNumber);
        return server;
    }

    public JVMClusterUtil.RegionServerThread suspendRegionServer(int serverNumber) {
        JVMClusterUtil.RegionServerThread server = (JVMClusterUtil.RegionServerThread)this.hbaseCluster.getRegionServers().get(serverNumber);
        LOG.info("Suspending {}", (Object)server.toString());
        server.suspend();
        return server;
    }

    public JVMClusterUtil.RegionServerThread resumeRegionServer(int serverNumber) {
        JVMClusterUtil.RegionServerThread server = (JVMClusterUtil.RegionServerThread)this.hbaseCluster.getRegionServers().get(serverNumber);
        LOG.info("Resuming {}", (Object)server.toString());
        server.resume();
        return server;
    }

    public String waitOnRegionServer(int serverNumber) {
        return this.hbaseCluster.waitOnRegionServer(serverNumber);
    }

    public JVMClusterUtil.MasterThread startMaster() throws IOException {
        Configuration c = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtil.getDifferentUser(c, ".hfs." + index++);
        JVMClusterUtil.MasterThread t = null;
        try {
            t = this.hbaseCluster.addMaster(c, this.hbaseCluster.getMasters().size(), user);
            t.start();
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted adding master to cluster", ie);
        }
        this.conf.set("hbase.masters", this.hbaseCluster.getConfiguration().get("hbase.masters"));
        return t;
    }

    public HMaster getMaster() {
        return this.hbaseCluster.getActiveMaster();
    }

    public JVMClusterUtil.MasterThread getMasterThread() {
        for (JVMClusterUtil.MasterThread mt : this.hbaseCluster.getLiveMasters()) {
            if (!mt.getMaster().isActiveMaster()) continue;
            return mt;
        }
        return null;
    }

    public HMaster getMaster(int serverNumber) {
        return this.hbaseCluster.getMaster(serverNumber);
    }

    public String abortMaster(int serverNumber) {
        HMaster server = this.getMaster(serverNumber);
        LOG.info("Aborting " + server.toString());
        server.abort("Aborting for tests", (Throwable)new Exception("Trace info"));
        return server.toString();
    }

    public JVMClusterUtil.MasterThread stopMaster(int serverNumber) {
        return this.stopMaster(serverNumber, true);
    }

    public JVMClusterUtil.MasterThread stopMaster(int serverNumber, boolean shutdownFS) {
        JVMClusterUtil.MasterThread server = (JVMClusterUtil.MasterThread)this.hbaseCluster.getMasters().get(serverNumber);
        LOG.info("Stopping " + server.toString());
        server.getMaster().stop("Stopping master " + serverNumber);
        return server;
    }

    public String waitOnMaster(int serverNumber) {
        return this.hbaseCluster.waitOnMaster(serverNumber);
    }

    @Override
    public boolean waitForActiveAndReadyMaster(long timeout) throws IOException {
        long start = EnvironmentEdgeManager.currentTime();
        while (EnvironmentEdgeManager.currentTime() - start < timeout) {
            for (JVMClusterUtil.MasterThread mt : this.getMasterThreads()) {
                if (!mt.getMaster().isActiveMaster() || !mt.getMaster().isInitialized()) continue;
                return true;
            }
            Threads.sleep((long)100L);
        }
        return false;
    }

    public List<JVMClusterUtil.MasterThread> getMasterThreads() {
        return this.hbaseCluster.getMasters();
    }

    public List<JVMClusterUtil.MasterThread> getLiveMasterThreads() {
        return this.hbaseCluster.getLiveMasters();
    }

    public void join() {
        this.hbaseCluster.join();
    }

    @Override
    public void shutdown() throws IOException {
        if (this.hbaseCluster != null) {
            this.hbaseCluster.shutdown();
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ClusterMetrics getClusterMetrics() throws IOException {
        HMaster master = this.getMaster();
        return master == null ? null : master.getClusterMetrics();
    }

    private void executeFlush(HRegion region) throws IOException {
        if (!RegionReplicaUtil.isDefaultReplica((RegionInfo)region.getRegionInfo())) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            HRegion.FlushResult result = region.flush(true);
            if (result.getResult() != HRegion.FlushResult.Result.CANNOT_FLUSH) {
                return;
            }
            Threads.sleep((long)1000L);
        }
    }

    public void flushcache() throws IOException {
        for (JVMClusterUtil.RegionServerThread t : this.hbaseCluster.getRegionServers()) {
            for (HRegion r : t.getRegionServer().getOnlineRegionsLocalContext()) {
                this.executeFlush(r);
            }
        }
    }

    public void flushcache(TableName tableName) throws IOException {
        for (JVMClusterUtil.RegionServerThread t : this.hbaseCluster.getRegionServers()) {
            for (HRegion r : t.getRegionServer().getOnlineRegionsLocalContext()) {
                if (!r.getTableDescriptor().getTableName().equals((Object)tableName)) continue;
                this.executeFlush(r);
            }
        }
    }

    public void compact(boolean major) throws IOException {
        for (JVMClusterUtil.RegionServerThread t : this.hbaseCluster.getRegionServers()) {
            for (HRegion r : t.getRegionServer().getOnlineRegionsLocalContext()) {
                if (!RegionReplicaUtil.isDefaultReplica((RegionInfo)r.getRegionInfo())) continue;
                r.compact(major);
            }
        }
    }

    public void compact(TableName tableName, boolean major) throws IOException {
        for (JVMClusterUtil.RegionServerThread t : this.hbaseCluster.getRegionServers()) {
            for (HRegion r : t.getRegionServer().getOnlineRegionsLocalContext()) {
                if (!r.getTableDescriptor().getTableName().equals((Object)tableName) || !RegionReplicaUtil.isDefaultReplica((RegionInfo)r.getRegionInfo())) continue;
                r.compact(major);
            }
        }
    }

    public int getNumLiveRegionServers() {
        return this.hbaseCluster.getLiveRegionServers().size();
    }

    public List<JVMClusterUtil.RegionServerThread> getRegionServerThreads() {
        return this.hbaseCluster.getRegionServers();
    }

    public List<JVMClusterUtil.RegionServerThread> getLiveRegionServerThreads() {
        return this.hbaseCluster.getLiveRegionServers();
    }

    public HRegionServer getRegionServer(int serverNumber) {
        return this.hbaseCluster.getRegionServer(serverNumber);
    }

    public HRegionServer getRegionServer(ServerName serverName) {
        return this.hbaseCluster.getRegionServers().stream().map(t -> t.getRegionServer()).filter(r -> r.getServerName().equals((Object)serverName)).findFirst().orElse(null);
    }

    public List<HRegion> getRegions(byte[] tableName) {
        return this.getRegions(TableName.valueOf((byte[])tableName));
    }

    public List<HRegion> getRegions(TableName tableName) {
        ArrayList<HRegion> ret = new ArrayList<HRegion>();
        for (JVMClusterUtil.RegionServerThread rst : this.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            for (Region region : hrs.getOnlineRegionsLocalContext()) {
                if (!region.getTableDescriptor().getTableName().equals((Object)tableName)) continue;
                ret.add((HRegion)region);
            }
        }
        return ret;
    }

    public int getServerWithMeta() {
        return this.getServerWith(RegionInfoBuilder.FIRST_META_REGIONINFO.getRegionName());
    }

    public int getServerWith(byte[] regionName) {
        int index = 0;
        for (JVMClusterUtil.RegionServerThread rst : this.getRegionServerThreads()) {
            HRegion region;
            HRegionServer hrs = rst.getRegionServer();
            if (!hrs.isStopped() && (region = hrs.getOnlineRegion(regionName)) != null) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public ServerName getServerHoldingRegion(TableName tn, byte[] regionName) throws IOException {
        int index = this.getServerWith(regionName);
        if (index < 0) {
            return null;
        }
        return this.getRegionServer(index).getServerName();
    }

    public long countServedRegions() {
        long count = 0L;
        for (JVMClusterUtil.RegionServerThread rst : this.getLiveRegionServerThreads()) {
            count += (long)rst.getRegionServer().getNumberOfOnlineRegions();
        }
        return count;
    }

    public void killAll() {
        JVMClusterUtil.MasterThread activeMaster = null;
        for (JVMClusterUtil.MasterThread masterThread : this.getMasterThreads()) {
            if (!masterThread.getMaster().isActiveMaster()) {
                masterThread.getMaster().abort("killAll");
                continue;
            }
            activeMaster = masterThread;
        }
        if (activeMaster != null) {
            activeMaster.getMaster().abort("killAll");
        }
        for (JVMClusterUtil.RegionServerThread rst : this.getRegionServerThreads()) {
            rst.getRegionServer().abort("killAll");
        }
    }

    @Override
    public void waitUntilShutDown() {
        this.hbaseCluster.join();
    }

    public List<HRegion> findRegionsForTable(TableName tableName) {
        ArrayList<HRegion> ret = new ArrayList<HRegion>();
        for (JVMClusterUtil.RegionServerThread rst : this.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            for (Region region : hrs.getRegions(tableName)) {
                if (!region.getTableDescriptor().getTableName().equals((Object)tableName)) continue;
                ret.add((HRegion)region);
            }
        }
        return ret;
    }

    protected int getRegionServerIndex(ServerName serverName) {
        List<JVMClusterUtil.RegionServerThread> servers = this.getRegionServerThreads();
        for (int i = 0; i < servers.size(); ++i) {
            if (!servers.get(i).getRegionServer().getServerName().equals((Object)serverName)) continue;
            return i;
        }
        return -1;
    }

    protected int getMasterIndex(ServerName serverName) {
        List<JVMClusterUtil.MasterThread> masters = this.getMasterThreads();
        for (int i = 0; i < masters.size(); ++i) {
            if (!masters.get(i).getMaster().getServerName().equals((Object)serverName)) continue;
            return i;
        }
        return -1;
    }

    static class SingleFileSystemShutdownThread
    extends Thread {
        private final FileSystem fs;

        SingleFileSystemShutdownThread(FileSystem fs) {
            super("Shutdown of " + fs);
            this.fs = fs;
        }

        @Override
        public void run() {
            try {
                LOG.info("Hook closing fs=" + this.fs);
                this.fs.close();
            }
            catch (IOException e) {
                LOG.warn("Running hook", (Throwable)e);
            }
        }
    }

    public static class MiniHBaseClusterRegionServer
    extends HRegionServer {
        private Thread shutdownThread = null;
        private User user = User.getCurrent();
        static Set<ServerName> killedServers = new HashSet<ServerName>();

        public MiniHBaseClusterRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected void handleReportForDutyResponse(RegionServerStatusProtos.RegionServerStartupResponse c) throws IOException {
            super.handleReportForDutyResponse(c);
            this.shutdownThread = new SingleFileSystemShutdownThread(this.getFileSystem());
        }

        public void run() {
            try {
                this.user.runAs((PrivilegedAction)new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        this.runRegionServer();
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                LOG.error("Exception in run", t);
            }
            finally {
                if (this.shutdownThread != null) {
                    this.shutdownThread.start();
                    Threads.shutdown((Thread)this.shutdownThread, (long)30000L);
                }
            }
        }

        private void runRegionServer() {
            super.run();
        }

        protected void kill() {
            killedServers.add(this.getServerName());
            super.kill();
        }

        public void abort(final String reason, final Throwable cause) {
            this.user.runAs((PrivilegedAction)new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    this.abortRegionServer(reason, cause);
                    return null;
                }
            });
        }

        private void abortRegionServer(String reason, Throwable cause) {
            super.abort(reason, cause);
        }
    }
}

