/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMovedRegionCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMovedRegionCache.class);
    @Rule
    public TestName name = new TestName();
    private HBaseTestingUtil UTIL;
    private MiniZooKeeperCluster zkCluster;
    private HRegionServer source;
    private HRegionServer dest;
    private RegionInfo movedRegionInfo;

    @Before
    public void setup() throws Exception {
        this.UTIL = new HBaseTestingUtil();
        this.zkCluster = this.UTIL.startMiniZKCluster();
        StartTestingClusterOption option = StartTestingClusterOption.builder().numRegionServers(2).build();
        SingleProcessHBaseCluster cluster = this.UTIL.startMiniHBaseCluster(option);
        this.source = cluster.getRegionServer(0);
        this.dest = cluster.getRegionServer(1);
        Assert.assertEquals((long)2L, (long)cluster.getRegionServerThreads().size());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.UTIL.createTable(tableName, Bytes.toBytes((String)"cf"));
        this.UTIL.waitTableAvailable(tableName, 30000L);
        this.movedRegionInfo = ((HRegion)Iterables.getOnlyElement(cluster.getRegions(tableName))).getRegionInfo();
        this.UTIL.getAdmin().move(this.movedRegionInfo.getEncodedNameAsBytes(), this.source.getServerName());
        this.UTIL.waitFor(2000L, (Waiter.Predicate)new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                return TestMovedRegionCache.this.source.getOnlineRegion(TestMovedRegionCache.this.movedRegionInfo.getRegionName()) != null;
            }
        });
    }

    @After
    public void after() throws Exception {
        this.UTIL.shutdownMiniCluster();
        if (this.zkCluster != null) {
            this.zkCluster.shutdown();
        }
    }

    @Test
    public void testMovedRegionsCache() throws IOException, InterruptedException {
        this.UTIL.getAdmin().move(this.movedRegionInfo.getEncodedNameAsBytes(), this.dest.getServerName());
        this.UTIL.waitFor(2000L, (Waiter.Predicate)new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                return TestMovedRegionCache.this.dest.getOnlineRegion(TestMovedRegionCache.this.movedRegionInfo.getRegionName()) != null;
            }
        });
        Assert.assertNotNull((String)"Moved region NOT in the cache!", (Object)this.source.getMovedRegion(this.movedRegionInfo.getEncodedName()));
        Thread.sleep(this.source.movedRegionCacheExpiredTime());
        Assert.assertNull((String)"Expired moved region exist in the cache!", (Object)this.source.getMovedRegion(this.movedRegionInfo.getEncodedName()));
    }
}

