/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class AbstractTestCITimeout {
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    protected static final byte[] FAM_NAM = Bytes.toBytes((String)"f");
    @Rule
    public final TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.status.published", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 5);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.handler.count", 3);
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public static class SleepCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public static final int SLEEP_TIME = 5000;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            Threads.sleep((long)5000L);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            Threads.sleep((long)5000L);
        }

        public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
            Threads.sleep((long)5000L);
            return null;
        }

        public void preDelete(ObserverContext<RegionCoprocessorEnvironment> e, Delete delete, WALEdit edit, Durability durability) throws IOException {
            Threads.sleep((long)5000L);
        }
    }

    public static class SleepAndFailFirstTime
    implements RegionCoprocessor,
    RegionObserver {
        static final AtomicLong ct = new AtomicLong(0L);
        static final String SLEEP_TIME_CONF_KEY = "hbase.coprocessor.SleepAndFailFirstTime.sleepTime";
        static final long DEFAULT_SLEEP_TIME = 20000L;
        static final AtomicLong sleepTime = new AtomicLong(20000L);

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)c.getEnvironment();
            Configuration conf = env.getConfiguration();
            sleepTime.set(conf.getLong(SLEEP_TIME_CONF_KEY, 20000L));
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            Threads.sleep((long)sleepTime.get());
            if (ct.incrementAndGet() == 1L) {
                throw new IOException("first call I fail");
            }
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            Threads.sleep((long)sleepTime.get());
            if (ct.incrementAndGet() == 1L) {
                throw new IOException("first call I fail");
            }
        }

        public void preDelete(ObserverContext<RegionCoprocessorEnvironment> e, Delete delete, WALEdit edit, Durability durability) throws IOException {
            Threads.sleep((long)sleepTime.get());
            if (ct.incrementAndGet() == 1L) {
                throw new IOException("first call I fail");
            }
        }

        public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
            Threads.sleep((long)sleepTime.get());
            if (ct.incrementAndGet() == 1L) {
                throw new IOException("first call I fail");
            }
            return null;
        }
    }
}

