/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public class RestoreSnapshotFromClientTestBase {
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    protected final byte[] FAMILY = Bytes.toBytes((String)"cf");
    protected final byte[] TEST_FAMILY2 = Bytes.toBytes((String)"cf2");
    protected TableName tableName;
    protected String emptySnapshot;
    protected String snapshotName0;
    protected String snapshotName1;
    protected String snapshotName2;
    protected int snapshot0Rows;
    protected int snapshot1Rows;
    protected Admin admin;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupCluster() throws Exception {
        RestoreSnapshotFromClientTestBase.setupConf(TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(3);
    }

    protected static void setupConf(Configuration conf) {
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        this.admin = TEST_UTIL.getAdmin();
        long tid = EnvironmentEdgeManager.currentTime();
        this.tableName = TableName.valueOf((String)(this.getValidMethodName() + "-" + tid));
        this.emptySnapshot = "emptySnaptb-" + tid;
        this.snapshotName0 = "snaptb0-" + tid;
        this.snapshotName1 = "snaptb1-" + tid;
        this.snapshotName2 = "snaptb2-" + tid;
        this.createTable();
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.emptySnapshot, this.tableName);
        this.admin.enableTable(this.tableName);
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        try (Table table = TEST_UTIL.getConnection().getTable(this.tableName);){
            this.snapshot0Rows = this.countRows(table, new byte[0][]);
        }
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName0, this.tableName);
        this.admin.enableTable(this.tableName);
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        table = TEST_UTIL.getConnection().getTable(this.tableName);
        var4_3 = null;
        try {
            this.snapshot1Rows = this.countRows(table, new byte[0][]);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var4_3 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
    }

    protected void createTable() throws Exception {
        SnapshotTestingUtils.createTable(TEST_UTIL, this.tableName, this.getNumReplicas(), (byte[][])new byte[][]{this.FAMILY});
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.deleteTable(this.tableName);
        SnapshotTestingUtils.deleteAllSnapshots(TEST_UTIL.getAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(TEST_UTIL);
    }

    protected int getNumReplicas() {
        return 1;
    }

    protected int countRows(Table table, byte[] ... families) throws IOException {
        return HBaseTestingUtil.countRows(table, families);
    }

    protected void verifyRowCount(HBaseTestingUtil util, TableName tableName, long expectedRows) throws IOException {
        SnapshotTestingUtils.verifyRowCount(util, tableName, expectedRows);
    }

    protected final void splitRegion(RegionInfo regionInfo) throws IOException {
        byte[][] splitPoints = Bytes.split((byte[])regionInfo.getStartKey(), (byte[])regionInfo.getEndKey(), (int)1);
        this.admin.split(regionInfo.getTable(), splitPoints[1]);
    }

    protected final String getValidMethodName() {
        return this.name.getMethodName().replaceAll("[^0-9A-Za-z_]", "_");
    }
}

