/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Cursor;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ScanPerNextResultScanner
implements ResultScanner,
AdvancedScanResultConsumer {
    private final AsyncTable<AdvancedScanResultConsumer> table;
    private final Scan scan;
    private final Queue<Result> queue = new ArrayDeque<Result>();
    private ScanMetrics scanMetrics;
    private boolean closed = false;
    private Throwable error;
    private AdvancedScanResultConsumer.ScanResumer resumer;

    public ScanPerNextResultScanner(AsyncTable<AdvancedScanResultConsumer> table, Scan scan) {
        this.table = table;
        this.scan = scan;
    }

    public synchronized void onError(Throwable error) {
        this.error = error;
        this.notifyAll();
    }

    public synchronized void onComplete() {
        this.closed = true;
        this.notifyAll();
    }

    public void onScanMetricsCreated(ScanMetrics scanMetrics) {
        this.scanMetrics = scanMetrics;
    }

    public synchronized void onNext(Result[] results, AdvancedScanResultConsumer.ScanController controller) {
        assert (results.length > 0);
        if (this.closed) {
            controller.terminate();
            return;
        }
        for (Result result : results) {
            this.queue.add(result);
        }
        this.notifyAll();
        this.resumer = controller.suspend();
    }

    public synchronized void onHeartbeat(AdvancedScanResultConsumer.ScanController controller) {
        if (this.closed) {
            controller.terminate();
            return;
        }
        if (this.scan.isNeedCursorResult()) {
            controller.cursor().ifPresent(c -> this.queue.add(Result.createCursorResult((Cursor)c)));
        }
    }

    public synchronized Result next() throws IOException {
        if (this.queue.isEmpty()) {
            if (this.resumer != null) {
                this.resumer.resume();
                this.resumer = null;
            } else {
                this.table.scan(this.scan, (ScanResultConsumerBase)this);
            }
        }
        while (this.queue.isEmpty()) {
            if (this.closed) {
                return null;
            }
            if (this.error != null) {
                Throwables.propagateIfPossible((Throwable)this.error, IOException.class);
                throw new IOException(this.error);
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
        return this.queue.poll();
    }

    public synchronized void close() {
        this.closed = true;
        this.queue.clear();
        if (this.resumer != null) {
            this.resumer.resume();
            this.resumer = null;
        }
        this.notifyAll();
    }

    public boolean renewLease() {
        return false;
    }

    public ScanMetrics getScanMetrics() {
        return this.scanMetrics;
    }
}

