/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanPerNextResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.regionserver.DelegatingInternalScanner;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class, ClientTests.class})
public class TestAvoidCellReferencesIntoShippedBlocks {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAvoidCellReferencesIntoShippedBlocks.class);
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    static byte[][] ROWS = new byte[2][];
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[] ROW1 = Bytes.toBytes((String)"testRow1");
    private static byte[] ROW2 = Bytes.toBytes((String)"testRow2");
    private static byte[] ROW3 = Bytes.toBytes((String)"testRow3");
    private static byte[] ROW4 = Bytes.toBytes((String)"testRow4");
    private static byte[] ROW5 = Bytes.toBytes((String)"testRow5");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[][] FAMILIES_1 = new byte[1][0];
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] QUALIFIER1 = Bytes.toBytes((String)"testQualifier1");
    private static byte[] data = new byte[1000];
    protected static int SLAVES = 1;
    private CountDownLatch latch = new CountDownLatch(1);
    private static CountDownLatch compactReadLatch = new CountDownLatch(1);
    private static AtomicBoolean doScan = new AtomicBoolean(false);
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestAvoidCellReferencesIntoShippedBlocks.ROWS[0] = ROW;
        TestAvoidCellReferencesIntoShippedBlocks.ROWS[1] = ROW1;
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{MultiRowMutationEndpoint.class.getName()});
        conf.setInt("hbase.regionserver.handler.count", 20);
        conf.setInt("hbase.bucketcache.size", 400);
        conf.setStrings("hbase.bucketcache.ioengine", new String[]{"offheap"});
        conf.setInt("hbase.hstore.compactionThreshold", 7);
        conf.setFloat("hfile.block.cache.size", 0.2f);
        conf.setFloat("hbase.regionserver.global.memstore.size", 0.1f);
        conf.setInt("hbase.client.retries.number", 0);
        conf.setInt("hbase.client.scanner.timeout.period", 500000);
        TestAvoidCellReferencesIntoShippedBlocks.FAMILIES_1[0] = FAMILY;
        TEST_UTIL.startMiniCluster(SLAVES);
        compactReadLatch = new CountDownLatch(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBase16372InCompactionWritePath() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Table table = TEST_UTIL.createTable(tableName, FAMILIES_1, 1, 1024, CompactorRegionObserver.class.getName());){
            int count;
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegion().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER1, data);
            table.put(put);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER1, data);
            table.put(put);
            put = new Put(ROW2);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW2);
            put.addColumn(FAMILY, QUALIFIER1, data);
            table.put(put);
            region.flush(true);
            put = new Put(ROW3);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW3);
            put.addColumn(FAMILY, QUALIFIER1, data);
            table.put(put);
            put = new Put(ROW4);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            put = new Put(ROW4);
            put.addColumn(FAMILY, QUALIFIER1, data);
            table.put(put);
            put = new Put(ROW5);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW5);
            put.addColumn(FAMILY, QUALIFIER1, data);
            table.put(put);
            region.flush(true);
            Scan s = new Scan();
            s.setMaxResultSize(1000L);
            try (ResultScanner scanner = table.getScanner(s);){
                count = Iterables.size((Iterable)scanner);
            }
            Assert.assertEquals((String)"Count all the rows ", (long)6L, (long)count);
            ScannerThread scannerThread = new ScannerThread(table, cache);
            scannerThread.start();
            region.compact(true);
            s = new Scan();
            s.setMaxResultSize(1000L);
            try (ResultScanner scanner = table.getScanner(s);){
                count = Iterables.size((Iterable)scanner);
            }
            Assert.assertEquals((String)"Count all the rows ", (long)6L, (long)count);
        }
    }

    @Test
    public void testHBASE16372InReadPath() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (final Table table = TEST_UTIL.createTable(tableName, FAMILIES_1, 1, 1024, null);){
            int count;
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegion().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            final BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER1, data);
            table.put(put);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER1, data);
            table.put(put);
            put = new Put(ROW2);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW2);
            put.addColumn(FAMILY, QUALIFIER1, data);
            table.put(put);
            put = new Put(ROW3);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW3);
            put.addColumn(FAMILY, QUALIFIER1, data);
            table.put(put);
            put = new Put(ROW4);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW4);
            put.addColumn(FAMILY, QUALIFIER1, data);
            table.put(put);
            put = new Put(ROW5);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW5);
            put.addColumn(FAMILY, QUALIFIER1, data);
            table.put(put);
            region.flush(true);
            Scan s = new Scan();
            s.setMaxResultSize(1000L);
            try (ResultScanner scanner = table.getScanner(s);){
                count = Iterables.size((Iterable)scanner);
            }
            Assert.assertEquals((String)"Count all the rows ", (long)6L, (long)count);
            s = new Scan();
            s.setCaching(1);
            s.withStartRow(ROW1);
            s.setAllowPartialResults(true);
            s.setMaxResultSize(1000L);
            scanner = new ScanPerNextResultScanner((AsyncTable<AdvancedScanResultConsumer>)TEST_UTIL.getAsyncConnection().getTable(tableName), s);
            var14_15 = null;
            try {
                Thread evictorThread = new Thread(){

                    @Override
                    public void run() {
                        ArrayList<BlockCacheKey> cacheList = new ArrayList<BlockCacheKey>();
                        for (CachedBlock next : cache) {
                            BlockCacheKey cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                            cacheList.add(cacheKey);
                            TestAvoidCellReferencesIntoShippedBlocks.this.evictBlock(cache, cacheKey);
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException next) {
                            // empty catch block
                        }
                        Iterator iterator = cache.iterator();
                        int refBlockCount = 0;
                        while (iterator.hasNext()) {
                            iterator.next();
                            ++refBlockCount;
                        }
                        Assert.assertEquals((String)"One block should be there ", (long)1L, (long)refBlockCount);
                        Scan s1 = new Scan();
                        s1.withStartRow(ROW3);
                        s1.withStopRow(ROW5);
                        s1.setCaching(1);
                        try (ResultScanner scanner = table.getScanner(s1);){
                            int count = Iterables.size((Iterable)scanner);
                            Assert.assertEquals((String)"Count the rows", (long)2L, (long)count);
                            int newBlockRefCount = 0;
                            ArrayList<BlockCacheKey> newCacheList = new ArrayList<BlockCacheKey>();
                            do {
                                newBlockRefCount = 0;
                                newCacheList.clear();
                                for (CachedBlock next : cache) {
                                    BlockCacheKey cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                                    newCacheList.add(cacheKey);
                                }
                                for (BlockCacheKey key : cacheList) {
                                    if (!newCacheList.contains(key)) continue;
                                    ++newBlockRefCount;
                                }
                            } while (newBlockRefCount != 6);
                            TestAvoidCellReferencesIntoShippedBlocks.this.latch.countDown();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
                count = 0;
                while (scanner.next() != null) {
                    if (++count != 2) continue;
                    evictorThread.start();
                    this.latch.await();
                }
            }
            catch (Throwable throwable) {
                var14_15 = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (var14_15 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            var14_15.addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            Assert.assertEquals((String)"Count should give all rows ", (long)10L, (long)count);
        }
    }

    private void evictBlock(BlockCache blockCache, BlockCacheKey blockCacheKey) {
        BlockCache[] blockCaches;
        Assert.assertTrue((boolean)(blockCache instanceof CombinedBlockCache));
        for (BlockCache currentBlockCache : blockCaches = blockCache.getBlockCaches()) {
            if (currentBlockCache instanceof BucketCache) {
                ((BucketCache)currentBlockCache).evictBlockIfNoRpcReferenced(blockCacheKey);
                continue;
            }
            currentBlockCache.evictBlock(blockCacheKey);
        }
    }

    private static final class CompactorInternalScanner
    extends DelegatingInternalScanner {
        public CompactorInternalScanner(InternalScanner scanner) {
            super(scanner);
        }

        @Override
        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            boolean next = this.scanner.next(result, scannerContext);
            for (Cell cell : result) {
                if (CellComparatorImpl.COMPARATOR.compareRows(cell, ROW2, 0, ROW2.length) != 0) continue;
                try {
                    doScan.compareAndSet(false, true);
                    compactReadLatch.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            return next;
        }
    }

    public static class CompactorRegionObserver
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
            return new CompactorInternalScanner(scanner);
        }
    }

    private static class ScannerThread
    extends Thread {
        private final Table table;
        private final BlockCache cache;

        public ScannerThread(Table table, BlockCache cache) {
            this.table = table;
            this.cache = cache;
        }

        @Override
        public void run() {
            Scan s = new Scan().withStartRow(ROW4).withStopRow(ROW5).setCaching(1);
            try {
                while (!doScan.get()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ArrayList<BlockCacheKey> cacheList = new ArrayList<BlockCacheKey>();
                for (CachedBlock next : this.cache) {
                    BlockCacheKey cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                    cacheList.add(cacheKey);
                    this.cache.evictBlock(cacheKey);
                }
                try (ResultScanner scanner = this.table.getScanner(s);){
                    while (scanner.next() != null) {
                    }
                }
                compactReadLatch.countDown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

