/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestBufferedMutator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBufferedMutator.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static byte[] CQ = Bytes.toBytes((String)"cq");
    private static int COUNT = 1024;
    private static byte[] VALUE = new byte[1024];

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLE_NAME, CF);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        try (BufferedMutator mutator = TEST_UTIL.getConnection().getBufferedMutator(new BufferedMutatorParams(TABLE_NAME).writeBufferSize(65536L));){
            mutator.mutate(IntStream.range(0, COUNT / 2).mapToObj(i -> new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, VALUE)).collect(Collectors.toList()));
            mutator.flush();
            mutator.mutate(IntStream.range(COUNT / 2, COUNT).mapToObj(i -> new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, VALUE)).collect(Collectors.toList()));
            mutator.close();
            this.verifyData();
        }
    }

    private void verifyData() throws IOException {
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            for (int i = 0; i < COUNT; ++i) {
                Result r = table.get(new Get(Bytes.toBytes((int)i)));
                Assert.assertArrayEquals((byte[])VALUE, (byte[])r.getValue(CF, CQ));
            }
        }
    }
}

