/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.TableDescriptorChecker;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;

@Category(value={LargeTests.class, ClientTests.class})
public class TestIllegalTableDescriptor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIllegalTableDescriptor.class);
    private static final Logger LOGGER;
    protected static final HBaseTestingUtil TEST_UTIL;
    private static byte[] FAMILY;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Field field = TableDescriptorChecker.class.getDeclaredField("LOG");
        field.setAccessible(true);
        field.set(null, LOGGER);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.table.sanity.checks", true);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testIllegalTableDescriptor() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName()));
        ColumnFamilyDescriptorBuilder cfBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY);
        this.checkTableIsIllegal(builder.build());
        this.checkTableIsLegal(builder.setColumnFamily(cfBuilder.build()).build());
        builder.setMaxFileSize(1024L);
        this.checkTableIsIllegal(builder.build());
        builder.setMaxFileSize(0L);
        this.checkTableIsIllegal(builder.build());
        builder.setMaxFileSize(0x40000000L);
        this.checkTableIsLegal(builder.build());
        builder.setMemStoreFlushSize(1024L);
        this.checkTableIsIllegal(builder.build());
        builder.setMemStoreFlushSize(0L);
        this.checkTableIsIllegal(builder.build());
        builder.setMemStoreFlushSize(0x8000000L);
        this.checkTableIsLegal(builder.build());
        builder.setRegionSplitPolicyClassName("nonexisting.foo.class");
        this.checkTableIsIllegal(builder.build());
        builder.setRegionSplitPolicyClassName(null);
        this.checkTableIsLegal(builder.build());
        builder.setValue("hbase.regionserver.region.split.policy", "nonexisting.foo.class");
        this.checkTableIsIllegal(builder.build());
        builder.removeValue(Bytes.toBytes((String)"hbase.regionserver.region.split.policy"));
        this.checkTableIsLegal(builder.build());
        cfBuilder.setBlocksize(0);
        this.checkTableIsIllegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        cfBuilder.setBlocksize(0x8000000);
        this.checkTableIsIllegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        cfBuilder.setBlocksize(1024);
        this.checkTableIsLegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        cfBuilder.setTimeToLive(0);
        this.checkTableIsIllegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        cfBuilder.setTimeToLive(-1);
        this.checkTableIsIllegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        cfBuilder.setTimeToLive(1);
        this.checkTableIsLegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        cfBuilder.setMinVersions(-1);
        this.checkTableIsIllegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        cfBuilder.setMinVersions(3);
        try {
            cfBuilder.setMaxVersions(2);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            cfBuilder.setMaxVersions(10);
        }
        this.checkTableIsLegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        cfBuilder.setMaxVersions(4);
        cfBuilder.setMinVersions(5);
        this.checkTableIsIllegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        cfBuilder.setMinVersions(3);
        cfBuilder.setScope(-1);
        this.checkTableIsIllegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        cfBuilder.setScope(0);
        this.checkTableIsLegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        cfBuilder.setValue("IN_MEMORY_COMPACTION", "INVALID");
        this.checkTableIsIllegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        cfBuilder.setValue("IN_MEMORY_COMPACTION", "NONE");
        this.checkTableIsLegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        try {
            cfBuilder.setDFSReplication((short)-1);
            Assert.fail((String)"Illegal value for setDFSReplication did not throw");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        cfBuilder.setValue("DFS_REPLICATION", "-1");
        this.checkTableIsIllegal(builder.modifyColumnFamily(cfBuilder.build()).build());
        try {
            cfBuilder.setDFSReplication((short)-1);
            Assert.fail((String)"Should throw exception if an illegal value is explicitly being set");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        builder.setMemStoreFlushSize(0L);
        builder.setValue("hbase.table.sanity.checks", Boolean.FALSE.toString());
        this.checkTableIsLegal(builder.build());
        ((Logger)Mockito.verify((Object)LOGGER)).warn(ArgumentMatchers.contains((String)"MEMSTORE_FLUSHSIZE for table descriptor or \"hbase.hregion.memstore.flush.size\" (0) is too small, which might cause very frequent flushing."));
    }

    private void checkTableIsLegal(TableDescriptor tableDescriptor) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        admin.createTable(tableDescriptor);
        Assert.assertTrue((boolean)admin.tableExists(tableDescriptor.getTableName()));
        TEST_UTIL.deleteTable(tableDescriptor.getTableName());
    }

    private void checkTableIsIllegal(TableDescriptor tableDescriptor) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        try {
            admin.createTable(tableDescriptor);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)admin.tableExists(tableDescriptor.getTableName()));
    }

    static {
        TEST_UTIL = new HBaseTestingUtil();
        FAMILY = Bytes.toBytes((String)"testFamily");
        LOGGER = (Logger)Mockito.mock(Logger.class);
    }
}

