/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.InvalidMutationDurabilityException;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestInvalidMutationDurabilityException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestInvalidMutationDurabilityException.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static TableName TABLE_NOT_REPLICATE = TableName.valueOf((String)"TableNotReplicate");
    private static TableName TABLE_NEED_REPLICATE = TableName.valueOf((String)"TableNeedReplicate");
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static byte[] CQ = Bytes.toBytes((String)"cq");
    private static Table tableNotReplicate;
    private static Table tableNeedReplicate;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster();
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_NOT_REPLICATE).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).build()).build());
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_NEED_REPLICATE).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).setScope(1).build()).build());
        tableNotReplicate = UTIL.getConnection().getTable(TABLE_NOT_REPLICATE);
        tableNeedReplicate = UTIL.getConnection().getTable(TABLE_NEED_REPLICATE);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.getAdmin().disableTable(TABLE_NOT_REPLICATE);
        UTIL.getAdmin().disableTable(TABLE_NEED_REPLICATE);
        UTIL.getAdmin().deleteTable(TABLE_NOT_REPLICATE);
        UTIL.getAdmin().deleteTable(TABLE_NEED_REPLICATE);
        UTIL.shutdownMiniCluster();
    }

    private Put newPutWithSkipWAL() {
        Put put = new Put(Bytes.toBytes((String)"row"));
        put.addColumn(CF, CQ, Bytes.toBytes((String)"value"));
        put.setDurability(Durability.SKIP_WAL);
        return put;
    }

    @Test
    public void testPutToTableNotReplicate() throws Exception {
        tableNotReplicate.put(this.newPutWithSkipWAL());
    }

    @Test(expected=InvalidMutationDurabilityException.class)
    public void testPutToTableNeedReplicate() throws Exception {
        tableNeedReplicate.put(this.newPutWithSkipWAL());
    }

    private Delete newDeleteWithSkipWAL() {
        Delete delete = new Delete(Bytes.toBytes((String)"row"));
        delete.addColumn(CF, CQ);
        delete.setDurability(Durability.SKIP_WAL);
        return delete;
    }

    @Test
    public void testDeleteToTableNotReplicate() throws Exception {
        tableNotReplicate.delete(this.newDeleteWithSkipWAL());
    }

    @Test(expected=InvalidMutationDurabilityException.class)
    public void testDeleteToTableNeedReplicate() throws Exception {
        tableNeedReplicate.delete(this.newDeleteWithSkipWAL());
    }

    private Append newAppendWithSkipWAL() {
        Append append = new Append(Bytes.toBytes((String)"row"));
        append.addColumn(CF, CQ, Bytes.toBytes((String)"value"));
        append.setDurability(Durability.SKIP_WAL);
        return append;
    }

    @Test
    public void testAppendToTableNotReplicate() throws Exception {
        tableNotReplicate.append(this.newAppendWithSkipWAL());
    }

    @Test(expected=InvalidMutationDurabilityException.class)
    public void testAppendToTableNeedReplicate() throws Exception {
        tableNeedReplicate.append(this.newAppendWithSkipWAL());
    }

    private Increment newIncrementWithSkipWAL() {
        Increment increment = new Increment(Bytes.toBytes((String)"row"));
        increment.addColumn(CF, CQ, 1L);
        increment.setDurability(Durability.SKIP_WAL);
        return increment;
    }

    @Test
    public void testIncrementToTableNotReplicate() throws Exception {
        tableNotReplicate.increment(this.newIncrementWithSkipWAL());
    }

    @Test(expected=InvalidMutationDurabilityException.class)
    public void testIncrementToTableNeedReplicate() throws Exception {
        tableNeedReplicate.increment(this.newIncrementWithSkipWAL());
    }

    @Test
    public void testCheckWithMutateToTableNotReplicate() throws Exception {
        tableNotReplicate.checkAndMutate(Bytes.toBytes((String)"row"), CF).qualifier(CQ).ifNotExists().thenPut(this.newPutWithSkipWAL());
    }

    @Test(expected=InvalidMutationDurabilityException.class)
    public void testCheckWithMutateToTableNeedReplicate() throws Exception {
        tableNeedReplicate.checkAndMutate(Bytes.toBytes((String)"row"), CF).qualifier(CQ).ifNotExists().thenPut(this.newPutWithSkipWAL());
    }
}

