/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.CatalogFamilyFormat;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMetaTableAccessorNoCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaTableAccessorNoCluster.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @Before
    public void before() throws Exception {
        UTIL.startMiniZKCluster();
    }

    @After
    public void after() throws IOException {
        UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testGetHRegionInfo() throws IOException {
        Assert.assertNull((Object)CatalogFamilyFormat.getRegionInfo((Result)new Result()));
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        Result r = Result.create(kvs);
        Assert.assertNull((Object)CatalogFamilyFormat.getRegionInfo((Result)r));
        byte[] f = HConstants.CATALOG_FAMILY;
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.SERVER_QUALIFIER, f));
        r = Result.create(kvs);
        Assert.assertNull((Object)CatalogFamilyFormat.getRegionInfo((Result)r));
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.REGIONINFO_QUALIFIER, f));
        RegionInfo hri = CatalogFamilyFormat.getRegionInfo((Result)Result.create(kvs));
        Assert.assertTrue((hri == null ? 1 : 0) != 0);
        kvs.clear();
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.REGIONINFO_QUALIFIER, RegionInfo.toByteArray((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO)));
        hri = CatalogFamilyFormat.getRegionInfo((Result)Result.create(kvs));
        Assert.assertNotNull((Object)hri);
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(hri, RegionInfoBuilder.FIRST_META_REGIONINFO) == 0 ? 1 : 0) != 0);
    }
}

