/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestMutationGetCellBuilder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMutationGetCellBuilder.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMutationGetCellBuilder() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] rowKey = Bytes.toBytes((String)"12345678");
        byte[] uselessRowKey = Bytes.toBytes((String)"123");
        byte[] family = Bytes.toBytes((String)"cf");
        byte[] qualifier = Bytes.toBytes((String)"foo");
        long now = EnvironmentEdgeManager.currentTime();
        try (Table table = TEST_UTIL.createTable(tableName, family);){
            TEST_UTIL.waitTableAvailable(tableName.getName(), 5000L);
            Put put = new Put(rowKey);
            CellBuilder cellBuilder = put.getCellBuilder().setQualifier(qualifier).setFamily(family).setValue(Bytes.toBytes((String)"bar")).setTimestamp(now);
            cellBuilder.setRow(uselessRowKey);
            put.add(cellBuilder.build());
            byte[] cloneRow = CellUtil.cloneRow((Cell)cellBuilder.build());
            Assert.assertTrue((String)"setRow must be useless", (!Arrays.equals(cloneRow, uselessRowKey) ? 1 : 0) != 0);
            table.put(put);
            Get get = new Get(rowKey);
            get.setTimestamp(now);
            Result result = table.get(get);
            Assert.assertTrue((String)"row key must be same", (boolean)Arrays.equals(result.getRow(), rowKey));
            Assert.assertTrue((String)"Column foo value should be bar", (boolean)Bytes.toString((byte[])result.getValue(family, qualifier)).equals("bar"));
            Delete delete = new Delete(rowKey);
            cellBuilder = delete.getCellBuilder().setQualifier(qualifier).setFamily(family);
            cellBuilder.setType(Cell.Type.Put);
            delete.add(cellBuilder.build());
            table.delete(delete);
            get = new Get(rowKey);
            get.setTimestamp(now);
            result = table.get(get);
            Assert.assertTrue((String)"Column foo should not exist", (result.getValue(family, qualifier) == null ? 1 : 0) != 0);
        }
    }
}

