/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestRequestAndConnectionAttributes {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRequestAndConnectionAttributes.class);
    private static final Map<String, byte[]> CONNECTION_ATTRIBUTES = new HashMap<String, byte[]>();
    private static final Map<String, byte[]> REQUEST_ATTRIBUTES;
    private static final ExecutorService EXECUTOR_SERVICE;
    private static final AtomicBoolean REQUEST_ATTRIBUTES_VALIDATED;
    private static final byte[] REQUEST_ATTRIBUTES_TEST_TABLE_CF;
    private static final TableName REQUEST_ATTRIBUTES_TEST_TABLE;
    private static HBaseTestingUtil TEST_UTIL;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL = new HBaseTestingUtil();
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(REQUEST_ATTRIBUTES_TEST_TABLE, (byte[][])new byte[][]{REQUEST_ATTRIBUTES_TEST_TABLE_CF}, 1, 65536, AttributesCoprocessor.class.getName());
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() {
        REQUEST_ATTRIBUTES_VALIDATED.getAndSet(false);
    }

    @Test
    public void testConnectionHeaderOverwrittenAttributesRemain() throws IOException {
        TableName tableName = TableName.valueOf((String)"testConnectionAttributes");
        byte[] cf = Bytes.toBytes((String)"0");
        TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{cf}, 1, 65536, AttributesCoprocessor.class.getName());
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = conn.getTable(tableName);){
            byte[] bytes = new byte[300];
            new Random().nextBytes(bytes);
            Result result = table.get(new Get(bytes));
            Assert.assertEquals((long)CONNECTION_ATTRIBUTES.size(), (long)result.size());
            for (Map.Entry<String, byte[]> attr : CONNECTION_ATTRIBUTES.entrySet()) {
                byte[] val = result.getValue(Bytes.toBytes((String)"c"), Bytes.toBytes((String)attr.getKey()));
                Assert.assertEquals((Object)Bytes.toStringBinary((byte[])attr.getValue()), (Object)Bytes.toStringBinary((byte[])val));
            }
        }
    }

    @Test
    public void testRequestAttributesGet() throws IOException {
        this.addRandomRequestAttributes();
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = TestRequestAndConnectionAttributes.configureRequestAttributes(conn.getTableBuilder(REQUEST_ATTRIBUTES_TEST_TABLE, EXECUTOR_SERVICE)).build();){
            table.get(new Get(Bytes.toBytes((int)0)));
        }
        Assert.assertTrue((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
    }

    @Test
    public void testRequestAttributesMultiGet() throws IOException {
        Assert.assertFalse((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
        this.addRandomRequestAttributes();
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = TestRequestAndConnectionAttributes.configureRequestAttributes(conn.getTableBuilder(REQUEST_ATTRIBUTES_TEST_TABLE, EXECUTOR_SERVICE)).build();){
            ImmutableList gets = ImmutableList.of((Object)new Get(Bytes.toBytes((int)0)), (Object)new Get(Bytes.toBytes((int)1)));
            table.get((List)gets);
        }
        Assert.assertTrue((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
    }

    @Test
    public void testRequestAttributesExists() throws IOException {
        Assert.assertFalse((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
        this.addRandomRequestAttributes();
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = TestRequestAndConnectionAttributes.configureRequestAttributes(conn.getTableBuilder(REQUEST_ATTRIBUTES_TEST_TABLE, EXECUTOR_SERVICE)).build();){
            table.exists(new Get(Bytes.toBytes((int)0)));
        }
        Assert.assertTrue((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
    }

    @Test
    public void testRequestAttributesScan() throws IOException {
        Assert.assertFalse((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
        this.addRandomRequestAttributes();
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = TestRequestAndConnectionAttributes.configureRequestAttributes(conn.getTableBuilder(REQUEST_ATTRIBUTES_TEST_TABLE, EXECUTOR_SERVICE)).build();){
            ResultScanner scanner = table.getScanner(new Scan());
            scanner.next();
        }
        Assert.assertTrue((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
    }

    @Test
    public void testRequestAttributesPut() throws IOException {
        Assert.assertFalse((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
        this.addRandomRequestAttributes();
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = TestRequestAndConnectionAttributes.configureRequestAttributes(conn.getTableBuilder(REQUEST_ATTRIBUTES_TEST_TABLE, EXECUTOR_SERVICE)).build();){
            Put put = new Put(Bytes.toBytes((String)"a"));
            put.addColumn(REQUEST_ATTRIBUTES_TEST_TABLE_CF, Bytes.toBytes((String)"c"), Bytes.toBytes((String)"v"));
            table.put(put);
        }
        Assert.assertTrue((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
    }

    @Test
    public void testRequestAttributesMultiPut() throws IOException {
        Assert.assertFalse((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
        this.addRandomRequestAttributes();
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = TestRequestAndConnectionAttributes.configureRequestAttributes(conn.getTableBuilder(REQUEST_ATTRIBUTES_TEST_TABLE, EXECUTOR_SERVICE)).build();){
            Put put = new Put(Bytes.toBytes((String)"a"));
            put.addColumn(REQUEST_ATTRIBUTES_TEST_TABLE_CF, Bytes.toBytes((String)"c"), Bytes.toBytes((String)"v"));
            table.put(put);
        }
        Assert.assertTrue((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
    }

    @Test
    public void testNoRequestAttributes() throws IOException {
        Assert.assertFalse((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
        TableName tableName = TableName.valueOf((String)"testNoRequestAttributesScan");
        TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{Bytes.toBytes((String)"0")}, 1, 65536, AttributesCoprocessor.class.getName());
        REQUEST_ATTRIBUTES.clear();
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);){
            TableBuilder tableBuilder = conn.getTableBuilder(tableName, null);
            try (Table table = tableBuilder.build();){
                table.get(new Get(Bytes.toBytes((int)0)));
                Assert.assertTrue((boolean)REQUEST_ATTRIBUTES_VALIDATED.get());
            }
        }
    }

    private void addRandomRequestAttributes() {
        REQUEST_ATTRIBUTES.clear();
        int j = Math.max(2, (int)(10.0 * Math.random()));
        for (int i = 0; i < j; ++i) {
            REQUEST_ATTRIBUTES.put(String.valueOf(i), Bytes.toBytes((String)UUID.randomUUID().toString()));
        }
    }

    private static TableBuilder configureRequestAttributes(TableBuilder tableBuilder) {
        REQUEST_ATTRIBUTES.forEach((arg_0, arg_1) -> ((TableBuilder)tableBuilder).setRequestAttribute(arg_0, arg_1));
        return tableBuilder;
    }

    static {
        CONNECTION_ATTRIBUTES.put("clientId", Bytes.toBytes((String)"foo"));
        REQUEST_ATTRIBUTES = new HashMap<String, byte[]>();
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(100);
        REQUEST_ATTRIBUTES_VALIDATED = new AtomicBoolean(false);
        REQUEST_ATTRIBUTES_TEST_TABLE_CF = Bytes.toBytes((String)"0");
        REQUEST_ATTRIBUTES_TEST_TABLE = TableName.valueOf((String)"testRequestAttributes");
        TEST_UTIL = null;
    }

    public static class AttributesCoprocessor
    implements RegionObserver,
    RegionCoprocessor {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
            this.validateRequestAttributes();
            RpcCall rpcCall = (RpcCall)RpcServer.getCurrentCall().get();
            for (Map.Entry attr : rpcCall.getRequestAttributes().entrySet()) {
                result.add((Cell)((RegionCoprocessorEnvironment)c.getEnvironment()).getCellBuilder().clear().setRow(get.getRow()).setFamily(Bytes.toBytes((String)"r")).setQualifier(Bytes.toBytes((String)((String)attr.getKey()))).setValue((byte[])attr.getValue()).setType(Cell.Type.Put).setTimestamp(1L).build());
            }
            for (Map.Entry attr : rpcCall.getConnectionAttributes().entrySet()) {
                result.add((Cell)((RegionCoprocessorEnvironment)c.getEnvironment()).getCellBuilder().clear().setRow(get.getRow()).setFamily(Bytes.toBytes((String)"c")).setQualifier(Bytes.toBytes((String)((String)attr.getKey()))).setValue((byte[])attr.getValue()).setType(Cell.Type.Put).setTimestamp(1L).build());
            }
            result.sort((Comparator<Cell>)CellComparator.getInstance());
            c.bypass();
        }

        public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
            this.validateRequestAttributes();
            return hasNext;
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit) throws IOException {
            this.validateRequestAttributes();
        }

        private void validateRequestAttributes() {
            RpcCall rpcCall = (RpcCall)RpcServer.getCurrentCall().get();
            Map attrs = rpcCall.getRequestAttributes();
            if (attrs.size() != REQUEST_ATTRIBUTES.size()) {
                return;
            }
            for (Map.Entry attr : attrs.entrySet()) {
                if (!REQUEST_ATTRIBUTES.containsKey(attr.getKey())) {
                    return;
                }
                if (Arrays.equals((byte[])REQUEST_ATTRIBUTES.get(attr.getKey()), (byte[])attr.getValue())) continue;
                return;
            }
            REQUEST_ATTRIBUTES_VALIDATED.getAndSet(true);
        }
    }
}

