/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class, ClientTests.class})
public class TestServerLoadDurability {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestServerLoadDurability.class);
    private static final byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    @Parameterized.Parameter
    public Configuration conf;
    protected HBaseTestingUtil utility;
    protected Connection conn;
    protected Admin admin;
    @Rule
    public TestName testName = new TestName();
    protected TableName tableName;

    @Parameterized.Parameters
    public static final Collection<Object[]> parameters() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        configurations.add(new Object[]{TestServerLoadDurability.createConfigurationForSimpleRpcServer()});
        configurations.add(new Object[]{TestServerLoadDurability.createConfigurationForNettyRpcServer()});
        return configurations;
    }

    private static Configuration createConfigurationForSimpleRpcServer() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.rpc.server.impl", SimpleRpcServer.class.getName());
        conf.setInt("hbase.server.allocator.buffer.size", 20);
        return conf;
    }

    private static Configuration createConfigurationForNettyRpcServer() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.rpc.server.impl", NettyRpcServer.class.getName());
        return conf;
    }

    @Before
    public void setUp() throws Exception {
        this.utility = new HBaseTestingUtil(this.conf);
        this.utility.startMiniCluster(2);
        this.conn = ConnectionFactory.createConnection((Configuration)this.utility.getConfiguration());
        this.admin = this.conn.getAdmin();
        String methodName = this.testName.getMethodName();
        this.tableName = TableName.valueOf((String)methodName.substring(0, methodName.length() - 3));
    }

    @After
    public void tearDown() throws Exception {
        this.utility.shutdownMiniCluster();
    }

    @Test
    public void testCompactionTimestamps() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        try (Table table = this.conn.getTable(this.tableName);){
            long l = this.admin.getLastMajorCompactionTimestamp(this.tableName);
        }
    }

    private void createTableWithDefaultConf(TableName tableName) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        this.admin.createTable(builder.build());
    }
}

