/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.constraint;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.constraint.AllFailConstraint;
import org.apache.hadoop.hbase.constraint.BaseConstraint;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.constraint.Constraints;
import org.apache.hadoop.hbase.constraint.RuntimeFailConstraint;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestConstraint {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestConstraint.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestConstraint.class);
    private static HBaseTestingUtil util;
    private static final TableName tableName;
    private static final byte[] dummy;
    private static final byte[] row1;
    private static final byte[] test;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        util = new HBaseTestingUtil();
        util.getConfiguration().setBoolean("hbase.coprocessor.abortonerror", false);
        util.startMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraintPasses() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] family : new byte[][]{dummy, test}) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        Constraints.add((TableDescriptorBuilder)builder, (Class[])new Class[]{CheckWasRunConstraint.class});
        util.getAdmin().createTable(builder.build());
        try (Table table = util.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            byte[] value = Bytes.toBytes((String)Integer.toString(10));
            byte[] qualifier = new byte[]{};
            put.addColumn(dummy, qualifier, value);
            table.put(put);
        }
        Assert.assertTrue((boolean)CheckWasRunConstraint.wasRun);
    }

    @Test
    public void testConstraintFails() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] family : new byte[][]{dummy, test}) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        Constraints.add((TableDescriptorBuilder)builder, (Class[])new Class[]{AllFailConstraint.class});
        util.getAdmin().createTable(builder.build());
        Table table = util.getConnection().getTable(tableName);
        Put put = new Put(row1);
        byte[] qualifier = new byte[]{};
        put.addColumn(dummy, qualifier, Bytes.toBytes((String)"fail"));
        LOG.warn("Doing put in table");
        try {
            table.put(put);
            Assert.fail((String)"This put should not have suceeded - AllFailConstraint was not run!");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableConstraint() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] family : new byte[][]{dummy, test}) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        Constraints.add((TableDescriptorBuilder)builder, (Class[])new Class[]{CheckWasRunConstraint.class});
        Constraints.add((TableDescriptorBuilder)builder, (Class[])new Class[]{AllFailConstraint.class});
        Constraints.disableConstraint((TableDescriptorBuilder)builder, AllFailConstraint.class);
        util.getAdmin().createTable(builder.build());
        try (Table table = util.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            byte[] qualifier = new byte[]{};
            put.addColumn(dummy, qualifier, Bytes.toBytes((String)"pass"));
            table.put(put);
        }
        Assert.assertTrue((boolean)CheckWasRunConstraint.wasRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableConstraints() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] family : new byte[][]{dummy, test}) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        Constraints.add((TableDescriptorBuilder)builder, (Class[])new Class[]{CheckWasRunConstraint.class});
        Constraints.disable((TableDescriptorBuilder)builder);
        util.getAdmin().createTable(builder.build());
        try (Table table = util.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            byte[] qualifier = new byte[]{};
            put.addColumn(dummy, qualifier, Bytes.toBytes((String)"pass"));
            LOG.warn("Doing put in table");
            table.put(put);
        }
        Assert.assertFalse((boolean)CheckWasRunConstraint.wasRun);
    }

    @Test
    public void testIsUnloaded() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] family : new byte[][]{dummy, test}) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        Constraints.add((TableDescriptorBuilder)builder, (Class[])new Class[]{RuntimeFailConstraint.class});
        Constraints.add((TableDescriptorBuilder)builder, (Class[])new Class[]{CheckWasRunConstraint.class});
        CheckWasRunConstraint.wasRun = false;
        util.getAdmin().createTable(builder.build());
        Table table = util.getConnection().getTable(tableName);
        Put put = new Put(row1);
        byte[] qualifier = new byte[]{};
        put.addColumn(dummy, qualifier, Bytes.toBytes((String)"pass"));
        try {
            table.put(put);
            Assert.fail((String)"RuntimeFailConstraint wasn't triggered - this put shouldn't work!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        table.put(put);
        Assert.assertFalse((boolean)CheckWasRunConstraint.wasRun);
        table.close();
    }

    @After
    public void cleanup() throws Exception {
        CheckWasRunConstraint.wasRun = false;
        util.getAdmin().disableTable(tableName);
        util.getAdmin().deleteTable(tableName);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    static {
        tableName = TableName.valueOf((String)"test");
        dummy = Bytes.toBytes((String)"dummy");
        row1 = Bytes.toBytes((String)"r1");
        test = Bytes.toBytes((String)"test");
    }

    public static class CheckWasRunConstraint
    extends BaseConstraint {
        public static boolean wasRun = false;

        public void check(Put p) {
            wasRun = true;
        }
    }
}

