/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestPassCustomCellViaRegionObserver {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPassCustomCellViaRegionObserver.class);
    @Rule
    public TestName testName = new TestName();
    private TableName tableName;
    private Table table = null;
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final byte[] ROW = Bytes.toBytes((String)"ROW");
    private static final byte[] FAMILY = Bytes.toBytes((String)"FAMILY");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"QUALIFIER");
    private static final byte[] VALUE = Bytes.toBytes((long)10L);
    private static final byte[] APPEND_VALUE = Bytes.toBytes((String)"MB");
    private static final byte[] QUALIFIER_FROM_CP = Bytes.toBytes((String)"QUALIFIER_FROM_CP");

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void clearTable() throws IOException {
        RegionObserverImpl.COUNT.set(0);
        this.tableName = TableName.valueOf((String)this.testName.getMethodName());
        if (this.table != null) {
            this.table.close();
        }
        try (Admin admin = UTIL.getAdmin();){
            for (TableName name : admin.listTableNames()) {
                try {
                    admin.disableTable(name);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                admin.deleteTable(name);
            }
            this.table = UTIL.createTable(TableDescriptorBuilder.newBuilder((TableName)this.tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setCoprocessor(RegionObserverImpl.class.getName()).build(), (byte[][])null);
        }
    }

    @Test
    public void testMutation() throws Exception {
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        this.table.put(put);
        byte[] value = VALUE;
        TestPassCustomCellViaRegionObserver.assertResult(this.table.get(new Get(ROW)), value, value);
        TestPassCustomCellViaRegionObserver.assertObserverHasExecuted();
        Increment inc = new Increment(ROW);
        inc.addColumn(FAMILY, QUALIFIER, 10L);
        this.table.increment(inc);
        value = Bytes.toBytes((long)20L);
        TestPassCustomCellViaRegionObserver.assertResult(this.table.get(new Get(ROW)), value, value);
        TestPassCustomCellViaRegionObserver.assertObserverHasExecuted();
        Append append = new Append(ROW);
        append.addColumn(FAMILY, QUALIFIER, APPEND_VALUE);
        this.table.append(append);
        value = ByteBuffer.wrap(new byte[value.length + APPEND_VALUE.length]).put(value).put(APPEND_VALUE).array();
        TestPassCustomCellViaRegionObserver.assertResult(this.table.get(new Get(ROW)), value, value);
        TestPassCustomCellViaRegionObserver.assertObserverHasExecuted();
        Delete delete = new Delete(ROW);
        delete.addColumns(FAMILY, QUALIFIER);
        this.table.delete(delete);
        Assert.assertTrue((String)Arrays.asList(this.table.get(new Get(ROW)).rawCells()).toString(), (boolean)this.table.get(new Get(ROW)).isEmpty());
        TestPassCustomCellViaRegionObserver.assertObserverHasExecuted();
        Assert.assertTrue((boolean)this.table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(put));
        TestPassCustomCellViaRegionObserver.assertObserverHasExecuted();
        Assert.assertTrue((boolean)this.table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifEquals(VALUE).thenDelete(delete));
        TestPassCustomCellViaRegionObserver.assertObserverHasExecuted();
        Assert.assertTrue((boolean)this.table.get(new Get(ROW)).isEmpty());
    }

    @Test
    public void testMultiPut() throws Exception {
        List puts = IntStream.range(0, 10).mapToObj(i -> new Put(ROW).addColumn(FAMILY, Bytes.toBytes((int)i), VALUE)).collect(Collectors.toList());
        this.table.put(puts);
        TestPassCustomCellViaRegionObserver.assertResult(this.table.get(new Get(ROW)), VALUE);
        TestPassCustomCellViaRegionObserver.assertObserverHasExecuted();
        List deletes = IntStream.range(0, 10).mapToObj(i -> new Delete(ROW).addColumn(FAMILY, Bytes.toBytes((int)i))).collect(Collectors.toList());
        this.table.delete(deletes);
        Assert.assertTrue((boolean)this.table.get(new Get(ROW)).isEmpty());
        TestPassCustomCellViaRegionObserver.assertObserverHasExecuted();
    }

    private static void assertObserverHasExecuted() {
        Assert.assertTrue((RegionObserverImpl.COUNT.getAndSet(0) > 0 ? 1 : 0) != 0);
    }

    private static void assertResult(Result result, byte[] expectedValue) {
        Assert.assertFalse((boolean)result.isEmpty());
        for (Cell c : result.rawCells()) {
            Assert.assertTrue((String)c.toString(), (boolean)Bytes.equals((byte[])ROW, (byte[])CellUtil.cloneRow((Cell)c)));
            Assert.assertTrue((String)c.toString(), (boolean)Bytes.equals((byte[])FAMILY, (byte[])CellUtil.cloneFamily((Cell)c)));
            Assert.assertTrue((String)c.toString(), (boolean)Bytes.equals((byte[])expectedValue, (byte[])CellUtil.cloneValue((Cell)c)));
        }
    }

    private static void assertResult(Result result, byte[] expectedValue, byte[] expectedFromCp) {
        Assert.assertFalse((boolean)result.isEmpty());
        for (Cell c : result.rawCells()) {
            Assert.assertTrue((String)c.toString(), (boolean)Bytes.equals((byte[])ROW, (byte[])CellUtil.cloneRow((Cell)c)));
            Assert.assertTrue((String)c.toString(), (boolean)Bytes.equals((byte[])FAMILY, (byte[])CellUtil.cloneFamily((Cell)c)));
            if (Bytes.equals((byte[])QUALIFIER, (byte[])CellUtil.cloneQualifier((Cell)c))) {
                Assert.assertTrue((String)c.toString(), (boolean)Bytes.equals((byte[])expectedValue, (byte[])CellUtil.cloneValue((Cell)c)));
                continue;
            }
            if (Bytes.equals((byte[])QUALIFIER_FROM_CP, (byte[])CellUtil.cloneQualifier((Cell)c))) {
                Assert.assertTrue((String)c.toString(), (boolean)Bytes.equals((byte[])expectedFromCp, (byte[])CellUtil.cloneValue((Cell)c)));
                continue;
            }
            Assert.fail((String)"No valid qualifier");
        }
    }

    private static Cell createCustomCell(final byte[] row, final byte[] family, final byte[] qualifier, final Cell.Type type, final byte[] value) {
        return new Cell(){

            public long heapSize() {
                return 0L;
            }

            private byte[] getArray(byte[] array) {
                return array == null ? HConstants.EMPTY_BYTE_ARRAY : array;
            }

            private int length(byte[] array) {
                return array == null ? 0 : array.length;
            }

            public byte[] getRowArray() {
                return this.getArray(row);
            }

            public int getRowOffset() {
                return 0;
            }

            public short getRowLength() {
                return (short)this.length(row);
            }

            public byte[] getFamilyArray() {
                return this.getArray(family);
            }

            public int getFamilyOffset() {
                return 0;
            }

            public byte getFamilyLength() {
                return (byte)this.length(family);
            }

            public byte[] getQualifierArray() {
                return this.getArray(qualifier);
            }

            public int getQualifierOffset() {
                return 0;
            }

            public int getQualifierLength() {
                return this.length(qualifier);
            }

            public long getTimestamp() {
                return Long.MAX_VALUE;
            }

            public byte getTypeByte() {
                return type.getCode();
            }

            public long getSequenceId() {
                return 0L;
            }

            public byte[] getValueArray() {
                return this.getArray(value);
            }

            public int getValueOffset() {
                return 0;
            }

            public int getValueLength() {
                return this.length(value);
            }

            public int getSerializedSize() {
                return KeyValueUtil.getSerializedSize((Cell)this, (boolean)true);
            }

            public byte[] getTagsArray() {
                return this.getArray(null);
            }

            public int getTagsOffset() {
                return 0;
            }

            public int getTagsLength() {
                return this.length(null);
            }

            public Cell.Type getType() {
                return type;
            }
        };
    }

    private static Cell createCustomCell(Put put) {
        return TestPassCustomCellViaRegionObserver.createCustomCell(put.getRow(), FAMILY, QUALIFIER_FROM_CP, Cell.Type.Put, VALUE);
    }

    private static Cell createCustomCell(Append append) {
        return TestPassCustomCellViaRegionObserver.createCustomCell(append.getRow(), FAMILY, QUALIFIER_FROM_CP, Cell.Type.Put, APPEND_VALUE);
    }

    private static Cell createCustomCell(Increment inc) {
        return TestPassCustomCellViaRegionObserver.createCustomCell(inc.getRow(), FAMILY, QUALIFIER_FROM_CP, Cell.Type.Put, VALUE);
    }

    private static Cell createCustomCell(Delete delete) {
        return TestPassCustomCellViaRegionObserver.createCustomCell(delete.getRow(), FAMILY, QUALIFIER_FROM_CP, Cell.Type.DeleteColumn, null);
    }

    public static class RegionObserverImpl
    implements RegionCoprocessor,
    RegionObserver {
        static final AtomicInteger COUNT = new AtomicInteger(0);

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            put.add(TestPassCustomCellViaRegionObserver.createCustomCell(put));
            COUNT.incrementAndGet();
        }

        public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
            delete.add(TestPassCustomCellViaRegionObserver.createCustomCell(delete));
            COUNT.incrementAndGet();
        }

        public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
            put.add(TestPassCustomCellViaRegionObserver.createCustomCell(put));
            COUNT.incrementAndGet();
            return result;
        }

        public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
            delete.add(TestPassCustomCellViaRegionObserver.createCustomCell(delete));
            COUNT.incrementAndGet();
            return result;
        }

        public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
            append.add(TestPassCustomCellViaRegionObserver.createCustomCell(append));
            COUNT.incrementAndGet();
            return null;
        }

        public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
            increment.add(TestPassCustomCellViaRegionObserver.createCustomCell(increment));
            COUNT.incrementAndGet();
            return null;
        }
    }
}

