/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.BinaryComponentComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestFiltersWithBinaryComponentComparator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFiltersWithBinaryComponentComparator.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final Logger LOG = LoggerFactory.getLogger(TestFiltersWithBinaryComponentComparator.class);
    private byte[] family = Bytes.toBytes((String)"family");
    private byte[] qf = Bytes.toBytes((String)"qf");
    private TableName tableName;
    private int aOffset = 0;
    private int bOffset = 4;
    private int cOffset = 8;
    private int dOffset = 12;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRowFilterWithBinaryComponentComparator() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(ht, this.family, this.qf);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        this.setRowFilters(filterList);
        Scan scan = this.createScan(filterList);
        List<Cell> result = this.getResults(ht, scan);
        for (Cell cell : result) {
            byte[] key = CellUtil.cloneRow((Cell)cell);
            int a = Bytes.readAsInt((byte[])key, (int)this.aOffset, (int)4);
            int b = Bytes.readAsInt((byte[])key, (int)this.bOffset, (int)4);
            int c = Bytes.readAsInt((byte[])key, (int)this.cOffset, (int)4);
            int d = Bytes.readAsInt((byte[])key, (int)this.dOffset, (int)4);
            Assert.assertTrue((a == 1 && b > 10 && b < 20 && c > 90 && c < 100 && d == 1 ? 1 : 0) != 0);
        }
        ht.close();
    }

    @Test
    public void testValueFilterWithBinaryComponentComparator() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(ht, this.family, this.qf);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        this.setValueFilters(filterList);
        Scan scan = new Scan();
        scan.setFilter((Filter)filterList);
        List<Cell> result = this.getResults(ht, scan);
        for (Cell cell : result) {
            byte[] value = CellUtil.cloneValue((Cell)cell);
            Assert.assertTrue((Bytes.toString((byte[])value).charAt(1) == 'y' ? 1 : 0) != 0);
        }
        ht.close();
    }

    @Test
    public void testRowAndValueFilterWithBinaryComponentComparator() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(ht, this.family, this.qf);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        this.setRowFilters(filterList);
        this.setValueFilters(filterList);
        Scan scan = new Scan();
        scan.setFilter((Filter)filterList);
        List<Cell> result = this.getResults(ht, scan);
        for (Cell cell : result) {
            byte[] key = CellUtil.cloneRow((Cell)cell);
            int a = Bytes.readAsInt((byte[])key, (int)this.aOffset, (int)4);
            int b = Bytes.readAsInt((byte[])key, (int)this.bOffset, (int)4);
            int c = Bytes.readAsInt((byte[])key, (int)this.cOffset, (int)4);
            int d = Bytes.readAsInt((byte[])key, (int)this.dOffset, (int)4);
            Assert.assertTrue((a == 1 && b > 10 && b < 20 && c > 90 && c < 100 && d == 1 ? 1 : 0) != 0);
            byte[] value = CellUtil.cloneValue((Cell)cell);
            Assert.assertTrue((Bytes.toString((byte[])value).charAt(1) == 'y' ? 1 : 0) != 0);
        }
        ht.close();
    }

    private void generateRows(Table ht, byte[] family, byte[] qf) throws IOException {
        for (int a = 1; a < 2; ++a) {
            for (int b = 9; b < 22; ++b) {
                for (int c = 89; c < 102; ++c) {
                    for (int d = 1; d < 2; ++d) {
                        byte[] key = new byte[16];
                        Bytes.putInt((byte[])key, (int)0, (int)a);
                        Bytes.putInt((byte[])key, (int)4, (int)b);
                        Bytes.putInt((byte[])key, (int)8, (int)c);
                        Bytes.putInt((byte[])key, (int)12, (int)d);
                        Put row = new Put(key);
                        if (c % 2 == 0) {
                            row.addColumn(family, qf, Bytes.toBytes((String)"abc"));
                            if (!LOG.isInfoEnabled()) continue;
                            LOG.info("added row: {} with value 'abc'", (Object)Arrays.toString(Hex.encodeHex((byte[])key)));
                            continue;
                        }
                        row.addColumn(family, qf, Bytes.toBytes((String)"xyz"));
                        if (!LOG.isInfoEnabled()) continue;
                        LOG.info("added row: {} with value 'xyz'", (Object)Arrays.toString(Hex.encodeHex((byte[])key)));
                    }
                }
            }
        }
        TEST_UTIL.flush();
    }

    private void setRowFilters(FilterList filterList) {
        int bOffset = 4;
        byte[] b10 = Bytes.toBytes((int)10);
        RowFilter b10Filter = new RowFilter(CompareOperator.GREATER, (ByteArrayComparable)new BinaryComponentComparator(b10, bOffset));
        filterList.addFilter((Filter)b10Filter);
        byte[] b20 = Bytes.toBytes((int)20);
        RowFilter b20Filter = new RowFilter(CompareOperator.LESS, (ByteArrayComparable)new BinaryComponentComparator(b20, bOffset));
        filterList.addFilter((Filter)b20Filter);
        int cOffset = 8;
        byte[] c90 = Bytes.toBytes((int)90);
        RowFilter c90Filter = new RowFilter(CompareOperator.GREATER, (ByteArrayComparable)new BinaryComponentComparator(c90, cOffset));
        filterList.addFilter((Filter)c90Filter);
        byte[] c100 = Bytes.toBytes((int)100);
        RowFilter c100Filter = new RowFilter(CompareOperator.LESS, (ByteArrayComparable)new BinaryComponentComparator(c100, cOffset));
        filterList.addFilter((Filter)c100Filter);
        int dOffset = 12;
        byte[] d1 = Bytes.toBytes((int)1);
        RowFilter dFilter = new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComponentComparator(d1, dOffset));
        filterList.addFilter((Filter)dFilter);
    }

    private void setValueFilters(FilterList filterList) {
        int offset = 1;
        byte[] y = Bytes.toBytes((String)"y");
        ValueFilter yFilter = new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComponentComparator(y, offset));
        filterList.addFilter((Filter)yFilter);
    }

    private Scan createScan(FilterList list) {
        byte[] startKey = new byte[16];
        Bytes.putInt((byte[])startKey, (int)this.aOffset, (int)1);
        Bytes.putInt((byte[])startKey, (int)this.bOffset, (int)11);
        Bytes.putInt((byte[])startKey, (int)this.cOffset, (int)91);
        Bytes.putInt((byte[])startKey, (int)this.dOffset, (int)1);
        byte[] endKey = new byte[16];
        Bytes.putInt((byte[])endKey, (int)this.aOffset, (int)1);
        Bytes.putInt((byte[])endKey, (int)this.bOffset, (int)20);
        Bytes.putInt((byte[])endKey, (int)this.cOffset, (int)100);
        Bytes.putInt((byte[])endKey, (int)this.dOffset, (int)1);
        Scan scan = new Scan().withStartRow(startKey).withStopRow(endKey);
        scan.setFilter((Filter)list);
        return scan;
    }

    private List<Cell> getResults(Table ht, Scan scan) throws IOException {
        Result r;
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Cell> results = new ArrayList<Cell>();
        while ((r = scanner.next()) != null) {
            for (Cell kv : r.listCells()) {
                results.add(kv);
            }
        }
        scanner.close();
        return results;
    }
}

