/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.TestLruBlockCache;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCombinedBlockCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCombinedBlockCache.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @Test
    public void testCombinedCacheStats() {
        CacheStats lruCacheStats = new CacheStats("lruCacheStats", 2);
        CacheStats bucketCacheStats = new CacheStats("bucketCacheStats", 2);
        CombinedBlockCache.CombinedCacheStats stats = new CombinedBlockCache.CombinedCacheStats(lruCacheStats, bucketCacheStats);
        double delta = 0.01;
        lruCacheStats.hit(true, true, BlockType.DATA);
        lruCacheStats.miss(true, false, BlockType.DATA);
        bucketCacheStats.hit(false, true, BlockType.DATA);
        bucketCacheStats.hit(false, true, BlockType.DATA);
        bucketCacheStats.miss(false, true, BlockType.DATA);
        Assert.assertEquals((long)5L, (long)stats.getRequestCount());
        Assert.assertEquals((long)2L, (long)stats.getRequestCachingCount());
        Assert.assertEquals((long)2L, (long)stats.getMissCount());
        Assert.assertEquals((long)1L, (long)stats.getPrimaryMissCount());
        Assert.assertEquals((long)1L, (long)stats.getMissCachingCount());
        Assert.assertEquals((long)3L, (long)stats.getHitCount());
        Assert.assertEquals((long)3L, (long)stats.getPrimaryHitCount());
        Assert.assertEquals((long)1L, (long)stats.getHitCachingCount());
        Assert.assertEquals((double)0.6, (double)stats.getHitRatio(), (double)delta);
        Assert.assertEquals((double)0.5, (double)stats.getHitCachingRatio(), (double)delta);
        Assert.assertEquals((double)0.4, (double)stats.getMissRatio(), (double)delta);
        Assert.assertEquals((double)0.5, (double)stats.getMissCachingRatio(), (double)delta);
        lruCacheStats.evicted(1000L, true);
        lruCacheStats.evicted(1000L, false);
        lruCacheStats.evict();
        bucketCacheStats.evict();
        Assert.assertEquals((long)2L, (long)stats.getEvictionCount());
        Assert.assertEquals((long)2L, (long)stats.getEvictedCount());
        Assert.assertEquals((long)1L, (long)stats.getPrimaryEvictedCount());
        Assert.assertEquals((double)1.0, (double)stats.evictedPerEviction(), (double)delta);
        lruCacheStats.failInsert();
        Assert.assertEquals((long)1L, (long)stats.getFailedInserts());
        stats.rollMetricsPeriod();
        Assert.assertEquals((long)3L, (long)stats.getSumHitCountsPastNPeriods());
        Assert.assertEquals((long)5L, (long)stats.getSumRequestCountsPastNPeriods());
        Assert.assertEquals((long)1L, (long)stats.getSumHitCachingCountsPastNPeriods());
        Assert.assertEquals((long)2L, (long)stats.getSumRequestCachingCountsPastNPeriods());
        Assert.assertEquals((double)0.6, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.5, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
        lruCacheStats.hit(true, true, BlockType.DATA);
        lruCacheStats.hit(true, true, BlockType.DATA);
        lruCacheStats.hit(true, true, BlockType.DATA);
        stats.rollMetricsPeriod();
        Assert.assertEquals((long)6L, (long)stats.getSumHitCountsPastNPeriods());
        Assert.assertEquals((long)8L, (long)stats.getSumRequestCountsPastNPeriods());
        Assert.assertEquals((long)4L, (long)stats.getSumHitCachingCountsPastNPeriods());
        Assert.assertEquals((long)5L, (long)stats.getSumRequestCachingCountsPastNPeriods());
        Assert.assertEquals((double)0.75, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.8, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
    }

    @Test
    public void testMultiThreadGetAndEvictBlock() throws Exception {
        CombinedBlockCache blockCache = this.createCombinedBlockCache();
        TestLruBlockCache.testMultiThreadGetAndEvictBlockInternal((BlockCache)blockCache);
    }

    @Test
    public void testCombinedBlockCacheStatsWithDataBlockType() throws Exception {
        this.testCombinedBlockCacheStats(BlockType.DATA, 0, 1);
    }

    @Test
    public void testCombinedBlockCacheStatsWithMetaBlockType() throws Exception {
        this.testCombinedBlockCacheStats(BlockType.META, 1, 0);
    }

    @Test
    public void testCombinedBlockCacheStatsWithNoBlockType() throws Exception {
        this.testCombinedBlockCacheStats(null, 0, 1);
    }

    private CombinedBlockCache createCombinedBlockCache() {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.bucketcache.ioengine", "offheap");
        conf.setInt("hbase.bucketcache.size", 32);
        BlockCache blockCache = BlockCacheFactory.createBlockCache((Configuration)conf);
        Assert.assertTrue((boolean)(blockCache instanceof CombinedBlockCache));
        return (CombinedBlockCache)blockCache;
    }

    public void testCombinedBlockCacheStats(BlockType type, int expectedL1Miss, int expectedL2Miss) throws Exception {
        CombinedBlockCache blockCache = this.createCombinedBlockCache();
        BlockCacheKey key = new BlockCacheKey("key1", 0L, false, type);
        int size = 100;
        int length = 33 + size;
        byte[] byteArr = new byte[length];
        HFileContext meta = new HFileContextBuilder().build();
        HFileBlock blk = new HFileBlock(type != null ? type : BlockType.DATA, size, size, -1L, ByteBuff.wrap((ByteBuffer)ByteBuffer.wrap(byteArr, 0, size)), true, -1L, 52, -1, meta, ByteBuffAllocator.HEAP);
        blockCache.cacheBlock(key, (Cacheable)blk);
        blockCache.getBlock(key, true, false, true);
        Assert.assertEquals((long)0L, (long)blockCache.getStats().getMissCount());
        blockCache.evictBlock(key);
        blockCache.getBlock(key, true, false, true);
        Assert.assertEquals((long)1L, (long)blockCache.getStats().getMissCount());
        Assert.assertEquals((long)expectedL1Miss, (long)blockCache.getFirstLevelCache().getStats().getMissCount());
        Assert.assertEquals((long)expectedL2Miss, (long)blockCache.getSecondLevelCache().getStats().getMissCount());
    }
}

