/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.TagUsage;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={IOTests.class, SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestSeekTo {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSeekTo.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private final DataBlockEncoding encoding;
    static boolean switchKVs = false;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            paramList.add(new Object[]{encoding});
        }
        return paramList;
    }

    public TestSeekTo(DataBlockEncoding encoding) {
        this.encoding = encoding;
    }

    @Before
    public void setUp() {
        switchKVs = false;
    }

    static KeyValue toKV(String row, TagUsage tagUsage) {
        if (tagUsage == TagUsage.NO_TAG) {
            return new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Bytes.toBytes((String)"value"));
        }
        if (tagUsage == TagUsage.ONLY_TAG) {
            ArrayBackedTag t = new ArrayBackedTag(1, "myTag1");
            Tag[] tags = new Tag[]{t};
            return new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Long.MAX_VALUE, Bytes.toBytes((String)"value"), tags);
        }
        if (!switchKVs) {
            switchKVs = true;
            return new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Long.MAX_VALUE, Bytes.toBytes((String)"value"));
        }
        switchKVs = false;
        ArrayBackedTag t = new ArrayBackedTag(1, "myTag1");
        Tag[] tags = new Tag[]{t};
        return new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Long.MAX_VALUE, Bytes.toBytes((String)"value"), tags);
    }

    static String toRowStr(Cell c) {
        return Bytes.toString((byte[])c.getRowArray(), (int)c.getRowOffset(), (int)c.getRowLength());
    }

    Path makeNewFile(TagUsage tagUsage) throws IOException {
        Path ncTFile = new Path(TEST_UTIL.getDataTestDir(), "basic.hfile");
        FSDataOutputStream fout = TEST_UTIL.getTestFileSystem().create(ncTFile);
        int blocksize = TestSeekTo.toKV("a", tagUsage).getLength() * 3;
        HFileContext context = new HFileContextBuilder().withBlockSize(blocksize).withDataBlockEncoding(this.encoding).withIncludesTags(true).build();
        Configuration conf = TEST_UTIL.getConfiguration();
        HFile.Writer writer = HFile.getWriterFactoryNoCache((Configuration)conf).withOutputStream(fout).withFileContext(context).create();
        writer.append((Cell)TestSeekTo.toKV("c", tagUsage));
        writer.append((Cell)TestSeekTo.toKV("e", tagUsage));
        writer.append((Cell)TestSeekTo.toKV("g", tagUsage));
        writer.append((Cell)TestSeekTo.toKV("i", tagUsage));
        writer.append((Cell)TestSeekTo.toKV("k", tagUsage));
        writer.close();
        fout.close();
        return ncTFile;
    }

    @Test
    public void testSeekBefore() throws Exception {
        this.testSeekBeforeInternals(TagUsage.NO_TAG);
        this.testSeekBeforeInternals(TagUsage.ONLY_TAG);
        this.testSeekBeforeInternals(TagUsage.PARTIAL_TAG);
    }

    protected void testSeekBeforeInternals(TagUsage tagUsage) throws IOException {
        Path p = this.makeNewFile(tagUsage);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)p, (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);
        HFileScanner scanner = reader.getScanner(conf, false, true);
        Assert.assertFalse((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("a", tagUsage)));
        Assert.assertFalse((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("c", tagUsage)));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("d", tagUsage)));
        Assert.assertEquals((Object)"c", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("e", tagUsage)));
        Assert.assertEquals((Object)"c", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("f", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("h", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("i", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("j", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Cell cell = scanner.getCell();
        if (tagUsage != TagUsage.NO_TAG && cell.getTagsLength() > 0) {
            Iterator tagsIterator = PrivateCellUtil.tagsIterator((Cell)cell);
            while (tagsIterator.hasNext()) {
                Tag next = (Tag)tagsIterator.next();
                Assert.assertEquals((Object)"myTag1", (Object)Bytes.toString((byte[])Tag.cloneValue((Tag)next)));
            }
        }
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("k", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("l", tagUsage)));
        Assert.assertEquals((Object)"k", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        reader.close();
        this.deleteTestDir(fs);
    }

    protected void deleteTestDir(FileSystem fs) throws IOException {
        Path dataTestDir = TEST_UTIL.getDataTestDir();
        if (fs.exists(dataTestDir)) {
            fs.delete(dataTestDir, true);
        }
    }

    @Test
    public void testSeekBeforeWithReSeekTo() throws Exception {
        this.testSeekBeforeWithReSeekToInternals(TagUsage.NO_TAG);
        this.testSeekBeforeWithReSeekToInternals(TagUsage.ONLY_TAG);
        this.testSeekBeforeWithReSeekToInternals(TagUsage.PARTIAL_TAG);
    }

    protected void testSeekBeforeWithReSeekToInternals(TagUsage tagUsage) throws IOException {
        Path p = this.makeNewFile(tagUsage);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)p, (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);
        HFileScanner scanner = reader.getScanner(conf, false, true);
        Assert.assertFalse((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("a", tagUsage)));
        Assert.assertFalse((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("b", tagUsage)));
        Assert.assertFalse((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("c", tagUsage)));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("d", tagUsage)));
        Assert.assertFalse((boolean)(scanner.getCell() instanceof ByteBufferKeyValue));
        Assert.assertEquals((Object)"c", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("c", tagUsage)));
        Assert.assertEquals((Object)"c", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("e", tagUsage)));
        Assert.assertEquals((Object)"c", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("e", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("f", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("e", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("e", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("h", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("i", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("j", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("i", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("k", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("i", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("k", tagUsage)));
        Assert.assertEquals((Object)"k", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertTrue((boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("l", tagUsage)));
        Assert.assertEquals((Object)"k", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo((Cell)TestSeekTo.toKV("k", tagUsage)));
        Assert.assertEquals((Object)"k", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        this.deleteTestDir(fs);
    }

    @Test
    public void testSeekTo() throws Exception {
        this.testSeekToInternals(TagUsage.NO_TAG);
        this.testSeekToInternals(TagUsage.ONLY_TAG);
        this.testSeekToInternals(TagUsage.PARTIAL_TAG);
    }

    protected void testSeekToInternals(TagUsage tagUsage) throws IOException {
        Path p = this.makeNewFile(tagUsage);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)p, (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);
        Assert.assertEquals((long)2L, (long)reader.getDataBlockIndexReader().getRootBlockCount());
        HFileScanner scanner = reader.getScanner(conf, false, true);
        Assert.assertEquals((long)-1L, (long)scanner.seekTo((Cell)TestSeekTo.toKV("a", tagUsage)));
        Assert.assertEquals((long)1L, (long)scanner.seekTo((Cell)TestSeekTo.toKV("d", tagUsage)));
        Assert.assertEquals((Object)"c", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)0L, (long)scanner.seekTo((Cell)TestSeekTo.toKV("i", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        Assert.assertEquals((long)1L, (long)scanner.seekTo((Cell)TestSeekTo.toKV("l", tagUsage)));
        Assert.assertEquals((Object)"k", (Object)TestSeekTo.toRowStr(scanner.getCell()));
        reader.close();
        this.deleteTestDir(fs);
    }

    @Test
    public void testBlockContainingKey() throws Exception {
        this.testBlockContainingKeyInternals(TagUsage.NO_TAG);
        this.testBlockContainingKeyInternals(TagUsage.ONLY_TAG);
        this.testBlockContainingKeyInternals(TagUsage.PARTIAL_TAG);
    }

    protected void testBlockContainingKeyInternals(TagUsage tagUsage) throws IOException {
        Path p = this.makeNewFile(tagUsage);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)p, (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);
        HFileBlockIndex.CellBasedKeyBlockIndexReader blockIndexReader = reader.getDataBlockIndexReader();
        System.out.println(blockIndexReader.toString());
        Assert.assertEquals((long)-1L, (long)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("a", tagUsage)));
        Assert.assertEquals((long)0L, (long)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("c", tagUsage)));
        Assert.assertEquals((long)0L, (long)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("d", tagUsage)));
        Assert.assertEquals((long)0L, (long)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("e", tagUsage)));
        Assert.assertEquals((long)0L, (long)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((long)1L, (long)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("h", tagUsage)));
        Assert.assertEquals((long)1L, (long)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("i", tagUsage)));
        Assert.assertEquals((long)1L, (long)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("j", tagUsage)));
        Assert.assertEquals((long)1L, (long)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("k", tagUsage)));
        Assert.assertEquals((long)1L, (long)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("l", tagUsage)));
        reader.close();
        this.deleteTestDir(fs);
    }
}

